/*
 * Decompiled with CFR 0.152.
 */
package android.sun.security.x509;

import android.sun.security.util.BitArray;
import android.sun.security.util.DerInputStream;
import android.sun.security.util.DerOutputStream;
import android.sun.security.util.DerValue;
import java.io.IOException;

public class UniqueIdentity {
    private BitArray id;

    public UniqueIdentity(BitArray id) {
        this.id = id;
    }

    public UniqueIdentity(byte[] id) {
        this.id = new BitArray(id.length * 8, id);
    }

    public UniqueIdentity(DerInputStream in) throws IOException {
        DerValue derVal = in.getDerValue();
        this.id = derVal.getUnalignedBitString(true);
    }

    public UniqueIdentity(DerValue derVal) throws IOException {
        this.id = derVal.getUnalignedBitString(true);
    }

    public String toString() {
        return "UniqueIdentity:" + this.id.toString() + "\n";
    }

    public void encode(DerOutputStream out, byte tag) throws IOException {
        byte[] bytes = this.id.toByteArray();
        int excessBits = bytes.length * 8 - this.id.length();
        out.write(tag);
        out.putLength(bytes.length + 1);
        out.write(excessBits);
        out.write(bytes);
    }

    public boolean[] getId() {
        if (this.id == null) {
            return null;
        }
        return this.id.toBooleanArray();
    }
}

