/*
 * Decompiled with CFR 0.152.
 */
package android.sun.security.x509;

import android.sun.security.pkcs.PKCS9Attribute;
import android.sun.security.util.DerOutputStream;
import android.sun.security.util.DerValue;
import android.sun.security.util.ObjectIdentifier;
import android.sun.security.x509.AVA;
import android.sun.security.x509.AttributeNameEnumeration;
import android.sun.security.x509.CertAttrSet;
import android.sun.security.x509.Extension;
import android.sun.security.x509.GeneralName;
import android.sun.security.x509.GeneralNameInterface;
import android.sun.security.x509.GeneralSubtree;
import android.sun.security.x509.GeneralSubtrees;
import android.sun.security.x509.PKIXExtensions;
import android.sun.security.x509.RFC822Name;
import android.sun.security.x509.X500Name;
import androidx.annotation.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class NameConstraintsExtension
extends Extension
implements CertAttrSet<String>,
Cloneable {
    public static final String IDENT = "x509.info.extensions.NameConstraints";
    public static final String NAME = "NameConstraints";
    public static final String PERMITTED_SUBTREES = "permitted_subtrees";
    public static final String EXCLUDED_SUBTREES = "excluded_subtrees";
    private static final byte TAG_PERMITTED = 0;
    private static final byte TAG_EXCLUDED = 1;
    private GeneralSubtrees permitted = null;
    private GeneralSubtrees excluded = null;

    private void encodeThis() throws IOException {
        DerOutputStream tmp;
        if (this.permitted == null && this.excluded == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream seq = new DerOutputStream();
        DerOutputStream tagged = new DerOutputStream();
        if (this.permitted != null) {
            tmp = new DerOutputStream();
            this.permitted.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmp);
        }
        if (this.excluded != null) {
            tmp = new DerOutputStream();
            this.excluded.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmp);
        }
        seq.write((byte)48, tagged);
        this.extensionValue = seq.toByteArray();
    }

    public NameConstraintsExtension(GeneralSubtrees permitted, GeneralSubtrees excluded) throws IOException {
        this.permitted = permitted;
        this.excluded = excluded;
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NameConstraintsExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for NameConstraintsExtension.");
        }
        if (val.data == null) {
            return;
        }
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
                if (this.permitted != null) {
                    throw new IOException("Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                }
                opt.resetTag((byte)48);
                this.permitted = new GeneralSubtrees(opt);
                continue;
            }
            if (opt.isContextSpecific((byte)1) && opt.isConstructed()) {
                if (this.excluded != null) {
                    throw new IOException("Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                }
                opt.resetTag((byte)48);
                this.excluded = new GeneralSubtrees(opt);
                continue;
            }
            throw new IOException("Invalid encoding of NameConstraintsExtension.");
        }
    }

    @Override
    @NonNull
    public String toString() {
        return super.toString() + "NameConstraints: [" + (this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n";
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.NameConstraints_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (!(obj instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.permitted = (GeneralSubtrees)obj;
        } else if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (!(obj instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.excluded = (GeneralSubtrees)obj;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            return this.permitted;
        }
        if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            return this.excluded;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            this.permitted = null;
        } else if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            this.excluded = null;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(PERMITTED_SUBTREES);
        elements.addElement(EXCLUDED_SUBTREES);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void merge(NameConstraintsExtension newConstraints) throws IOException {
        if (newConstraints == null) {
            return;
        }
        GeneralSubtrees newExcluded = (GeneralSubtrees)newConstraints.get(EXCLUDED_SUBTREES);
        if (this.excluded == null) {
            this.excluded = newExcluded != null ? (GeneralSubtrees)newExcluded.clone() : null;
        } else if (newExcluded != null) {
            this.excluded.union(newExcluded);
        }
        GeneralSubtrees newPermitted = (GeneralSubtrees)newConstraints.get(PERMITTED_SUBTREES);
        if (this.permitted == null) {
            this.permitted = newPermitted != null ? (GeneralSubtrees)newPermitted.clone() : null;
        } else if (newPermitted != null && (newExcluded = this.permitted.intersect(newPermitted)) != null) {
            if (this.excluded != null) {
                this.excluded.union(newExcluded);
            } else {
                this.excluded = (GeneralSubtrees)newExcluded.clone();
            }
        }
        if (this.permitted != null) {
            this.permitted.reduce(this.excluded);
        }
        this.encodeThis();
    }

    public boolean verify(GeneralNameInterface name) throws IOException {
        if (name == null) {
            throw new IOException("name is null");
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            block9: for (int i = 0; i < this.excluded.size(); ++i) {
                GeneralNameInterface exName;
                GeneralName gn;
                GeneralSubtree gs = this.excluded.get(i);
                if (gs == null || (gn = gs.getName()) == null || (exName = gn.getName()) == null) continue;
                switch (exName.constrains(name)) {
                    case -1: 
                    case 2: 
                    case 3: {
                        continue block9;
                    }
                    case 0: 
                    case 1: {
                        return false;
                    }
                }
            }
        }
        if (this.permitted != null && this.permitted.size() > 0) {
            boolean sameType = false;
            block10: for (int i = 0; i < this.permitted.size(); ++i) {
                GeneralNameInterface perName;
                GeneralName gn;
                GeneralSubtree gs = this.permitted.get(i);
                if (gs == null || (gn = gs.getName()) == null || (perName = gn.getName()) == null) continue;
                switch (perName.constrains(name)) {
                    case -1: {
                        continue block10;
                    }
                    case 2: 
                    case 3: {
                        sameType = true;
                        continue block10;
                    }
                    case 0: 
                    case 1: {
                        return true;
                    }
                }
            }
            return !sameType;
        }
        return true;
    }

    public boolean verifyRFC822SpecialCase(X500Name subject) throws IOException {
        for (AVA ava : subject.allAvas()) {
            RFC822Name emailName;
            String attrValue;
            ObjectIdentifier attrOID = ava.getObjectIdentifier();
            if (!attrOID.equals(PKCS9Attribute.EMAIL_ADDRESS_OID) || (attrValue = ava.getValueString()) == null) continue;
            try {
                emailName = new RFC822Name(attrValue);
            }
            catch (IOException ioe) {
                continue;
            }
            if (this.verify(emailName)) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public Object clone() {
        try {
            NameConstraintsExtension newNCE = (NameConstraintsExtension)super.clone();
            if (this.permitted != null) {
                newNCE.permitted = (GeneralSubtrees)this.permitted.clone();
            }
            if (this.excluded != null) {
                newNCE.excluded = (GeneralSubtrees)this.excluded.clone();
            }
            return newNCE;
        }
        catch (CloneNotSupportedException cnsee) {
            throw new RuntimeException("CloneNotSupportedException while cloning NameConstraintsException. This should never happen.");
        }
    }
}

