/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.github.muntashirakon.adb.ByteArrayNoThrowOutputStream;
import io.github.muntashirakon.adb.StringCompat;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Objects;
import javax.crypto.Cipher;
import org.bouncycastle.util.encoders.Base64;

final class AndroidPubkey {
    public static final int ANDROID_PUBKEY_MODULUS_SIZE = 256;
    public static final int ANDROID_PUBKEY_ENCODED_SIZE = 524;
    public static final int ANDROID_PUBKEY_MODULUS_SIZE_WORDS = 64;
    private static final int[] SIGNATURE_PADDING_AS_INT = new int[]{0, 1, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
    private static final byte[] RSA_SHA_PKCS1_SIGNATURE_PADDING = new byte[SIGNATURE_PADDING_AS_INT.length];

    AndroidPubkey() {
    }

    @NonNull
    public static byte[] adbAuthSign(@NonNull PrivateKey privateKey, byte[] payload) throws GeneralSecurityException {
        Cipher c = Cipher.getInstance("RSA/ECB/NoPadding");
        c.init(1, privateKey);
        c.update(RSA_SHA_PKCS1_SIGNATURE_PADDING);
        return c.doFinal(payload);
    }

    @NonNull
    public static byte[] encodeWithName(@NonNull RSAPublicKey publicKey, @NonNull String name) throws InvalidKeyException {
        int pkeySize = 4 * (int)Math.ceil(174.66666666666666);
        try (ByteArrayNoThrowOutputStream bos = new ByteArrayNoThrowOutputStream(pkeySize + name.length() + 2);){
            bos.write(Base64.encode((byte[])AndroidPubkey.encode(publicKey)));
            bos.write(AndroidPubkey.getUserInfo(name));
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    @VisibleForTesting
    @NonNull
    static byte[] getUserInfo(@NonNull String name) {
        return StringCompat.getBytes(String.format(" %s\u0000", name), "UTF-8");
    }

    @NonNull
    public static RSAPublicKey decode(@NonNull byte[] androidPubkey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (androidPubkey.length < 524) {
            throw new InvalidKeyException("Invalid key length");
        }
        ByteBuffer keyStruct = ByteBuffer.wrap(androidPubkey).order(ByteOrder.LITTLE_ENDIAN);
        int modulusSize = keyStruct.getInt();
        if (modulusSize != 64) {
            throw new InvalidKeyException("Invalid modulus length.");
        }
        byte[] modulus = new byte[256];
        keyStruct.position(8);
        keyStruct.get(modulus);
        BigInteger n = new BigInteger(1, AndroidPubkey.swapEndianness(modulus));
        keyStruct.position(520);
        BigInteger e = BigInteger.valueOf(keyStruct.getInt());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(n, e);
        return (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
    }

    @NonNull
    public static byte[] encode(@NonNull RSAPublicKey publicKey) throws InvalidKeyException {
        if (publicKey.getModulus().toByteArray().length < 256) {
            throw new InvalidKeyException("Invalid key length " + publicKey.getModulus().toByteArray().length);
        }
        ByteBuffer keyStruct = ByteBuffer.allocate(524).order(ByteOrder.LITTLE_ENDIAN);
        keyStruct.putInt(64);
        BigInteger r32 = BigInteger.ZERO.setBit(32);
        BigInteger n0inv = publicKey.getModulus().mod(r32);
        n0inv = n0inv.modInverse(r32);
        n0inv = r32.subtract(n0inv);
        keyStruct.putInt(n0inv.intValue());
        keyStruct.put(Objects.requireNonNull(AndroidPubkey.BigEndianToLittleEndianPadded(256, publicKey.getModulus())));
        BigInteger rr = BigInteger.ZERO.setBit(2048);
        rr = rr.modPow(BigInteger.valueOf(2L), publicKey.getModulus());
        keyStruct.put(Objects.requireNonNull(AndroidPubkey.BigEndianToLittleEndianPadded(256, rr)));
        keyStruct.putInt(publicKey.getPublicExponent().intValue());
        return keyStruct.array();
    }

    @Nullable
    private static byte[] BigEndianToLittleEndianPadded(int len, @NonNull BigInteger in) {
        byte[] out = new byte[len];
        byte[] bytes = AndroidPubkey.swapEndianness(in.toByteArray());
        int num_bytes = bytes.length;
        if (len < num_bytes) {
            if (!AndroidPubkey.fitsInBytes(bytes, num_bytes, len)) {
                return null;
            }
            num_bytes = len;
        }
        System.arraycopy(bytes, 0, out, 0, num_bytes);
        return out;
    }

    static boolean fitsInBytes(@NonNull byte[] bytes, int num_bytes, int len) {
        byte mask = 0;
        for (int i = len; i < num_bytes; ++i) {
            mask = (byte)(mask | bytes[i]);
        }
        return mask == 0;
    }

    @NonNull
    private static byte[] swapEndianness(@NonNull byte[] bytes) {
        int len = bytes.length;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = bytes[len - i - 1];
        }
        return out;
    }

    static {
        for (int i = 0; i < RSA_SHA_PKCS1_SIGNATURE_PADDING.length; ++i) {
            AndroidPubkey.RSA_SHA_PKCS1_SIGNATURE_PADDING[i] = (byte)SIGNATURE_PADDING_AS_INT[i];
        }
    }
}

