/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import io.github.muntashirakon.adb.AdbAuthenticationFailedException;
import io.github.muntashirakon.adb.AdbPairingRequiredException;
import io.github.muntashirakon.adb.AdbProtocol;
import io.github.muntashirakon.adb.AdbStream;
import io.github.muntashirakon.adb.AndroidPubkey;
import io.github.muntashirakon.adb.KeyPair;
import io.github.muntashirakon.adb.LocalServices;
import io.github.muntashirakon.adb.SslUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.security.auth.DestroyFailedException;

public class AdbConnection
implements Closeable {
    public static final String TAG = AdbConnection.class.getSimpleName();
    @NonNull
    private final Socket mSocket;
    @NonNull
    private final String mHost;
    private final int mPort;
    private final int mApi;
    private int mLastLocalId;
    @GuardedBy(value="lock")
    @NonNull
    private final InputStream mPlainInputStream;
    @GuardedBy(value="lock")
    @NonNull
    private final OutputStream mPlainOutputStream;
    @GuardedBy(value="lock")
    @Nullable
    private volatile InputStream mTlsInputStream;
    @GuardedBy(value="lock")
    @Nullable
    private volatile OutputStream mTlsOutputStream;
    @NonNull
    private final Thread mConnectionThread;
    private volatile boolean mConnectAttempted;
    private volatile boolean mAbortOnUnauthorised;
    private volatile boolean mAuthorisationFailed;
    private volatile boolean mConnectionEstablished;
    @Nullable
    private volatile Exception mConnectionException;
    private volatile int mMaxData;
    private volatile int mProtocolVersion;
    @NonNull
    private final KeyPair mKeyPair;
    @NonNull
    private volatile String mDeviceName = "Unknown Device";
    private volatile boolean mSentSignature;
    @NonNull
    private final ConcurrentHashMap<Integer, AdbStream> mOpenedStreams;
    private volatile boolean mIsTls = false;
    @GuardedBy(value="lock")
    @NonNull
    private final Object mLock = new Object();

    @WorkerThread
    @NonNull
    public static AdbConnection create(@NonNull String host, int port, @NonNull PrivateKey privateKey, @NonNull Certificate certificate) throws IOException {
        return AdbConnection.create(host, port, privateKey, certificate, 1);
    }

    @WorkerThread
    @NonNull
    public static AdbConnection create(@NonNull String host, int port, @NonNull PrivateKey privateKey, @NonNull Certificate certificate, int api) throws IOException {
        return AdbConnection.create(host, port, new KeyPair(Objects.requireNonNull(privateKey), Objects.requireNonNull(certificate)), api);
    }

    @WorkerThread
    @NonNull
    static AdbConnection create(@NonNull String host, int port, @NonNull KeyPair keyPair, int api) throws IOException {
        return new AdbConnection(host, port, keyPair, api);
    }

    @WorkerThread
    private AdbConnection(@NonNull String host, int port, @NonNull KeyPair keyPair, int api) throws IOException {
        this.mHost = Objects.requireNonNull(host);
        this.mPort = port;
        this.mApi = api;
        this.mProtocolVersion = AdbProtocol.getProtocolVersion(this.mApi);
        this.mMaxData = AdbProtocol.getMaxData(api);
        this.mKeyPair = Objects.requireNonNull(keyPair);
        try {
            this.mSocket = new Socket(host, port);
        }
        catch (Throwable th) {
            throw (IOException)new IOException().initCause(th);
        }
        this.mPlainInputStream = this.mSocket.getInputStream();
        this.mPlainOutputStream = this.mSocket.getOutputStream();
        this.mSocket.setTcpNoDelay(true);
        this.mOpenedStreams = new ConcurrentHashMap();
        this.mLastLocalId = 0;
        this.mConnectionThread = this.createConnectionThread();
    }

    @GuardedBy(value="lock")
    @NonNull
    private InputStream getInputStream() {
        return this.mIsTls ? Objects.requireNonNull(this.mTlsInputStream) : this.mPlainInputStream;
    }

    @GuardedBy(value="lock")
    @NonNull
    private OutputStream getOutputStream() {
        return this.mIsTls ? Objects.requireNonNull(this.mTlsOutputStream) : this.mPlainOutputStream;
    }

    @NonNull
    private Thread createConnectionThread() {
        return new Thread(() -> {
            block20: while (!this.mConnectionThread.isInterrupted()) {
                try {
                    AdbProtocol.Message msg = AdbProtocol.Message.parse(this.getInputStream(), this.mProtocolVersion, this.mMaxData);
                    switch (msg.command) {
                        case 1163086915: 
                        case 1163154007: 
                        case 1497451343: {
                            AdbStream waitingStream;
                            if (!this.mConnectionEstablished || (waitingStream = this.mOpenedStreams.get(msg.arg1)) == null) continue block20;
                            AdbStream adbStream = waitingStream;
                            synchronized (adbStream) {
                                if (msg.command == 1497451343) {
                                    waitingStream.updateRemoteId(msg.arg0);
                                    waitingStream.readyForWrite();
                                    waitingStream.notify();
                                } else if (msg.command == 1163154007) {
                                    waitingStream.addPayload(msg.payload);
                                    waitingStream.sendReady();
                                } else {
                                    this.mOpenedStreams.remove(msg.arg1);
                                    waitingStream.notifyClose(true);
                                }
                                break;
                            }
                        }
                        case 1397511251: {
                            if (Build.VERSION.SDK_INT < 9) continue block20;
                            this.sendPacket(AdbProtocol.generateStls());
                            SSLContext sslContext = SslUtils.getSslContext(this.mKeyPair);
                            SSLSocket tlsSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(this.mSocket, this.mHost, this.mPort, true);
                            tlsSocket.startHandshake();
                            Log.d((String)TAG, (String)"Handshake succeeded.");
                            AdbConnection adbConnection = this;
                            synchronized (adbConnection) {
                                this.mTlsInputStream = tlsSocket.getInputStream();
                                this.mTlsOutputStream = tlsSocket.getOutputStream();
                                this.mIsTls = true;
                                break;
                            }
                        }
                        case 1213486401: {
                            byte[] packet;
                            if (this.mIsTls || msg.arg0 != 1) break;
                            if (this.mSentSignature) {
                                if (this.mAbortOnUnauthorised) {
                                    this.mAuthorisationFailed = true;
                                    break block20;
                                }
                                packet = AdbProtocol.generateAuth(3, AndroidPubkey.encodeWithName((RSAPublicKey)this.mKeyPair.getPublicKey(), this.mDeviceName));
                            } else {
                                packet = AdbProtocol.generateAuth(2, AndroidPubkey.adbAuthSign(this.mKeyPair.getPrivateKey(), msg.payload));
                                this.mSentSignature = true;
                            }
                            this.sendPacket(packet);
                            break;
                        }
                        case 1314410051: {
                            AdbConnection adbConnection = this;
                            synchronized (adbConnection) {
                                this.mProtocolVersion = msg.arg0;
                                this.mMaxData = msg.arg1;
                                this.mConnectionEstablished = true;
                                this.notifyAll();
                                break;
                            }
                        }
                        default: {
                            Log.e((String)TAG, (String)String.format("Unrecognized command = 0x%x", msg.command));
                        }
                    }
                }
                catch (Exception e) {
                    this.mConnectionException = e;
                    e.printStackTrace();
                    break;
                }
            }
            AdbConnection adbConnection = this;
            synchronized (adbConnection) {
                this.cleanupStreams();
                this.notifyAll();
                this.mConnectionEstablished = false;
                this.mConnectAttempted = false;
            }
        });
    }

    public void setDeviceName(@NonNull String deviceName) {
        this.mDeviceName = Objects.requireNonNull(deviceName);
    }

    public int getProtocolVersion() {
        return this.mProtocolVersion;
    }

    public int getMaxData() throws InterruptedException, IOException, AdbPairingRequiredException {
        if (!this.mConnectAttempted) {
            throw new IllegalStateException("connect() must be called first");
        }
        this.waitForConnection(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        return this.mMaxData;
    }

    public boolean isConnectionEstablished() {
        return this.mConnectionEstablished;
    }

    public boolean isConnected() {
        return !this.mSocket.isClosed() && this.mSocket.isConnected();
    }

    public boolean connect() throws IOException, InterruptedException, AdbPairingRequiredException {
        return this.connect(Long.MAX_VALUE, TimeUnit.MILLISECONDS, false);
    }

    public boolean connect(long timeout, @NonNull TimeUnit unit, boolean throwOnUnauthorised) throws IOException, InterruptedException, AdbAuthenticationFailedException, AdbPairingRequiredException {
        if (this.mConnectionEstablished) {
            throw new IllegalStateException("Already connected");
        }
        this.sendPacket(AdbProtocol.generateConnect(this.mApi));
        this.mConnectAttempted = true;
        this.mAbortOnUnauthorised = throwOnUnauthorised;
        this.mAuthorisationFailed = false;
        this.mConnectionThread.start();
        return this.waitForConnection(timeout, Objects.requireNonNull(unit));
    }

    @NonNull
    public AdbStream open(int service, String ... args) throws IOException, InterruptedException, AdbPairingRequiredException {
        if (service < 1 || service > 15) {
            throw new IllegalArgumentException("Invalid service: " + service);
        }
        return this.open(LocalServices.getDestination(service, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public AdbStream open(@NonNull String destination) throws IOException, InterruptedException, AdbPairingRequiredException {
        int localId = ++this.mLastLocalId;
        if (!this.mConnectAttempted) {
            throw new IllegalStateException("connect() must be called first");
        }
        this.waitForConnection(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        AdbStream stream = new AdbStream(this, localId);
        this.mOpenedStreams.put(localId, stream);
        this.sendPacket(AdbProtocol.generateOpen(localId, Objects.requireNonNull(destination)));
        AdbStream adbStream = stream;
        synchronized (adbStream) {
            stream.wait();
        }
        if (stream.isClosed()) {
            this.mOpenedStreams.remove(localId);
            throw new ConnectException("Stream open actively rejected by remote peer.");
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForConnection(long timeout, @NonNull TimeUnit unit) throws InterruptedException, IOException, AdbPairingRequiredException {
        AdbConnection adbConnection = this;
        synchronized (adbConnection) {
            long timeoutEndMillis = System.currentTimeMillis() + Objects.requireNonNull(unit).toMillis(timeout);
            while (!this.mConnectionEstablished && this.mConnectAttempted && timeoutEndMillis - System.currentTimeMillis() > 0L) {
                this.wait(timeoutEndMillis - System.currentTimeMillis());
            }
            if (!this.mConnectionEstablished) {
                String message;
                if (this.mConnectAttempted) {
                    return false;
                }
                if (this.mAuthorisationFailed) {
                    throw new AdbAuthenticationFailedException();
                }
                Exception connectionException = this.mConnectionException;
                if (connectionException != null && connectionException instanceof SSLProtocolException && (message = connectionException.getMessage()) != null && message.contains("protocol error")) {
                    throw (AdbPairingRequiredException)new AdbPairingRequiredException("ADB pairing is required.").initCause(connectionException);
                }
                throw new IOException("Connection failed");
            }
        }
        return true;
    }

    private void cleanupStreams() {
        for (AdbStream s : this.mOpenedStreams.values()) {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        this.mOpenedStreams.clear();
    }

    @Override
    public void close() throws IOException {
        this.mSocket.close();
        this.mConnectionThread.interrupt();
        try {
            this.mConnectionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.mKeyPair.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(byte[] packet) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            OutputStream os = this.getOutputStream();
            os.write(packet);
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushPacket() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.getOutputStream().flush();
        }
    }

    public static class Builder {
        private String mHost = "127.0.0.1";
        private int mPort = 5555;
        private int mApi = 1;
        private PrivateKey mPrivateKey;
        private Certificate mCertificate;
        private KeyPair mKeyPair;
        private String mDeviceName;

        public Builder() {
        }

        public Builder(String host, int port) {
            this.mHost = host;
            this.mPort = port;
        }

        public Builder setHost(String host) {
            this.mHost = host;
            return this;
        }

        public Builder setPort(int port) {
            this.mPort = port;
            return this;
        }

        public Builder setDeviceName(String deviceName) {
            this.mDeviceName = deviceName;
            return this;
        }

        public Builder setApi(int api) {
            this.mApi = api;
            return this;
        }

        public Builder setPrivateKey(PrivateKey privateKey) {
            this.mPrivateKey = privateKey;
            return this;
        }

        public Builder setCertificate(Certificate certificate) {
            this.mCertificate = certificate;
            return this;
        }

        Builder setKeyPair(KeyPair keyPair) {
            this.mKeyPair = keyPair;
            return this;
        }

        public AdbConnection build() throws IOException {
            if (this.mKeyPair == null) {
                if (this.mPrivateKey == null || this.mCertificate == null) {
                    throw new UnsupportedOperationException("Private key and certificate must be set.");
                }
                this.mKeyPair = new KeyPair(this.mPrivateKey, this.mCertificate);
            }
            AdbConnection adbConnection = AdbConnection.create(this.mHost, this.mPort, this.mKeyPair, this.mApi);
            if (this.mDeviceName != null) {
                adbConnection.setDeviceName(this.mDeviceName);
            }
            return adbConnection;
        }

        public AdbConnection connect() throws IOException, InterruptedException, AdbPairingRequiredException {
            AdbConnection adbConnection = this.build();
            if (adbConnection.connect()) {
                throw new IOException("Unable to establish a new connection.");
            }
            return adbConnection;
        }

        public AdbConnection connect(long timeout, @NonNull TimeUnit unit, boolean throwOnUnauthorised) throws IOException, InterruptedException, AdbPairingRequiredException {
            AdbConnection adbConnection = this.build();
            if (adbConnection.connect(timeout, unit, throwOnUnauthorised)) {
                throw new IOException("Unable to establish a new connection.");
            }
            return adbConnection;
        }
    }
}

