/*
 * Decompiled with CFR 0.152.
 */
package com.mohammedalaa.seekbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.widget.AppCompatSeekBar;
import android.util.AttributeSet;
import android.view.View;
import android.widget.SeekBar;
import com.mohammedalaa.seekbar.R;

public class RangeSeekBarView
extends AppCompatSeekBar
implements SeekBar.OnSeekBarChangeListener {
    private int maxValue = 0;
    private int currentValue = 0;
    private int minValue = 0;
    private float valueToDraw;
    private int step = 0;
    private int barHeight;
    private int circleRadius;
    private int circleTextSize;
    private int circleTextColor;
    private int baseColor;
    private int fillColor;
    private Paint barBasePaint;
    private Paint barFillPaint;
    private Paint circlePaint;
    private Paint currentValuePaint;

    public RangeSeekBarView(Context context) {
        super(context);
    }

    public RangeSeekBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setSaveEnabled(true);
        this.getThumb().mutate().setAlpha(0);
        this.setBackgroundColor(0);
        this.setBackgroundColor(0);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RangeSeekBarView, 0, 0);
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_stepValue)) {
            this.step = typedArray.getInt(R.styleable.RangeSeekBarView_stepValue, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_minValue)) {
            this.minValue = typedArray.getInt(R.styleable.RangeSeekBarView_minValue, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_maxValue)) {
            this.maxValue = typedArray.getInt(R.styleable.RangeSeekBarView_maxValue, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_currentValue)) {
            this.currentValue = typedArray.getInt(R.styleable.RangeSeekBarView_currentValue, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_barHeight)) {
            this.barHeight = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_barHeight, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleRadius)) {
            this.circleRadius = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_circleRadius, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleTextSize)) {
            this.circleTextSize = typedArray.getDimensionPixelSize(R.styleable.RangeSeekBarView_circleTextSize, 0);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_circleTextColor)) {
            this.circleTextColor = typedArray.getColor(R.styleable.RangeSeekBarView_circleTextColor, -65536);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_baseColor)) {
            this.baseColor = typedArray.getColor(R.styleable.RangeSeekBarView_baseColor, -7829368);
        }
        if (typedArray.hasValue(R.styleable.RangeSeekBarView_fillColor)) {
            this.fillColor = typedArray.getColor(R.styleable.RangeSeekBarView_fillColor, -16777216);
        }
        this.setMax(100);
        if (this.currentValue < this.minValue || this.currentValue > this.maxValue) {
            throw new RuntimeException("Value must be in range   (min <= value <= max) ");
        }
        this.setProgress(this.calculateProgress(this.currentValue, this.minValue, this.maxValue));
        this.setValue(this.currentValue);
        typedArray.recycle();
        this.barBasePaint = new Paint(1);
        this.barBasePaint.setColor(this.baseColor);
        this.barFillPaint = new Paint(1);
        this.barFillPaint.setColor(this.fillColor);
        this.circlePaint = new Paint(1);
        this.circlePaint.setColor(this.fillColor);
        this.currentValuePaint = new Paint(1);
        this.currentValuePaint.setTextSize((float)this.circleTextSize);
        this.currentValuePaint.setColor(this.circleTextColor);
        this.currentValuePaint.setTextAlign(Paint.Align.CENTER);
        this.setOnSeekBarChangeListener(this);
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        this.invalidate();
        this.requestLayout();
    }

    private int calculateProgress(int value, int MIN, int MAX) {
        return 100 * (value - MIN) / (MAX - MIN);
    }

    public void setMinValue(int value) {
        this.minValue = value;
        this.invalidate();
        this.requestLayout();
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setValue(int newValue) {
        if (newValue < this.minValue || newValue > this.maxValue) {
            newValue = this.currentValue;
        }
        if (newValue % this.step == 0) {
            this.currentValue = newValue;
        }
        this.valueToDraw = this.currentValue;
        this.invalidate();
    }

    public int getValue() {
        return this.currentValue;
    }

    private int measureHeight(int measureSpec) {
        int size = this.getPaddingTop() + this.getPaddingBottom();
        return RangeSeekBarView.resolveSizeAndState((int)(size += Math.max(this.barHeight, this.circleRadius * 2)), (int)measureSpec, (int)0);
    }

    private int measureWidth(int measureSpec) {
        int size = this.getPaddingLeft() + this.getPaddingRight();
        return RangeSeekBarView.resolveSizeAndState((int)size, (int)measureSpec, (int)0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        this.drawBar(canvas);
    }

    private void drawBar(Canvas canvas) {
        float barLength = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
        float barCenter = this.getBarCenter();
        float halfBarHeight = this.barHeight / 2;
        float top = barCenter - halfBarHeight;
        float bottom = barCenter + halfBarHeight;
        float left = this.getPaddingLeft();
        float right = (float)this.getPaddingLeft() + barLength;
        RectF rect = new RectF(left, top, right, bottom);
        canvas.drawRoundRect(rect, halfBarHeight, halfBarHeight, this.barBasePaint);
        float percentFilled = (float)this.calculateProgress((int)this.valueToDraw, this.minValue, this.maxValue) / (float)this.getMax();
        float fillLength = barLength * percentFilled;
        float fillPosition = left + fillLength;
        RectF fillRect = new RectF(left, top, fillPosition, bottom);
        canvas.drawRoundRect(fillRect, halfBarHeight, halfBarHeight, this.barFillPaint);
        canvas.drawCircle(fillPosition, barCenter, (float)this.circleRadius, this.circlePaint);
        Rect bounds = new Rect();
        String valueString = String.valueOf(Math.round(this.valueToDraw));
        this.currentValuePaint.getTextBounds(valueString, 0, valueString.length(), bounds);
        float y = barCenter + (float)(bounds.height() / 2);
        canvas.drawText(valueString, fillPosition, y, this.currentValuePaint);
    }

    private float getBarCenter() {
        float barCenter = (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2;
        return barCenter;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.value = this.currentValue;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.currentValue = ss.value;
        this.valueToDraw = this.currentValue;
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        double value = Math.round(progress * (this.getMaxValue() - this.getMinValue()) / 100);
        int displayValue = ((int)value + this.getMinValue()) / this.step * this.step;
        this.setValue(displayValue);
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
    }

    private static class SavedState
    extends View.BaseSavedState {
        int value;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.value = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.value);
        }
    }
}

