/*
 * Decompiled with CFR 0.152.
 */
package tv.porst.jhexview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tv.porst.jhexview.DataChangedEvent;
import tv.porst.jhexview.IDataChangedListener;
import tv.porst.jhexview.IDataProvider;

public final class SimpleDataProvider
implements IDataProvider {
    private final List<IDataChangedListener> listeners = new ArrayList<IDataChangedListener>();
    private final byte[] m_data;

    public SimpleDataProvider(byte[] data) {
        this.m_data = data;
    }

    @Override
    public void addListener(IDataChangedListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public byte[] getData(long offset, int length) {
        if (offset + (long)length > (long)this.getDataLength()) {
            length = this.getDataLength() - (int)offset;
        }
        if (length > 0) {
            return Arrays.copyOfRange(this.m_data, (int)offset, (int)(offset + (long)length));
        }
        return new byte[0];
    }

    @Override
    public int getDataLength() {
        return this.m_data.length;
    }

    @Deprecated
    public long getOffset() {
        return 0L;
    }

    @Override
    public boolean hasData(long offset, int length) {
        return true;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean keepTrying() {
        return false;
    }

    @Override
    public void removeListener(IDataChangedListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void setData(long offset, byte[] data) {
        int length = data.length;
        int len = this.getDataLength() - (int)offset;
        if (length > len) {
            length = len;
        }
        if (length > 0) {
            System.arraycopy(data, 0, this.m_data, (int)offset, length);
            this.fireDataChangedListener();
        }
    }

    protected void fireDataChangedListener() {
        if (!this.listeners.isEmpty()) {
            DataChangedEvent event = new DataChangedEvent(this);
            for (IDataChangedListener l : this.listeners) {
                l.dataChanged(event);
            }
        }
    }
}

