/*
 * Decompiled with CFR 0.152.
 */
package tv.porst.jhexview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import tv.porst.jhexview.SelectionEvent;
import tv.porst.jhexview.SelectionListener;

public class SelectionModel
implements Iterable<Interval> {
    protected final ArrayList<Interval> selected = new ArrayList();
    private final EventListenerList listeners = new EventListenerList();

    public boolean isEmpty() {
        return this.selected.isEmpty();
    }

    public boolean isSelected(long offset) {
        for (Interval range : this.selected) {
            if (!range.contains(offset)) continue;
            return true;
        }
        return false;
    }

    public Interval findInterval(long offset) {
        for (Interval range : this.selected) {
            if (!range.contains(offset)) continue;
            return range;
        }
        return null;
    }

    @Override
    public Iterator<Interval> iterator() {
        return Collections.unmodifiableList(this.selected).iterator();
    }

    public void setSelectionInterval(long offset0, long offset1) {
        Interval range = Interval.create(offset0, offset1);
        if (range.isEmpty()) {
            this.clearSelection();
            return;
        }
        if (this.selected.size() != 1 || !range.equals(this.selected.get(0))) {
            this.selected.clear();
            this.selected.add(range);
            this.fireSelectionEvent();
        }
    }

    public void addSelectionInterval(long offset0, long offset1) {
        this.addSelectionInterval(Interval.create(offset0, offset1));
    }

    void addSelectionInterval(Interval key) {
        if (key.isEmpty()) {
            return;
        }
        if (this.selected.isEmpty()) {
            this.selected.add(key);
            this.fireSelectionEvent();
            return;
        }
        ArrayList<Interval> old = new ArrayList<Interval>(this.selected);
        this.selected.clear();
        Iterator<Interval> it = old.iterator();
        long start = key.start;
        long end = key.end;
        boolean hasChanges = false;
        Interval firstAfterNew = null;
        while (it.hasNext()) {
            Interval range = it.next();
            if (range.end < key.start) {
                this.selected.add(range);
                continue;
            }
            if (range.start > key.end) {
                firstAfterNew = range;
                break;
            }
            if (range.start < start) {
                start = range.start;
                hasChanges = true;
            }
            if (range.end <= end) continue;
            end = range.end;
            hasChanges = true;
        }
        this.selected.add(new Interval(start, end));
        if (firstAfterNew != null) {
            this.selected.add(firstAfterNew);
        }
        while (it.hasNext()) {
            this.selected.add(it.next());
        }
        if (hasChanges) {
            this.fireSelectionEvent();
        }
    }

    public void removeSelectionInterval(long offset0, long offset1) {
        this.removeSelectionInterval(Interval.create(offset0, offset1));
    }

    void removeSelectionInterval(Interval key) {
        if (key.isEmpty() || this.selected.isEmpty()) {
            return;
        }
        ListIterator<Interval> it = this.selected.listIterator();
        while (it.hasNext()) {
            Interval range = it.next();
            if (range.end <= key.start) continue;
            if (key.end <= range.start) break;
            if (range.contains(key)) {
                it.remove();
                if (range.start != key.start) {
                    it.add(new Interval(range.start, key.start));
                }
                if (range.end != key.end) {
                    it.add(new Interval(key.end, range.end));
                }
                this.fireSelectionEvent();
                break;
            }
            it.remove();
            if (range.start < key.start) {
                it.add(new Interval(range.start, key.start));
            }
            if (key.end < range.end) {
                it.add(new Interval(key.end, range.end));
            }
            this.fireSelectionEvent();
            break;
        }
    }

    public void clearSelection() {
        if (!this.selected.isEmpty()) {
            this.selected.clear();
            this.fireSelectionEvent();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Selection change listener of JHexView can't be null");
        }
        this.listeners.add(SelectionListener.class, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(SelectionListener.class, listener);
    }

    private void fireSelectionEvent() {
        SelectionEvent event = null;
        for (SelectionListener l : (SelectionListener[])this.listeners.getListeners(SelectionListener.class)) {
            if (event == null) {
                event = new SelectionEvent(this);
            }
            l.selectionChanged(event);
        }
    }

    public static class Interval {
        private final long start;
        private final long end;

        Interval(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getLength() {
            return this.end - this.start;
        }

        public boolean contains(long offset) {
            return this.start <= offset && offset < this.end;
        }

        public boolean contains(Interval other) {
            return this.start <= other.start && other.end <= this.end;
        }

        boolean isEmpty() {
            return this.start == this.end;
        }

        public String toString() {
            return "[" + this.start + "; " + this.end + ")";
        }

        public int hashCode() {
            int hash = 3;
            hash = 19 * hash + (int)(this.start ^ this.start >>> 32);
            hash = 19 * hash + (int)(this.end ^ this.end >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Interval other = (Interval)obj;
            if (this.start != other.start) {
                return false;
            }
            return this.end == other.end;
        }

        static Interval create(long offset0, long offset1) {
            return new Interval(Math.min(offset0, offset1), Math.max(offset0, offset1) + 1L);
        }
    }
}

