/*
 * Decompiled with CFR 0.152.
 */
package tv.porst.jhexview;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import tv.porst.jhexview.Caret;
import tv.porst.jhexview.ColoredRange;
import tv.porst.jhexview.ColoredRangeManager;
import tv.porst.jhexview.DataChangedEvent;
import tv.porst.jhexview.HexViewEvent;
import tv.porst.jhexview.ICaretListener;
import tv.porst.jhexview.IColormap;
import tv.porst.jhexview.IDataChangedListener;
import tv.porst.jhexview.IDataProvider;
import tv.porst.jhexview.IHexViewListener;
import tv.porst.jhexview.IMenuCreator;
import tv.porst.jhexview.SelectionModel;

public final class JHexView
extends JComponent {
    private static final long serialVersionUID = -2402458562501988128L;
    private static final String[] HEX_BYTES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
    private static final String[] ASCII_VIEW_TABLE;
    private static final int PADDING_OFFSETVIEW = 20;
    private static final Stroke DOTTED_STROKE;
    private final EventListenerList m_listeners = new EventListenerList();
    private final TreeMap<Long, Integer> m_modifiedOffsets = new TreeMap();
    private boolean m_showModified = false;
    private final SelectionModel selectionModel = new SelectionModel();
    private final UndoManager m_undo = new UndoManager();
    private IDataProvider m_dataProvider;
    private int m_bytesPerRow = 16;
    private Font m_font = new Font("Monospaced", 0, 12);
    private Views m_activeView = Views.HEX_VIEW;
    private int m_hexViewWidth = 270;
    private int m_columnSpacing = 4;
    private int m_bytesPerColumn = 2;
    private Color m_bgColorHeader = Color.WHITE;
    private Color m_bgColorOffset = Color.GRAY;
    private Color m_bgColorHex = Color.WHITE;
    private Color m_bgColorAscii = Color.WHITE;
    private Color m_fontColorHeader = new Color(191);
    private Color m_fontColorOffsets = Color.WHITE;
    private Color m_fontColorHex1 = Color.BLUE;
    private Color m_fontColorHex2 = new Color(0x3399FF);
    private Color m_fontColorAscii = new Color(0x339900);
    private Color m_disabledColor = Color.GRAY;
    private Color m_colorHighlight = Color.LIGHT_GRAY;
    private Color m_selectionColor = Color.YELLOW;
    private Color m_fontColorModified = Color.RED;
    private final ColoredRangeManager[] m_coloredRanges = new ColoredRangeManager[10];
    private IColormap m_colormap;
    private boolean m_colorMapEnabled = true;
    private int m_rowHeight = 12;
    private int m_charWidth = 8;
    private final JScrollBar m_scrollbar = new JScrollBar(1, 0, 1, 0, 1);
    private final JScrollBar m_horizontalScrollbar = new JScrollBar(0, 0, 1, 0, 1);
    private int m_firstRow = 0;
    private int m_firstColumn = 0;
    private long m_baseAddress = 0L;
    private int m_lastMouseX = 0;
    private int m_lastMouseY = 0;
    private boolean editable = false;
    private final Caret m_caret = new Caret();
    private final int m_paddingHexLeft = 10;
    private final int m_paddingAsciiLeft = 10;
    private final int m_paddingTop = 16;
    private int m_charHeight = 8;
    private int m_charMaxAscent = 8;
    private int m_charMaxDescent = 3;
    private DefinitionStatus m_status = DefinitionStatus.UNDEFINED;
    private IMenuCreator m_menuCreator;
    private AddressMode m_addressMode = AddressMode.BIT32;
    private int m_offsetViewWidth;
    private Timer m_updateTimer;
    private boolean m_firstDraw = true;
    private final InternalListener m_listener = new InternalListener();
    private final ActionLeft m_leftAction = new ActionLeft(true);
    private final ActionLeft m_shiftLeftAction = new ActionLeft(false);
    private final ActionRight m_rightAction = new ActionRight(true);
    private final ActionRight m_shiftRightAction = new ActionRight(false);
    private final ActionUp m_upAction = new ActionUp();
    private final ActionDown m_downAction = new ActionDown();
    private final ActionPageUp m_pageUpAction = new ActionPageUp();
    private final ActionPageDown m_pageDownAction = new ActionPageDown();
    private final ActionHome m_homeLineAction = new ActionHome(false);
    private final ActionHome m_homeDocAction = new ActionHome(true);
    private final ActionEnd m_endLineAction = new ActionEnd(false);
    private final ActionEnd m_endDocAction = new ActionEnd(true);
    private final ActionTab m_tabAction = new ActionTab();
    private final ActionShortcut m_SelectAllAction = new ActionShortcut(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    private final ActionShortcut m_PasteTextAction = new ActionShortcut(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    private final ActionShortcut m_CopyTextAction = new ActionShortcut(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    private final ActionShortcut m_UndoAction = new ActionShortcut(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    private final ActionShortcut m_RedoAction = new ActionShortcut(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    private boolean m_headerVisible = true;
    private int m_headerFontStyle = 0;
    private boolean m_separatorsVisible = true;
    private boolean m_mouseOverHighlighted = true;
    private boolean m_flipBytes = false;

    public JHexView() {
        this.setDoubleBuffered(true);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        for (int i = 0; i < this.m_coloredRanges.length; ++i) {
            this.m_coloredRanges[i] = new ColoredRangeManager();
        }
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setFont(this.m_font);
        this.initListeners();
        this.initHotkeys();
        this.initScrollbar();
        this.setTransferHandler(new HexTransferHandler());
        this.setScrollBarMaximum();
        this.updateOffsetViewWidth();
    }

    public Color getBackgroundColorHeader() {
        return this.m_bgColorHeader;
    }

    public void setBackgroundColorHeader(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_bgColorHeader = color;
        this.repaint();
    }

    public Color getBackgroundColorOffsetView() {
        return this.m_bgColorOffset;
    }

    public void setBackgroundColorOffsetView(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_bgColorOffset = color;
        this.repaint();
    }

    public Color getBackgroundColorHexView() {
        return this.m_bgColorHex;
    }

    public void setBackgroundColorHexView(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_bgColorHex = color;
        this.repaint();
    }

    public Color getBackgroundColorAsciiView() {
        return this.m_bgColorAscii;
    }

    public void setBackgroundColorAsciiView(Color color) {
        if (color == null) {
            throw new NullPointerException("Error: Color can't be null");
        }
        this.m_bgColorAscii = color;
        this.repaint();
    }

    public Color getFontColorHeader() {
        return this.m_fontColorHeader;
    }

    public void setFontColorHeader(Color color) {
        if (color == null) {
            throw new NullPointerException("Font color for header view can't be null");
        }
        this.m_fontColorHeader = color;
        this.repaint();
    }

    public Color getFontColorOffsetView() {
        return this.m_fontColorOffsets;
    }

    public void setFontColorOffsetView(Color color) {
        if (color == null) {
            throw new NullPointerException("Font color for offset view can't be null");
        }
        this.m_fontColorOffsets = color;
        this.repaint();
    }

    public Color getFontColorHexView1() {
        return this.m_fontColorHex1;
    }

    public void setFontColorHexView1(Color color) {
        if (color == null) {
            throw new NullPointerException("Font color for even columns can't be null");
        }
        this.m_fontColorHex1 = color;
        this.repaint();
    }

    public Color getFontColorHexView2() {
        return this.m_fontColorHex2;
    }

    public void setFontColorHexView2(Color color) {
        if (color == null) {
            throw new NullPointerException("Font color for odd columns can't be null");
        }
        this.m_fontColorHex2 = color;
        this.repaint();
    }

    public Color getFontColorAsciiView() {
        return this.m_fontColorAscii;
    }

    public void setFontColorAsciiView(Color color) {
        if (color == null) {
            throw new NullPointerException("Font color for ASCII view can't be null");
        }
        this.m_fontColorAscii = color;
        this.repaint();
    }

    public Color getSelectionColor() {
        return this.m_selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new NullPointerException("Selection color can't be null");
        }
        this.m_selectionColor = color;
        this.repaint();
    }

    public Color getFontColorModified() {
        return this.m_fontColorModified;
    }

    public void setFontColorModified(Color color) {
        if (color == null) {
            throw new NullPointerException("Font color for modified data can't be null");
        }
        this.m_fontColorModified = color;
        this.repaint();
    }

    public Color getCaretColor() {
        return this.m_caret.getColor();
    }

    public void setCaretColor(Color color) {
        this.m_caret.setColor(color);
        this.repaint();
    }

    public boolean isColorMapEnabled() {
        return this.m_colorMapEnabled;
    }

    public void setColorMapEnabled(boolean enabled) {
        if (enabled != this.m_colorMapEnabled) {
            this.m_colorMapEnabled = enabled;
            this.repaint();
        }
    }

    public IColormap getColorMap() {
        return this.m_colormap;
    }

    public void setColormap(IColormap colormap) {
        this.m_colormap = colormap;
        this.repaint();
    }

    public void colorize(int level, long offset, int size, Color color, Color bgcolor) {
        this.getColoredRange(level, offset, size).addRange(new ColoredRange(offset, size, color, bgcolor));
        this.repaint();
    }

    public void uncolorize(int level, long offset, int size) {
        this.getColoredRange(level, offset, size).removeRange(offset, size);
        this.repaint();
    }

    public void uncolorizeAll(int level) {
        this.getColoredRange(level, 0L, 1).clear();
        this.repaint();
    }

    public void uncolorizeAll() {
        for (ColoredRangeManager coloredRange : this.m_coloredRanges) {
            coloredRange.clear();
        }
        this.repaint();
    }

    private ColoredRangeManager getColoredRange(int level, long offset, int size) {
        if (level < 0 || level >= this.m_coloredRanges.length) {
            throw new IllegalArgumentException("Invalid level: " + level + ", must be in range [0 ;" + this.m_coloredRanges.length + ")");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset can't be negative: 0x" + Long.toHexString(offset));
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive: " + size);
        }
        return this.m_coloredRanges[level];
    }

    private ColoredRange findColoredRange(long currentOffset) {
        for (ColoredRangeManager element : this.m_coloredRanges) {
            ColoredRange range = element.findRangeWith(currentOffset);
            if (range == null) continue;
            return range;
        }
        return null;
    }

    public boolean canUndo() {
        return this.m_undo.canUndo();
    }

    public void undo() {
        if (this.canUndo()) {
            this.m_undo.undo();
        }
    }

    public String getUndoPresentationName() {
        return this.canUndo() ? this.m_undo.getUndoPresentationName() : "";
    }

    public boolean canRedo() {
        return this.m_undo.canRedo();
    }

    public void redo() {
        if (this.canRedo()) {
            this.m_undo.redo();
        }
    }

    public String getRedoPresentationName() {
        return this.canRedo() ? this.m_undo.getRedoPresentationName() : "";
    }

    public void resetUndo() {
        this.m_undo.die();
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        if (listener == null) {
            throw new NullPointerException("UndoableEditListener can't be null");
        }
        this.m_listeners.add(UndoableEditListener.class, listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        if (listener == null) {
            throw new NullPointerException("UndoableEditListener can't be null");
        }
        this.m_listeners.remove(UndoableEditListener.class, listener);
    }

    private void fireUndoableEditListener(UndoableEdit edit) {
        UndoableEditEvent event = null;
        Object[] l = this.m_listeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != UndoableEditListener.class) continue;
            if (event == null) {
                event = new UndoableEditEvent(this, edit);
            }
            ((UndoableEditListener)l[i + 1]).undoableEditHappened(event);
        }
    }

    public boolean isShowModified() {
        return this.m_showModified;
    }

    public void setShowModified(boolean show) {
        if (show != this.m_showModified) {
            this.m_showModified = show;
            this.repaint();
        }
    }

    public boolean isModified() {
        return !this.m_modifiedOffsets.isEmpty();
    }

    public boolean isModified(long offset) {
        return this.m_modifiedOffsets.containsKey(offset);
    }

    public int getModifiedCount(long offset) {
        Integer value = this.m_modifiedOffsets.get(offset);
        return value != null ? value : 0;
    }

    public long[] getModifiedOffsets() {
        long[] retVal = new long[this.m_modifiedOffsets.size()];
        if (!this.m_modifiedOffsets.isEmpty()) {
            int i = 0;
            Iterator<Long> iter = this.m_modifiedOffsets.keySet().iterator();
            while (iter.hasNext()) {
                retVal[i] = iter.next();
                ++i;
            }
        }
        return retVal;
    }

    public void clearModified() {
        if (!this.m_modifiedOffsets.isEmpty()) {
            this.m_modifiedOffsets.clear();
            if (this.isShowModified()) {
                this.repaint();
            }
        }
    }

    private boolean clearModified(long offset, boolean forceRemove) {
        Long key = offset;
        Integer value = this.m_modifiedOffsets.get(key);
        if (value != null) {
            int newCount = value - 1;
            if (!forceRemove && newCount > 0) {
                this.m_modifiedOffsets.put(key, newCount);
            } else {
                this.m_modifiedOffsets.remove(key);
            }
            return true;
        }
        return false;
    }

    private int setModified(long offset) {
        int retVal = 0;
        if (offset >= 0L) {
            Long key = offset;
            Integer value = this.m_modifiedOffsets.get(key);
            if (value != null) {
                retVal = value;
            }
            this.m_modifiedOffsets.put(key, retVal + 1);
        }
        return retVal;
    }

    public Views getActiveView() {
        return this.m_activeView;
    }

    public void setActiveView(Views view) {
        if (view == null) {
            throw new NullPointerException("Active view can't be null");
        }
        if (view != this.m_activeView) {
            this.m_tabAction.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    public AddressMode getAddressMode() {
        return this.m_addressMode;
    }

    public void setAddressMode(AddressMode mode) {
        if (mode == null) {
            throw new NullPointerException("Address mode can't be null");
        }
        if (this.m_addressMode != mode) {
            this.m_addressMode = mode;
            this.updateOffsetViewWidth();
            this.updatePreferredSize();
            this.repaint();
        }
    }

    public int getBytesPerColumn() {
        return this.m_bytesPerColumn;
    }

    public void setBytesPerColumn(int bytes) {
        if (bytes <= 0 || bytes > this.m_bytesPerRow) {
            throw new IllegalArgumentException("Invalid number of bytes per column: " + bytes + ", must be in range [1; " + this.m_bytesPerRow + "]");
        }
        if (this.m_bytesPerColumn != bytes) {
            this.m_bytesPerColumn = bytes;
            this.updateHexViewWidth();
            this.updatePreferredSize();
            this.repaint();
        }
    }

    public int getBytesPerRow() {
        return this.m_bytesPerRow;
    }

    public void setBytesPerRow(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Bytes per row must be positive: " + value);
        }
        if (this.m_bytesPerRow != value) {
            this.m_bytesPerRow = value;
            this.repaint();
        }
    }

    public int getColumnSpacing() {
        return this.m_columnSpacing;
    }

    public void setColumnSpacing(int spacing) {
        if (spacing <= 0) {
            throw new IllegalArgumentException("Column spacing must be positive: " + spacing);
        }
        if (this.m_columnSpacing != spacing) {
            this.m_columnSpacing = spacing;
            this.repaint();
        }
    }

    public DefinitionStatus getDefinitionStatus() {
        return this.m_status;
    }

    public void setDefinitionStatus(DefinitionStatus status) {
        if (status == null) {
            throw new NullPointerException("Definition status can't be null");
        }
        if (this.m_status != status) {
            this.m_status = status;
            this.repaint();
        }
    }

    public boolean isSeparatorsVisible() {
        return this.m_separatorsVisible;
    }

    public void setSeparatorsVisible(boolean show) {
        if (show != this.m_separatorsVisible) {
            this.m_separatorsVisible = show;
            this.repaint();
        }
    }

    public int getHexViewWidth() {
        return this.m_hexViewWidth;
    }

    public void setHexViewWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Hex view width must be positive: " + width);
        }
        if (this.m_hexViewWidth != width) {
            this.m_hexViewWidth = width;
            this.repaint();
        }
    }

    public boolean isHeaderVisible() {
        return this.m_headerVisible;
    }

    public void setHeaderVisible(boolean visible) {
        if (this.m_headerVisible != visible) {
            this.m_headerVisible = visible;
            this.m_firstDraw = true;
            this.repaint();
        }
    }

    public int getHeaderFontStyle() {
        return this.m_headerFontStyle;
    }

    public void setHeaderFontStyle(int style) {
        if (style != this.m_headerFontStyle) {
            this.m_headerFontStyle = style;
            this.repaint();
        }
    }

    public boolean isMouseOverHighlighted() {
        return this.m_mouseOverHighlighted;
    }

    public void setMouseOverHighlighted(boolean highlight) {
        if (highlight != this.m_mouseOverHighlighted) {
            this.m_mouseOverHighlighted = highlight;
            this.repaint();
        }
    }

    public boolean isFlipBytes() {
        return this.m_flipBytes;
    }

    public void setFlipBytes(boolean flip) {
        if (this.m_flipBytes != flip) {
            this.m_flipBytes = flip;
            this.repaint();
        }
    }

    @Override
    public Font getFont() {
        return this.m_font;
    }

    @Override
    public void setFont(Font font) {
        if (font != this.m_font) {
            if (font == null) {
                font = new Font("Monospaced", 0, this.m_font.getSize());
            }
            this.m_font = font;
            super.setFont(this.m_font);
            this.m_firstDraw = true;
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (editable != this.editable) {
            boolean oldVal = this.editable;
            this.editable = editable;
            this.enableInputMethods(editable);
            this.firePropertyChange("editable", (Object)oldVal, (Object)editable);
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled && !this.isEnabled()) {
            this.setScrollBarMaximum();
        }
        super.setEnabled(enabled);
    }

    public void setMenuCreator(IMenuCreator creator) {
        this.m_menuCreator = creator;
    }

    public IDataProvider getData() {
        return this.m_dataProvider;
    }

    public void setData(IDataProvider data) {
        if (this.m_dataProvider != null) {
            this.m_dataProvider.removeListener(this.m_listener);
        }
        this.m_dataProvider = data;
        if (data != null) {
            data.addListener(this.m_listener);
        }
        this.setCurrentPosition(0L);
        this.setScrollBarMaximum();
        this.selectionModel.clearSelection();
        this.repaint();
    }

    public long getBaseAddress() {
        return this.m_baseAddress;
    }

    public void setBaseAddress(long baseAddress) {
        if (baseAddress < 0L) {
            throw new IllegalArgumentException("Base address can't be negative: 0x" + Long.toHexString(baseAddress));
        }
        if (this.m_baseAddress != baseAddress) {
            this.m_baseAddress = baseAddress;
            this.repaint();
        }
    }

    public long getFirstVisibleOffset() {
        return this.getBaseAddress() + this.getFirstVisibleByte();
    }

    public int getVisibleBytes() {
        int maxVisible = this.getMaximumVisibleBytes();
        int visible = this.m_dataProvider.getDataLength() - (int)this.getFirstVisibleByte();
        return visible >= maxVisible ? maxVisible : visible;
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public long getCurrentOffset() {
        long currentOffset = this.m_baseAddress + this.m_caret.getPosition() / 2L;
        if (this.m_flipBytes) {
            return (currentOffset & (long)(-this.m_bytesPerColumn)) + (long)this.m_bytesPerColumn - currentOffset % (long)this.m_bytesPerColumn - 1L;
        }
        return currentOffset;
    }

    public void setCurrentOffset(long offset) {
        if (this.m_dataProvider == null) {
            return;
        }
        long end = this.m_baseAddress + (long)this.m_dataProvider.getDataLength();
        if (offset < this.m_baseAddress || offset > end) {
            throw new IllegalArgumentException("Invalid offset 0x" + Long.toHexString(offset) + ", must be in range [0x" + Long.toHexString(this.m_baseAddress) + "; 0x" + Long.toHexString(end) + "]");
        }
        this.setCurrentPosition(2L * (offset - this.m_baseAddress));
    }

    public void registerShortcut(Shortcut shortcut) {
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap inputMap = this.getInputMap();
        switch (shortcut) {
            case CTRL_A: {
                inputMap.put(KeyStroke.getKeyStroke(65, ctrl), "ctrl A");
                break;
            }
            case CTRL_C: {
                inputMap.put(KeyStroke.getKeyStroke(67, ctrl), "ctrl C");
                break;
            }
            case CTRL_V: {
                inputMap.put(KeyStroke.getKeyStroke(86, ctrl), "ctrl V");
                break;
            }
            case CTRL_Y: {
                inputMap.put(KeyStroke.getKeyStroke(89, ctrl), "ctrl Y");
                break;
            }
            case CTRL_Z: {
                inputMap.put(KeyStroke.getKeyStroke(90, ctrl), "ctrl Z");
            }
        }
    }

    public void unregisterShortcut(Shortcut shortcut) {
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap inputMap = this.getInputMap();
        switch (shortcut) {
            case CTRL_A: {
                inputMap.remove(KeyStroke.getKeyStroke(65, ctrl));
                break;
            }
            case CTRL_C: {
                inputMap.remove(KeyStroke.getKeyStroke(67, ctrl));
                break;
            }
            case CTRL_V: {
                inputMap.remove(KeyStroke.getKeyStroke(86, ctrl));
                break;
            }
            case CTRL_Y: {
                inputMap.remove(KeyStroke.getKeyStroke(89, ctrl));
                break;
            }
            case CTRL_Z: {
                inputMap.remove(KeyStroke.getKeyStroke(90, ctrl));
            }
        }
    }

    public void addHexListener(IHexViewListener listener) {
        if (listener == null) {
            throw new NullPointerException("IHexViewListener can't be null");
        }
        this.m_listeners.add(IHexViewListener.class, listener);
    }

    public void removeHexListener(IHexViewListener listener) {
        if (listener == null) {
            throw new NullPointerException("IHexViewListener can't be null");
        }
        this.m_listeners.remove(IHexViewListener.class, listener);
    }

    public void copy() {
        if (!this.selectionModel.isEmpty()) {
            this.m_CopyTextAction.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    public void paste() {
        this.m_PasteTextAction.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    @Deprecated
    public int findAscii(int offset, String keyword, boolean caseSensitive) {
        return (int)this.findAscii((long)offset, keyword, caseSensitive);
    }

    public long findAscii(long offset, String keyword, boolean caseSensitive) {
        if (this.getDefinitionStatus() == DefinitionStatus.DEFINED) {
            if (keyword == null) {
                throw new NullPointerException("String for search must not be null");
            }
            byte[] pattern = new byte[keyword.length()];
            for (int i = 0; i < pattern.length; ++i) {
                pattern[i] = (byte)(keyword.charAt(i) & 0xFF);
            }
            long len = (long)this.getData().getDataLength() - offset;
            return this.findIndexOf(offset, len, pattern, caseSensitive);
        }
        return -1L;
    }

    @Deprecated
    public int findHex(int offset, byte[] keyword) {
        return (int)this.findHex((long)offset, keyword);
    }

    public long findHex(long offset, byte[] keyword) {
        if (this.getDefinitionStatus() == DefinitionStatus.DEFINED) {
            if (keyword == null) {
                throw new NullPointerException("Byte array for search must not be null");
            }
            long len = (long)this.getData().getDataLength() - offset;
            return this.findIndexOf(offset, len, keyword, false);
        }
        return -1L;
    }

    @Deprecated
    public void gotoOffset(long offset) {
        if (this.m_dataProvider == null) {
            throw new IllegalStateException("No data provider active");
        }
        this.setCurrentOffset(offset);
    }

    @Override
    protected void paintComponent(Graphics gx) {
        int bytesToDraw;
        super.paintComponent(gx);
        this.resetBufferedGraphic(gx);
        this.calculateSizes();
        this.updateOffsetViewWidth();
        if (this.m_firstDraw) {
            this.m_firstDraw = false;
            this.updateHexViewWidth();
            this.updatePreferredSize();
        }
        this.drawBackground(gx);
        this.drawOffsets(gx);
        if (this.isEnabled()) {
            this.drawMouseOverHighlighting(gx);
        }
        if (this.m_status == DefinitionStatus.DEFINED && this.m_dataProvider != null && (bytesToDraw = this.getBytesToDraw()) != 0 && !this.m_dataProvider.hasData(this.getFirstVisibleByte(), bytesToDraw)) {
            this.setDefinitionStatus(DefinitionStatus.UNDEFINED);
            this.setEnabled(false);
            if (this.m_updateTimer != null) {
                this.m_updateTimer.setRepeats(false);
                this.m_updateTimer.stop();
            }
            this.m_updateTimer = new Timer(1000, new ActionWaitingForData(this.getFirstVisibleByte(), bytesToDraw));
            this.m_updateTimer.setRepeats(true);
            this.m_updateTimer.start();
            return;
        }
        if (this.isDataAvailable() || this.m_status == DefinitionStatus.UNDEFINED) {
            this.drawHexView(gx);
            this.drawAsciiPanel(gx);
            if (this.hasFocus()) {
                this.drawCaret((Graphics2D)gx);
            }
        }
    }

    private void drawBackground(Graphics g) {
        int w;
        int H = this.getHeight();
        int W = this.getWidth();
        int HH = this.getHeaderHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, W, H);
        int x1 = -this.m_firstColumn * this.m_charWidth;
        int x2 = x1 + this.m_offsetViewWidth;
        int x3 = x2 + this.m_hexViewWidth;
        if (this.m_headerVisible) {
            w = W - x1 - this.m_scrollbar.getWidth();
            g.setColor(this.m_bgColorHeader);
            g.fillRect(x1, 0, w, HH);
        }
        g.setColor(this.m_bgColorOffset);
        g.fillRect(x1, HH, this.m_offsetViewWidth, H);
        g.setColor(this.m_bgColorHex);
        g.fillRect(x2, HH, this.m_hexViewWidth, H);
        w = this.m_bytesPerRow * this.m_charWidth + 20;
        g.setColor(this.m_bgColorAscii);
        g.fillRect(x3, HH, w, H);
        if (this.m_separatorsVisible) {
            g.setColor(Color.BLACK);
            g.drawLine(x2, HH, x2, H);
            g.drawLine(x3, HH, x3, H);
        }
    }

    private void drawOffsets(Graphics g) {
        int x = -this.m_firstColumn * this.m_charWidth + 10;
        if (this.m_headerVisible) {
            Font oldFont = this.getFont();
            g.setFont(oldFont.deriveFont(this.m_headerFontStyle));
            g.setColor(this.m_fontColorHeader);
            String title = this.getHeaderTitleOffset(this.m_addressMode);
            g.drawString(title, x, 16);
            g.setFont(oldFont);
        }
        if (this.isEnabled()) {
            g.setColor(this.m_fontColorOffsets);
        } else {
            g.setColor(this.m_disabledColor != this.m_bgColorOffset ? this.m_disabledColor : Color.WHITE);
        }
        int bytesToDraw = this.m_status == DefinitionStatus.DEFINED && this.m_dataProvider.getDataLength() > 0 ? this.getBytesToDraw() : this.m_bytesPerRow;
        String formatString = this.getAddressModeFormat(this.m_addressMode);
        for (int i = 0; i < bytesToDraw; i += this.m_bytesPerRow) {
            long address = this.m_baseAddress + (long)(this.m_firstRow * this.m_bytesPerRow) + (long)i;
            String offsetString = String.format(formatString, address);
            int currentRow = i / this.m_bytesPerRow;
            int y = 16 + this.getHeaderHeight() + currentRow * this.m_rowHeight;
            g.drawString(offsetString, x, y);
        }
    }

    private void drawMouseOverHighlighting(Graphics g) {
        if (this.m_mouseOverHighlighted) {
            long nibble = this.getNibbleAtCoordinate(this.m_lastMouseX, this.m_lastMouseY);
            if (nibble == -1L) {
                return;
            }
            int relativeNibble = (int)(nibble - 2L * this.getFirstVisibleByte());
            if (relativeNibble >= 0 && relativeNibble <= 2 * this.getMaximumVisibleBytes()) {
                Views lastHighlightedView = this.m_lastMouseX >= this.getAsciiViewLeft() ? Views.ASCII_VIEW : Views.HEX_VIEW;
                g.setColor(this.m_colorHighlight);
                if (lastHighlightedView == Views.HEX_VIEW) {
                    this.drawNibbleBoundsHex(g, relativeNibble);
                } else if (lastHighlightedView == Views.ASCII_VIEW) {
                    this.drawNibbleBoundsHex(g, relativeNibble);
                    this.drawNibbleBoundsHex(g, relativeNibble + 1);
                }
                this.drawByteBoundsAscii(g, relativeNibble / 2);
            }
        }
    }

    private void drawNibbleBoundsHex(Graphics g, int position) {
        int row = position / (2 * this.m_bytesPerRow);
        int column = position % (2 * this.m_bytesPerRow) / (2 * this.m_bytesPerColumn);
        int nibble = position % (2 * this.m_bytesPerRow) % (2 * this.m_bytesPerColumn);
        int x = this.getHexViewLeft() + 10 + column * this.getColumnSize() + nibble * this.m_charWidth;
        int y = 16 + this.getHeaderHeight() - this.m_charHeight + row * this.m_rowHeight;
        g.fillRect(x, y, this.m_charWidth, this.m_charMaxAscent + this.m_charMaxDescent);
    }

    private void drawByteBoundsAscii(Graphics g, int position) {
        int row = position / this.m_bytesPerRow;
        int chr = position % this.m_bytesPerRow;
        int x = this.getAsciiViewLeft() + 10 + chr * this.m_charWidth;
        int y = 16 + this.getHeaderHeight() - this.m_charHeight + row * this.m_rowHeight;
        g.fillRect(x, y, this.m_charWidth, this.m_charMaxAscent + this.m_charMaxDescent);
    }

    private void drawHexView(Graphics g) {
        int bytesToDraw;
        int standardSize = 2 * this.m_charWidth;
        int firstX = -this.m_firstColumn * this.m_charWidth + 10 + this.m_offsetViewWidth;
        if (this.m_headerVisible) {
            Font oldFont = this.getFont();
            g.setFont(oldFont.deriveFont(this.m_headerFontStyle));
            g.setColor(this.m_fontColorHeader);
            int x = firstX;
            for (int i = 0; i < this.m_bytesPerRow; ++i) {
                if (i != 0 && i % this.m_bytesPerColumn == 0) {
                    x += this.m_columnSpacing;
                }
                g.drawString(HEX_BYTES[i & 0xFF], x, 16);
                x += standardSize;
            }
            g.setFont(oldFont);
        }
        int x = firstX;
        int y = 16 + this.getHeaderHeight();
        boolean evenColumn = true;
        byte[] data = null;
        long dataOffset = this.getFirstVisibleByte();
        if (this.m_status == DefinitionStatus.DEFINED) {
            bytesToDraw = this.getBytesToDraw();
            data = this.m_dataProvider.getData(dataOffset, bytesToDraw);
        } else {
            bytesToDraw = this.getMaximumVisibleBytes();
        }
        int i = 0;
        while (i < bytesToDraw) {
            if (i != 0) {
                if (i % this.m_bytesPerRow == 0) {
                    x = firstX;
                    y += this.m_rowHeight;
                    evenColumn = true;
                } else if (i % this.m_bytesPerColumn == 0) {
                    x += this.m_columnSpacing;
                    boolean bl = evenColumn = !evenColumn;
                }
            }
            if (this.isEnabled()) {
                int preSpaceX = 0;
                int postSpaceX = 0;
                if (i % this.m_bytesPerColumn == 0) {
                    preSpaceX = this.m_columnSpacing / 2;
                }
                if (i % this.m_bytesPerColumn == this.m_bytesPerColumn - 1) {
                    postSpaceX = this.m_columnSpacing / 2;
                }
                if (this.selectionModel.isSelected(2L * dataOffset)) {
                    g.setColor(this.m_selectionColor);
                    g.fillRect(x - preSpaceX, y - this.m_charMaxAscent, 2 * this.m_charWidth + preSpaceX + postSpaceX, this.m_charMaxAscent + this.m_charMaxDescent);
                    g.setColor(evenColumn ? this.m_fontColorHex1 : this.m_fontColorHex2);
                } else {
                    ColoredRange range = this.findColoredRange(dataOffset);
                    if (range != null) {
                        Color bgColor = range.getBackgroundColor();
                        if (bgColor != null) {
                            g.setColor(bgColor);
                        }
                        g.fillRect(x - preSpaceX, y - this.m_charMaxAscent, 2 * this.m_charWidth + preSpaceX + postSpaceX, this.m_charMaxAscent + this.m_charMaxDescent);
                        g.setColor(range.getColor());
                    } else if (this.m_colorMapEnabled && this.m_colormap != null && this.m_colormap.colorize(data[i], dataOffset)) {
                        Color foregroundColor;
                        Color backgroundColor = this.m_colormap.getBackgroundColor(data[i], dataOffset);
                        Color color = foregroundColor = this.isShowModified() && this.isModified(dataOffset) ? this.m_fontColorModified : this.m_colormap.getForegroundColor(data[i], dataOffset);
                        if (backgroundColor != null) {
                            g.setColor(backgroundColor);
                            g.fillRect(x - preSpaceX, y - this.m_charMaxAscent, 2 * this.m_charWidth + preSpaceX + postSpaceX, this.m_charMaxAscent + this.m_charMaxDescent);
                        }
                        if (foregroundColor != null) {
                            g.setColor(foregroundColor);
                        } else {
                            g.setColor(evenColumn ? this.m_fontColorHex1 : this.m_fontColorHex2);
                        }
                    } else if (this.isShowModified() && this.isModified(dataOffset)) {
                        g.setColor(this.m_fontColorModified);
                    } else {
                        g.setColor(evenColumn ? this.m_fontColorHex1 : this.m_fontColorHex2);
                    }
                }
            } else {
                g.setColor(this.m_disabledColor != this.m_bgColorHex ? this.m_disabledColor : Color.WHITE);
            }
            if (this.m_status == DefinitionStatus.DEFINED) {
                int columnBytes = Math.min(this.m_dataProvider.getDataLength() - i, this.m_bytesPerColumn);
                int dataPosition = this.m_flipBytes ? i / this.m_bytesPerColumn * this.m_bytesPerColumn + (columnBytes - i % columnBytes - 1) : i;
                g.drawString(HEX_BYTES[data[dataPosition] & 0xFF], x, y);
            } else {
                g.drawString("??", x, y);
            }
            x += standardSize;
            ++i;
            ++dataOffset;
        }
    }

    private void drawAsciiPanel(Graphics g) {
        int bytesToDraw;
        int initx;
        int x = initx = this.getAsciiViewLeft() + 10;
        int y = 16 + this.getHeaderHeight();
        if (this.m_headerVisible) {
            Font oldFont = this.getFont();
            g.setFont(oldFont.deriveFont(this.m_headerFontStyle));
            g.setColor(this.m_fontColorHeader);
            String title = this.getHeaderTitleAscii(this.m_addressMode);
            g.drawString(title, x, 16);
            g.setFont(oldFont);
        }
        if (this.isEnabled()) {
            g.setColor(this.m_fontColorAscii);
        } else {
            g.setColor(this.m_disabledColor != this.m_bgColorAscii ? this.m_disabledColor : Color.WHITE);
        }
        byte[] data = null;
        long dataOffset = this.getFirstVisibleByte();
        if (this.m_status == DefinitionStatus.DEFINED) {
            bytesToDraw = this.getBytesToDraw();
            data = this.m_dataProvider.getData(dataOffset, bytesToDraw);
        } else {
            bytesToDraw = this.getMaximumVisibleBytes();
        }
        int i = 0;
        while (i < bytesToDraw) {
            if (i != 0 && i % this.m_bytesPerRow == 0) {
                x = initx;
                y += this.m_rowHeight;
            }
            if (this.m_status == DefinitionStatus.DEFINED) {
                byte b = data[i];
                if (this.isEnabled()) {
                    if (this.selectionModel.isSelected(2L * dataOffset)) {
                        g.setColor(this.m_selectionColor);
                        g.fillRect(x, y - this.m_charMaxAscent, this.m_charWidth, this.m_charMaxAscent + this.m_charMaxDescent);
                        if (this.isShowModified() && this.isModified(dataOffset)) {
                            g.setColor(this.m_fontColorModified);
                        } else {
                            g.setColor(this.m_fontColorAscii);
                        }
                    } else {
                        ColoredRange range = this.findColoredRange(dataOffset);
                        if (range != null && dataOffset + (long)bytesToDraw >= range.getStart()) {
                            Color bgColor = range.getBackgroundColor();
                            if (bgColor != null) {
                                g.setColor(bgColor);
                            }
                            g.fillRect(x, y - this.m_charMaxAscent, this.m_charWidth, this.m_charMaxAscent + this.m_charMaxDescent);
                            g.setColor(range.getColor());
                        } else if (this.m_colorMapEnabled && this.m_colormap != null && this.m_colormap.colorize(b, dataOffset)) {
                            Color foregroundColor;
                            Color backgroundColor = this.m_colormap.getBackgroundColor(b, dataOffset);
                            Color color = foregroundColor = this.isShowModified() && this.isModified(dataOffset) ? this.m_fontColorModified : this.m_colormap.getForegroundColor(b, dataOffset);
                            if (backgroundColor != null) {
                                g.setColor(backgroundColor);
                                g.fillRect(x, y - this.m_charMaxAscent, this.m_charWidth, this.m_charMaxAscent + this.m_charMaxDescent);
                            }
                            if (foregroundColor != null) {
                                g.setColor(foregroundColor);
                            } else {
                                g.setColor(this.m_fontColorAscii);
                            }
                        } else if (this.isShowModified() && this.isModified(dataOffset)) {
                            g.setColor(this.m_fontColorModified);
                        } else {
                            g.setColor(this.m_fontColorAscii);
                        }
                    }
                } else {
                    g.setColor(this.m_disabledColor != this.m_bgColorAscii ? this.m_disabledColor : Color.WHITE);
                }
                g.drawString(ASCII_VIEW_TABLE[b & 0xFF], x, y);
            } else {
                g.drawString("?", x, y);
            }
            x += this.m_charWidth;
            ++i;
            ++dataOffset;
        }
    }

    private void drawCaret(Graphics2D g) {
        long first = this.getFirstVisibleByte();
        if (this.m_caret.getPosition() < 2L * first || (long)this.getCurrentColumn() > first + (long)this.getMaximumVisibleBytes()) {
            return;
        }
        boolean isHex = this.m_activeView == Views.HEX_VIEW;
        this.drawCaretHexWindow(g, isHex);
        this.drawCaretAsciiWindow(g, !isHex);
    }

    private void drawCaretHexWindow(Graphics2D g, boolean showCaret) {
        int currentRow = this.getCurrentRow() - this.m_firstRow;
        int currentColumn = this.getCurrentColumn();
        int startLeft = 9 + this.m_offsetViewWidth;
        int paddingColumns = currentColumn / (2 * this.m_bytesPerColumn) * this.m_columnSpacing;
        int x = (currentColumn - this.m_firstColumn) * this.m_charWidth + startLeft + paddingColumns;
        int y = 16 + this.getHeaderHeight() - this.m_charHeight + this.m_rowHeight * currentRow;
        if (showCaret && this.isEditable()) {
            if (this.m_caret.isVisible()) {
                this.m_caret.draw(g, x, y, this.m_rowHeight);
            }
        } else {
            Stroke oldStroke = g.getStroke();
            g.setStroke(DOTTED_STROKE);
            g.drawRect(x, y, showCaret ? this.m_charWidth : this.m_charWidth * 2 + 1, this.m_rowHeight);
            g.setStroke(oldStroke);
        }
    }

    private void drawCaretAsciiWindow(Graphics2D g, boolean showCaret) {
        int currentRow = this.getCurrentRow() - this.m_firstRow;
        int currentColumn = this.getCurrentColumn();
        int currentCharacter = currentColumn / 2;
        int startLeft = 9 + this.m_offsetViewWidth + this.m_hexViewWidth;
        int x = (currentCharacter - this.m_firstColumn) * this.m_charWidth + startLeft;
        int y = 16 + this.getHeaderHeight() - this.m_charHeight + this.m_rowHeight * currentRow;
        if (showCaret && this.isEditable()) {
            if (this.m_caret.isVisible()) {
                this.m_caret.draw(g, x, y, this.m_rowHeight);
            }
        } else {
            Stroke oldStroke = g.getStroke();
            g.setStroke(DOTTED_STROKE);
            g.drawRect(x, y, this.m_charWidth, this.m_rowHeight);
            g.setStroke(oldStroke);
        }
    }

    private void calculateSizes() {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                FontMetrics m = g.getFontMetrics();
                this.m_rowHeight = m.getHeight();
                this.m_charHeight = m.getAscent();
                this.m_charMaxAscent = m.getMaxAscent();
                this.m_charMaxDescent = m.getMaxDescent();
                this.m_charWidth = (int)m.getStringBounds("0", g).getWidth();
            }
            finally {
                g.dispose();
            }
        }
    }

    private void changeBy(ActionEvent event, long length) {
        this.changeBy((event.getModifiers() & 1) == 1, length);
    }

    private void changeBy(boolean expandSelection, long length) {
        long newPos;
        long oldPos = this.m_caret.getPosition();
        long pos = oldPos + length;
        if (pos < 0L) {
            newPos = 0L;
        } else {
            int nibbleCount = 2 * this.m_dataProvider.getDataLength();
            long l = newPos = pos < (long)nibbleCount ? pos : (long)nibbleCount;
        }
        if (expandSelection) {
            SelectionModel.Interval newSel = new SelectionModel.Interval(Math.min(oldPos, newPos), Math.max(oldPos, newPos));
            if (this.selectionModel.isSelected(newPos)) {
                this.selectionModel.removeSelectionInterval(newSel);
            } else {
                this.selectionModel.addSelectionInterval(newSel);
            }
        } else {
            this.selectionModel.clearSelection();
        }
        this.m_caret.setPosition(newPos);
        if (newPos < 2L * this.getFirstVisibleByte()) {
            this.scrollToPosition(newPos);
        } else if (newPos >= 2L * (this.getFirstVisibleByte() + (long)this.getMaximumVisibleBytes())) {
            this.scrollToPosition(newPos + (long)(2 * (this.m_bytesPerRow - this.getMaximumVisibleBytes())));
        }
        this.m_caret.setVisible(true);
        this.repaint();
    }

    private long findIndexOf(long startPos, long length, byte[] pattern, boolean caseSensitive) {
        byte b;
        int j;
        if (pattern.length == 0) {
            return startPos;
        }
        IDataProvider data = this.getData();
        int dataLength = data.getDataLength();
        if (startPos < 0L) {
            startPos = 0L;
        }
        if (length < 0L) {
            length = 0L;
        }
        if (startPos + length > (long)dataLength) {
            length = (long)dataLength - startPos;
        }
        if (length <= 0L) {
            return -1L;
        }
        for (int i = 0; i < pattern.length; ++i) {
            pattern[i] = this.normalizeByte(pattern[i], caseSensitive);
        }
        int[] byteTable = this.findMakeByteTable(pattern);
        int[] offsetTable = this.findMakeOffsetTable(pattern);
        for (long off = startPos + (long)pattern.length - 1L; off < startPos + length; off += (long)Math.max(offsetTable[pattern.length - 1 - j], byteTable[b & 0xFF])) {
            j = pattern.length - 1;
            while (pattern[j] == (b = this.normalizeByte(data.getData(off, 1)[0], caseSensitive))) {
                if (j == 0) {
                    return off;
                }
                --off;
                --j;
            }
        }
        return -1L;
    }

    private byte normalizeByte(byte value, boolean caseSensitive) {
        char ch;
        if (!caseSensitive && JHexView.isPrintableCharacter(ch = JHexView.toChar(value))) {
            int chLo = Character.toLowerCase(ch);
            return (byte)(chLo < 128 ? chLo : 63);
        }
        return value;
    }

    private int[] findMakeByteTable(byte[] pattern) {
        int i;
        int[] table = new int[256];
        for (i = 0; i < table.length; ++i) {
            table[i] = pattern.length;
        }
        for (i = 0; i < pattern.length - 1; ++i) {
            table[pattern[i] & 0xFF] = pattern.length - 1 - i;
        }
        return table;
    }

    private int[] findMakeOffsetTable(byte[] pattern) {
        int i;
        int[] table = new int[pattern.length];
        int lastPrefixPos = pattern.length;
        for (i = pattern.length - 1; i >= 0; --i) {
            if (this.findIsPrefix(pattern, i + 1)) {
                lastPrefixPos = i + 1;
            }
            table[pattern.length - 1 - i] = lastPrefixPos - i + pattern.length - 1;
        }
        for (i = 0; i < pattern.length - 1; ++i) {
            int slen = this.findSuffixLength(pattern, i);
            table[slen] = pattern.length - 1 - i + slen;
        }
        return table;
    }

    private boolean findIsPrefix(byte[] pattern, int p) {
        int i = p;
        int j = 0;
        while (i < pattern.length) {
            if (pattern[i] != pattern[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private int findSuffixLength(byte[] pattern, int p) {
        int len = 0;
        int i = p;
        int j = pattern.length - 1;
        while (i >= 0 && pattern[i] == pattern[j]) {
            ++len;
            --i;
            --j;
        }
        return len;
    }

    private void fireHexListener(Views view) {
        HexViewEvent event = null;
        Object[] l = this.m_listeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != IHexViewListener.class) continue;
            if (event == null) {
                event = new HexViewEvent(this, view);
            }
            ((IHexViewListener)l[i + 1]).stateChanged(event);
        }
    }

    private int getAddressDigits(AddressMode mode) {
        switch (mode) {
            case BIT8: {
                return 2;
            }
            case BIT16: {
                return 4;
            }
            case BIT24: {
                return 6;
            }
            case BIT32: {
                return 8;
            }
            case BIT40: {
                return 10;
            }
            case BIT48: {
                return 12;
            }
            case BIT56: {
                return 14;
            }
        }
        return 16;
    }

    private String getAddressModeFormat(AddressMode mode) {
        return String.format("%%0%1$dX", this.getAddressDigits(mode));
    }

    private int getAsciiViewLeft() {
        return this.getHexViewLeft() + this.getHexViewWidth();
    }

    private int getBytesToDraw() {
        int firstVisibleByte = (int)this.getFirstVisibleByte();
        int maxBytes = this.getMaximumVisibleBytes() + this.m_bytesPerRow;
        int restBytes = this.m_dataProvider.getDataLength() - firstVisibleByte;
        return Math.min(maxBytes, restBytes);
    }

    private int getColumnSize() {
        return 2 * this.m_bytesPerColumn * this.m_charWidth + this.m_columnSpacing;
    }

    private int getCurrentColumn() {
        return (int)this.m_caret.getPosition() % (2 * this.m_bytesPerRow);
    }

    private int getCurrentRow() {
        return (int)this.m_caret.getPosition() / (2 * this.m_bytesPerRow);
    }

    private long getFirstVisibleByte() {
        return this.m_firstRow * this.m_bytesPerRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHeaderHeight() {
        Graphics g;
        if (this.m_headerVisible && (g = this.getGraphics()) != null) {
            try {
                FontMetrics m = g.getFontMetrics();
                int n = m.getMaxAscent() + m.getMaxDescent();
                return n;
            }
            finally {
                g.dispose();
            }
        }
        return 0;
    }

    private String getHeaderTitleOffset(AddressMode mode) {
        int length = this.getAddressDigits(mode);
        String retVal = length < 2 ? "" : (length < 4 ? "Of" : (length < 6 ? "Ofs." : (length < 9 ? "Offset" : "Offset(h)")));
        return retVal;
    }

    private String getHeaderTitleAscii(AddressMode mode) {
        int length = this.m_bytesPerRow;
        String retVal = length < 5 ? "" : "ASCII";
        return retVal;
    }

    private int getHexViewLeft() {
        return -this.m_firstColumn * this.m_charWidth + this.m_offsetViewWidth;
    }

    private int getMaximumVisibleBytes() {
        return this.getNumberOfVisibleRows() * this.m_bytesPerRow;
    }

    private long getNibbleAtCoordinate(int x, int y) {
        if (this.m_dataProvider != null && y >= 16 + this.getHeaderHeight() - this.m_font.getSize()) {
            int left = this.getHexViewLeft();
            if (x >= left + this.getHexViewWidth()) {
                return this.getNibbleAtCoordinatesAscii(x, y);
            }
            if (x >= left + 10) {
                return this.getNibbleAtCoordinatesHex(x, y);
            }
        }
        return -1L;
    }

    private long getNibbleAtCoordinatesAscii(int x, int y) {
        int normalizedX = x - (this.getAsciiViewLeft() + 10);
        if (normalizedX < 0 || normalizedX / this.m_charWidth >= this.m_bytesPerRow) {
            return -1L;
        }
        int row = (y - (16 + this.getHeaderHeight() - this.m_charHeight)) / this.m_rowHeight;
        long byteAtPos = this.getFirstVisibleByte() + (long)(row * this.m_bytesPerRow) + (long)(normalizedX / this.m_charWidth);
        return byteAtPos >= (long)this.m_dataProvider.getDataLength() ? -1L : 2L * byteAtPos;
    }

    private long getNibbleAtCoordinatesHex(int x, int y) {
        int columnSize;
        int normalizedX = x - (this.getHexViewLeft() + 10);
        int column = normalizedX / (columnSize = this.getColumnSize());
        if (column >= this.m_bytesPerRow / this.m_bytesPerColumn) {
            return -1L;
        }
        int xInColumn = normalizedX % columnSize;
        int nibbleInColumn = xInColumn / this.m_charWidth;
        if (nibbleInColumn >= 2 * this.m_bytesPerColumn) {
            return -1L;
        }
        int row = (y - (16 + this.getHeaderHeight() - this.m_charHeight)) / this.m_rowHeight;
        long byteAtPos = this.getFirstVisibleByte() + (long)(row * this.m_bytesPerRow) + (long)(column * this.m_bytesPerColumn);
        long position = 2L * byteAtPos + (long)nibbleInColumn;
        return position >= (long)(2 * this.m_dataProvider.getDataLength()) ? -1L : position;
    }

    private int getNumberOfVisibleRows() {
        int rawHeight = this.getHeight() - 16 - this.getHeaderHeight() - this.m_horizontalScrollbar.getHeight();
        return rawHeight / this.m_rowHeight + (rawHeight % this.m_rowHeight == 0 ? 0 : 1);
    }

    private void initHotkeys() {
        int none = 0;
        int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        int shift = 1;
        this.setFocusTraversalKeys(0, new HashSet());
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, none), "LEFT");
        actionMap.put("LEFT", this.m_leftAction);
        inputMap.put(KeyStroke.getKeyStroke(37, shift), "shift LEFT");
        actionMap.put("shift LEFT", this.m_shiftLeftAction);
        inputMap.put(KeyStroke.getKeyStroke(39, none), "RIGHT");
        actionMap.put("RIGHT", this.m_rightAction);
        inputMap.put(KeyStroke.getKeyStroke(39, shift), "shift RIGHT");
        actionMap.put("shift RIGHT", this.m_shiftRightAction);
        inputMap.put(KeyStroke.getKeyStroke(38, none), "UP");
        actionMap.put("UP", this.m_upAction);
        inputMap.put(KeyStroke.getKeyStroke(38, shift), "shift UP");
        actionMap.put("shift UP", this.m_upAction);
        inputMap.put(KeyStroke.getKeyStroke(40, none), "DOWN");
        actionMap.put("DOWN", this.m_downAction);
        inputMap.put(KeyStroke.getKeyStroke(40, shift), "shift DOWN");
        actionMap.put("shift DOWN", this.m_downAction);
        inputMap.put(KeyStroke.getKeyStroke(34, none), "PAGE_DOWN");
        actionMap.put("PAGE_DOWN", this.m_pageDownAction);
        inputMap.put(KeyStroke.getKeyStroke(34, shift), "shift PAGE_DOWN");
        actionMap.put("shift PAGE_DOWN", this.m_pageDownAction);
        inputMap.put(KeyStroke.getKeyStroke(33, none), "PAGE_UP");
        actionMap.put("PAGE_UP", this.m_pageUpAction);
        inputMap.put(KeyStroke.getKeyStroke(33, shift), "shift PAGE_UP");
        actionMap.put("shift PAGE_UP", this.m_pageUpAction);
        inputMap.put(KeyStroke.getKeyStroke(36, none), "HOME");
        actionMap.put("HOME", this.m_homeLineAction);
        inputMap.put(KeyStroke.getKeyStroke(36, shift), "shift HOME");
        actionMap.put("shift HOME", this.m_homeLineAction);
        inputMap.put(KeyStroke.getKeyStroke(36, ctrl), "ctrl HOME");
        actionMap.put("ctrl HOME", this.m_homeDocAction);
        inputMap.put(KeyStroke.getKeyStroke(36, ctrl + shift), "ctrl shift HOME");
        actionMap.put("ctrl shift HOME", this.m_homeDocAction);
        inputMap.put(KeyStroke.getKeyStroke(35, none), "END");
        actionMap.put("END", this.m_endLineAction);
        inputMap.put(KeyStroke.getKeyStroke(35, shift), "shift END");
        actionMap.put("shift END", this.m_endLineAction);
        inputMap.put(KeyStroke.getKeyStroke(35, ctrl), "ctrl END");
        actionMap.put("ctrl END", this.m_endDocAction);
        inputMap.put(KeyStroke.getKeyStroke(35, ctrl + shift), "ctrl shift END");
        actionMap.put("ctrl shift END", this.m_endDocAction);
        inputMap.put(KeyStroke.getKeyStroke(9, none), "TAB");
        actionMap.put("TAB", this.m_tabAction);
        inputMap.put(KeyStroke.getKeyStroke(65, ctrl), "ctrl A");
        actionMap.put("ctrl A", this.m_SelectAllAction);
        inputMap.put(KeyStroke.getKeyStroke(86, ctrl), "ctrl V");
        actionMap.put("ctrl V", this.m_PasteTextAction);
        inputMap.put(KeyStroke.getKeyStroke(67, ctrl), "ctrl C");
        actionMap.put("ctrl C", this.m_CopyTextAction);
        inputMap.put(KeyStroke.getKeyStroke(90, ctrl), "ctrl Z");
        actionMap.put("ctrl Z", this.m_UndoAction);
        inputMap.put(KeyStroke.getKeyStroke(89, ctrl), "ctrl Y");
        actionMap.put("ctrl Y", this.m_RedoAction);
    }

    private void initListeners() {
        this.addMouseListener(this.m_listener);
        this.addMouseMotionListener(this.m_listener);
        this.addMouseWheelListener(this.m_listener);
        this.addFocusListener(this.m_listener);
        this.addComponentListener(this.m_listener);
        this.addKeyListener(this.m_listener);
        this.addUndoableEditListener(this.m_listener);
        this.m_caret.addCaretListener(this.m_listener);
    }

    private void initScrollbar() {
        this.m_scrollbar.addAdjustmentListener(this.m_listener);
        this.add((Component)this.m_scrollbar, "East");
        this.m_horizontalScrollbar.addAdjustmentListener(this.m_listener);
        this.add((Component)this.m_horizontalScrollbar, "South");
    }

    private boolean isDataAvailable() {
        return this.m_dataProvider != null;
    }

    private boolean isInsideAsciiView(int x, int y) {
        return y >= 16 + this.getHeaderHeight() - this.m_font.getSize() && x >= this.getAsciiViewLeft();
    }

    private boolean isInsideHexView(int x, int y) {
        return y >= 16 + this.getHeaderHeight() - this.m_font.getSize() && x >= this.getHexViewLeft() && x < this.getHexViewLeft() + this.getHexViewWidth();
    }

    private boolean isPositionVisible(long position) {
        long firstVisible = this.getFirstVisibleByte();
        long lastVisible = firstVisible + (long)this.getMaximumVisibleBytes();
        return position >= 2L * firstVisible && position <= 2L * lastVisible;
    }

    private void resetBufferedGraphic(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setFont(this.m_font);
    }

    private void scrollToPosition(long position) {
        this.m_scrollbar.setValue((int)position / (2 * this.m_bytesPerRow));
    }

    private void setCurrentPosition(long newPosition) {
        if (!this.isPositionVisible(newPosition)) {
            this.scrollToPosition(newPosition);
        }
        this.m_caret.setPosition(newPosition);
    }

    private void setScrollBarMaximum() {
        if (this.m_dataProvider == null) {
            this.m_scrollbar.setMaximum(1);
            this.m_horizontalScrollbar.setMaximum(1);
        } else {
            int visibleRows = this.getNumberOfVisibleRows();
            int totalRows = this.m_dataProvider.getDataLength() / this.m_bytesPerRow;
            int scrollRange = 2 + totalRows - visibleRows;
            if (scrollRange < 0) {
                scrollRange = 0;
                this.m_scrollbar.setEnabled(false);
            } else {
                this.m_scrollbar.setEnabled(true);
            }
            this.m_scrollbar.setValue(Math.min(this.m_scrollbar.getValue(), scrollRange));
            this.m_scrollbar.setMaximum(scrollRange + visibleRows);
            this.m_scrollbar.setVisibleAmount(visibleRows);
            this.m_scrollbar.setBlockIncrement(visibleRows);
            int totalWidth = this.getAsciiViewLeft() + 10 + this.m_charWidth * this.m_bytesPerRow;
            int realWidth = this.getWidth() - this.m_scrollbar.getWidth();
            if (realWidth >= totalWidth) {
                this.m_horizontalScrollbar.setValue(0);
                this.m_horizontalScrollbar.setEnabled(false);
            } else {
                this.m_horizontalScrollbar.setMaximum((totalWidth - realWidth) / this.m_charWidth + 1);
                this.m_horizontalScrollbar.setEnabled(true);
            }
        }
    }

    private void updateHexViewWidth() {
        this.m_hexViewWidth = 15 + this.getColumnSize() * this.getBytesPerRow() / this.getBytesPerColumn();
    }

    private void updateOffsetViewWidth() {
        int addressBytes = this.getAddressDigits(this.m_addressMode);
        this.m_offsetViewWidth = 20 + this.m_charWidth * addressBytes;
    }

    private void updatePreferredSize() {
        int width = this.m_offsetViewWidth + this.m_hexViewWidth + 18 * this.m_charWidth + this.m_scrollbar.getWidth();
        this.setPreferredSize(new Dimension(width, this.getHeight()));
        this.revalidate();
    }

    private boolean needSkip(byte value) {
        char ch = JHexView.toChar(value);
        return ".,:;()?!-'/\"".indexOf(ch) >= 0 || Character.isWhitespace(ch) || !this.getFont().canDisplay(ch);
    }

    private void expandSelection(long offset) {
        long start = offset;
        long end = offset;
        if (!this.needSkip(this.m_dataProvider.getData(offset, 1)[0])) {
            int i = 1;
            while ((long)i < offset && !this.needSkip(this.m_dataProvider.getData(offset - (long)i, 1)[0])) {
                --start;
                ++i;
            }
            long maxLength = (long)this.m_dataProvider.getDataLength() - offset;
            int i2 = 1;
            while ((long)i2 < maxLength && !this.needSkip(this.m_dataProvider.getData(offset + (long)i2, 1)[0])) {
                ++end;
                ++i2;
            }
        }
        end = 2L * end + 1L;
        this.selectionModel.setSelectionInterval(2L * start, end);
        this.m_caret.setPosition(end + 1L);
    }

    public void dispose() {
        this.removeMouseListener(this.m_listener);
        this.removeMouseMotionListener(this.m_listener);
        this.removeMouseWheelListener(this.m_listener);
        this.removeFocusListener(this.m_listener);
        this.removeComponentListener(this.m_listener);
        this.removeKeyListener(this.m_listener);
        this.m_caret.removeListener(this.m_listener);
        this.m_caret.stop();
    }

    public void selectAll() {
        this.m_SelectAllAction.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    private static boolean isHexCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isPrintableCharacter(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    private static char toChar(byte b) {
        return (char)(b >= 0 ? (int)b : 65533);
    }

    static {
        DOTTED_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);
        ASCII_VIEW_TABLE = new String[256];
        Arrays.fill(ASCII_VIEW_TABLE, ".");
        for (int i = 32; i < 127; ++i) {
            JHexView.ASCII_VIEW_TABLE[i] = String.valueOf((char)i);
        }
    }

    public static enum Shortcut {
        CTRL_A,
        CTRL_C,
        CTRL_V,
        CTRL_Y,
        CTRL_Z;

    }

    public static enum Views {
        HEX_VIEW,
        ASCII_VIEW;

    }

    public static enum DefinitionStatus {
        DEFINED,
        UNDEFINED;

    }

    public static enum AddressMode {
        BIT8,
        BIT16,
        BIT24,
        BIT32,
        BIT40,
        BIT48,
        BIT56,
        BIT64;

    }

    private class InternalListener
    implements AdjustmentListener,
    MouseListener,
    MouseMotionListener,
    FocusListener,
    ICaretListener,
    IDataChangedListener,
    ComponentListener,
    KeyListener,
    MouseWheelListener,
    UndoableEditListener {
        private long startNibble = -1L;

        private InternalListener() {
        }

        private void keyPressedInAsciiView(char ch) {
            byte newValue;
            long offset = JHexView.this.m_caret.getPosition() / 2L;
            byte[] data = JHexView.this.m_dataProvider.getData(offset, 1);
            if (data == null || data.length == 0) {
                return;
            }
            byte oldValue = data[0];
            data[0] = newValue = (byte)ch;
            JHexView.this.m_dataProvider.setData(offset, data);
            JHexView.this.setModified(offset);
            JHexView.this.fireUndoableEditListener(new DataEdit(offset, oldValue, newValue, JHexView.this.getActiveView()));
            JHexView.this.changeBy(false, 2L);
        }

        private void keyPressedInHexView(char ch) {
            int value = Character.digit(ch, 16);
            if (value == -1) {
                return;
            }
            long offset = JHexView.this.m_caret.getPosition() / 2L;
            byte[] data = JHexView.this.m_dataProvider.getData(offset, 1);
            if (data == null || data.length == 0) {
                return;
            }
            byte oldValue = data[0];
            byte newValue = JHexView.this.m_caret.getPosition() % 2L == 0L ? (byte)(oldValue & 0xF | value << 4) : (byte)(oldValue & 0xF0 | value);
            data[0] = newValue;
            JHexView.this.m_dataProvider.setData(offset, data);
            JHexView.this.setModified(offset);
            JHexView.this.fireUndoableEditListener(new DataEdit(offset, oldValue, newValue, JHexView.this.getActiveView()));
            JHexView.this.changeBy(false, 1L);
        }

        private void showPopupMenu(MouseEvent event) {
            JPopupMenu menu;
            if (JHexView.this.m_menuCreator != null && (menu = JHexView.this.m_menuCreator.createMenu(JHexView.this.m_caret.getPosition() / 2L)) != null) {
                menu.show(JHexView.this, event.getX(), event.getY());
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            if (event.getSource() == JHexView.this.m_scrollbar) {
                JHexView.this.m_firstRow = event.getValue();
            } else {
                JHexView.this.m_firstColumn = event.getValue();
            }
            JHexView.this.repaint();
        }

        @Override
        public void caretStatusChanged(Caret source) {
            JHexView.this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent event) {
        }

        @Override
        public void componentMoved(ComponentEvent event) {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            JHexView.this.setScrollBarMaximum();
        }

        @Override
        public void componentShown(ComponentEvent event) {
        }

        @Override
        public void dataChanged(DataChangedEvent event) {
            JHexView.this.setScrollBarMaximum();
            JHexView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent event) {
            JHexView.this.m_caret.setVisible(true);
            JHexView.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent event) {
            JHexView.this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (!JHexView.this.isEditable()) {
                return;
            }
            char ch = event.getKeyChar();
            if (JHexView.this.m_activeView == Views.HEX_VIEW) {
                if (JHexView.this.m_dataProvider.isEditable() && JHexView.isHexCharacter(ch)) {
                    this.keyPressedInHexView(ch);
                }
            } else if (JHexView.this.m_dataProvider.isEditable() && JHexView.isPrintableCharacter(ch)) {
                this.keyPressedInAsciiView(ch);
            }
            JHexView.this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (!JHexView.this.isEnabled() || this.startNibble < 0L) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            int nibblesPerRow = 2 * JHexView.this.m_bytesPerRow;
            if (y < 16 - (JHexView.this.m_rowHeight - JHexView.this.m_charHeight)) {
                JHexView.this.scrollToPosition(2L * JHexView.this.getFirstVisibleByte() - (long)nibblesPerRow);
                long newPos = JHexView.this.m_caret.getPosition() - (long)nibblesPerRow;
                if (newPos >= this.startNibble) {
                    JHexView.this.selectionModel.setSelectionInterval(this.startNibble, newPos);
                    JHexView.this.m_caret.setPosition(newPos);
                }
            } else if (y >= JHexView.this.m_rowHeight * JHexView.this.getNumberOfVisibleRows()) {
                JHexView.this.scrollToPosition(2L * JHexView.this.getFirstVisibleByte() + (long)nibblesPerRow);
                long newPos = JHexView.this.m_caret.getPosition() + (long)nibblesPerRow;
                if (this.startNibble + newPos <= (long)(2 * JHexView.this.m_dataProvider.getDataLength())) {
                    JHexView.this.selectionModel.setSelectionInterval(this.startNibble, newPos);
                    JHexView.this.m_caret.setPosition(newPos);
                }
            } else {
                long newPos = JHexView.this.getNibbleAtCoordinate(x, y);
                if (newPos != -1L) {
                    JHexView.this.selectionModel.setSelectionInterval(this.startNibble, newPos);
                    JHexView.this.m_caret.setPosition(newPos);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            JHexView.this.m_lastMouseX = event.getX();
            JHexView.this.m_lastMouseY = event.getY();
            JHexView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            if (event.getButton() == 1) {
                JHexView.this.requestFocusInWindow();
                int x = event.getX();
                int y = event.getY();
                Views oldView = JHexView.this.m_activeView;
                if (JHexView.this.isInsideHexView(x, y)) {
                    JHexView.this.m_activeView = Views.HEX_VIEW;
                } else if (JHexView.this.isInsideAsciiView(x, y)) {
                    JHexView.this.m_activeView = Views.ASCII_VIEW;
                }
                if (oldView != JHexView.this.m_activeView) {
                    JHexView.this.fireHexListener(JHexView.this.m_activeView);
                }
                JHexView.this.m_caret.setVisible(true);
                this.startNibble = JHexView.this.getNibbleAtCoordinate(x, y);
                if (this.startNibble != -1L) {
                    if (JHexView.this.m_activeView == Views.ASCII_VIEW) {
                        if (event.getClickCount() == 2) {
                            JHexView.this.expandSelection(this.startNibble / 2L);
                        } else {
                            long start = this.startNibble & 0xFFFFFFFFFFFFFFFEL;
                            JHexView.this.selectionModel.setSelectionInterval(start, start + 1L);
                            JHexView.this.setCurrentPosition(start);
                        }
                    } else {
                        if (event.getClickCount() == 3) {
                            long nibblesPerRow = 2 * JHexView.this.m_bytesPerRow;
                            long start = this.startNibble & -nibblesPerRow;
                            JHexView.this.selectionModel.setSelectionInterval(start, start + nibblesPerRow - 1L);
                        } else if (event.getClickCount() == 2) {
                            long start = this.startNibble & 0xFFFFFFFFFFFFFFFEL;
                            JHexView.this.selectionModel.setSelectionInterval(start, start + 1L);
                        } else {
                            JHexView.this.selectionModel.setSelectionInterval(this.startNibble, this.startNibble);
                        }
                        JHexView.this.setCurrentPosition(this.startNibble);
                    }
                } else {
                    JHexView.this.selectionModel.clearSelection();
                }
                JHexView.this.repaint();
            }
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
            if (event.getButton() == 1) {
                this.startNibble = -1L;
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!JHexView.this.isEnabled()) {
                return;
            }
            int notches = e.getWheelRotation();
            JHexView.this.m_scrollbar.setValue(JHexView.this.m_scrollbar.getValue() + 3 * notches);
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            JHexView.this.m_undo.addEdit(e.getEdit());
        }
    }

    private class HexTransferHandler
    extends TransferHandler {
        private HexTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            block8: {
                if (support.getComponent() instanceof JHexView && this.canImport(support)) {
                    JHexView hv = (JHexView)support.getComponent();
                    try {
                        String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                        if (data == null || support.isDrop() || hv.m_caret.getPosition() >= (long)(2 * JHexView.this.getData().getDataLength())) break block8;
                        if (hv.getActiveView() == Views.HEX_VIEW) {
                            KeyEvent event = new KeyEvent(hv, 0, 0L, 0, 0, '\u0000');
                            for (int i = 0; i < data.length(); ++i) {
                                char ch = data.charAt(i);
                                if (Character.isWhitespace(ch)) continue;
                                event.setKeyChar(ch);
                                hv.m_listener.keyPressed(event);
                            }
                        } else {
                            KeyEvent event = new KeyEvent(hv, 0, 0L, 0, 0, '\u0000');
                            for (int i = 0; i < data.length(); ++i) {
                                char ch = data.charAt(i);
                                event.setKeyChar(ch);
                                hv.m_listener.keyPressed(event);
                            }
                        }
                        return true;
                    }
                    catch (UnsupportedFlavorException ufe) {
                        ufe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JHexView) {
                JHexView hv = (JHexView)c;
                StringBuilder sb = new StringBuilder();
                if (hv.m_activeView == Views.HEX_VIEW) {
                    for (SelectionModel.Interval r : hv.selectionModel) {
                        byte[] buffer;
                        for (byte b : buffer = JHexView.this.m_dataProvider.getData(r.getStart(), (int)r.getLength())) {
                            sb.append(HEX_BYTES[b & 0xFF]).append(' ');
                        }
                    }
                    if (sb.length() != 0) {
                        sb.setLength(sb.length() - 1);
                    }
                } else {
                    for (SelectionModel.Interval r : hv.selectionModel) {
                        byte[] buffer;
                        for (byte b : buffer = JHexView.this.m_dataProvider.getData(r.getStart(), (int)r.getLength())) {
                            sb.append(ASCII_VIEW_TABLE[b & 0xFF]);
                        }
                    }
                }
                return new StringSelection(sb.toString());
            }
            return null;
        }
    }

    public class DataEdit
    extends AbstractEdit {
        private final long offset;
        private final byte oldValue;
        private final byte newValue;
        private final Views view;

        public DataEdit(long offset, byte oldValue, byte newValue, Views view) {
            super("Typing");
            this.offset = offset;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.view = view;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (JHexView.this.getDefinitionStatus() != DefinitionStatus.DEFINED) {
                throw new CannotUndoException();
            }
            JHexView.this.setActiveView(this.view);
            JHexView.this.getData().setData(this.offset, new byte[]{this.oldValue});
            JHexView.this.clearModified(this.offset, false);
            JHexView.this.setCurrentPosition(2L * this.offset);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (JHexView.this.getDefinitionStatus() != DefinitionStatus.DEFINED) {
                throw new CannotRedoException();
            }
            JHexView.this.setActiveView(this.view);
            JHexView.this.getData().setData(this.offset, new byte[]{this.newValue});
            JHexView.this.setModified(this.offset);
            JHexView.this.setCurrentPosition(2L * this.offset + 2L);
        }
    }

    private class ActionWaitingForData
    extends AbstractAction {
        private static final long serialVersionUID = -610823391617272365L;
        private final long m_offset;
        private final int m_size;

        private ActionWaitingForData(long offset, int size) {
            this.m_offset = offset;
            this.m_size = size;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (JHexView.this.m_dataProvider.hasData(this.m_offset, this.m_size)) {
                JHexView.this.setEnabled(true);
                JHexView.this.setDefinitionStatus(DefinitionStatus.DEFINED);
                ((Timer)event.getSource()).stop();
            } else if (!JHexView.this.m_dataProvider.keepTrying()) {
                ((Timer)event.getSource()).stop();
            }
        }
    }

    private class ActionUp
    extends AbstractAction {
        private static final long serialVersionUID = -3513103611571283106L;

        private ActionUp() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, -2L * (long)JHexView.this.m_bytesPerRow);
        }
    }

    private class ActionTab
    extends AbstractAction {
        private static final long serialVersionUID = -3265020583339369531L;

        private ActionTab() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (JHexView.this.m_activeView == Views.HEX_VIEW) {
                JHexView.this.m_activeView = Views.ASCII_VIEW;
                JHexView.this.m_caret.setPosition(JHexView.this.m_caret.getPosition() & 0xFFFFFFFFFFFFFFFEL);
                if (!JHexView.this.selectionModel.isEmpty()) {
                    for (SelectionModel.Interval range : new ArrayList<SelectionModel.Interval>(((JHexView)JHexView.this).selectionModel.selected)) {
                        JHexView.this.selectionModel.addSelectionInterval(range.getStart() & 0xFFFFFFFFFFFFFFFEL, range.getEnd() & 0xFFFFFFFFFFFFFFFEL);
                    }
                }
            } else {
                JHexView.this.m_activeView = Views.HEX_VIEW;
            }
            JHexView.this.fireHexListener(JHexView.this.m_activeView);
            JHexView.this.m_caret.setVisible(true);
            JHexView.this.repaint();
        }
    }

    private class ActionShortcut
    extends AbstractAction {
        private static final long serialVersionUID = -3513103611571283107L;
        private final KeyStroke keyStroke;

        public ActionShortcut(KeyStroke keyStroke) {
            this.keyStroke = keyStroke;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int ctrl = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            if (this.isKeyStroke(65, ctrl)) {
                long end = 2 * JHexView.this.m_dataProvider.getDataLength();
                JHexView.this.selectionModel.setSelectionInterval(0L, end);
                JHexView.this.m_caret.setPosition(end);
            } else if (this.isKeyStroke(86, ctrl)) {
                TransferHandler.getPasteAction().actionPerformed(event);
            } else if (this.isKeyStroke(67, ctrl)) {
                TransferHandler.getCopyAction().actionPerformed(event);
            } else if (this.isKeyStroke(90, ctrl)) {
                JHexView.this.undo();
            } else if (this.isKeyStroke(89, ctrl)) {
                JHexView.this.redo();
            }
        }

        private boolean isKeyStroke(int key, int modifiers) {
            if (this.keyStroke != null) {
                return this.keyStroke.getKeyCode() == key && (this.keyStroke.getModifiers() & modifiers) == modifiers;
            }
            return false;
        }
    }

    private class ActionRight
    extends AbstractAction {
        private static final long serialVersionUID = 3857972387525998636L;
        private final boolean clearSelection;

        public ActionRight(boolean clearSelection) {
            this.clearSelection = clearSelection;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.clearSelection && !JHexView.this.selectionModel.isEmpty()) {
                long cur = JHexView.this.m_caret.getPosition();
                SelectionModel.Interval range = JHexView.this.selectionModel.findInterval(cur);
                JHexView.this.changeBy(event, range == null ? 0L : (range.getEnd() + 1L & 0xFFFFFFFFFFFFFFFEL) - cur);
            } else {
                JHexView.this.changeBy(event, JHexView.this.m_activeView == Views.HEX_VIEW ? 1L : 2L);
            }
        }
    }

    private class ActionPageUp
    extends AbstractAction {
        private static final long serialVersionUID = -7424423002191015929L;

        private ActionPageUp() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, -2L * (long)JHexView.this.getNumberOfVisibleRows() * (long)JHexView.this.m_bytesPerRow);
        }
    }

    private class ActionPageDown
    extends AbstractAction {
        private static final long serialVersionUID = 490837791577654025L;

        private ActionPageDown() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, 2L * (long)JHexView.this.getNumberOfVisibleRows() * (long)JHexView.this.m_bytesPerRow);
        }
    }

    private class ActionLeft
    extends AbstractAction {
        private static final long serialVersionUID = -9032577023548944503L;
        private final boolean clearSelection;

        public ActionLeft(boolean clearSelection) {
            this.clearSelection = clearSelection;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.clearSelection && !JHexView.this.selectionModel.isEmpty()) {
                long cur = JHexView.this.m_caret.getPosition();
                SelectionModel.Interval range = JHexView.this.selectionModel.findInterval(cur);
                JHexView.this.changeBy(event, range == null ? 0L : (range.getStart() & 0xFFFFFFFFFFFFFFFEL) - cur);
            } else {
                JHexView.this.changeBy(event, JHexView.this.m_activeView == Views.HEX_VIEW ? -1L : -2L);
            }
        }
    }

    private class ActionHome
    extends AbstractAction {
        private static final long serialVersionUID = 3857972387525998637L;
        private final boolean isCtrl;

        public ActionHome(boolean isCtrl) {
            this.isCtrl = isCtrl;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            long change = this.isCtrl ? -JHexView.this.m_caret.getPosition() : -(JHexView.this.m_caret.getPosition() % (long)(JHexView.this.m_bytesPerRow * 2));
            JHexView.this.changeBy(event, change);
        }
    }

    private class ActionEnd
    extends AbstractAction {
        private static final long serialVersionUID = 3857972387525998638L;
        private final boolean isCtrl;

        public ActionEnd(boolean isCtrl) {
            this.isCtrl = isCtrl;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            long change = this.isCtrl ? (long)(JHexView.this.getData().getDataLength() * 2) - JHexView.this.m_caret.getPosition() - 2L : (long)(JHexView.this.m_bytesPerRow * 2) - JHexView.this.m_caret.getPosition() % (long)(JHexView.this.m_bytesPerRow * 2) - 2L;
            JHexView.this.changeBy(event, change);
        }
    }

    private class ActionDown
    extends AbstractAction {
        private static final long serialVersionUID = -6501310447863685486L;

        private ActionDown() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JHexView.this.changeBy(event, 2L * (long)JHexView.this.m_bytesPerRow);
        }
    }

    public abstract class AbstractEdit
    extends AbstractUndoableEdit {
        private final String name;

        public AbstractEdit(String name) {
            this.name = name;
        }

        @Override
        public String getPresentationName() {
            return this.name != null ? this.name : "";
        }

        @Override
        public String getRedoPresentationName() {
            return this.getPresentationName();
        }

        @Override
        public String getUndoPresentationName() {
            return this.getPresentationName();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

