/*
 * Decompiled with CFR 0.152.
 */
package tv.porst.jhexview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import tv.porst.jhexview.ICaretListener;

public class Caret {
    private static final int DEFAULT_BLINK_TIME = 500;
    private static final Color DEFAULT_CARET_COLOR = Color.RED;
    private static final Stroke DEFAULT_CARET_STROKE = new BasicStroke(2.0f);
    private final List<ICaretListener> m_listeners = new ArrayList<ICaretListener>();
    private final Timer m_caretTimer;
    private boolean m_isCaretVisible = false;
    private Color m_caretColor;
    private long position;
    private final InternalListener m_listener = new InternalListener();

    public Caret() {
        this(500, DEFAULT_CARET_COLOR);
    }

    public Caret(Color caretColor) {
        this(500, caretColor);
    }

    public Caret(int blinkPeriod) {
        this(blinkPeriod, DEFAULT_CARET_COLOR);
    }

    public Caret(int blinkPeriod, Color caretColor) {
        if (blinkPeriod < 0) {
            throw new IllegalArgumentException("Error: Blink period can't be negative");
        }
        if (caretColor == null) {
            throw new NullPointerException("Error: Caret color can't be null");
        }
        this.m_caretColor = caretColor;
        this.m_caretTimer = new Timer(blinkPeriod, this.m_listener);
        this.m_caretTimer.setRepeats(true);
        this.m_caretTimer.start();
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        if (this.position != position) {
            this.position = position;
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        for (ICaretListener listener : this.m_listeners) {
            listener.caretStatusChanged(this);
        }
    }

    public void addCaretListener(ICaretListener listener) {
        if (listener == null) {
            throw new NullPointerException("Error: Listener can't be null");
        }
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void draw(Graphics2D g, int x, int y, int height) {
        if (g == null) {
            throw new NullPointerException("Caret: Graphics context can't be null");
        }
        if (this.isVisible()) {
            Color oldColor = g.getColor();
            Stroke oldStroke = g.getStroke();
            g.setColor(this.m_caretColor);
            g.setStroke(DEFAULT_CARET_STROKE);
            g.drawLine(x, y, x, y + height - 1);
            g.setStroke(oldStroke);
            g.setColor(oldColor);
        }
    }

    public Color getColor() {
        return this.m_caretColor;
    }

    public boolean isVisible() {
        return this.m_isCaretVisible;
    }

    public void removeListener(ICaretListener listener) {
        this.m_listeners.remove(listener);
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException("Caret: Caret color can't be null");
        }
        if (!this.m_caretColor.equals(color)) {
            this.m_caretColor = color;
        }
    }

    public void setVisible(boolean isCaretVisible) {
        this.m_isCaretVisible = isCaretVisible;
        this.notifyListeners();
    }

    public void stop() {
        this.m_caretTimer.stop();
        this.m_caretTimer.removeActionListener(this.m_listener);
        this.setVisible(false);
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Caret.this.m_isCaretVisible = !Caret.this.m_isCaretVisible;
            Caret.this.notifyListeners();
        }
    }
}

