/*
 * Decompiled with CFR 0.152.
 */
package com.ortiz.touchview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import androidx.appcompat.widget.AppCompatImageView;
import com.ortiz.touchview.FixedPixel;
import com.ortiz.touchview.ImageActionState;
import com.ortiz.touchview.OnTouchCoordinatesListener;
import com.ortiz.touchview.OnTouchImageViewListener;
import com.ortiz.touchview.OnZoomFinishedListener;
import com.ortiz.touchview.R;
import com.ortiz.touchview.ZoomVariables;
import java.io.Serializable;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u0000 \u00c7\u00012\u00020\u0001:\u0010\u00c6\u0001\u00c7\u0001\u00c8\u0001\u00c9\u0001\u00ca\u0001\u00cb\u0001\u00cc\u0001\u00cd\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010b\u001a\u00020!2\u0006\u0010c\u001a\u00020\u0007H\u0016J\u0010\u0010d\u001a\u00020!2\u0006\u0010c\u001a\u00020\u0007H\u0007J\u0010\u0010e\u001a\u00020!2\u0006\u0010c\u001a\u00020\u0007H\u0016J\u0010\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0003J\b\u0010j\u001a\u00020gH\u0002J\b\u0010k\u001a\u00020gH\u0002J\b\u0010l\u001a\u00020gH\u0002J\u0012\u0010m\u001a\u00020\u00072\b\u0010n\u001a\u0004\u0018\u00010oH\u0002J\u0012\u0010p\u001a\u00020\u00072\b\u0010n\u001a\u0004\u0018\u00010oH\u0002J \u0010q\u001a\u00020\n2\u0006\u0010r\u001a\u00020\n2\u0006\u0010s\u001a\u00020\n2\u0006\u0010t\u001a\u00020\nH\u0002J(\u0010u\u001a\u00020\n2\u0006\u0010v\u001a\u00020\n2\u0006\u0010s\u001a\u00020\n2\u0006\u0010t\u001a\u00020\n2\u0006\u0010w\u001a\u00020\nH\u0002J\b\u0010x\u001a\u00020UH\u0016JB\u0010y\u001a\u00020\n2\u0006\u0010v\u001a\u00020\n2\u0006\u0010z\u001a\u00020\n2\u0006\u0010{\u001a\u00020\n2\u0006\u0010|\u001a\u00020\u00072\u0006\u0010s\u001a\u00020\u00072\u0006\u0010}\u001a\u00020\u00072\b\u0010~\u001a\u0004\u0018\u00010;H\u0002J\u0012\u0010\u007f\u001a\u00020g2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0016J\u0013\u0010\u0082\u0001\u001a\u00020g2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0014J\u001b\u0010\u0085\u0001\u001a\u00020g2\u0007\u0010\u0086\u0001\u001a\u00020\u00072\u0007\u0010\u0087\u0001\u001a\u00020\u0007H\u0014J\u0013\u0010\u0088\u0001\u001a\u00020g2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\f\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0016J-\u0010\u008c\u0001\u001a\u00020g2\u0007\u0010\u008d\u0001\u001a\u00020\u00072\u0007\u0010\u008e\u0001\u001a\u00020\u00072\u0007\u0010\u008f\u0001\u001a\u00020\u00072\u0007\u0010\u0090\u0001\u001a\u00020\u0007H\u0014J\u0013\u0010\u0091\u0001\u001a\u00020!2\b\u0010n\u001a\u0004\u0018\u00010oH\u0002J\u0007\u0010\u0092\u0001\u001a\u00020gJ\u0007\u0010\u0093\u0001\u001a\u00020gJ\u0007\u0010\u0094\u0001\u001a\u00020gJ.\u0010\u0095\u0001\u001a\u00020g2\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\u0007\u0010\u009a\u0001\u001a\u00020!H\u0002J\u0013\u0010\u009b\u0001\u001a\u00020g2\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0016J\u0013\u0010\u009e\u0001\u001a\u00020g2\b\u0010n\u001a\u0004\u0018\u00010oH\u0016J\u0012\u0010\u009f\u0001\u001a\u00020g2\u0007\u0010\u00a0\u0001\u001a\u00020\u0007H\u0016J\u0015\u0010\u00a1\u0001\u001a\u00020g2\n\u0010\u00a2\u0001\u001a\u0005\u0018\u00010\u00a3\u0001H\u0016J\u000f\u0010\u00a4\u0001\u001a\u00020g2\u0006\u0010/\u001a\u00020\nJ\u0010\u0010\u00a5\u0001\u001a\u00020g2\u0007\u0010\u00a6\u0001\u001a\u00020\u0011J\u0010\u0010\u00a7\u0001\u001a\u00020g2\u0007\u0010\u00a8\u0001\u001a\u00020PJ\u0010\u0010\u00a9\u0001\u001a\u00020g2\u0007\u0010\u00aa\u0001\u001a\u00020RJ\u0012\u0010\u00ab\u0001\u001a\u00020g2\u0007\u0010\u00ac\u0001\u001a\u00020XH\u0016J\u0010\u0010\u00ad\u0001\u001a\u00020g2\u0007\u0010\u00ae\u0001\u001a\u00020!J\u0012\u0010\u00af\u0001\u001a\u00020g2\u0007\u0010\u00b0\u0001\u001a\u00020UH\u0016J\u0019\u0010\u00b1\u0001\u001a\u00020g2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\nJ\u0011\u0010\u00b2\u0001\u001a\u00020g2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u00b3\u0001\u001a\u00020\u00072\u0007\u0010\u00b4\u0001\u001a\u00020\u00072\u0007\u0010\u00b5\u0001\u001a\u00020\u00072\u0007\u0010\u00b6\u0001\u001a\u00020\u0007H\u0002J\u0010\u0010\u00b7\u0001\u001a\u00020g2\u0007\u0010\u00b8\u0001\u001a\u00020\u0000J\u0010\u0010\u00b7\u0001\u001a\u00020g2\u0007\u0010\u00b9\u0001\u001a\u00020\nJ\"\u0010\u00b7\u0001\u001a\u00020g2\u0007\u0010\u00b9\u0001\u001a\u00020\n2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\nJ-\u0010\u00b7\u0001\u001a\u00020g2\u0007\u0010\u00b9\u0001\u001a\u00020\n2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\t\u0010\u00ba\u0001\u001a\u0004\u0018\u00010UJ\"\u0010\u00bb\u0001\u001a\u00020g2\u0007\u0010\u00b9\u0001\u001a\u00020\n2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\nJ.\u0010\u00bb\u0001\u001a\u00020g2\u0007\u0010\u00b9\u0001\u001a\u00020\n2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\n\u0010\u00bc\u0001\u001a\u0005\u0018\u00010\u00bd\u0001J+\u0010\u00bb\u0001\u001a\u00020g2\u0007\u0010\u00b9\u0001\u001a\u00020\n2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\u0007\u0010\u00be\u0001\u001a\u00020\u0007J7\u0010\u00bb\u0001\u001a\u00020g2\u0007\u0010\u00b9\u0001\u001a\u00020\n2\u0007\u0010\u0098\u0001\u001a\u00020\n2\u0007\u0010\u0099\u0001\u001a\u00020\n2\u0007\u0010\u00be\u0001\u001a\u00020\u00072\n\u0010\u00bc\u0001\u001a\u0005\u0018\u00010\u00bd\u0001J\u001b\u0010\u00bf\u0001\u001a\u00020J2\u0007\u0010\u00c0\u0001\u001a\u00020\n2\u0007\u0010\u00c1\u0001\u001a\u00020\nH\u0004J$\u0010\u00c2\u0001\u001a\u00020J2\u0007\u0010\u00c3\u0001\u001a\u00020\n2\u0007\u0010\u00c4\u0001\u001a\u00020\n2\u0007\u0010\u00c5\u0001\u001a\u00020!H\u0004R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\rR\u000e\u0010$\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010&R\u000e\u0010*\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00100\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010\r\"\u0004\b2\u0010\u0015R\u000e\u00103\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u00020\n2\u0006\u00104\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\r\"\u0004\b7\u0010\u0015R\u000e\u00108\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010I\u001a\u00020J8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u000e\u0010M\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u0004\u0018\u00010RX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010T\u001a\u0004\u0018\u00010UX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010W\u001a\u0004\u0018\u00010XX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010Z\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010=\"\u0004\b\\\u0010?R\u000e\u0010]\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010^\u001a\u00020_8F\u00a2\u0006\u0006\u001a\u0004\b`\u0010a\u00a8\u0006\u00ce\u0001"}, d2={"Lcom/ortiz/touchview/TouchImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "", "currentZoom", "getCurrentZoom", "()F", "delayedZoomVariables", "Lcom/ortiz/touchview/ZoomVariables;", "doubleTapListener", "Landroid/view/GestureDetector$OnDoubleTapListener;", "doubleTapScale", "getDoubleTapScale", "setDoubleTapScale", "(F)V", "fling", "Lcom/ortiz/touchview/TouchImageView$Fling;", "floatMatrix", "", "gestureDetector", "Landroid/view/GestureDetector;", "imageActionState", "Lcom/ortiz/touchview/ImageActionState;", "imageHeight", "getImageHeight", "imageRenderedAtLeastOnce", "", "imageWidth", "getImageWidth", "isRotateImageToFitScreen", "isZoomEnabled", "()Z", "setZoomEnabled", "(Z)V", "isZoomed", "matchViewHeight", "matchViewWidth", "maxScale", "maxScaleIsSetByMultiplier", "maxScaleMultiplier", "max", "maxZoom", "getMaxZoom", "setMaxZoom", "minScale", "min", "minZoom", "getMinZoom", "setMinZoom", "onDrawReady", "orientation", "orientationChangeFixedPixel", "Lcom/ortiz/touchview/FixedPixel;", "getOrientationChangeFixedPixel", "()Lcom/ortiz/touchview/FixedPixel;", "setOrientationChangeFixedPixel", "(Lcom/ortiz/touchview/FixedPixel;)V", "orientationJustChanged", "prevMatchViewHeight", "prevMatchViewWidth", "prevMatrix", "Landroid/graphics/Matrix;", "prevViewHeight", "prevViewWidth", "scaleDetector", "Landroid/view/ScaleGestureDetector;", "scrollPosition", "Landroid/graphics/PointF;", "getScrollPosition", "()Landroid/graphics/PointF;", "superMaxScale", "superMinScale", "touchCoordinatesListener", "Lcom/ortiz/touchview/OnTouchCoordinatesListener;", "touchImageViewListener", "Lcom/ortiz/touchview/OnTouchImageViewListener;", "touchMatrix", "touchScaleType", "Landroid/widget/ImageView$ScaleType;", "userSpecifiedMinScale", "userTouchListener", "Landroid/view/View$OnTouchListener;", "viewHeight", "viewSizeChangeFixedPixel", "getViewSizeChangeFixedPixel", "setViewSizeChangeFixedPixel", "viewWidth", "zoomedRect", "Landroid/graphics/RectF;", "getZoomedRect", "()Landroid/graphics/RectF;", "canScrollHorizontally", "direction", "canScrollHorizontallyFroyo", "canScrollVertically", "compatPostOnAnimation", "", "runnable", "Ljava/lang/Runnable;", "fitImageToView", "fixScaleTrans", "fixTrans", "getDrawableHeight", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawableWidth", "getFixDragTrans", "delta", "viewSize", "contentSize", "getFixTrans", "trans", "offset", "getScaleType", "newTranslationAfterChange", "prevImageSize", "imageSize", "prevViewSize", "drawableSize", "sizeChangeFixedPixel", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "orientationMismatch", "resetZoom", "resetZoomAnimated", "savePreviousImageValues", "scaleImage", "deltaScale", "", "focusX", "focusY", "stretchImageToSuper", "setImageBitmap", "bm", "Landroid/graphics/Bitmap;", "setImageDrawable", "setImageResource", "resId", "setImageURI", "uri", "Landroid/net/Uri;", "setMaxZoomRatio", "setOnDoubleTapListener", "onDoubleTapListener", "setOnTouchCoordinatesListener", "onTouchCoordinatesListener", "setOnTouchImageViewListener", "onTouchImageViewListener", "setOnTouchListener", "onTouchListener", "setRotateImageToFitScreen", "rotateImageToFitScreen", "setScaleType", "type", "setScrollPosition", "setState", "setViewSize", "mode", "size", "drawableWidth", "setZoom", "img", "scale", "scaleType", "setZoomAnimated", "listener", "Lcom/ortiz/touchview/OnZoomFinishedListener;", "zoomTimeMs", "transformCoordBitmapToTouch", "bx", "by", "transformCoordTouchToBitmap", "x", "y", "clipToBitmap", "AnimatedZoom", "Companion", "CompatScroller", "DoubleTapZoom", "Fling", "GestureListener", "PrivateOnTouchListener", "ScaleListener", "touchview_release"})
public class TouchImageView
extends AppCompatImageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float currentZoom;
    @NotNull
    private Matrix touchMatrix;
    @NotNull
    private Matrix prevMatrix;
    private boolean isZoomEnabled;
    private boolean isRotateImageToFitScreen;
    @Nullable
    private FixedPixel orientationChangeFixedPixel;
    @Nullable
    private FixedPixel viewSizeChangeFixedPixel;
    private boolean orientationJustChanged;
    @Nullable
    private ImageActionState imageActionState;
    private float userSpecifiedMinScale;
    private float minScale;
    private boolean maxScaleIsSetByMultiplier;
    private float maxScaleMultiplier;
    private float maxScale;
    private float superMinScale;
    private float superMaxScale;
    @NotNull
    private float[] floatMatrix;
    private float doubleTapScale;
    @Nullable
    private Fling fling;
    private int orientation;
    @Nullable
    private ImageView.ScaleType touchScaleType;
    private boolean imageRenderedAtLeastOnce;
    private boolean onDrawReady;
    @Nullable
    private ZoomVariables delayedZoomVariables;
    private int viewWidth;
    private int viewHeight;
    private int prevViewWidth;
    private int prevViewHeight;
    private float matchViewWidth;
    private float matchViewHeight;
    private float prevMatchViewWidth;
    private float prevMatchViewHeight;
    @NotNull
    private ScaleGestureDetector scaleDetector;
    @NotNull
    private GestureDetector gestureDetector;
    @Nullable
    private OnTouchCoordinatesListener touchCoordinatesListener;
    @Nullable
    private GestureDetector.OnDoubleTapListener doubleTapListener;
    @Nullable
    private View.OnTouchListener userTouchListener;
    @Nullable
    private OnTouchImageViewListener touchImageViewListener;
    private static final float SUPER_MIN_MULTIPLIER = 0.75f;
    private static final float SUPER_MAX_MULTIPLIER = 1.25f;
    private static final int DEFAULT_ZOOM_TIME = 500;
    public static final float AUTOMATIC_MIN_ZOOM = -1.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public TouchImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.orientationChangeFixedPixel = FixedPixel.CENTER;
        this.viewSizeChangeFixedPixel = FixedPixel.CENTER;
        super.setClickable(true);
        this.orientation = this.getResources().getConfiguration().orientation;
        this.scaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.touchMatrix = new Matrix();
        this.prevMatrix = new Matrix();
        this.floatMatrix = new float[9];
        this.currentZoom = 1.0f;
        if (this.touchScaleType == null) {
            this.touchScaleType = ImageView.ScaleType.FIT_CENTER;
        }
        this.minScale = 1.0f;
        this.maxScale = 3.0f;
        this.superMinScale = 0.75f * this.minScale;
        this.superMaxScale = 1.25f * this.maxScale;
        this.setImageMatrix(this.touchMatrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setState(ImageActionState.NONE);
        this.onDrawReady = false;
        super.setOnTouchListener((View.OnTouchListener)new PrivateOnTouchListener());
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TouchImageView, defStyle, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.TouchImageView, defStyle, 0)");
        TypedArray attributes = typedArray;
        try {
            if (!this.isInEditMode()) {
                this.isZoomEnabled = attributes.getBoolean(R.styleable.TouchImageView_zoom_enabled, true);
            }
        }
        finally {
            attributes.recycle();
        }
    }

    public /* synthetic */ TouchImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final float getCurrentZoom() {
        return this.currentZoom;
    }

    public final boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public final void setZoomEnabled(boolean bl) {
        this.isZoomEnabled = bl;
    }

    @Nullable
    public final FixedPixel getOrientationChangeFixedPixel() {
        return this.orientationChangeFixedPixel;
    }

    public final void setOrientationChangeFixedPixel(@Nullable FixedPixel fixedPixel) {
        this.orientationChangeFixedPixel = fixedPixel;
    }

    @Nullable
    public final FixedPixel getViewSizeChangeFixedPixel() {
        return this.viewSizeChangeFixedPixel;
    }

    public final void setViewSizeChangeFixedPixel(@Nullable FixedPixel fixedPixel) {
        this.viewSizeChangeFixedPixel = fixedPixel;
    }

    public final float getDoubleTapScale() {
        return this.doubleTapScale;
    }

    public final void setDoubleTapScale(float f) {
        this.doubleTapScale = f;
    }

    public final void setRotateImageToFitScreen(boolean rotateImageToFitScreen) {
        this.isRotateImageToFitScreen = rotateImageToFitScreen;
    }

    public void setOnTouchListener(@NotNull View.OnTouchListener onTouchListener) {
        Intrinsics.checkNotNullParameter((Object)onTouchListener, (String)"onTouchListener");
        this.userTouchListener = onTouchListener;
    }

    public final void setOnTouchImageViewListener(@NotNull OnTouchImageViewListener onTouchImageViewListener) {
        Intrinsics.checkNotNullParameter((Object)onTouchImageViewListener, (String)"onTouchImageViewListener");
        this.touchImageViewListener = onTouchImageViewListener;
    }

    public final void setOnDoubleTapListener(@NotNull GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        Intrinsics.checkNotNullParameter((Object)onDoubleTapListener, (String)"onDoubleTapListener");
        this.doubleTapListener = onDoubleTapListener;
    }

    public final void setOnTouchCoordinatesListener(@NotNull OnTouchCoordinatesListener onTouchCoordinatesListener) {
        Intrinsics.checkNotNullParameter((Object)onTouchCoordinatesListener, (String)"onTouchCoordinatesListener");
        this.touchCoordinatesListener = onTouchCoordinatesListener;
    }

    public void setImageResource(int resId) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageResource(resId);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageBitmap(@NotNull Bitmap bm) {
        Intrinsics.checkNotNullParameter((Object)bm, (String)"bm");
        this.imageRenderedAtLeastOnce = false;
        super.setImageBitmap(bm);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageDrawable(drawable);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageURI(@Nullable Uri uri) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageURI(uri);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setScaleType(@NotNull ImageView.ScaleType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type == ImageView.ScaleType.MATRIX) {
            super.setScaleType(ImageView.ScaleType.MATRIX);
        } else {
            this.touchScaleType = type;
            if (this.onDrawReady) {
                this.setZoom(this);
            }
        }
    }

    @NotNull
    public ImageView.ScaleType getScaleType() {
        ImageView.ScaleType scaleType = this.touchScaleType;
        Intrinsics.checkNotNull((Object)scaleType);
        return scaleType;
    }

    public final boolean isZoomed() {
        return !(this.currentZoom == 1.0f);
    }

    @NotNull
    public final RectF getZoomedRect() {
        if (this.touchScaleType == ImageView.ScaleType.FIT_XY) {
            throw new UnsupportedOperationException("getZoomedRect() not supported with FIT_XY");
        }
        PointF topLeft = this.transformCoordTouchToBitmap(0.0f, 0.0f, true);
        PointF bottomRight = this.transformCoordTouchToBitmap(this.viewWidth, this.viewHeight, true);
        float w = this.getDrawableWidth(this.getDrawable());
        float h = this.getDrawableHeight(this.getDrawable());
        return new RectF(topLeft.x / w, topLeft.y / h, bottomRight.x / w, bottomRight.y / h);
    }

    public final void savePreviousImageValues() {
        if (this.viewHeight != 0 && this.viewWidth != 0) {
            this.touchMatrix.getValues(this.floatMatrix);
            this.prevMatrix.setValues(this.floatMatrix);
            this.prevMatchViewHeight = this.matchViewHeight;
            this.prevMatchViewWidth = this.matchViewWidth;
            this.prevViewHeight = this.viewHeight;
            this.prevViewWidth = this.viewWidth;
        }
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt("orientation", this.orientation);
        bundle.putFloat("saveScale", this.currentZoom);
        bundle.putFloat("matchViewHeight", this.matchViewHeight);
        bundle.putFloat("matchViewWidth", this.matchViewWidth);
        bundle.putInt("viewWidth", this.viewWidth);
        bundle.putInt("viewHeight", this.viewHeight);
        this.touchMatrix.getValues(this.floatMatrix);
        bundle.putFloatArray("matrix", this.floatMatrix);
        bundle.putBoolean("imageRendered", this.imageRenderedAtLeastOnce);
        bundle.putSerializable("viewSizeChangeFixedPixel", (Serializable)((Object)this.viewSizeChangeFixedPixel));
        bundle.putSerializable("orientationChangeFixedPixel", (Serializable)((Object)this.orientationChangeFixedPixel));
        return (Parcelable)bundle;
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof Bundle) {
            this.currentZoom = ((Bundle)state).getFloat("saveScale");
            float[] fArray = ((Bundle)state).getFloatArray("matrix");
            Intrinsics.checkNotNull((Object)fArray);
            float[] fArray2 = fArray;
            this.floatMatrix = fArray2;
            this.prevMatrix.setValues(this.floatMatrix);
            this.prevMatchViewHeight = ((Bundle)state).getFloat("matchViewHeight");
            this.prevMatchViewWidth = ((Bundle)state).getFloat("matchViewWidth");
            this.prevViewHeight = ((Bundle)state).getInt("viewHeight");
            this.prevViewWidth = ((Bundle)state).getInt("viewWidth");
            this.imageRenderedAtLeastOnce = ((Bundle)state).getBoolean("imageRendered");
            this.viewSizeChangeFixedPixel = (FixedPixel)((Object)((Bundle)state).getSerializable("viewSizeChangeFixedPixel"));
            this.orientationChangeFixedPixel = (FixedPixel)((Object)((Bundle)state).getSerializable("orientationChangeFixedPixel"));
            int oldOrientation = ((Bundle)state).getInt("orientation");
            if (this.orientation != oldOrientation) {
                this.orientationJustChanged = true;
            }
            super.onRestoreInstanceState(((Bundle)state).getParcelable("instanceState"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.onDrawReady = true;
        this.imageRenderedAtLeastOnce = true;
        if (this.delayedZoomVariables != null) {
            ZoomVariables zoomVariables = this.delayedZoomVariables;
            Intrinsics.checkNotNull((Object)zoomVariables);
            float f = zoomVariables.getScale();
            zoomVariables = this.delayedZoomVariables;
            Intrinsics.checkNotNull((Object)zoomVariables);
            float f2 = zoomVariables.getFocusX();
            zoomVariables = this.delayedZoomVariables;
            Intrinsics.checkNotNull((Object)zoomVariables);
            float f3 = zoomVariables.getFocusY();
            zoomVariables = this.delayedZoomVariables;
            Intrinsics.checkNotNull((Object)zoomVariables);
            this.setZoom(f, f2, f3, zoomVariables.getScaleType());
            this.delayedZoomVariables = null;
        }
        super.onDraw(canvas);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        int newOrientation = this.getResources().getConfiguration().orientation;
        if (newOrientation != this.orientation) {
            this.orientationJustChanged = true;
            this.orientation = newOrientation;
        }
        this.savePreviousImageValues();
    }

    public final float getMaxZoom() {
        return this.maxScale;
    }

    public final void setMaxZoom(float max) {
        this.maxScale = max;
        this.superMaxScale = 1.25f * this.maxScale;
        this.maxScaleIsSetByMultiplier = false;
    }

    public final void setMaxZoomRatio(float max) {
        this.maxScaleMultiplier = max;
        this.maxScale = this.minScale * this.maxScaleMultiplier;
        this.superMaxScale = 1.25f * this.maxScale;
        this.maxScaleIsSetByMultiplier = true;
    }

    public final float getMinZoom() {
        return this.minScale;
    }

    public final void setMinZoom(float min) {
        this.userSpecifiedMinScale = min;
        if (min == -1.0f) {
            if (this.touchScaleType == ImageView.ScaleType.CENTER || this.touchScaleType == ImageView.ScaleType.CENTER_CROP) {
                Drawable drawable = this.getDrawable();
                int drawableWidth = this.getDrawableWidth(drawable);
                int drawableHeight = this.getDrawableHeight(drawable);
                if (drawable != null && drawableWidth > 0 && drawableHeight > 0) {
                    float f;
                    float widthRatio = (float)this.viewWidth / (float)drawableWidth;
                    float heightRatio = (float)this.viewHeight / (float)drawableHeight;
                    if (this.touchScaleType == ImageView.ScaleType.CENTER) {
                        boolean bl = false;
                        f = Math.min(widthRatio, heightRatio);
                    } else {
                        boolean bl = false;
                        bl = false;
                        f = Math.min(widthRatio, heightRatio) / Math.max(widthRatio, heightRatio);
                    }
                    this.minScale = f;
                }
            } else {
                this.minScale = 1.0f;
            }
        } else {
            this.minScale = this.userSpecifiedMinScale;
        }
        if (this.maxScaleIsSetByMultiplier) {
            this.setMaxZoomRatio(this.maxScaleMultiplier);
        }
        this.superMinScale = 0.75f * this.minScale;
    }

    public final void resetZoom() {
        this.currentZoom = 1.0f;
        this.fitImageToView();
    }

    public final void resetZoomAnimated() {
        this.setZoomAnimated(1.0f, 0.5f, 0.5f);
    }

    public final void setZoom(float scale) {
        this.setZoom(scale, 0.5f, 0.5f);
    }

    public final void setZoom(float scale, float focusX, float focusY) {
        this.setZoom(scale, focusX, focusY, this.touchScaleType);
    }

    public final void setZoom(float scale, float focusX, float focusY, @Nullable ImageView.ScaleType scaleType) {
        if (!this.onDrawReady) {
            this.delayedZoomVariables = new ZoomVariables(scale, focusX, focusY, scaleType);
            return;
        }
        if (this.userSpecifiedMinScale == -1.0f) {
            this.setMinZoom(-1.0f);
            if (this.currentZoom < this.minScale) {
                this.currentZoom = this.minScale;
            }
        }
        if (scaleType != this.touchScaleType) {
            Intrinsics.checkNotNull((Object)scaleType);
            this.setScaleType(scaleType);
        }
        this.resetZoom();
        this.scaleImage(scale, (float)this.viewWidth / 2.0f, (float)this.viewHeight / 2.0f, true);
        this.touchMatrix.getValues(this.floatMatrix);
        this.floatMatrix[2] = ((float)this.viewWidth - this.matchViewWidth) / (float)2 - focusX * (scale - 1.0f) * this.matchViewWidth;
        this.floatMatrix[5] = ((float)this.viewHeight - this.matchViewHeight) / (float)2 - focusY * (scale - 1.0f) * this.matchViewHeight;
        this.touchMatrix.setValues(this.floatMatrix);
        this.fixTrans();
        this.savePreviousImageValues();
        this.setImageMatrix(this.touchMatrix);
    }

    public final void setZoom(@NotNull TouchImageView img) {
        Intrinsics.checkNotNullParameter((Object)((Object)img), (String)"img");
        PointF center = img.getScrollPosition();
        this.setZoom(img.currentZoom, center.x, center.y, img.getScaleType());
    }

    @NotNull
    public final PointF getScrollPosition() {
        PointF point;
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return new PointF(0.5f, 0.5f);
        }
        Drawable drawable2 = drawable;
        int drawableWidth = this.getDrawableWidth(drawable2);
        int drawableHeight = this.getDrawableHeight(drawable2);
        PointF pointF = point = this.transformCoordTouchToBitmap((float)this.viewWidth / 2.0f, (float)this.viewHeight / 2.0f, true);
        pointF.x /= (float)drawableWidth;
        pointF = point;
        pointF.y /= (float)drawableHeight;
        return point;
    }

    private final boolean orientationMismatch(Drawable drawable) {
        boolean bl = this.viewWidth > this.viewHeight;
        Intrinsics.checkNotNull((Object)drawable);
        return bl != drawable.getIntrinsicWidth() > drawable.getIntrinsicHeight();
    }

    private final int getDrawableWidth(Drawable drawable) {
        int n;
        if (this.orientationMismatch(drawable) && this.isRotateImageToFitScreen) {
            Intrinsics.checkNotNull((Object)drawable);
            n = drawable.getIntrinsicHeight();
        } else {
            Intrinsics.checkNotNull((Object)drawable);
            n = drawable.getIntrinsicWidth();
        }
        return n;
    }

    private final int getDrawableHeight(Drawable drawable) {
        int n;
        if (this.orientationMismatch(drawable) && this.isRotateImageToFitScreen) {
            Intrinsics.checkNotNull((Object)drawable);
            n = drawable.getIntrinsicWidth();
        } else {
            Intrinsics.checkNotNull((Object)drawable);
            n = drawable.getIntrinsicHeight();
        }
        return n;
    }

    public final void setScrollPosition(float focusX, float focusY) {
        this.setZoom(this.currentZoom, focusX, focusY);
    }

    private final void fixTrans() {
        this.touchMatrix.getValues(this.floatMatrix);
        float transX = this.floatMatrix[2];
        float transY = this.floatMatrix[5];
        float offset = 0.0f;
        if (this.isRotateImageToFitScreen && this.orientationMismatch(this.getDrawable())) {
            offset = this.getImageWidth();
        }
        float fixTransX = this.getFixTrans(transX, this.viewWidth, this.getImageWidth(), offset);
        float fixTransY = this.getFixTrans(transY, this.viewHeight, this.getImageHeight(), 0.0f);
        this.touchMatrix.postTranslate(fixTransX, fixTransY);
    }

    private final void fixScaleTrans() {
        this.fixTrans();
        this.touchMatrix.getValues(this.floatMatrix);
        if (this.getImageWidth() < (float)this.viewWidth) {
            float xOffset = ((float)this.viewWidth - this.getImageWidth()) / (float)2;
            if (this.isRotateImageToFitScreen && this.orientationMismatch(this.getDrawable())) {
                xOffset += this.getImageWidth();
            }
            this.floatMatrix[2] = xOffset;
        }
        if (this.getImageHeight() < (float)this.viewHeight) {
            this.floatMatrix[5] = ((float)this.viewHeight - this.getImageHeight()) / (float)2;
        }
        this.touchMatrix.setValues(this.floatMatrix);
    }

    private final float getFixTrans(float trans, float viewSize, float contentSize, float offset) {
        float minTrans = 0.0f;
        float maxTrans = 0.0f;
        if (contentSize <= viewSize) {
            minTrans = offset;
            maxTrans = offset + viewSize - contentSize;
        } else {
            minTrans = offset + viewSize - contentSize;
            maxTrans = offset;
        }
        if (trans < minTrans) {
            return -trans + minTrans;
        }
        return trans > maxTrans ? -trans + maxTrans : 0.0f;
    }

    private final float getFixDragTrans(float delta, float viewSize, float contentSize) {
        return contentSize <= viewSize ? 0.0f : delta;
    }

    private final float getImageWidth() {
        return this.matchViewWidth * this.currentZoom;
    }

    private final float getImageHeight() {
        return this.matchViewHeight * this.currentZoom;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable = this.getDrawable();
        if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        int drawableWidth = this.getDrawableWidth(drawable);
        int drawableHeight = this.getDrawableHeight(drawable);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int totalViewWidth = this.setViewSize(widthMode, widthSize, drawableWidth);
        int totalViewHeight = this.setViewSize(heightMode, heightSize, drawableHeight);
        if (!this.orientationJustChanged) {
            this.savePreviousImageValues();
        }
        int width = totalViewWidth - this.getPaddingLeft() - this.getPaddingRight();
        int height = totalViewHeight - this.getPaddingTop() - this.getPaddingBottom();
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.viewWidth = w;
        this.viewHeight = h;
        this.fitImageToView();
    }

    private final void fitImageToView() {
        FixedPixel fixedPixel = this.orientationJustChanged ? this.orientationChangeFixedPixel : this.viewSizeChangeFixedPixel;
        this.orientationJustChanged = false;
        Drawable drawable = this.getDrawable();
        if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
            return;
        }
        if (this.touchMatrix == null || this.prevMatrix == null) {
            return;
        }
        if (this.userSpecifiedMinScale == -1.0f) {
            this.setMinZoom(-1.0f);
            if (this.currentZoom < this.minScale) {
                this.currentZoom = this.minScale;
            }
        }
        int drawableWidth = this.getDrawableWidth(drawable);
        int drawableHeight = this.getDrawableHeight(drawable);
        float scaleX = 0.0f;
        scaleX = (float)this.viewWidth / (float)drawableWidth;
        float scaleY = 0.0f;
        scaleY = (float)this.viewHeight / (float)drawableHeight;
        ImageView.ScaleType scaleType = this.touchScaleType;
        int n = scaleType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()];
        switch (n) {
            case 1: {
                scaleX = scaleY = 1.0f;
                break;
            }
            case 2: {
                float f = scaleX;
                float f2 = scaleY;
                boolean bl2 = false;
                scaleX = scaleY = Math.max(f, f2);
                break;
            }
            case 3: {
                TouchImageView touchImageView = this;
                boolean bl = false;
                boolean bl2 = false;
                TouchImageView $this$fitImageToView_u24lambda_u2d0 = touchImageView;
                boolean bl3 = false;
                float f = 1.0f;
                float f3 = scaleX;
                float f4 = scaleY;
                boolean bl4 = false;
                f3 = Math.min(f3, f4);
                boolean bl5 = false;
                scaleX = scaleY = Math.min(f, f3);
                touchImageView = this;
                bl = false;
                bl2 = false;
                TouchImageView $this$fitImageToView_u24lambda_u2d1 = touchImageView;
                boolean bl6 = false;
                f = scaleX;
                f3 = scaleY;
                bl5 = false;
                scaleX = scaleY = Math.min(f, f3);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                float f = scaleX;
                float f2 = scaleY;
                boolean bl2 = false;
                scaleX = scaleY = Math.min(f, f2);
                break;
            }
            case 7: {
                break;
            }
        }
        float redundantXSpace = (float)this.viewWidth - scaleX * (float)drawableWidth;
        float redundantYSpace = (float)this.viewHeight - scaleY * (float)drawableHeight;
        this.matchViewWidth = (float)this.viewWidth - redundantXSpace;
        this.matchViewHeight = (float)this.viewHeight - redundantYSpace;
        if (!this.isZoomed() && !this.imageRenderedAtLeastOnce) {
            if (this.isRotateImageToFitScreen && this.orientationMismatch(drawable)) {
                this.touchMatrix.setRotate(90.0f);
                this.touchMatrix.postTranslate((float)drawableWidth, 0.0f);
                this.touchMatrix.postScale(scaleX, scaleY);
            } else {
                this.touchMatrix.setScale(scaleX, scaleY);
            }
            ImageView.ScaleType scaleType2 = this.touchScaleType;
            int n2 = scaleType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scaleType2.ordinal()];
            switch (n2) {
                case 5: {
                    this.touchMatrix.postTranslate(0.0f, 0.0f);
                    break;
                }
                case 6: {
                    this.touchMatrix.postTranslate(redundantXSpace, redundantYSpace);
                    break;
                }
                default: {
                    this.touchMatrix.postTranslate(redundantXSpace / (float)2, redundantYSpace / (float)2);
                }
            }
            this.currentZoom = 1.0f;
        } else {
            if (this.prevMatchViewWidth == 0.0f || this.prevMatchViewHeight == 0.0f) {
                this.savePreviousImageValues();
            }
            this.prevMatrix.getValues(this.floatMatrix);
            this.floatMatrix[0] = this.matchViewWidth / (float)drawableWidth * this.currentZoom;
            this.floatMatrix[4] = this.matchViewHeight / (float)drawableHeight * this.currentZoom;
            float transX = this.floatMatrix[2];
            float transY = this.floatMatrix[5];
            float prevActualWidth = this.prevMatchViewWidth * this.currentZoom;
            float actualWidth = this.getImageWidth();
            this.floatMatrix[2] = this.newTranslationAfterChange(transX, prevActualWidth, actualWidth, this.prevViewWidth, this.viewWidth, drawableWidth, fixedPixel);
            float prevActualHeight = this.prevMatchViewHeight * this.currentZoom;
            float actualHeight = this.getImageHeight();
            this.floatMatrix[5] = this.newTranslationAfterChange(transY, prevActualHeight, actualHeight, this.prevViewHeight, this.viewHeight, drawableHeight, fixedPixel);
            this.touchMatrix.setValues(this.floatMatrix);
        }
        this.fixTrans();
        this.setImageMatrix(this.touchMatrix);
    }

    private final int setViewSize(int mode, int size, int drawableWidth) {
        int n;
        int n2 = mode;
        switch (n2) {
            case 0x40000000: {
                n = size;
                break;
            }
            case -2147483648: {
                boolean bl = false;
                n = Math.min(drawableWidth, size);
                break;
            }
            case 0: {
                n = drawableWidth;
                break;
            }
            default: {
                n = size;
            }
        }
        return n;
    }

    private final float newTranslationAfterChange(float trans, float prevImageSize, float imageSize, int prevViewSize, int viewSize, int drawableSize, FixedPixel sizeChangeFixedPixel) {
        float f;
        if (imageSize < (float)viewSize) {
            f = ((float)viewSize - (float)drawableSize * this.floatMatrix[0]) * 0.5f;
        } else if (trans > 0.0f) {
            f = -((imageSize - (float)viewSize) * 0.5f);
        } else {
            float fixedPixelPositionInView = 0.5f;
            if (sizeChangeFixedPixel == FixedPixel.BOTTOM_RIGHT) {
                fixedPixelPositionInView = 1.0f;
            } else if (sizeChangeFixedPixel == FixedPixel.TOP_LEFT) {
                fixedPixelPositionInView = 0.0f;
            }
            float fixedPixelPositionInImage = (-trans + fixedPixelPositionInView * (float)prevViewSize) / prevImageSize;
            f = -(fixedPixelPositionInImage * imageSize - (float)viewSize * fixedPixelPositionInView);
        }
        return f;
    }

    private final void setState(ImageActionState imageActionState) {
        this.imageActionState = imageActionState;
    }

    @Deprecated(message="")
    public final boolean canScrollHorizontallyFroyo(int direction) {
        return this.canScrollHorizontally(direction);
    }

    public boolean canScrollHorizontally(int direction) {
        boolean bl;
        this.touchMatrix.getValues(this.floatMatrix);
        float x = this.floatMatrix[2];
        if (this.getImageWidth() < (float)this.viewWidth) {
            bl = false;
        } else if (x >= -1.0f && direction < 0) {
            bl = false;
        } else {
            boolean bl2 = false;
            bl = Math.abs(x) + (float)this.viewWidth + 1.0f < this.getImageWidth() || direction <= 0;
        }
        return bl;
    }

    public boolean canScrollVertically(int direction) {
        boolean bl;
        this.touchMatrix.getValues(this.floatMatrix);
        float y = this.floatMatrix[5];
        if (this.getImageHeight() < (float)this.viewHeight) {
            bl = false;
        } else if (y >= -1.0f && direction < 0) {
            bl = false;
        } else {
            boolean bl2 = false;
            bl = Math.abs(y) + (float)this.viewHeight + 1.0f < this.getImageHeight() || direction <= 0;
        }
        return bl;
    }

    private final void scaleImage(double deltaScale, float focusX, float focusY, boolean stretchImageToSuper) {
        double deltaScaleLocal = deltaScale;
        float lowerScale = 0.0f;
        float upperScale = 0.0f;
        if (stretchImageToSuper) {
            lowerScale = this.superMinScale;
            upperScale = this.superMaxScale;
        } else {
            lowerScale = this.minScale;
            upperScale = this.maxScale;
        }
        float origScale = this.currentZoom;
        TouchImageView touchImageView = this;
        touchImageView.currentZoom *= (float)deltaScaleLocal;
        if (this.currentZoom > upperScale) {
            this.currentZoom = upperScale;
            deltaScaleLocal = (double)upperScale / (double)origScale;
        } else if (this.currentZoom < lowerScale) {
            this.currentZoom = lowerScale;
            deltaScaleLocal = (double)lowerScale / (double)origScale;
        }
        this.touchMatrix.postScale((float)deltaScaleLocal, (float)deltaScaleLocal, focusX, focusY);
        this.fixScaleTrans();
    }

    @NotNull
    protected final PointF transformCoordTouchToBitmap(float x, float y, boolean clipToBitmap) {
        this.touchMatrix.getValues(this.floatMatrix);
        float origW = this.getDrawable().getIntrinsicWidth();
        float origH = this.getDrawable().getIntrinsicHeight();
        float transX = this.floatMatrix[2];
        float transY = this.floatMatrix[5];
        float finalX = (x - transX) * origW / this.getImageWidth();
        float finalY = (y - transY) * origH / this.getImageHeight();
        if (clipToBitmap) {
            float f = 0.0f;
            boolean bl = false;
            f = Math.max(finalX, f);
            bl = false;
            finalX = Math.min(f, origW);
            f = 0.0f;
            bl = false;
            f = Math.max(finalY, f);
            bl = false;
            finalY = Math.min(f, origH);
        }
        return new PointF(finalX, finalY);
    }

    @NotNull
    protected final PointF transformCoordBitmapToTouch(float bx, float by) {
        this.touchMatrix.getValues(this.floatMatrix);
        float origW = this.getDrawable().getIntrinsicWidth();
        float origH = this.getDrawable().getIntrinsicHeight();
        float px = bx / origW;
        float py = by / origH;
        float finalX = this.floatMatrix[2] + this.getImageWidth() * px;
        float finalY = this.floatMatrix[5] + this.getImageHeight() * py;
        return new PointF(finalX, finalY);
    }

    @TargetApi(value=16)
    private final void compatPostOnAnimation(Runnable runnable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.postOnAnimation(runnable);
        } else {
            this.postDelayed(runnable, 16L);
        }
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY) {
        this.setZoomAnimated(scale, focusX, focusY, 500);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, int zoomTimeMs) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), zoomTimeMs);
        this.compatPostOnAnimation(animation);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, int zoomTimeMs, @Nullable OnZoomFinishedListener listener) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), zoomTimeMs);
        animation.setListener(listener);
        this.compatPostOnAnimation(animation);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, @Nullable OnZoomFinishedListener listener) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), 500);
        animation.setListener(listener);
        this.compatPostOnAnimation(animation);
    }

    @JvmOverloads
    public TouchImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TouchImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J,\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/ortiz/touchview/TouchImageView$GestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "(Lcom/ortiz/touchview/TouchImageView;)V", "onDoubleTap", "", "e", "Landroid/view/MotionEvent;", "onDoubleTapEvent", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onLongPress", "", "onSingleTapConfirmed", "touchview_release"})
    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public GestureListener() {
            Intrinsics.checkNotNullParameter((Object)((Object)TouchImageView.this), (String)"this$0");
        }

        public boolean onSingleTapConfirmed(@Nullable MotionEvent e) {
            GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
            Boolean bl = onDoubleTapListener == null ? null : Boolean.valueOf(onDoubleTapListener.onSingleTapConfirmed(e));
            return bl == null ? TouchImageView.this.performClick() : bl.booleanValue();
        }

        public void onLongPress(@Nullable MotionEvent e) {
            TouchImageView.this.performLongClick();
        }

        /*
         * WARNING - void declaration
         */
        public boolean onFling(@Nullable MotionEvent e1, @Nullable MotionEvent e2, float velocityX, float velocityY) {
            void it;
            Fling fling = TouchImageView.this.fling;
            if (fling != null) {
                fling.cancelFling();
            }
            fling = new Fling((int)velocityX, (int)velocityY);
            TouchImageView touchImageView = TouchImageView.this;
            boolean bl = false;
            boolean bl2 = false;
            Fling fling2 = fling;
            TouchImageView touchImageView2 = TouchImageView.this;
            boolean bl3 = false;
            touchImageView.compatPostOnAnimation((Runnable)it);
            Unit unit = Unit.INSTANCE;
            touchImageView2.fling = fling;
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onDoubleTap(@Nullable MotionEvent e) {
            boolean consumed = false;
            if (e != null && TouchImageView.this.isZoomEnabled()) {
                GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
                if (onDoubleTapListener != null) {
                    GestureDetector.OnDoubleTapListener onDoubleTapListener2 = onDoubleTapListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    GestureDetector.OnDoubleTapListener it = onDoubleTapListener2;
                    boolean bl3 = false;
                    consumed = it.onDoubleTap(e);
                }
                if (TouchImageView.this.imageActionState == ImageActionState.NONE) {
                    float maxZoomScale = TouchImageView.this.getDoubleTapScale() == 0.0f ? TouchImageView.this.maxScale : TouchImageView.this.getDoubleTapScale();
                    float targetZoom = TouchImageView.this.getCurrentZoom() == TouchImageView.this.minScale ? maxZoomScale : TouchImageView.this.minScale;
                    DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, e.getX(), e.getY(), false);
                    TouchImageView.this.compatPostOnAnimation(doubleTap);
                    consumed = true;
                }
            }
            return consumed;
        }

        public boolean onDoubleTapEvent(@Nullable MotionEvent e) {
            boolean bl;
            GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
            return onDoubleTapListener == null ? false : (bl = onDoubleTapListener.onDoubleTapEvent(e));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ortiz/touchview/TouchImageView$PrivateOnTouchListener;", "Landroid/view/View$OnTouchListener;", "(Lcom/ortiz/touchview/TouchImageView;)V", "last", "Landroid/graphics/PointF;", "onTouch", "", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "touchview_release"})
    private final class PrivateOnTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final PointF last;

        public PrivateOnTouchListener() {
            Intrinsics.checkNotNullParameter((Object)((Object)TouchImageView.this), (String)"this$0");
            this.last = new PointF();
        }

        public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (TouchImageView.this.getDrawable() == null) {
                TouchImageView.this.setState(ImageActionState.NONE);
                return false;
            }
            if (TouchImageView.this.isZoomEnabled()) {
                TouchImageView.this.scaleDetector.onTouchEvent(event);
            }
            TouchImageView.this.gestureDetector.onTouchEvent(event);
            PointF curr = new PointF(event.getX(), event.getY());
            if (TouchImageView.this.imageActionState == ImageActionState.NONE || TouchImageView.this.imageActionState == ImageActionState.DRAG || TouchImageView.this.imageActionState == ImageActionState.FLING) {
                int n = event.getAction();
                switch (n) {
                    case 0: {
                        this.last.set(curr);
                        object2 = TouchImageView.this.fling;
                        if (object2 != null) {
                            ((Fling)object2).cancelFling();
                        }
                        TouchImageView.this.setState(ImageActionState.DRAG);
                        break;
                    }
                    case 2: {
                        if (TouchImageView.this.imageActionState != ImageActionState.DRAG) break;
                        float deltaX = curr.x - this.last.x;
                        float deltaY = curr.y - this.last.y;
                        float fixTransX = TouchImageView.this.getFixDragTrans(deltaX, TouchImageView.this.viewWidth, TouchImageView.this.getImageWidth());
                        float fixTransY = TouchImageView.this.getFixDragTrans(deltaY, TouchImageView.this.viewHeight, TouchImageView.this.getImageHeight());
                        TouchImageView.this.touchMatrix.postTranslate(fixTransX, fixTransY);
                        TouchImageView.this.fixTrans();
                        this.last.set(curr.x, curr.y);
                        break;
                    }
                    case 1: 
                    case 6: {
                        TouchImageView.this.setState(ImageActionState.NONE);
                    }
                }
            }
            if ((object = TouchImageView.this.touchCoordinatesListener) != null) {
                object2 = object;
                TouchImageView touchImageView = TouchImageView.this;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                PointF bitmapPoint = touchImageView.transformCoordTouchToBitmap(event.getX(), event.getY(), true);
                it.onTouchCoordinate(v, event, bitmapPoint);
            }
            TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
            object = TouchImageView.this.userTouchListener;
            if (object != null) {
                object.onTouch(v, event);
            }
            object = TouchImageView.this.touchImageViewListener;
            if (object != null) {
                object.onMove();
            }
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/ortiz/touchview/TouchImageView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lcom/ortiz/touchview/TouchImageView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "onScaleBegin", "onScaleEnd", "", "touchview_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public ScaleListener() {
            Intrinsics.checkNotNullParameter((Object)((Object)TouchImageView.this), (String)"this$0");
        }

        public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            TouchImageView.this.setState(ImageActionState.ZOOM);
            return true;
        }

        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            TouchImageView.this.scaleImage(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY(), true);
            OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
            if (onTouchImageViewListener != null) {
                onTouchImageViewListener.onMove();
            }
            return true;
        }

        public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            super.onScaleEnd(detector);
            TouchImageView.this.setState(ImageActionState.NONE);
            boolean animateToZoomBoundary = false;
            float targetZoom = TouchImageView.this.getCurrentZoom();
            if (TouchImageView.this.getCurrentZoom() > TouchImageView.this.maxScale) {
                targetZoom = TouchImageView.this.maxScale;
                animateToZoomBoundary = true;
            } else if (TouchImageView.this.getCurrentZoom() < TouchImageView.this.minScale) {
                targetZoom = TouchImageView.this.minScale;
                animateToZoomBoundary = true;
            }
            if (animateToZoomBoundary) {
                DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, TouchImageView.this.viewWidth / 2, TouchImageView.this.viewHeight / 2, true);
                TouchImageView.this.compatPostOnAnimation(doubleTap);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/ortiz/touchview/TouchImageView$DoubleTapZoom;", "Ljava/lang/Runnable;", "targetZoom", "", "focusX", "focusY", "stretchImageToSuper", "", "(Lcom/ortiz/touchview/TouchImageView;FFFZ)V", "bitmapX", "bitmapY", "endTouch", "Landroid/graphics/PointF;", "interpolator", "Landroid/view/animation/AccelerateDecelerateInterpolator;", "startTime", "", "startTouch", "startZoom", "calculateDeltaScale", "", "t", "interpolate", "run", "", "translateImageToCenterTouchPosition", "touchview_release"})
    private final class DoubleTapZoom
    implements Runnable {
        private final long startTime;
        private final float startZoom;
        private final float targetZoom;
        private final float bitmapX;
        private final float bitmapY;
        private final boolean stretchImageToSuper;
        @NotNull
        private final AccelerateDecelerateInterpolator interpolator;
        @NotNull
        private final PointF startTouch;
        @NotNull
        private final PointF endTouch;

        public DoubleTapZoom(float targetZoom, float focusX, float focusY, boolean stretchImageToSuper) {
            Intrinsics.checkNotNullParameter((Object)((Object)TouchImageView.this), (String)"this$0");
            this.interpolator = new AccelerateDecelerateInterpolator();
            TouchImageView.this.setState(ImageActionState.ANIMATE_ZOOM);
            this.startTime = System.currentTimeMillis();
            this.startZoom = TouchImageView.this.getCurrentZoom();
            this.targetZoom = targetZoom;
            this.stretchImageToSuper = stretchImageToSuper;
            PointF bitmapPoint = TouchImageView.this.transformCoordTouchToBitmap(focusX, focusY, false);
            this.bitmapX = bitmapPoint.x;
            this.bitmapY = bitmapPoint.y;
            this.startTouch = TouchImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            this.endTouch = new PointF((float)(TouchImageView.this.viewWidth / 2), (float)(TouchImageView.this.viewHeight / 2));
        }

        @Override
        public void run() {
            if (TouchImageView.this.getDrawable() == null) {
                TouchImageView.this.setState(ImageActionState.NONE);
                return;
            }
            float t = this.interpolate();
            double deltaScale = this.calculateDeltaScale(t);
            TouchImageView.this.scaleImage(deltaScale, this.bitmapX, this.bitmapY, this.stretchImageToSuper);
            this.translateImageToCenterTouchPosition(t);
            TouchImageView.this.fixScaleTrans();
            TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
            OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
            if (onTouchImageViewListener != null) {
                onTouchImageViewListener.onMove();
            }
            if (t < 1.0f) {
                TouchImageView.this.compatPostOnAnimation(this);
            } else {
                TouchImageView.this.setState(ImageActionState.NONE);
            }
        }

        private final void translateImageToCenterTouchPosition(float t) {
            float targetX = this.startTouch.x + t * (this.endTouch.x - this.startTouch.x);
            float targetY = this.startTouch.y + t * (this.endTouch.y - this.startTouch.y);
            PointF curr = TouchImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            TouchImageView.this.touchMatrix.postTranslate(targetX - curr.x, targetY - curr.y);
        }

        private final float interpolate() {
            long currTime = System.currentTimeMillis();
            float elapsed = (float)(currTime - this.startTime) / 500.0f;
            float f = 1.0f;
            boolean bl = false;
            elapsed = Math.min(f, elapsed);
            return this.interpolator.getInterpolation(elapsed);
        }

        private final double calculateDeltaScale(float t) {
            double zoom = (double)this.startZoom + (double)t * (double)(this.targetZoom - this.startZoom);
            return zoom / (double)TouchImageView.this.getCurrentZoom();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001e\u0010\u000e\u001a\u00060\u000fR\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/ortiz/touchview/TouchImageView$Fling;", "Ljava/lang/Runnable;", "velocityX", "", "velocityY", "(Lcom/ortiz/touchview/TouchImageView;II)V", "currX", "getCurrX", "()I", "setCurrX", "(I)V", "currY", "getCurrY", "setCurrY", "scroller", "Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "Lcom/ortiz/touchview/TouchImageView;", "getScroller", "()Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "setScroller", "(Lcom/ortiz/touchview/TouchImageView$CompatScroller;)V", "cancelFling", "", "run", "touchview_release"})
    private final class Fling
    implements Runnable {
        @NotNull
        private CompatScroller scroller;
        private int currX;
        private int currY;

        public Fling(int velocityX, int velocityY) {
            Intrinsics.checkNotNullParameter((Object)((Object)TouchImageView.this), (String)"this$0");
            TouchImageView.this.setState(ImageActionState.FLING);
            this.scroller = new CompatScroller(TouchImageView.this.getContext());
            TouchImageView.this.touchMatrix.getValues(TouchImageView.this.floatMatrix);
            int startX = (int)TouchImageView.this.floatMatrix[2];
            int startY = (int)TouchImageView.this.floatMatrix[5];
            int minX = 0;
            int maxX = 0;
            int minY = 0;
            int maxY = 0;
            if (TouchImageView.this.isRotateImageToFitScreen && TouchImageView.this.orientationMismatch(TouchImageView.this.getDrawable())) {
                startX -= (int)TouchImageView.this.getImageWidth();
            }
            if (TouchImageView.this.getImageWidth() > (float)TouchImageView.this.viewWidth) {
                minX = TouchImageView.this.viewWidth - (int)TouchImageView.this.getImageWidth();
                maxX = 0;
            } else {
                minX = maxX = startX;
            }
            if (TouchImageView.this.getImageHeight() > (float)TouchImageView.this.viewHeight) {
                minY = TouchImageView.this.viewHeight - (int)TouchImageView.this.getImageHeight();
                maxY = 0;
            } else {
                minY = maxY = startY;
            }
            this.scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            this.currX = startX;
            this.currY = startY;
        }

        @NotNull
        public final CompatScroller getScroller() {
            return this.scroller;
        }

        public final void setScroller(@NotNull CompatScroller compatScroller) {
            Intrinsics.checkNotNullParameter((Object)compatScroller, (String)"<set-?>");
            this.scroller = compatScroller;
        }

        public final int getCurrX() {
            return this.currX;
        }

        public final void setCurrX(int n) {
            this.currX = n;
        }

        public final int getCurrY() {
            return this.currY;
        }

        public final void setCurrY(int n) {
            this.currY = n;
        }

        public final void cancelFling() {
            TouchImageView.this.setState(ImageActionState.NONE);
            this.scroller.forceFinished(true);
        }

        @Override
        public void run() {
            OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
            if (onTouchImageViewListener != null) {
                onTouchImageViewListener.onMove();
            }
            if (this.scroller.isFinished()) {
                return;
            }
            if (this.scroller.computeScrollOffset()) {
                int newX = this.scroller.getCurrX();
                int newY = this.scroller.getCurrY();
                int transX = newX - this.currX;
                int transY = newY - this.currY;
                this.currX = newX;
                this.currY = newY;
                TouchImageView.this.touchMatrix.postTranslate((float)transX, (float)transY);
                TouchImageView.this.fixTrans();
                TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
                TouchImageView.this.compatPostOnAnimation(this);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0014\u001a\u00020\fJF\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "", "context", "Landroid/content/Context;", "(Lcom/ortiz/touchview/TouchImageView;Landroid/content/Context;)V", "currX", "", "getCurrX", "()I", "currY", "getCurrY", "isFinished", "", "()Z", "overScroller", "Landroid/widget/OverScroller;", "getOverScroller", "()Landroid/widget/OverScroller;", "setOverScroller", "(Landroid/widget/OverScroller;)V", "computeScrollOffset", "fling", "", "startX", "startY", "velocityX", "velocityY", "minX", "maxX", "minY", "maxY", "forceFinished", "finished", "touchview_release"})
    private final class CompatScroller {
        @NotNull
        private OverScroller overScroller;

        public CompatScroller(Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)TouchImageView.this), (String)"this$0");
            this.overScroller = new OverScroller(context);
        }

        @NotNull
        public final OverScroller getOverScroller() {
            return this.overScroller;
        }

        public final void setOverScroller(@NotNull OverScroller overScroller) {
            Intrinsics.checkNotNullParameter((Object)overScroller, (String)"<set-?>");
            this.overScroller = overScroller;
        }

        public final void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
            this.overScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
        }

        public final void forceFinished(boolean finished) {
            this.overScroller.forceFinished(finished);
        }

        public final boolean isFinished() {
            return this.overScroller.isFinished();
        }

        public final boolean computeScrollOffset() {
            this.overScroller.computeScrollOffset();
            return this.overScroller.computeScrollOffset();
        }

        public final int getCurrX() {
            return this.overScroller.getCurrX();
        }

        public final int getCurrY() {
            return this.overScroller.getCurrY();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ortiz/touchview/TouchImageView$AnimatedZoom;", "Ljava/lang/Runnable;", "targetZoom", "", "focus", "Landroid/graphics/PointF;", "zoomTimeMillis", "", "(Lcom/ortiz/touchview/TouchImageView;FLandroid/graphics/PointF;I)V", "interpolator", "Landroid/view/animation/LinearInterpolator;", "startFocus", "startTime", "", "startZoom", "targetFocus", "zoomFinishedListener", "Lcom/ortiz/touchview/OnZoomFinishedListener;", "interpolate", "run", "", "setListener", "listener", "touchview_release"})
    private final class AnimatedZoom
    implements Runnable {
        private final int zoomTimeMillis;
        private final long startTime;
        private final float startZoom;
        private final float targetZoom;
        @NotNull
        private final PointF startFocus;
        @NotNull
        private final PointF targetFocus;
        @NotNull
        private final LinearInterpolator interpolator;
        @Nullable
        private OnZoomFinishedListener zoomFinishedListener;

        public AnimatedZoom(@NotNull float targetZoom, PointF focus, int zoomTimeMillis) {
            Intrinsics.checkNotNullParameter((Object)((Object)TouchImageView.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)focus, (String)"focus");
            this.interpolator = new LinearInterpolator();
            TouchImageView.this.setState(ImageActionState.ANIMATE_ZOOM);
            this.startTime = System.currentTimeMillis();
            this.startZoom = TouchImageView.this.getCurrentZoom();
            this.targetZoom = targetZoom;
            this.zoomTimeMillis = zoomTimeMillis;
            this.startFocus = TouchImageView.this.getScrollPosition();
            this.targetFocus = focus;
        }

        @Override
        public void run() {
            float t = this.interpolate();
            float nextZoom = this.startZoom + (this.targetZoom - this.startZoom) * t;
            float nextX = this.startFocus.x + (this.targetFocus.x - this.startFocus.x) * t;
            float nextY = this.startFocus.y + (this.targetFocus.y - this.startFocus.y) * t;
            TouchImageView.this.setZoom(nextZoom, nextX, nextY);
            if (t < 1.0f) {
                TouchImageView.this.compatPostOnAnimation(this);
            } else {
                TouchImageView.this.setState(ImageActionState.NONE);
                OnZoomFinishedListener onZoomFinishedListener = this.zoomFinishedListener;
                if (onZoomFinishedListener != null) {
                    onZoomFinishedListener.onZoomFinished();
                }
            }
        }

        private final float interpolate() {
            float elapsed = (float)(System.currentTimeMillis() - this.startTime) / (float)this.zoomTimeMillis;
            float f = 1.0f;
            boolean bl = false;
            elapsed = Math.min(f, elapsed);
            return this.interpolator.getInterpolation(elapsed);
        }

        public final void setListener(@Nullable OnZoomFinishedListener listener) {
            this.zoomFinishedListener = listener;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ortiz/touchview/TouchImageView$Companion;", "", "()V", "AUTOMATIC_MIN_ZOOM", "", "DEFAULT_ZOOM_TIME", "", "SUPER_MAX_MULTIPLIER", "SUPER_MIN_MULTIPLIER", "touchview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageView.ScaleType.values().length];
            nArray[ImageView.ScaleType.CENTER.ordinal()] = 1;
            nArray[ImageView.ScaleType.CENTER_CROP.ordinal()] = 2;
            nArray[ImageView.ScaleType.CENTER_INSIDE.ordinal()] = 3;
            nArray[ImageView.ScaleType.FIT_CENTER.ordinal()] = 4;
            nArray[ImageView.ScaleType.FIT_START.ordinal()] = 5;
            nArray[ImageView.ScaleType.FIT_END.ordinal()] = 6;
            nArray[ImageView.ScaleType.FIT_XY.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

