/*
 * Decompiled with CFR 0.152.
 */
package com.ortiz.touchview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import androidx.appcompat.widget.AppCompatImageView;
import com.ortiz.touchview.R;
import com.ortiz.touchview.TouchImageView$WhenMappings;
import java.io.Serializable;
import java.util.HashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 \u00c2\u00012\u00020\u0001:\u001a\u00c1\u0001\u00c2\u0001\u00c3\u0001\u00c4\u0001\u00c5\u0001\u00c6\u0001\u00c7\u0001\u00c8\u0001\u00c9\u0001\u00ca\u0001\u00cb\u0001\u00cc\u0001\u00cd\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010`\u001a\u00020\u001d2\u0006\u0010a\u001a\u00020\u0007H\u0016J\u0010\u0010b\u001a\u00020\u001d2\u0006\u0010a\u001a\u00020\u0007H\u0007J\u0010\u0010c\u001a\u00020\u001d2\u0006\u0010a\u001a\u00020\u0007H\u0016J\u0010\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020gH\u0003J\b\u0010h\u001a\u00020eH\u0002J\b\u0010i\u001a\u00020eH\u0002J\b\u0010j\u001a\u00020eH\u0002J\u0012\u0010k\u001a\u00020\u00072\b\u0010l\u001a\u0004\u0018\u00010mH\u0002J\u0012\u0010n\u001a\u00020\u00072\b\u0010l\u001a\u0004\u0018\u00010mH\u0002J \u0010o\u001a\u00020\n2\u0006\u0010p\u001a\u00020\n2\u0006\u0010q\u001a\u00020\n2\u0006\u0010r\u001a\u00020\nH\u0002J(\u0010s\u001a\u00020\n2\u0006\u0010t\u001a\u00020\n2\u0006\u0010q\u001a\u00020\n2\u0006\u0010r\u001a\u00020\n2\u0006\u0010u\u001a\u00020\nH\u0002J\b\u0010v\u001a\u00020SH\u0016JB\u0010w\u001a\u00020\n2\u0006\u0010t\u001a\u00020\n2\u0006\u0010x\u001a\u00020\n2\u0006\u0010y\u001a\u00020\n2\u0006\u0010z\u001a\u00020\u00072\u0006\u0010q\u001a\u00020\u00072\u0006\u0010{\u001a\u00020\u00072\b\u0010|\u001a\u0004\u0018\u00010;H\u0002J\u0010\u0010}\u001a\u00020e2\u0006\u0010~\u001a\u00020\u007fH\u0016J\u0013\u0010\u0080\u0001\u001a\u00020e2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0014J\u001b\u0010\u0083\u0001\u001a\u00020e2\u0007\u0010\u0084\u0001\u001a\u00020\u00072\u0007\u0010\u0085\u0001\u001a\u00020\u0007H\u0014J\u0012\u0010\u0086\u0001\u001a\u00020e2\u0007\u0010K\u001a\u00030\u0087\u0001H\u0016J\f\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0087\u0001H\u0016J-\u0010\u0089\u0001\u001a\u00020e2\u0007\u0010\u008a\u0001\u001a\u00020\u00072\u0007\u0010\u008b\u0001\u001a\u00020\u00072\u0007\u0010\u008c\u0001\u001a\u00020\u00072\u0007\u0010\u008d\u0001\u001a\u00020\u0007H\u0014J\u0013\u0010\u008e\u0001\u001a\u00020\u001d2\b\u0010l\u001a\u0004\u0018\u00010mH\u0002J\u0007\u0010\u008f\u0001\u001a\u00020eJ\u0007\u0010\u0090\u0001\u001a\u00020eJ\u0007\u0010\u0091\u0001\u001a\u00020eJ.\u0010\u0092\u0001\u001a\u00020e2\b\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020\n2\u0007\u0010\u0097\u0001\u001a\u00020\u001dH\u0002J\u0013\u0010\u0098\u0001\u001a\u00020e2\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001H\u0016J\u0013\u0010\u009b\u0001\u001a\u00020e2\b\u0010l\u001a\u0004\u0018\u00010mH\u0016J\u0012\u0010\u009c\u0001\u001a\u00020e2\u0007\u0010\u009d\u0001\u001a\u00020\u0007H\u0016J\u0015\u0010\u009e\u0001\u001a\u00020e2\n\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u00a0\u0001H\u0016J\u000f\u0010\u00a1\u0001\u001a\u00020e2\u0006\u0010/\u001a\u00020\nJ\u0010\u0010\u00a2\u0001\u001a\u00020e2\u0007\u0010\u00a3\u0001\u001a\u00020\u0011J\u0010\u0010\u00a4\u0001\u001a\u00020e2\u0007\u0010\u00a5\u0001\u001a\u00020PJ\u0012\u0010\u00a6\u0001\u001a\u00020e2\u0007\u0010\u00a7\u0001\u001a\u00020VH\u0016J\u0010\u0010\u00a8\u0001\u001a\u00020e2\u0007\u0010\u00a9\u0001\u001a\u00020\u001dJ\u0012\u0010\u00aa\u0001\u001a\u00020e2\u0007\u0010\u00ab\u0001\u001a\u00020SH\u0016J\u0019\u0010\u00ac\u0001\u001a\u00020e2\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020\nJ\u0011\u0010\u00ad\u0001\u001a\u00020e2\u0006\u0010K\u001a\u00020LH\u0002J$\u0010\u00ae\u0001\u001a\u00020\u00072\u0007\u0010\u00af\u0001\u001a\u00020\u00072\u0007\u0010\u00b0\u0001\u001a\u00020\u00072\u0007\u0010\u00b1\u0001\u001a\u00020\u0007H\u0002J\u0010\u0010\u00b2\u0001\u001a\u00020e2\u0007\u0010\u00b3\u0001\u001a\u00020\u0000J\u0010\u0010\u00b2\u0001\u001a\u00020e2\u0007\u0010\u00b4\u0001\u001a\u00020\nJ\"\u0010\u00b2\u0001\u001a\u00020e2\u0007\u0010\u00b4\u0001\u001a\u00020\n2\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020\nJ-\u0010\u00b2\u0001\u001a\u00020e2\u0007\u0010\u00b4\u0001\u001a\u00020\n2\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020\n2\t\u0010\u00b5\u0001\u001a\u0004\u0018\u00010SJ\"\u0010\u00b6\u0001\u001a\u00020e2\u0007\u0010\u00b4\u0001\u001a\u00020\n2\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020\nJ.\u0010\u00b6\u0001\u001a\u00020e2\u0007\u0010\u00b4\u0001\u001a\u00020\n2\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020\n2\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00b8\u0001J+\u0010\u00b6\u0001\u001a\u00020e2\u0007\u0010\u00b4\u0001\u001a\u00020\n2\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020\n2\u0007\u0010\u00b9\u0001\u001a\u00020\u0007J7\u0010\u00b6\u0001\u001a\u00020e2\u0007\u0010\u00b4\u0001\u001a\u00020\n2\u0007\u0010\u0095\u0001\u001a\u00020\n2\u0007\u0010\u0096\u0001\u001a\u00020\n2\u0007\u0010\u00b9\u0001\u001a\u00020\u00072\n\u0010\u00b7\u0001\u001a\u0005\u0018\u00010\u00b8\u0001J\u001b\u0010\u00ba\u0001\u001a\u00020H2\u0007\u0010\u00bb\u0001\u001a\u00020\n2\u0007\u0010\u00bc\u0001\u001a\u00020\nH\u0004J$\u0010\u00bd\u0001\u001a\u00020H2\u0007\u0010\u00be\u0001\u001a\u00020\n2\u0007\u0010\u00bf\u0001\u001a\u00020\n2\u0007\u0010\u00c0\u0001\u001a\u00020\u001dH\u0004R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u000e\u0010 \u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00100\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010\r\"\u0004\b2\u0010\u0015R\u000e\u00103\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u00020\n2\u0006\u00104\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\r\"\u0004\b7\u0010\u0015R\u000e\u00108\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010G\u001a\u00020H8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0010\u0010K\u001a\u0004\u0018\u00010LX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u0004\u0018\u00010SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010U\u001a\u0004\u0018\u00010VX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010X\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010=\"\u0004\bZ\u0010?R\u000e\u0010[\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\\\u001a\u00020]8F\u00a2\u0006\u0006\u001a\u0004\b^\u0010_\u00a8\u0006\u00ce\u0001"}, d2={"Lcom/ortiz/touchview/TouchImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "", "currentZoom", "getCurrentZoom", "()F", "delayedZoomVariables", "Lcom/ortiz/touchview/TouchImageView$ZoomVariables;", "doubleTapListener", "Landroid/view/GestureDetector$OnDoubleTapListener;", "doubleTapScale", "getDoubleTapScale", "setDoubleTapScale", "(F)V", "fling", "Lcom/ortiz/touchview/TouchImageView$Fling;", "floatMatrix", "", "imageHeight", "getImageHeight", "imageRenderedAtLeastOnce", "", "imageWidth", "getImageWidth", "isRotateImageToFitScreen", "isZoomEnabled", "()Z", "setZoomEnabled", "(Z)V", "isZoomed", "mGestureDetector", "Landroid/view/GestureDetector;", "mScaleDetector", "Landroid/view/ScaleGestureDetector;", "matchViewHeight", "matchViewWidth", "maxScale", "maxScaleIsSetByMultiplier", "maxScaleMultiplier", "max", "maxZoom", "getMaxZoom", "setMaxZoom", "minScale", "min", "minZoom", "getMinZoom", "setMinZoom", "onDrawReady", "orientation", "orientationChangeFixedPixel", "Lcom/ortiz/touchview/TouchImageView$FixedPixel;", "getOrientationChangeFixedPixel", "()Lcom/ortiz/touchview/TouchImageView$FixedPixel;", "setOrientationChangeFixedPixel", "(Lcom/ortiz/touchview/TouchImageView$FixedPixel;)V", "orientationJustChanged", "prevMatchViewHeight", "prevMatchViewWidth", "prevMatrix", "Landroid/graphics/Matrix;", "prevViewHeight", "prevViewWidth", "scrollPosition", "Landroid/graphics/PointF;", "getScrollPosition", "()Landroid/graphics/PointF;", "state", "Lcom/ortiz/touchview/TouchImageView$State;", "superMaxScale", "superMinScale", "touchImageViewListener", "Lcom/ortiz/touchview/TouchImageView$OnTouchImageViewListener;", "touchMatrix", "touchScaleType", "Landroid/widget/ImageView$ScaleType;", "userSpecifiedMinScale", "userTouchListener", "Landroid/view/View$OnTouchListener;", "viewHeight", "viewSizeChangeFixedPixel", "getViewSizeChangeFixedPixel", "setViewSizeChangeFixedPixel", "viewWidth", "zoomedRect", "Landroid/graphics/RectF;", "getZoomedRect", "()Landroid/graphics/RectF;", "canScrollHorizontally", "direction", "canScrollHorizontallyFroyo", "canScrollVertically", "compatPostOnAnimation", "", "runnable", "Ljava/lang/Runnable;", "fitImageToView", "fixScaleTrans", "fixTrans", "getDrawableHeight", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawableWidth", "getFixDragTrans", "delta", "viewSize", "contentSize", "getFixTrans", "trans", "offset", "getScaleType", "newTranslationAfterChange", "prevImageSize", "imageSize", "prevViewSize", "drawableSize", "sizeChangeFixedPixel", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "orientationMismatch", "resetZoom", "resetZoomAnimated", "savePreviousImageValues", "scaleImage", "deltaScale", "", "focusX", "focusY", "stretchImageToSuper", "setImageBitmap", "bm", "Landroid/graphics/Bitmap;", "setImageDrawable", "setImageResource", "resId", "setImageURI", "uri", "Landroid/net/Uri;", "setMaxZoomRatio", "setOnDoubleTapListener", "onDoubleTapListener", "setOnTouchImageViewListener", "onTouchImageViewListener", "setOnTouchListener", "onTouchListener", "setRotateImageToFitScreen", "rotateImageToFitScreen", "setScaleType", "type", "setScrollPosition", "setState", "setViewSize", "mode", "size", "drawableWidth", "setZoom", "img", "scale", "scaleType", "setZoomAnimated", "listener", "Lcom/ortiz/touchview/TouchImageView$OnZoomFinishedListener;", "zoomTimeMs", "transformCoordBitmapToTouch", "bx", "by", "transformCoordTouchToBitmap", "x", "y", "clipToBitmap", "AnimatedZoom", "Companion", "CompatScroller", "DoubleTapZoom", "FixedPixel", "Fling", "GestureListener", "OnTouchImageViewListener", "OnZoomFinishedListener", "PrivateOnTouchListener", "ScaleListener", "State", "ZoomVariables", "touchview_release"})
public final class TouchImageView
extends AppCompatImageView {
    private float currentZoom;
    private Matrix touchMatrix;
    private Matrix prevMatrix;
    private boolean isZoomEnabled;
    private boolean isRotateImageToFitScreen;
    @Nullable
    private FixedPixel orientationChangeFixedPixel;
    @Nullable
    private FixedPixel viewSizeChangeFixedPixel;
    private boolean orientationJustChanged;
    private State state;
    private float userSpecifiedMinScale;
    private float minScale;
    private boolean maxScaleIsSetByMultiplier;
    private float maxScaleMultiplier;
    private float maxScale;
    private float superMinScale;
    private float superMaxScale;
    private float[] floatMatrix;
    private float doubleTapScale;
    private Fling fling;
    private int orientation;
    private ImageView.ScaleType touchScaleType;
    private boolean imageRenderedAtLeastOnce;
    private boolean onDrawReady;
    private ZoomVariables delayedZoomVariables;
    private int viewWidth;
    private int viewHeight;
    private int prevViewWidth;
    private int prevViewHeight;
    private float matchViewWidth;
    private float matchViewHeight;
    private float prevMatchViewWidth;
    private float prevMatchViewHeight;
    private ScaleGestureDetector mScaleDetector;
    private GestureDetector mGestureDetector;
    private GestureDetector.OnDoubleTapListener doubleTapListener;
    private View.OnTouchListener userTouchListener;
    private OnTouchImageViewListener touchImageViewListener;
    private static final String DEBUG = "DEBUG";
    private static final float SUPER_MIN_MULTIPLIER = 0.75f;
    private static final float SUPER_MAX_MULTIPLIER = 1.25f;
    private static final int DEFAULT_ZOOM_TIME = 500;
    public static final float AUTOMATIC_MIN_ZOOM = -1.0f;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final float getCurrentZoom() {
        return this.currentZoom;
    }

    public final boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public final void setZoomEnabled(boolean bl) {
        this.isZoomEnabled = bl;
    }

    @Nullable
    public final FixedPixel getOrientationChangeFixedPixel() {
        return this.orientationChangeFixedPixel;
    }

    public final void setOrientationChangeFixedPixel(@Nullable FixedPixel fixedPixel) {
        this.orientationChangeFixedPixel = fixedPixel;
    }

    @Nullable
    public final FixedPixel getViewSizeChangeFixedPixel() {
        return this.viewSizeChangeFixedPixel;
    }

    public final void setViewSizeChangeFixedPixel(@Nullable FixedPixel fixedPixel) {
        this.viewSizeChangeFixedPixel = fixedPixel;
    }

    public final float getDoubleTapScale() {
        return this.doubleTapScale;
    }

    public final void setDoubleTapScale(float f) {
        this.doubleTapScale = f;
    }

    public final void setRotateImageToFitScreen(boolean rotateImageToFitScreen) {
        this.isRotateImageToFitScreen = rotateImageToFitScreen;
    }

    public void setOnTouchListener(@NotNull View.OnTouchListener onTouchListener) {
        Intrinsics.checkParameterIsNotNull((Object)onTouchListener, (String)"onTouchListener");
        this.userTouchListener = onTouchListener;
    }

    public final void setOnTouchImageViewListener(@NotNull OnTouchImageViewListener onTouchImageViewListener) {
        Intrinsics.checkParameterIsNotNull((Object)onTouchImageViewListener, (String)"onTouchImageViewListener");
        this.touchImageViewListener = onTouchImageViewListener;
    }

    public final void setOnDoubleTapListener(@NotNull GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        Intrinsics.checkParameterIsNotNull((Object)onDoubleTapListener, (String)"onDoubleTapListener");
        this.doubleTapListener = onDoubleTapListener;
    }

    public void setImageResource(int resId) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageResource(resId);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageBitmap(@NotNull Bitmap bm) {
        Intrinsics.checkParameterIsNotNull((Object)bm, (String)"bm");
        this.imageRenderedAtLeastOnce = false;
        super.setImageBitmap(bm);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageDrawable(drawable);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageURI(@Nullable Uri uri) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageURI(uri);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setScaleType(@NotNull ImageView.ScaleType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (type == ImageView.ScaleType.MATRIX) {
            super.setScaleType(ImageView.ScaleType.MATRIX);
        } else {
            this.touchScaleType = type;
            if (this.onDrawReady) {
                this.setZoom(this);
            }
        }
    }

    @NotNull
    public ImageView.ScaleType getScaleType() {
        ImageView.ScaleType scaleType = this.touchScaleType;
        if (scaleType == null) {
            Intrinsics.throwNpe();
        }
        return scaleType;
    }

    public final boolean isZoomed() {
        return this.currentZoom != 1.0f;
    }

    @NotNull
    public final RectF getZoomedRect() {
        if (this.touchScaleType == ImageView.ScaleType.FIT_XY) {
            throw (Throwable)new UnsupportedOperationException("getZoomedRect() not supported with FIT_XY");
        }
        PointF topLeft = this.transformCoordTouchToBitmap(0.0f, 0.0f, true);
        PointF bottomRight = this.transformCoordTouchToBitmap(this.viewWidth, this.viewHeight, true);
        float w = this.getDrawableWidth(this.getDrawable());
        float h = this.getDrawableHeight(this.getDrawable());
        return new RectF(topLeft.x / w, topLeft.y / h, bottomRight.x / w, bottomRight.y / h);
    }

    public final void savePreviousImageValues() {
        if (this.touchMatrix != null && this.viewHeight != 0 && this.viewWidth != 0) {
            Matrix matrix = this.touchMatrix;
            if (matrix == null) {
                Intrinsics.throwNpe();
            }
            matrix.getValues(this.floatMatrix);
            Matrix matrix2 = this.prevMatrix;
            if (matrix2 == null) {
                Intrinsics.throwNpe();
            }
            matrix2.setValues(this.floatMatrix);
            this.prevMatchViewHeight = this.matchViewHeight;
            this.prevMatchViewWidth = this.matchViewWidth;
            this.prevViewHeight = this.viewHeight;
            this.prevViewWidth = this.viewWidth;
        }
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt("orientation", this.orientation);
        bundle.putFloat("saveScale", this.currentZoom);
        bundle.putFloat("matchViewHeight", this.matchViewHeight);
        bundle.putFloat("matchViewWidth", this.matchViewWidth);
        bundle.putInt("viewWidth", this.viewWidth);
        bundle.putInt("viewHeight", this.viewHeight);
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.getValues(this.floatMatrix);
        bundle.putFloatArray("matrix", this.floatMatrix);
        bundle.putBoolean("imageRendered", this.imageRenderedAtLeastOnce);
        bundle.putSerializable("viewSizeChangeFixedPixel", (Serializable)((Object)this.viewSizeChangeFixedPixel));
        bundle.putSerializable("orientationChangeFixedPixel", (Serializable)((Object)this.orientationChangeFixedPixel));
        return (Parcelable)bundle;
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state instanceof Bundle) {
            Parcelable bundle = state;
            this.currentZoom = ((Bundle)bundle).getFloat("saveScale");
            this.floatMatrix = ((Bundle)bundle).getFloatArray("matrix");
            Matrix matrix = this.prevMatrix;
            if (matrix == null) {
                Intrinsics.throwNpe();
            }
            matrix.setValues(this.floatMatrix);
            this.prevMatchViewHeight = ((Bundle)bundle).getFloat("matchViewHeight");
            this.prevMatchViewWidth = ((Bundle)bundle).getFloat("matchViewWidth");
            this.prevViewHeight = ((Bundle)bundle).getInt("viewHeight");
            this.prevViewWidth = ((Bundle)bundle).getInt("viewWidth");
            this.imageRenderedAtLeastOnce = ((Bundle)bundle).getBoolean("imageRendered");
            this.viewSizeChangeFixedPixel = (FixedPixel)((Object)((Bundle)bundle).getSerializable("viewSizeChangeFixedPixel"));
            this.orientationChangeFixedPixel = (FixedPixel)((Object)((Bundle)bundle).getSerializable("orientationChangeFixedPixel"));
            int oldOrientation = ((Bundle)bundle).getInt("orientation");
            if (this.orientation != oldOrientation) {
                this.orientationJustChanged = true;
            }
            super.onRestoreInstanceState(((Bundle)bundle).getParcelable("instanceState"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.onDrawReady = true;
        this.imageRenderedAtLeastOnce = true;
        if (this.delayedZoomVariables != null) {
            ZoomVariables zoomVariables = this.delayedZoomVariables;
            if (zoomVariables == null) {
                Intrinsics.throwNpe();
            }
            float f = zoomVariables.getScale();
            ZoomVariables zoomVariables2 = this.delayedZoomVariables;
            if (zoomVariables2 == null) {
                Intrinsics.throwNpe();
            }
            float f2 = zoomVariables2.getFocusX();
            ZoomVariables zoomVariables3 = this.delayedZoomVariables;
            if (zoomVariables3 == null) {
                Intrinsics.throwNpe();
            }
            float f3 = zoomVariables3.getFocusY();
            ZoomVariables zoomVariables4 = this.delayedZoomVariables;
            if (zoomVariables4 == null) {
                Intrinsics.throwNpe();
            }
            this.setZoom(f, f2, f3, zoomVariables4.getScaleType());
            this.delayedZoomVariables = null;
        }
        super.onDraw(canvas);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkParameterIsNotNull((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        int newOrientation = resources.getConfiguration().orientation;
        if (newOrientation != this.orientation) {
            this.orientationJustChanged = true;
            this.orientation = newOrientation;
        }
        this.savePreviousImageValues();
    }

    public final float getMaxZoom() {
        return this.maxScale;
    }

    public final void setMaxZoom(float max) {
        this.maxScale = max;
        this.superMaxScale = 1.25f * this.maxScale;
        this.maxScaleIsSetByMultiplier = false;
    }

    public final void setMaxZoomRatio(float max) {
        this.maxScaleMultiplier = max;
        this.maxScale = this.minScale * this.maxScaleMultiplier;
        this.superMaxScale = 1.25f * this.maxScale;
        this.maxScaleIsSetByMultiplier = true;
    }

    public final float getMinZoom() {
        return this.minScale;
    }

    public final void setMinZoom(float min) {
        this.userSpecifiedMinScale = min;
        if (min == -1.0f) {
            if (this.touchScaleType == ImageView.ScaleType.CENTER || this.touchScaleType == ImageView.ScaleType.CENTER_CROP) {
                Drawable drawable = this.getDrawable();
                int drawableWidth = this.getDrawableWidth(drawable);
                int drawableHeight = this.getDrawableHeight(drawable);
                if (drawable != null && drawableWidth > 0 && drawableHeight > 0) {
                    float widthRatio = (float)this.viewWidth / (float)drawableWidth;
                    float heightRatio = (float)this.viewHeight / (float)drawableHeight;
                    this.minScale = this.touchScaleType == ImageView.ScaleType.CENTER ? Math.min(widthRatio, heightRatio) : Math.min(widthRatio, heightRatio) / Math.max(widthRatio, heightRatio);
                }
            } else {
                this.minScale = 1.0f;
            }
        } else {
            this.minScale = this.userSpecifiedMinScale;
        }
        if (this.maxScaleIsSetByMultiplier) {
            this.setMaxZoomRatio(this.maxScaleMultiplier);
        }
        this.superMinScale = 0.75f * this.minScale;
    }

    public final void resetZoom() {
        this.currentZoom = 1.0f;
        this.fitImageToView();
    }

    public final void resetZoomAnimated() {
        this.setZoomAnimated(1.0f, 0.5f, 0.5f);
    }

    public final void setZoom(float scale) {
        this.setZoom(scale, 0.5f, 0.5f);
    }

    public final void setZoom(float scale, float focusX, float focusY) {
        this.setZoom(scale, focusX, focusY, this.touchScaleType);
    }

    public final void setZoom(float scale, float focusX, float focusY, @Nullable ImageView.ScaleType scaleType) {
        if (!this.onDrawReady) {
            this.delayedZoomVariables = new ZoomVariables(scale, focusX, focusY, scaleType);
            return;
        }
        if (this.userSpecifiedMinScale == -1.0f) {
            this.setMinZoom(-1.0f);
            if (this.currentZoom < this.minScale) {
                this.currentZoom = this.minScale;
            }
        }
        if (scaleType != this.touchScaleType) {
            ImageView.ScaleType scaleType2 = scaleType;
            if (scaleType2 == null) {
                Intrinsics.throwNpe();
            }
            this.setScaleType(scaleType2);
        }
        this.resetZoom();
        this.scaleImage(scale, (float)this.viewWidth / (float)2, (float)this.viewHeight / (float)2, true);
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.getValues(this.floatMatrix);
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        this.floatMatrix[2] = -(focusX * this.getImageWidth() - (float)this.viewWidth * 0.5f);
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        this.floatMatrix[5] = -(focusY * this.getImageHeight() - (float)this.viewHeight * 0.5f);
        Matrix matrix2 = this.touchMatrix;
        if (matrix2 == null) {
            Intrinsics.throwNpe();
        }
        matrix2.setValues(this.floatMatrix);
        this.fixTrans();
        this.savePreviousImageValues();
        this.setImageMatrix(this.touchMatrix);
    }

    public final void setZoom(@NotNull TouchImageView img) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)img), (String)"img");
        PointF center = img.getScrollPosition();
        this.setZoom(img.currentZoom, center.x, center.y, img.getScaleType());
    }

    @NotNull
    public final PointF getScrollPosition() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return new PointF(0.5f, 0.5f);
        }
        Drawable drawable2 = drawable;
        int drawableWidth = this.getDrawableWidth(drawable2);
        int drawableHeight = this.getDrawableHeight(drawable2);
        PointF point = this.transformCoordTouchToBitmap((float)this.viewWidth / (float)2, (float)this.viewHeight / (float)2, true);
        point.x /= (float)drawableWidth;
        point.y /= (float)drawableHeight;
        return point;
    }

    private final boolean orientationMismatch(Drawable drawable) {
        boolean bl = this.viewWidth > this.viewHeight;
        Drawable drawable2 = drawable;
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        return bl != drawable2.getIntrinsicWidth() > drawable.getIntrinsicHeight();
    }

    private final int getDrawableWidth(Drawable drawable) {
        int n;
        if (this.orientationMismatch(drawable) && this.isRotateImageToFitScreen) {
            Drawable drawable2 = drawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            n = drawable2.getIntrinsicHeight();
        } else {
            Drawable drawable3 = drawable;
            if (drawable3 == null) {
                Intrinsics.throwNpe();
            }
            n = drawable3.getIntrinsicWidth();
        }
        return n;
    }

    private final int getDrawableHeight(Drawable drawable) {
        int n;
        if (this.orientationMismatch(drawable) && this.isRotateImageToFitScreen) {
            Drawable drawable2 = drawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            n = drawable2.getIntrinsicWidth();
        } else {
            Drawable drawable3 = drawable;
            if (drawable3 == null) {
                Intrinsics.throwNpe();
            }
            n = drawable3.getIntrinsicHeight();
        }
        return n;
    }

    public final void setScrollPosition(float focusX, float focusY) {
        this.setZoom(this.currentZoom, focusX, focusY);
    }

    private final void fixTrans() {
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.getValues(this.floatMatrix);
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        float transX = this.floatMatrix[2];
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        float transY = this.floatMatrix[5];
        float offset = 0.0f;
        if (this.isRotateImageToFitScreen && this.orientationMismatch(this.getDrawable())) {
            offset = this.getImageWidth();
        }
        float fixTransX = this.getFixTrans(transX, this.viewWidth, this.getImageWidth(), offset);
        float fixTransY = this.getFixTrans(transY, this.viewHeight, this.getImageHeight(), 0.0f);
        Matrix matrix2 = this.touchMatrix;
        if (matrix2 == null) {
            Intrinsics.throwNpe();
        }
        matrix2.postTranslate(fixTransX, fixTransY);
    }

    private final void fixScaleTrans() {
        this.fixTrans();
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.getValues(this.floatMatrix);
        if (this.getImageWidth() < (float)this.viewWidth) {
            float xOffset = ((float)this.viewWidth - this.getImageWidth()) / (float)2;
            if (this.isRotateImageToFitScreen && this.orientationMismatch(this.getDrawable())) {
                xOffset += this.getImageWidth();
            }
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            this.floatMatrix[2] = xOffset;
        }
        if (this.getImageHeight() < (float)this.viewHeight) {
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            this.floatMatrix[5] = ((float)this.viewHeight - this.getImageHeight()) / (float)2;
        }
        Matrix matrix2 = this.touchMatrix;
        if (matrix2 == null) {
            Intrinsics.throwNpe();
        }
        matrix2.setValues(this.floatMatrix);
    }

    private final float getFixTrans(float trans, float viewSize, float contentSize, float offset) {
        float minTrans = 0.0f;
        float maxTrans = 0.0f;
        if (contentSize <= viewSize) {
            minTrans = offset;
            maxTrans = offset + viewSize - contentSize;
        } else {
            minTrans = offset + viewSize - contentSize;
            maxTrans = offset;
        }
        if (trans < minTrans) {
            return -trans + minTrans;
        }
        return trans > maxTrans ? -trans + maxTrans : 0.0f;
    }

    private final float getFixDragTrans(float delta, float viewSize, float contentSize) {
        return contentSize <= viewSize ? 0.0f : delta;
    }

    private final float getImageWidth() {
        return this.matchViewWidth * this.currentZoom;
    }

    private final float getImageHeight() {
        return this.matchViewHeight * this.currentZoom;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable = this.getDrawable();
        if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        int drawableWidth = this.getDrawableWidth(drawable);
        int drawableHeight = this.getDrawableHeight(drawable);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int totalViewWidth = this.setViewSize(widthMode, widthSize, drawableWidth);
        int totalViewHeight = this.setViewSize(heightMode, heightSize, drawableHeight);
        if (!this.orientationJustChanged) {
            this.savePreviousImageValues();
        }
        int width = totalViewWidth - this.getPaddingLeft() - this.getPaddingRight();
        int height = totalViewHeight - this.getPaddingTop() - this.getPaddingBottom();
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.viewWidth = w;
        this.viewHeight = h;
        this.fitImageToView();
    }

    /*
     * Unable to fully structure code
     */
    private final void fitImageToView() {
        block35: {
            block34: {
                fixedPixel = this.orientationJustChanged != false ? this.orientationChangeFixedPixel : this.viewSizeChangeFixedPixel;
                this.orientationJustChanged = false;
                drawable = this.getDrawable();
                if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
                    return;
                }
                if (this.touchMatrix == null || this.prevMatrix == null) {
                    return;
                }
                if (this.userSpecifiedMinScale == -1.0f) {
                    this.setMinZoom(-1.0f);
                    if (this.currentZoom < this.minScale) {
                        this.currentZoom = this.minScale;
                    }
                }
                drawableWidth = this.getDrawableWidth(drawable);
                drawableHeight = this.getDrawableHeight(drawable);
                scaleX = (float)this.viewWidth / (float)drawableWidth;
                scaleY = (float)this.viewHeight / (float)drawableHeight;
                v0 = this.touchScaleType;
                if (v0 != null) {
                    switch (TouchImageView$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                        case 1: {
                            scaleX = scaleY = 1.0f;
                            break;
                        }
                        case 2: {
                            scaleX = scaleY = Math.max(scaleX, scaleY);
                            break;
                        }
                        case 3: {
                            var7_7 = this;
                            var8_9 = false;
                            var9_11 = false;
                            $this$run = var7_7;
                            $i$a$-run-TouchImageView$fitImageToView$1 = false;
                            scaleX = scaleY = Math.min(1.0f, Math.min(scaleX, scaleY));
                            var7_7 = this;
                            var8_9 = false;
                            var9_11 = false;
                            $this$run = var7_7;
                            $i$a$-run-TouchImageView$fitImageToView$2 = false;
                            scaleX = scaleY = Math.min(scaleX, scaleY);
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            scaleX = scaleY = Math.min(scaleX, scaleY);
                            break;
                        }
                        case 7: {
                            break;
                        }
                    }
                }
                redundantXSpace = (float)this.viewWidth - scaleX * (float)drawableWidth;
                redundantYSpace = (float)this.viewHeight - scaleY * (float)drawableHeight;
                this.matchViewWidth = (float)this.viewWidth - redundantXSpace;
                this.matchViewHeight = (float)this.viewHeight - redundantYSpace;
                if (this.isZoomed() || this.imageRenderedAtLeastOnce) break block34;
                if (this.isRotateImageToFitScreen && this.orientationMismatch(drawable)) {
                    v1 = this.touchMatrix;
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    v1.setRotate(90.0f);
                    v2 = this.touchMatrix;
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    v2.postTranslate((float)drawableWidth, 0.0f);
                    v3 = this.touchMatrix;
                    if (v3 == null) {
                        Intrinsics.throwNpe();
                    }
                    v3.postScale(scaleX, scaleY);
                } else {
                    v4 = this.touchMatrix;
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    v4.setScale(scaleX, scaleY);
                }
                v5 = this.touchScaleType;
                if (v5 == null) ** GOTO lbl-1000
                switch (TouchImageView$WhenMappings.$EnumSwitchMapping$1[v5.ordinal()]) {
                    case 1: {
                        v6 = this.touchMatrix;
                        if (v6 == null) {
                            Intrinsics.throwNpe();
                        }
                        v6.postTranslate(0.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        v7 = this.touchMatrix;
                        if (v7 == null) {
                            Intrinsics.throwNpe();
                        }
                        v7.postTranslate(redundantXSpace, redundantYSpace);
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v8 = this.touchMatrix;
                        if (v8 == null) {
                            Intrinsics.throwNpe();
                        }
                        v8.postTranslate(redundantXSpace / (float)2, redundantYSpace / (float)2);
                    }
                }
                this.currentZoom = 1.0f;
                break block35;
            }
            if (this.prevMatchViewWidth == 0.0f || this.prevMatchViewHeight == 0.0f) {
                this.savePreviousImageValues();
            }
            v9 = this.prevMatrix;
            if (v9 == null) {
                Intrinsics.throwNpe();
            }
            v9.getValues(this.floatMatrix);
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            this.floatMatrix[0] = this.matchViewWidth / (float)drawableWidth * this.currentZoom;
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            this.floatMatrix[4] = this.matchViewHeight / (float)drawableHeight * this.currentZoom;
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            transX = this.floatMatrix[2];
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            transY = this.floatMatrix[5];
            prevActualWidth = this.prevMatchViewWidth * this.currentZoom;
            actualWidth = this.getImageWidth();
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            this.floatMatrix[2] = this.newTranslationAfterChange(transX, prevActualWidth, actualWidth, this.prevViewWidth, this.viewWidth, drawableWidth, fixedPixel);
            prevActualHeight = this.prevMatchViewHeight * this.currentZoom;
            actualHeight = this.getImageHeight();
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            this.floatMatrix[5] = this.newTranslationAfterChange(transY, prevActualHeight, actualHeight, this.prevViewHeight, this.viewHeight, drawableHeight, fixedPixel);
            v10 = this.touchMatrix;
            if (v10 == null) {
                Intrinsics.throwNpe();
            }
            v10.setValues(this.floatMatrix);
        }
        this.fixTrans();
        this.setImageMatrix(this.touchMatrix);
    }

    private final int setViewSize(int mode, int size, int drawableWidth) {
        int n;
        int viewSize = 0;
        switch (mode) {
            case 0x40000000: {
                n = size;
                break;
            }
            case -2147483648: {
                n = Math.min(drawableWidth, size);
                break;
            }
            case 0: {
                n = drawableWidth;
                break;
            }
            default: {
                n = size;
            }
        }
        viewSize = n;
        return viewSize;
    }

    private final float newTranslationAfterChange(float trans, float prevImageSize, float imageSize, int prevViewSize, int viewSize, int drawableSize, FixedPixel sizeChangeFixedPixel) {
        float f;
        if (imageSize < (float)viewSize) {
            float f2 = viewSize;
            float f3 = drawableSize;
            if (this.floatMatrix == null) {
                Intrinsics.throwNpe();
            }
            f = (f2 - f3 * this.floatMatrix[0]) * 0.5f;
        } else if (trans > 0.0f) {
            f = -((imageSize - (float)viewSize) * 0.5f);
        } else {
            float fixedPixelPositionInView = 0.5f;
            if (sizeChangeFixedPixel == FixedPixel.BOTTOM_RIGHT) {
                fixedPixelPositionInView = 1.0f;
            } else if (sizeChangeFixedPixel == FixedPixel.TOP_LEFT) {
                fixedPixelPositionInView = 0.0f;
            }
            float fixedPixelPositionInImage = (-trans + fixedPixelPositionInView * (float)prevViewSize) / prevImageSize;
            f = -(fixedPixelPositionInImage * imageSize - (float)viewSize * fixedPixelPositionInView);
        }
        return f;
    }

    private final void setState(State state) {
        this.state = state;
    }

    @Deprecated(message="")
    public final boolean canScrollHorizontallyFroyo(int direction) {
        return this.canScrollHorizontally(direction);
    }

    public boolean canScrollHorizontally(int direction) {
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.getValues(this.floatMatrix);
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        float x = this.floatMatrix[2];
        return this.getImageWidth() < (float)this.viewWidth ? false : (x >= (float)-1 && direction < 0 ? false : Math.abs(x) + (float)this.viewWidth + 1.0f < this.getImageWidth() || direction <= 0);
    }

    public boolean canScrollVertically(int direction) {
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.getValues(this.floatMatrix);
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        float y = this.floatMatrix[5];
        return this.getImageHeight() < (float)this.viewHeight ? false : (y >= (float)-1 && direction < 0 ? false : Math.abs(y) + (float)this.viewHeight + 1.0f < this.getImageHeight() || direction <= 0);
    }

    private final void scaleImage(double deltaScale, float focusX, float focusY, boolean stretchImageToSuper) {
        double deltaScaleLocal = deltaScale;
        float lowerScale = 0.0f;
        float upperScale = 0.0f;
        if (stretchImageToSuper) {
            lowerScale = this.superMinScale;
            upperScale = this.superMaxScale;
        } else {
            lowerScale = this.minScale;
            upperScale = this.maxScale;
        }
        float origScale = this.currentZoom;
        this.currentZoom *= (float)deltaScaleLocal;
        if (this.currentZoom > upperScale) {
            this.currentZoom = upperScale;
            deltaScaleLocal = (double)upperScale / (double)origScale;
        } else if (this.currentZoom < lowerScale) {
            this.currentZoom = lowerScale;
            deltaScaleLocal = (double)lowerScale / (double)origScale;
        }
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.postScale((float)deltaScaleLocal, (float)deltaScaleLocal, focusX, focusY);
        this.fixScaleTrans();
    }

    @NotNull
    protected final PointF transformCoordTouchToBitmap(float x, float y, boolean clipToBitmap) {
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.getValues(this.floatMatrix);
        Drawable drawable = this.getDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"drawable");
        float origW = drawable.getIntrinsicWidth();
        Drawable drawable2 = this.getDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"drawable");
        float origH = drawable2.getIntrinsicHeight();
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        float transX = this.floatMatrix[2];
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        float transY = this.floatMatrix[5];
        float finalX = (x - transX) * origW / this.getImageWidth();
        float finalY = (y - transY) * origH / this.getImageHeight();
        if (clipToBitmap) {
            finalX = Math.min(Math.max(finalX, 0.0f), origW);
            finalY = Math.min(Math.max(finalY, 0.0f), origH);
        }
        return new PointF(finalX, finalY);
    }

    @NotNull
    protected final PointF transformCoordBitmapToTouch(float bx, float by) {
        Matrix matrix = this.touchMatrix;
        if (matrix == null) {
            Intrinsics.throwNpe();
        }
        matrix.getValues(this.floatMatrix);
        Drawable drawable = this.getDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"drawable");
        float origW = drawable.getIntrinsicWidth();
        Drawable drawable2 = this.getDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"drawable");
        float origH = drawable2.getIntrinsicHeight();
        float px = bx / origW;
        float py = by / origH;
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        float finalX = this.floatMatrix[2] + this.getImageWidth() * px;
        if (this.floatMatrix == null) {
            Intrinsics.throwNpe();
        }
        float finalY = this.floatMatrix[5] + this.getImageHeight() * py;
        return new PointF(finalX, finalY);
    }

    @TargetApi(value=16)
    private final void compatPostOnAnimation(Runnable runnable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.postOnAnimation(runnable);
        } else {
            this.postDelayed(runnable, 16L);
        }
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY) {
        this.setZoomAnimated(scale, focusX, focusY, 500);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, int zoomTimeMs) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), zoomTimeMs);
        this.compatPostOnAnimation(animation);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, int zoomTimeMs, @Nullable OnZoomFinishedListener listener) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), zoomTimeMs);
        animation.setListener(listener);
        this.compatPostOnAnimation(animation);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, @Nullable OnZoomFinishedListener listener) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), 500);
        animation.setListener(listener);
        this.compatPostOnAnimation(animation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public TouchImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.orientationChangeFixedPixel = FixedPixel.CENTER;
        this.viewSizeChangeFixedPixel = FixedPixel.CENTER;
        super.setClickable(true);
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        this.orientation = resources.getConfiguration().orientation;
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.touchMatrix = new Matrix();
        this.prevMatrix = new Matrix();
        this.floatMatrix = new float[9];
        this.currentZoom = 1.0f;
        if (this.touchScaleType == null) {
            this.touchScaleType = ImageView.ScaleType.FIT_CENTER;
        }
        this.minScale = 1.0f;
        this.maxScale = 3.0f;
        this.superMinScale = 0.75f * this.minScale;
        this.superMaxScale = 1.25f * this.maxScale;
        this.setImageMatrix(this.touchMatrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setState(State.NONE);
        this.onDrawReady = false;
        super.setOnTouchListener((View.OnTouchListener)new PrivateOnTouchListener());
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TouchImageView, defStyle, 0);
        try {
            if (!this.isInEditMode()) {
                this.isZoomEnabled = attributes.getBoolean(R.styleable.TouchImageView_zoom_enabled, true);
            }
        }
        finally {
            attributes.recycle();
        }
    }

    public /* synthetic */ TouchImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public TouchImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TouchImageView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$setDoubleTapListener$p(TouchImageView $this, GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        $this.doubleTapListener = onDoubleTapListener;
    }

    public static final /* synthetic */ void access$setState$p(TouchImageView $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ void access$setMaxScale$p(TouchImageView $this, float f) {
        $this.maxScale = f;
    }

    public static final /* synthetic */ float access$getCurrentZoom$p(TouchImageView $this) {
        return $this.currentZoom;
    }

    public static final /* synthetic */ void access$setCurrentZoom$p(TouchImageView $this, float f) {
        $this.currentZoom = f;
    }

    public static final /* synthetic */ void access$setMinScale$p(TouchImageView $this, float f) {
        $this.minScale = f;
    }

    public static final /* synthetic */ void access$setMScaleDetector$p(TouchImageView $this, ScaleGestureDetector scaleGestureDetector) {
        $this.mScaleDetector = scaleGestureDetector;
    }

    public static final /* synthetic */ void access$setMGestureDetector$p(TouchImageView $this, GestureDetector gestureDetector) {
        $this.mGestureDetector = gestureDetector;
    }

    public static final /* synthetic */ void access$setViewWidth$p(TouchImageView $this, int n) {
        $this.viewWidth = n;
    }

    public static final /* synthetic */ void access$setViewHeight$p(TouchImageView $this, int n) {
        $this.viewHeight = n;
    }

    public static final /* synthetic */ void access$setTouchMatrix$p(TouchImageView $this, Matrix matrix) {
        $this.touchMatrix = matrix;
    }

    public static final /* synthetic */ void access$setUserTouchListener$p(TouchImageView $this, View.OnTouchListener onTouchListener) {
        $this.userTouchListener = onTouchListener;
    }

    public static final /* synthetic */ void access$setTouchImageViewListener$p(TouchImageView $this, OnTouchImageViewListener onTouchImageViewListener) {
        $this.touchImageViewListener = onTouchImageViewListener;
    }

    public static final /* synthetic */ void access$setFloatMatrix$p(TouchImageView $this, float[] fArray) {
        $this.floatMatrix = fArray;
    }

    public static final /* synthetic */ void access$setRotateImageToFitScreen$p(TouchImageView $this, boolean bl) {
        $this.isRotateImageToFitScreen = bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/ortiz/touchview/TouchImageView$FixedPixel;", "", "(Ljava/lang/String;I)V", "CENTER", "TOP_LEFT", "BOTTOM_RIGHT", "touchview_release"})
    public static final class FixedPixel
    extends Enum<FixedPixel> {
        public static final /* enum */ FixedPixel CENTER;
        public static final /* enum */ FixedPixel TOP_LEFT;
        public static final /* enum */ FixedPixel BOTTOM_RIGHT;
        private static final /* synthetic */ FixedPixel[] $VALUES;

        static {
            FixedPixel[] fixedPixelArray = new FixedPixel[3];
            FixedPixel[] fixedPixelArray2 = fixedPixelArray;
            fixedPixelArray[0] = CENTER = new FixedPixel();
            fixedPixelArray[1] = TOP_LEFT = new FixedPixel();
            fixedPixelArray[2] = BOTTOM_RIGHT = new FixedPixel();
            $VALUES = fixedPixelArray;
        }

        public static FixedPixel[] values() {
            return (FixedPixel[])$VALUES.clone();
        }

        public static FixedPixel valueOf(String string) {
            return Enum.valueOf(FixedPixel.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/ortiz/touchview/TouchImageView$State;", "", "(Ljava/lang/String;I)V", "NONE", "DRAG", "ZOOM", "FLING", "ANIMATE_ZOOM", "touchview_release"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State NONE;
        public static final /* enum */ State DRAG;
        public static final /* enum */ State ZOOM;
        public static final /* enum */ State FLING;
        public static final /* enum */ State ANIMATE_ZOOM;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[5];
            State[] stateArray2 = stateArray;
            stateArray[0] = NONE = new State();
            stateArray[1] = DRAG = new State();
            stateArray[2] = ZOOM = new State();
            stateArray[3] = FLING = new State();
            stateArray[4] = ANIMATE_ZOOM = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/ortiz/touchview/TouchImageView$GestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "(Lcom/ortiz/touchview/TouchImageView;)V", "onDoubleTap", "", "e", "Landroid/view/MotionEvent;", "onDoubleTapEvent", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onLongPress", "", "onSingleTapConfirmed", "touchview_release"})
    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (TouchImageView.this.doubleTapListener != null) {
                GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
                if (onDoubleTapListener == null) {
                    Intrinsics.throwNpe();
                }
                bl = onDoubleTapListener.onSingleTapConfirmed(e);
            } else {
                bl = TouchImageView.this.performClick();
            }
            return bl;
        }

        public void onLongPress(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            TouchImageView.this.performLongClick();
        }

        public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            if (TouchImageView.this.fling != null) {
                Fling fling = TouchImageView.this.fling;
                if (fling == null) {
                    Intrinsics.throwNpe();
                }
                fling.cancelFling();
            }
            TouchImageView.this.fling = new Fling((int)velocityX, (int)velocityY);
            Fling fling = TouchImageView.this.fling;
            if (fling == null) {
                Intrinsics.throwNpe();
            }
            TouchImageView.this.compatPostOnAnimation(fling);
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onDoubleTap(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            boolean consumed = false;
            if (TouchImageView.this.isZoomEnabled()) {
                if (TouchImageView.this.doubleTapListener != null) {
                    GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
                    if (onDoubleTapListener == null) {
                        Intrinsics.throwNpe();
                    }
                    consumed = onDoubleTapListener.onDoubleTap(e);
                }
                if (TouchImageView.this.state == State.NONE) {
                    float maxZoomScale = TouchImageView.this.getDoubleTapScale() == 0.0f ? TouchImageView.this.maxScale : TouchImageView.this.getDoubleTapScale();
                    float targetZoom = TouchImageView.this.getCurrentZoom() == TouchImageView.this.minScale ? maxZoomScale : TouchImageView.this.minScale;
                    DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, e.getX(), e.getY(), false);
                    TouchImageView.this.compatPostOnAnimation(doubleTap);
                    consumed = true;
                }
            }
            return consumed;
        }

        public boolean onDoubleTapEvent(@NotNull MotionEvent e) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (TouchImageView.this.doubleTapListener != null) {
                GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
                if (onDoubleTapListener == null) {
                    Intrinsics.throwNpe();
                }
                bl = onDoubleTapListener.onDoubleTapEvent(e);
            } else {
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/ortiz/touchview/TouchImageView$OnTouchImageViewListener;", "", "onMove", "", "touchview_release"})
    public static interface OnTouchImageViewListener {
        public void onMove();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ortiz/touchview/TouchImageView$PrivateOnTouchListener;", "Landroid/view/View$OnTouchListener;", "(Lcom/ortiz/touchview/TouchImageView;)V", "last", "Landroid/graphics/PointF;", "onTouch", "", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "touchview_release"})
    private final class PrivateOnTouchListener
    implements View.OnTouchListener {
        private final PointF last = new PointF();

        public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (TouchImageView.this.getDrawable() == null) {
                TouchImageView.this.setState(State.NONE);
                return false;
            }
            if (TouchImageView.this.isZoomEnabled()) {
                ScaleGestureDetector scaleGestureDetector = TouchImageView.this.mScaleDetector;
                if (scaleGestureDetector == null) {
                    Intrinsics.throwNpe();
                }
                scaleGestureDetector.onTouchEvent(event);
            }
            GestureDetector gestureDetector = TouchImageView.this.mGestureDetector;
            if (gestureDetector == null) {
                Intrinsics.throwNpe();
            }
            gestureDetector.onTouchEvent(event);
            PointF curr = new PointF(event.getX(), event.getY());
            if (TouchImageView.this.state == State.NONE || TouchImageView.this.state == State.DRAG || TouchImageView.this.state == State.FLING) {
                switch (event.getAction()) {
                    case 0: {
                        this.last.set(curr);
                        if (TouchImageView.this.fling != null) {
                            Fling fling = TouchImageView.this.fling;
                            if (fling == null) {
                                Intrinsics.throwNpe();
                            }
                            fling.cancelFling();
                        }
                        TouchImageView.this.setState(State.DRAG);
                        break;
                    }
                    case 2: {
                        if (TouchImageView.this.state != State.DRAG) break;
                        float deltaX = curr.x - this.last.x;
                        float deltaY = curr.y - this.last.y;
                        float fixTransX = TouchImageView.this.getFixDragTrans(deltaX, TouchImageView.this.viewWidth, TouchImageView.this.getImageWidth());
                        float fixTransY = TouchImageView.this.getFixDragTrans(deltaY, TouchImageView.this.viewHeight, TouchImageView.this.getImageHeight());
                        Matrix matrix = TouchImageView.this.touchMatrix;
                        if (matrix == null) {
                            Intrinsics.throwNpe();
                        }
                        matrix.postTranslate(fixTransX, fixTransY);
                        TouchImageView.this.fixTrans();
                        this.last.set(curr.x, curr.y);
                        break;
                    }
                    case 1: 
                    case 6: {
                        TouchImageView.this.setState(State.NONE);
                        break;
                    }
                }
            }
            TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
            if (TouchImageView.this.userTouchListener != null) {
                View.OnTouchListener onTouchListener = TouchImageView.this.userTouchListener;
                if (onTouchListener == null) {
                    Intrinsics.throwNpe();
                }
                onTouchListener.onTouch(v, event);
            }
            if (TouchImageView.this.touchImageViewListener != null) {
                OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
                if (onTouchImageViewListener == null) {
                    Intrinsics.throwNpe();
                }
                onTouchImageViewListener.onMove();
            }
            return true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/ortiz/touchview/TouchImageView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lcom/ortiz/touchview/TouchImageView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "onScaleBegin", "onScaleEnd", "", "touchview_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            TouchImageView.this.setState(State.ZOOM);
            return true;
        }

        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            TouchImageView.this.scaleImage(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY(), true);
            if (TouchImageView.this.touchImageViewListener != null) {
                OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
                if (onTouchImageViewListener == null) {
                    Intrinsics.throwNpe();
                }
                onTouchImageViewListener.onMove();
            }
            return true;
        }

        public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            super.onScaleEnd(detector);
            TouchImageView.this.setState(State.NONE);
            boolean animateToZoomBoundary = false;
            float targetZoom = TouchImageView.this.getCurrentZoom();
            if (TouchImageView.this.getCurrentZoom() > TouchImageView.this.maxScale) {
                targetZoom = TouchImageView.this.maxScale;
                animateToZoomBoundary = true;
            } else if (TouchImageView.this.getCurrentZoom() < TouchImageView.this.minScale) {
                targetZoom = TouchImageView.this.minScale;
                animateToZoomBoundary = true;
            }
            if (animateToZoomBoundary) {
                DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, TouchImageView.this.viewWidth / 2, TouchImageView.this.viewHeight / 2, true);
                TouchImageView.this.compatPostOnAnimation(doubleTap);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/ortiz/touchview/TouchImageView$DoubleTapZoom;", "Ljava/lang/Runnable;", "targetZoom", "", "focusX", "focusY", "stretchImageToSuper", "", "(Lcom/ortiz/touchview/TouchImageView;FFFZ)V", "bitmapX", "bitmapY", "endTouch", "Landroid/graphics/PointF;", "interpolator", "Landroid/view/animation/AccelerateDecelerateInterpolator;", "startTime", "", "startTouch", "startZoom", "calculateDeltaScale", "", "t", "interpolate", "run", "", "translateImageToCenterTouchPosition", "touchview_release"})
    private final class DoubleTapZoom
    implements Runnable {
        private final long startTime;
        private final float startZoom;
        private final float targetZoom;
        private final float bitmapX;
        private final float bitmapY;
        private final boolean stretchImageToSuper;
        private final AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        private final PointF startTouch;
        private final PointF endTouch;

        @Override
        public void run() {
            if (TouchImageView.this.getDrawable() == null) {
                TouchImageView.this.setState(State.NONE);
                return;
            }
            float t = this.interpolate();
            double deltaScale = this.calculateDeltaScale(t);
            TouchImageView.this.scaleImage(deltaScale, this.bitmapX, this.bitmapY, this.stretchImageToSuper);
            this.translateImageToCenterTouchPosition(t);
            TouchImageView.this.fixScaleTrans();
            TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
            if (TouchImageView.this.touchImageViewListener != null) {
                OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
                if (onTouchImageViewListener == null) {
                    Intrinsics.throwNpe();
                }
                onTouchImageViewListener.onMove();
            }
            if (t < 1.0f) {
                TouchImageView.this.compatPostOnAnimation(this);
            } else {
                TouchImageView.this.setState(State.NONE);
            }
        }

        private final void translateImageToCenterTouchPosition(float t) {
            float targetX = this.startTouch.x + t * (this.endTouch.x - this.startTouch.x);
            float targetY = this.startTouch.y + t * (this.endTouch.y - this.startTouch.y);
            PointF curr = TouchImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            Matrix matrix = TouchImageView.this.touchMatrix;
            if (matrix == null) {
                Intrinsics.throwNpe();
            }
            matrix.postTranslate(targetX - curr.x, targetY - curr.y);
        }

        private final float interpolate() {
            long currTime = System.currentTimeMillis();
            float elapsed = (float)(currTime - this.startTime) / (float)500;
            elapsed = Math.min(1.0f, elapsed);
            return this.interpolator.getInterpolation(elapsed);
        }

        private final double calculateDeltaScale(float t) {
            double zoom = (double)this.startZoom + (double)t * (double)(this.targetZoom - this.startZoom);
            return zoom / (double)TouchImageView.this.getCurrentZoom();
        }

        public DoubleTapZoom(float targetZoom, float focusX, float focusY, boolean stretchImageToSuper) {
            TouchImageView.this.setState(State.ANIMATE_ZOOM);
            this.startTime = System.currentTimeMillis();
            this.startZoom = TouchImageView.this.getCurrentZoom();
            this.targetZoom = targetZoom;
            this.stretchImageToSuper = stretchImageToSuper;
            PointF bitmapPoint = TouchImageView.this.transformCoordTouchToBitmap(focusX, focusY, false);
            this.bitmapX = bitmapPoint.x;
            this.bitmapY = bitmapPoint.y;
            this.startTouch = TouchImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            this.endTouch = new PointF((float)(TouchImageView.this.viewWidth / 2), (float)(TouchImageView.this.viewHeight / 2));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR \u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/ortiz/touchview/TouchImageView$Fling;", "Ljava/lang/Runnable;", "velocityX", "", "velocityY", "(Lcom/ortiz/touchview/TouchImageView;II)V", "currX", "getCurrX", "()I", "setCurrX", "(I)V", "currY", "getCurrY", "setCurrY", "scroller", "Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "Lcom/ortiz/touchview/TouchImageView;", "getScroller", "()Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "setScroller", "(Lcom/ortiz/touchview/TouchImageView$CompatScroller;)V", "cancelFling", "", "run", "touchview_release"})
    private final class Fling
    implements Runnable {
        @Nullable
        private CompatScroller scroller;
        private int currX;
        private int currY;

        @Nullable
        public final CompatScroller getScroller() {
            return this.scroller;
        }

        public final void setScroller(@Nullable CompatScroller compatScroller) {
            this.scroller = compatScroller;
        }

        public final int getCurrX() {
            return this.currX;
        }

        public final void setCurrX(int n) {
            this.currX = n;
        }

        public final int getCurrY() {
            return this.currY;
        }

        public final void setCurrY(int n) {
            this.currY = n;
        }

        public final void cancelFling() {
            if (this.scroller != null) {
                TouchImageView.this.setState(State.NONE);
                CompatScroller compatScroller = this.scroller;
                if (compatScroller == null) {
                    Intrinsics.throwNpe();
                }
                compatScroller.forceFinished(true);
            }
        }

        @Override
        public void run() {
            if (TouchImageView.this.touchImageViewListener != null) {
                OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
                if (onTouchImageViewListener == null) {
                    Intrinsics.throwNpe();
                }
                onTouchImageViewListener.onMove();
            }
            CompatScroller compatScroller = this.scroller;
            if (compatScroller == null) {
                Intrinsics.throwNpe();
            }
            if (compatScroller.isFinished()) {
                this.scroller = null;
                return;
            }
            CompatScroller compatScroller2 = this.scroller;
            if (compatScroller2 == null) {
                Intrinsics.throwNpe();
            }
            if (compatScroller2.computeScrollOffset()) {
                CompatScroller compatScroller3 = this.scroller;
                if (compatScroller3 == null) {
                    Intrinsics.throwNpe();
                }
                int newX = compatScroller3.getCurrX();
                CompatScroller compatScroller4 = this.scroller;
                if (compatScroller4 == null) {
                    Intrinsics.throwNpe();
                }
                int newY = compatScroller4.getCurrY();
                int transX = newX - this.currX;
                int transY = newY - this.currY;
                this.currX = newX;
                this.currY = newY;
                Matrix matrix = TouchImageView.this.touchMatrix;
                if (matrix == null) {
                    Intrinsics.throwNpe();
                }
                matrix.postTranslate((float)transX, (float)transY);
                TouchImageView.this.fixTrans();
                TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
                TouchImageView.this.compatPostOnAnimation(this);
            }
        }

        public Fling(int velocityX, int velocityY) {
            TouchImageView.this.setState(State.FLING);
            this.scroller = new CompatScroller(TouchImageView.this.getContext());
            Matrix matrix = TouchImageView.this.touchMatrix;
            if (matrix == null) {
                Intrinsics.throwNpe();
            }
            matrix.getValues(TouchImageView.this.floatMatrix);
            float[] fArray = TouchImageView.this.floatMatrix;
            if (fArray == null) {
                Intrinsics.throwNpe();
            }
            int startX = (int)fArray[2];
            float[] fArray2 = TouchImageView.this.floatMatrix;
            if (fArray2 == null) {
                Intrinsics.throwNpe();
            }
            int startY = (int)fArray2[5];
            int minX = 0;
            int maxX = 0;
            int minY = 0;
            int maxY = 0;
            if (TouchImageView.this.isRotateImageToFitScreen && TouchImageView.this.orientationMismatch(TouchImageView.this.getDrawable())) {
                startX -= (int)TouchImageView.this.getImageWidth();
            }
            if (TouchImageView.this.getImageWidth() > (float)TouchImageView.this.viewWidth) {
                minX = TouchImageView.this.viewWidth - (int)TouchImageView.this.getImageWidth();
                maxX = 0;
            } else {
                minX = maxX = startX;
            }
            if (TouchImageView.this.getImageHeight() > (float)TouchImageView.this.viewHeight) {
                minY = TouchImageView.this.viewHeight - (int)TouchImageView.this.getImageHeight();
                maxY = 0;
            } else {
                minY = maxY = startY;
            }
            CompatScroller compatScroller = this.scroller;
            if (compatScroller == null) {
                Intrinsics.throwNpe();
            }
            compatScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            this.currX = startX;
            this.currY = startY;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0014\u001a\u00020\fJF\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "", "context", "Landroid/content/Context;", "(Lcom/ortiz/touchview/TouchImageView;Landroid/content/Context;)V", "currX", "", "getCurrX", "()I", "currY", "getCurrY", "isFinished", "", "()Z", "overScroller", "Landroid/widget/OverScroller;", "getOverScroller", "()Landroid/widget/OverScroller;", "setOverScroller", "(Landroid/widget/OverScroller;)V", "computeScrollOffset", "fling", "", "startX", "startY", "velocityX", "velocityY", "minX", "maxX", "minY", "maxY", "forceFinished", "finished", "touchview_release"})
    @TargetApi(value=9)
    private final class CompatScroller {
        @NotNull
        private OverScroller overScroller;

        @NotNull
        public final OverScroller getOverScroller() {
            return this.overScroller;
        }

        public final void setOverScroller(@NotNull OverScroller overScroller) {
            Intrinsics.checkParameterIsNotNull((Object)overScroller, (String)"<set-?>");
            this.overScroller = overScroller;
        }

        public final void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
            this.overScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
        }

        public final void forceFinished(boolean finished) {
            this.overScroller.forceFinished(finished);
        }

        public final boolean isFinished() {
            return this.overScroller.isFinished();
        }

        public final boolean computeScrollOffset() {
            this.overScroller.computeScrollOffset();
            return this.overScroller.computeScrollOffset();
        }

        public final int getCurrX() {
            return this.overScroller.getCurrX();
        }

        public final int getCurrY() {
            return this.overScroller.getCurrY();
        }

        public CompatScroller(Context context) {
            this.overScroller = new OverScroller(context);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0082\u0004\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/ortiz/touchview/TouchImageView$ZoomVariables;", "", "scale", "", "focusX", "focusY", "scaleType", "Landroid/widget/ImageView$ScaleType;", "(Lcom/ortiz/touchview/TouchImageView;FFFLandroid/widget/ImageView$ScaleType;)V", "getFocusX", "()F", "setFocusX", "(F)V", "getFocusY", "setFocusY", "getScale", "setScale", "getScaleType", "()Landroid/widget/ImageView$ScaleType;", "setScaleType", "(Landroid/widget/ImageView$ScaleType;)V", "touchview_release"})
    private final class ZoomVariables {
        private float scale;
        private float focusX;
        private float focusY;
        @Nullable
        private ImageView.ScaleType scaleType;

        public final float getScale() {
            return this.scale;
        }

        public final void setScale(float f) {
            this.scale = f;
        }

        public final float getFocusX() {
            return this.focusX;
        }

        public final void setFocusX(float f) {
            this.focusX = f;
        }

        public final float getFocusY() {
            return this.focusY;
        }

        public final void setFocusY(float f) {
            this.focusY = f;
        }

        @Nullable
        public final ImageView.ScaleType getScaleType() {
            return this.scaleType;
        }

        public final void setScaleType(@Nullable ImageView.ScaleType scaleType) {
            this.scaleType = scaleType;
        }

        public ZoomVariables(float scale, float focusX, @Nullable float focusY, ImageView.ScaleType scaleType) {
            this.scale = scale;
            this.focusX = focusX;
            this.focusY = focusY;
            this.scaleType = scaleType;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/ortiz/touchview/TouchImageView$OnZoomFinishedListener;", "", "onZoomFinished", "", "touchview_release"})
    public static interface OnZoomFinishedListener {
        public void onZoomFinished();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/ortiz/touchview/TouchImageView$AnimatedZoom;", "Ljava/lang/Runnable;", "targetZoom", "", "focus", "Landroid/graphics/PointF;", "zoomTimeMillis", "", "(Lcom/ortiz/touchview/TouchImageView;FLandroid/graphics/PointF;I)V", "interpolator", "Landroid/view/animation/LinearInterpolator;", "listener", "Lcom/ortiz/touchview/TouchImageView$OnZoomFinishedListener;", "startFocus", "startTime", "", "startZoom", "targetFocus", "interpolate", "run", "", "setListener", "touchview_release"})
    private final class AnimatedZoom
    implements Runnable {
        private final int zoomTimeMillis;
        private final long startTime;
        private final float startZoom;
        private final float targetZoom;
        private final PointF startFocus;
        private final PointF targetFocus;
        private final LinearInterpolator interpolator;
        private OnZoomFinishedListener listener;

        @Override
        public void run() {
            float t = this.interpolate();
            float nextZoom = this.startZoom + (this.targetZoom - this.startZoom) * t;
            float nextX = this.startFocus.x + (this.targetFocus.x - this.startFocus.x) * t;
            float nextY = this.startFocus.y + (this.targetFocus.y - this.startFocus.y) * t;
            TouchImageView.this.setZoom(nextZoom, nextX, nextY);
            if (t < 1.0f) {
                TouchImageView.this.compatPostOnAnimation(this);
            } else {
                TouchImageView.this.setState(State.NONE);
                if (this.listener != null) {
                    OnZoomFinishedListener onZoomFinishedListener = this.listener;
                    if (onZoomFinishedListener == null) {
                        Intrinsics.throwNpe();
                    }
                    onZoomFinishedListener.onZoomFinished();
                }
            }
        }

        private final float interpolate() {
            float elapsed = (float)(System.currentTimeMillis() - this.startTime) / (float)this.zoomTimeMillis;
            elapsed = Math.min(1.0f, elapsed);
            return this.interpolator.getInterpolation(elapsed);
        }

        public final void setListener(@Nullable OnZoomFinishedListener listener) {
            this.listener = listener;
        }

        public AnimatedZoom(@NotNull float targetZoom, PointF focus, int zoomTimeMillis) {
            Intrinsics.checkParameterIsNotNull((Object)focus, (String)"focus");
            this.interpolator = new LinearInterpolator();
            TouchImageView.this.setState(State.ANIMATE_ZOOM);
            this.startTime = System.currentTimeMillis();
            this.startZoom = TouchImageView.this.getCurrentZoom();
            this.targetZoom = targetZoom;
            this.zoomTimeMillis = zoomTimeMillis;
            this.startFocus = TouchImageView.this.getScrollPosition();
            this.targetFocus = focus;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ortiz/touchview/TouchImageView$Companion;", "", "()V", "AUTOMATIC_MIN_ZOOM", "", "DEBUG", "", "DEFAULT_ZOOM_TIME", "", "SUPER_MAX_MULTIPLIER", "SUPER_MIN_MULTIPLIER", "touchview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

