/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.ext;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a*\u0010\u0007\u001a\u00020\b*\u00020\u00022\b\b\u0001\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0001\u0010\u0010\u001a\u00020\b\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0004\u001a\u0014\u0010\u0014\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0004H\u0007\u001a\n\u0010\u0015\u001a\u00020\b*\u00020\u0002\u001a-\u0010\u0016\u001a\u0004\u0018\u00010\b*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0018\u001a&\u0010\u0019\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u0004*\u00020\u0002\u001a\n\u0010\u001b\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\u001d\u001a\u00020\r*\u00020\u0002\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0004\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0002\u001a$\u0010\"\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020\u0004\u00a8\u0006'"}, d2={"copyToClipboard", "", "Landroid/content/Context;", "text", "", "label", "getApplicationName", "getColorFromAttr", "", "attrColor", "typedValue", "Landroid/util/TypedValue;", "resolveRefs", "", "getDimension", "", "res", "getDrawableByName", "Landroid/graphics/drawable/Drawable;", "name", "getDrawableResourceIdByName", "getNavigationBarHeight", "getResourceFromAttr", "attr", "(Landroid/content/Context;ILandroid/util/TypedValue;Z)Ljava/lang/Integer;", "getStringFromAttr", "getVersion", "getWindowHeight", "getWindowWidth", "isTablet", "openUrl", "url", "startAppDetailsOnGooglePlay", "startAppSettingsIntent", "startMapIntent", "latitude", "", "longitude", "dealershipName", "utils_release"})
public final class ContextExtKt {
    @Nullable
    public static final Integer getResourceFromAttr(@NotNull Context $this$getResourceFromAttr, int attr, @NotNull TypedValue typedValue, boolean resolveRefs) {
        Intrinsics.checkNotNullParameter((Object)$this$getResourceFromAttr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typedValue, (String)"typedValue");
        $this$getResourceFromAttr.getTheme().resolveAttribute(attr, typedValue, resolveRefs);
        int id = typedValue.resourceId;
        return id == 0 ? null : Integer.valueOf(id);
    }

    public static /* synthetic */ Integer getResourceFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtKt.getResourceFromAttr(context, n, typedValue, bl);
    }

    @NotNull
    public static final String getStringFromAttr(@NotNull Context $this$getStringFromAttr, int attr, @NotNull TypedValue typedValue, boolean resolveRefs) {
        Intrinsics.checkNotNullParameter((Object)$this$getStringFromAttr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typedValue, (String)"typedValue");
        $this$getStringFromAttr.getTheme().resolveAttribute(attr, typedValue, resolveRefs);
        return ((Object)typedValue.string).toString();
    }

    public static /* synthetic */ String getStringFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtKt.getStringFromAttr(context, n, typedValue, bl);
    }

    @ColorInt
    public static final int getColorFromAttr(@NotNull Context $this$getColorFromAttr, @AttrRes int attrColor, @NotNull TypedValue typedValue, boolean resolveRefs) {
        Intrinsics.checkNotNullParameter((Object)$this$getColorFromAttr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typedValue, (String)"typedValue");
        $this$getColorFromAttr.getTheme().resolveAttribute(attrColor, typedValue, resolveRefs);
        return typedValue.data;
    }

    public static /* synthetic */ int getColorFromAttr$default(Context context, int n, TypedValue typedValue, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            typedValue = new TypedValue();
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return ContextExtKt.getColorFromAttr(context, n, typedValue, bl);
    }

    public static final void startMapIntent(@NotNull Context $this$startMapIntent, double latitude, double longitude, @NotNull String dealershipName) {
        Intrinsics.checkNotNullParameter((Object)$this$startMapIntent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dealershipName, (String)"dealershipName");
        Uri gmmIntentUri = Uri.parse((String)("geo:0,0?q=" + latitude + ',' + longitude + '(' + dealershipName + ')'));
        Intent mapIntent = new Intent("android.intent.action.VIEW", gmmIntentUri);
        mapIntent.setPackage("com.google.android.apps.maps");
        PackageManager packageManager = $this$startMapIntent.getPackageManager();
        if (packageManager != null) {
            PackageManager packageManager2 = packageManager;
            boolean bl = false;
            if (mapIntent.resolveActivity(packageManager2) != null) {
                $this$startMapIntent.startActivity(mapIntent);
            }
        }
    }

    public static /* synthetic */ void startMapIntent$default(Context context, double d, double d2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        ContextExtKt.startMapIntent(context, d, d2, string2);
    }

    public static final void startAppSettingsIntent(@NotNull Context $this$startAppSettingsIntent) {
        Intrinsics.checkNotNullParameter((Object)$this$startAppSettingsIntent, (String)"<this>");
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)$this$startAppSettingsIntent.getPackageName(), null);
        intent.setData(uri);
        PackageManager packageManager = $this$startAppSettingsIntent.getPackageManager();
        if (packageManager != null) {
            PackageManager packageManager2 = packageManager;
            boolean bl = false;
            if (intent.resolveActivity(packageManager2) != null) {
                $this$startAppSettingsIntent.startActivity(intent);
            }
        }
    }

    public static final void startAppDetailsOnGooglePlay(@NotNull Context $this$startAppDetailsOnGooglePlay) {
        Intrinsics.checkNotNullParameter((Object)$this$startAppDetailsOnGooglePlay, (String)"<this>");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)Intrinsics.stringPlus((String)"market://details?id=", (Object)$this$startAppDetailsOnGooglePlay.getPackageName())));
        PackageManager packageManager = $this$startAppDetailsOnGooglePlay.getPackageManager();
        if (packageManager != null) {
            PackageManager packageManager2 = packageManager;
            boolean bl = false;
            if (intent.resolveActivity(packageManager2) != null) {
                $this$startAppDetailsOnGooglePlay.startActivity(intent);
            }
        }
    }

    public static final int getWindowWidth(@NotNull Context $this$getWindowWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$getWindowWidth, (String)"<this>");
        DisplayMetrics metrics = $this$getWindowWidth.getResources().getDisplayMetrics();
        return metrics.widthPixels;
    }

    public static final int getWindowHeight(@NotNull Context $this$getWindowHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$getWindowHeight, (String)"<this>");
        DisplayMetrics metrics = $this$getWindowHeight.getResources().getDisplayMetrics();
        return metrics.heightPixels;
    }

    public static final int getNavigationBarHeight(@NotNull Context $this$getNavigationBarHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$getNavigationBarHeight, (String)"<this>");
        int result = 0;
        boolean hasMenuKey = ViewConfiguration.get((Context)$this$getNavigationBarHeight).hasPermanentMenuKey();
        boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
        if (!hasMenuKey && !hasBackKey) {
            int resourceId;
            int orientation = $this$getNavigationBarHeight.getResources().getConfiguration().orientation;
            int n = ContextExtKt.isTablet($this$getNavigationBarHeight) ? $this$getNavigationBarHeight.getResources().getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_height_landscape", "dimen", "android") : (resourceId = $this$getNavigationBarHeight.getResources().getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_width", "dimen", "android"));
            if (resourceId > 0) {
                return $this$getNavigationBarHeight.getResources().getDimensionPixelSize(resourceId);
            }
        }
        return result;
    }

    public static final boolean isTablet(@NotNull Context $this$isTablet) {
        Intrinsics.checkNotNullParameter((Object)$this$isTablet, (String)"<this>");
        return ($this$isTablet.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    @NotNull
    public static final String getApplicationName(@NotNull Context $this$getApplicationName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getApplicationName, (String)"<this>");
        ApplicationInfo applicationInfo = $this$getApplicationName.getApplicationInfo();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"applicationInfo");
        ApplicationInfo applicationInfo2 = applicationInfo;
        int stringId = applicationInfo2.labelRes;
        if (stringId == 0) {
            string2 = ((Object)applicationInfo2.nonLocalizedLabel).toString();
        } else {
            String string3 = $this$getApplicationName.getString(stringId);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(stringId)");
            string2 = string3;
        }
        return string2;
    }

    @Nullable
    public static final String getVersion(@NotNull Context $this$getVersion) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getVersion, (String)"<this>");
        try {
            PackageInfo packageInfo = $this$getVersion.getPackageManager().getPackageInfo($this$getVersion.getPackageName(), 0);
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo, (String)"packageManager.getPackageInfo(packageName, 0)");
            PackageInfo pInfo = packageInfo;
            string2 = pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    public static final float getDimension(@NotNull Context $this$getDimension, @DimenRes int res) {
        Intrinsics.checkNotNullParameter((Object)$this$getDimension, (String)"<this>");
        return $this$getDimension.getResources().getDimension(res);
    }

    @Nullable
    public static final Drawable getDrawableByName(@NotNull Context $this$getDrawableByName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ContextCompat.getDrawable((Context)$this$getDrawableByName, (int)ContextExtKt.getDrawableResourceIdByName($this$getDrawableByName, name));
    }

    @DrawableRes
    public static final int getDrawableResourceIdByName(@NotNull Context $this$getDrawableResourceIdByName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getDrawableResourceIdByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Resources resources = $this$getDrawableResourceIdByName.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        Resources resources2 = resources;
        return resources2.getIdentifier(name, "drawable", $this$getDrawableResourceIdByName.getPackageName());
    }

    public static final void openUrl(@NotNull Context $this$openUrl, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)$this$openUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        ContextCompat.startActivity((Context)$this$openUrl, (Intent)browserIntent, null);
    }

    public static final void copyToClipboard(@NotNull Context $this$copyToClipboard, @NotNull String text, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)$this$copyToClipboard, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        ClipboardManager clipboard = (ClipboardManager)$this$copyToClipboard.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)label, (CharSequence)text);
        Intrinsics.checkNotNullExpressionValue((Object)clipData, (String)"newPlainText(label, text)");
        ClipData clip = clipData;
        ClipboardManager clipboardManager = clipboard;
        if (clipboardManager != null) {
            clipboardManager.setPrimaryClip(clip);
        }
    }

    public static /* synthetic */ void copyToClipboard$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "Copied text";
        }
        ContextExtKt.copyToClipboard(context, string2, string3);
    }
}

