/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.billing;

import android.text.TextUtils;
import android.util.Base64;
import com.merseyside.utils.Logger;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002J$\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/merseyside/utils/billing/Security;", "", "()V", "KEY_FACTORY_ALGORITHM", "", "SIGNATURE_ALGORITHM", "TAG", "generatePublicKey", "Ljava/security/PublicKey;", "encodedPublicKey", "verify", "", "publicKey", "signedData", "signature", "verifyPurchase", "base64PublicKey", "utils_release"})
public final class Security {
    @NotNull
    public static final Security INSTANCE = new Security();
    @NotNull
    private static final String TAG = "IABUtil/Security";
    @NotNull
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    @NotNull
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    private Security() {
    }

    public final boolean verifyPurchase(@Nullable String base64PublicKey, @NotNull String signedData, @Nullable String signature) throws IOException {
        Intrinsics.checkNotNullParameter((Object)signedData, (String)"signedData");
        if (TextUtils.isEmpty((CharSequence)signedData) || TextUtils.isEmpty((CharSequence)base64PublicKey) || TextUtils.isEmpty((CharSequence)signature)) {
            Logger.INSTANCE.logErr(TAG, "Purchase verification failed: missing data.");
            return false;
        }
        PublicKey key = this.generatePublicKey(base64PublicKey);
        return this.verify(key, signedData, signature);
    }

    private final PublicKey generatePublicKey(String encodedPublicKey) throws IOException {
        PublicKey publicKey;
        try {
            byte[] byArray = Base64.decode((String)encodedPublicKey, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(encodedPublicKey, Base64.DEFAULT)");
            byte[] decodedKey = byArray;
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            Intrinsics.checkNotNullExpressionValue((Object)keyFactory, (String)"getInstance(KEY_FACTORY_ALGORITHM)");
            KeyFactory keyFactory2 = keyFactory;
            publicKey = keyFactory2.generatePublic(new X509EncodedKeySpec(decodedKey));
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"{\n            val decode\u2026ec(decodedKey))\n        }");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            String msg = Intrinsics.stringPlus((String)"Invalid key specification: ", (Object)e);
            Logger.INSTANCE.logErr(TAG, msg);
            throw new IOException(msg);
        }
        return publicKey;
    }

    private final boolean verify(PublicKey publicKey, String signedData, String signature) {
        byte[] byArray;
        try {
            byArray = Base64.decode((String)signature, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            Base64.dec\u2026Base64.DEFAULT)\n        }");
        }
        catch (IllegalArgumentException e) {
            Logger.INSTANCE.logErr(TAG, "Base64 decoding failed.");
            return false;
        }
        byte[] signatureBytes = byArray;
        try {
            Object object = Signature.getInstance(SIGNATURE_ALGORITHM);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(SIGNATURE_ALGORITHM)");
            Signature signatureAlgorithm = object;
            signatureAlgorithm.initVerify(publicKey);
            object = signedData;
            byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            signatureAlgorithm.update(byArray2);
            if (!signatureAlgorithm.verify(signatureBytes)) {
                Logger.INSTANCE.logErr(TAG, "Signature verification failed.");
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            Logger.INSTANCE.logErr(TAG, "Invalid key specification.");
        }
        catch (SignatureException e) {
            Logger.INSTANCE.logErr(TAG, "Signature exception.");
        }
        return false;
    }
}

