/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.billing;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.RawRes;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.SubscriptionPurchase;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.merseyside.utils.Logger;
import com.merseyside.utils.billing.BillingManager;
import com.merseyside.utils.billing.Security;
import com.merseyside.utils.billing.Subscription;
import com.merseyside.utils.ext.CollectionExtKt;
import com.merseyside.utils.ext.ContextExtKt;
import com.merseyside.utils.ext.LoggerExtKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0003;<=B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J+\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J)\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&H\u0016J7\u0010(\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00162\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060*\"\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J7\u0010,\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00162\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060*\"\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u000e\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0012J\u0013\u0010/\u001a\u0004\u0018\u00010\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0016\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0017J!\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u0010\u001c\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0019\u00106\u001a\u00020\"2\u0006\u00102\u001a\u000203H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006>"}, d2={"Lcom/merseyside/utils/billing/BillingManager;", "Lcom/android/billingclient/api/PurchasesUpdatedListener;", "Lkotlinx/coroutines/CoroutineScope;", "context", "Landroid/content/Context;", "base64Key", "", "credentialsId", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Integer;)V", "billingClient", "Lcom/android/billingclient/api/BillingClient;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Ljava/lang/Integer;", "onPurchaseListener", "Lcom/merseyside/utils/billing/BillingManager$OnPurchaseListener;", "getGoogleCredentials", "Lcom/google/auth/oauth2/GoogleCredentials;", "getSkuDetails", "", "Lcom/android/billingclient/api/SkuDetails;", "skuList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSubscriptionState", "Lcom/merseyside/utils/billing/Subscription;", "sku", "token", "isKeepActiveOnError", "", "(Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onPurchasesUpdated", "", "result", "Lcom/android/billingclient/api/BillingResult;", "purchases", "", "Lcom/android/billingclient/api/Purchase;", "queryActiveSubscriptionsAsync", "skus", "", "([Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryAllSubscriptionsAsync", "setOnPurchaseListener", "listener", "startConnection", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startSubscription", "activity", "Landroid/app/Activity;", "skuDetails", "(Landroid/app/Activity;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startTestPurchase", "(Landroid/app/Activity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyValidSignature", "signedData", "signature", "BillingConnectionListener", "Companion", "OnPurchaseListener", "utils_release"})
public final class BillingManager
implements PurchasesUpdatedListener,
CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String base64Key;
    @Nullable
    private final Integer credentialsId;
    @Nullable
    private OnPurchaseListener onPurchaseListener;
    @Nullable
    private BillingClient billingClient;
    @NotNull
    private static final String TEST_SUBSCRIPTION_ID = "android.test.purchased";
    @NotNull
    private static final String PUBLISHER_SCOPE = "https://www.googleapis.com/auth/androidpublisher";

    public BillingManager(@NotNull Context context, @NotNull String base64Key, @RawRes @Nullable Integer credentialsId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)base64Key, (String)"base64Key");
        this.context = context;
        this.base64Key = base64Key;
        this.credentialsId = credentialsId;
    }

    public /* synthetic */ BillingManager(Context context, String string2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        this(context, string2, n);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)Dispatchers.getMain();
    }

    public final void setOnPurchaseListener(@NotNull OnPurchaseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.onPurchaseListener = listener;
    }

    private final Object startConnection(Continuation<? super BillingClient> $completion) {
        if (this.billingClient == null) {
            boolean $i$f$suspendCancellableCoroutine = false;
            Continuation<? super BillingClient> uCont$iv = $completion;
            boolean bl = false;
            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
            cancellable$iv.initCancellability();
            CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
            boolean bl2 = false;
            BillingClient billingClient = BillingClient.newBuilder((Context)this.context).enablePendingPurchases().setListener((PurchasesUpdatedListener)this).build();
            Intrinsics.checkNotNullExpressionValue((Object)billingClient, (String)"newBuilder(context)\n    \u2026                 .build()");
            BillingClient client = billingClient;
            client.startConnection(new BillingClientStateListener((CancellableContinuation<? super BillingClient>)cont, this, client){
                final /* synthetic */ CancellableContinuation<BillingClient> $cont;
                final /* synthetic */ BillingManager this$0;
                final /* synthetic */ BillingClient $client;
                {
                    this.$cont = $cont;
                    this.this$0 = $receiver;
                    this.$client = $client;
                }

                public void onBillingSetupFinished(@NotNull BillingResult billingResult) {
                    Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
                    if (this.$cont.isActive()) {
                        if (billingResult.getResponseCode() == 0) {
                            BillingManager.access$setBillingClient$p(this.this$0, this.$client);
                            ((Continuation)this.$cont).resumeWith(Result.constructor-impl((Object)BillingManager.access$getBillingClient$p(this.this$0)));
                        } else {
                            ((Continuation)this.$cont).resumeWith(Result.constructor-impl(null));
                        }
                    }
                }

                public void onBillingServiceDisconnected() {
                    BillingManager.access$setBillingClient$p(this.this$0, null);
                }
            });
            Object object = cancellable$iv.getResult();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                DebugProbesKt.probeCoroutineSuspended($completion);
            }
            return object;
        }
        return this.billingClient;
    }

    public void onPurchasesUpdated(@NotNull BillingResult result, @Nullable List<Purchase> purchases) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.getResponseCode() == 0) {
            if (purchases != null) {
                Iterable $this$forEach$iv = purchases;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Purchase purchase = (Purchase)element$iv;
                    boolean bl = false;
                    String string2 = purchase.getOriginalJson();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"purchase.originalJson");
                    String string3 = string2;
                    string2 = purchase.getSignature();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"purchase.signature");
                    if (this.verifyValidSignature(string3, string2)) {
                        OnPurchaseListener onPurchaseListener = this.onPurchaseListener;
                        if (onPurchaseListener == null) continue;
                        onPurchaseListener.onPurchase(purchase);
                        continue;
                    }
                    OnPurchaseListener onPurchaseListener = this.onPurchaseListener;
                    if (onPurchaseListener == null) continue;
                    onPurchaseListener.onError(result);
                }
            } else {
                OnPurchaseListener onPurchaseListener = this.onPurchaseListener;
                if (onPurchaseListener != null) {
                    onPurchaseListener.onError(result);
                }
            }
        } else {
            OnPurchaseListener onPurchaseListener = this.onPurchaseListener;
            if (onPurchaseListener != null) {
                onPurchaseListener.onError(result);
            }
        }
    }

    private final boolean verifyValidSignature(String signedData, String signature) {
        boolean bl;
        try {
            bl = Security.INSTANCE.verifyPurchase(this.base64Key, signedData, signature);
        }
        catch (IOException e) {
            Logger.INSTANCE.logErr(this, Intrinsics.stringPlus((String)"Got an exception trying to validate a purchase: ", (Object)e.getMessage()));
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object getSkuDetails(@Nullable List<String> var1_1, @NotNull Continuation<? super List<? extends SkuDetails>> var2_2) {
        block10: {
            if (!(var2_2 instanceof getSkuDetails.1)) ** GOTO lbl-1000
            var13_3 = var2_2;
            if ((var13_3.label & -2147483648) != 0) {
                var13_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ BillingManager this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.getSkuDetails(null, (Continuation<? super List<? extends SkuDetails>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!CollectionExtKt.isNotNullAndEmpty(skuList)) break block10;
                    Logger.INSTANCE.log(this, this);
                    var11_6 = this;
                    $continuation.L$0 = this;
                    $continuation.L$1 = skuList;
                    $continuation.L$2 = var11_6;
                    $continuation.label = 1;
                    v0 = this.startConnection((Continuation<? super BillingClient>)$continuation);
                    if (v0 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    var11_6 = (BillingManager)$continuation.L$2;
                    skuList = (List)$continuation.L$1;
                    this = (BillingManager)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    var11_6.billingClient = (BillingClient)v0;
                    v1 = this.billingClient;
                    if (v1 == null) break;
                    client = v1;
                    $i$a$-let-BillingManager$getSkuDetails$2 = false;
                    var5_10 /* !! */  = SkuDetailsParams.newBuilder().setSkusList(skuList).setType("subs").build();
                    Intrinsics.checkNotNullExpressionValue((Object)var5_10 /* !! */ , (String)"newBuilder().setSkusList\u2026ent.SkuType.SUBS).build()");
                    skuDetailsParams = var5_10 /* !! */ ;
                    var5_10 /* !! */  = $continuation;
                    $continuation.L$0 = client;
                    $continuation.L$1 = var5_10 /* !! */ ;
                    $continuation.L$2 = skuDetailsParams;
                    $continuation.label = 2;
                    var7_12 /* !! */  = var5_10 /* !! */ ;
                    var8_13 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var7_12 /* !! */ ));
                    cont = (Continuation)var8_13;
                    $i$a$-suspendCoroutine-BillingManager$getSkuDetails$2$1 = false;
                    client.querySkuDetailsAsync(skuDetailsParams, new SkuDetailsResponseListener((Continuation<? super List<? extends SkuDetails>>)cont){
                        final /* synthetic */ Continuation<List<? extends SkuDetails>> $cont;
                        {
                            this.$cont = $cont;
                        }

                        public final void onSkuDetailsResponse(@NotNull BillingResult result, @Nullable List<SkuDetails> responseSkuList) {
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            if (result.getResponseCode() == 0) {
                                this.$cont.resumeWith(Result.constructor-impl(responseSkuList));
                            } else {
                                Continuation<List<? extends SkuDetails>> continuation = this.$cont;
                                Object var4_4 = null;
                                continuation.resumeWith(Result.constructor-impl(var4_4));
                            }
                        }
                    });
                    v2 = var8_13.getOrThrow();
                    if (v2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)var5_10 /* !! */ );
                    }
                    v3 = v2;
                    if (v2 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl66
                }
                case 2: {
                    $i$a$-let-BillingManager$getSkuDetails$2 = false;
                    (SkuDetailsParams)$continuation.L$2;
                    $continuation.L$1;
                    (BillingClient)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl66:
                    // 2 sources

                    return v3;
                }
            }
            return null;
        }
        throw new IllegalArgumentException("Sku list can not be empty");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getSkuDetails$default(BillingManager billingManager, List list, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return billingManager.getSkuDetails(list, (Continuation<? super List<? extends SkuDetails>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startSubscription(@NotNull Activity var1_1, @NotNull String var2_2, @NotNull Continuation<? super BillingResult> var3_3) {
        if (!(var3_3 instanceof startSubscription.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ BillingManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startSubscription(null, null, (Continuation<? super BillingResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = activity;
                $continuation.L$2 = sku;
                $continuation.label = 1;
                v0 = this.getSkuDetails(CollectionsKt.listOf((Object)sku), (Continuation<? super List<? extends SkuDetails>>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                sku = (String)$continuation.L$2;
                activity = (Activity)$continuation.L$1;
                this = (BillingManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                v1 = details = (List)v0;
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-BillingManager$startSubscription$2 = false;
                    return this.startSubscription(activity, (SkuDetails)CollectionsKt.first((List)it));
                }
                throw new IllegalArgumentException("Sku " + sku + " not found!");
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final BillingResult startSubscription(@NotNull Activity activity, @NotNull SkuDetails skuDetails) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)skuDetails, (String)"skuDetails");
        Logger.INSTANCE.log(this, this);
        if (this.billingClient != null) {
            BillingFlowParams billingFlowParams = BillingFlowParams.newBuilder().setSkuDetails(skuDetails).build();
            Intrinsics.checkNotNullExpressionValue((Object)billingFlowParams, (String)"newBuilder()\n           \u2026\n                .build()");
            BillingFlowParams flowParams = billingFlowParams;
            BillingClient billingClient = this.billingClient;
            Intrinsics.checkNotNull((Object)billingClient);
            billingFlowParams = billingClient.launchBillingFlow(activity, flowParams);
            Intrinsics.checkNotNullExpressionValue((Object)billingFlowParams, (String)"billingClient!!.launchBi\u2026low(activity, flowParams)");
            return billingFlowParams;
        }
        throw new IllegalStateException("BillingClient is null");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object queryAllSubscriptionsAsync(@NotNull String[] var1_1, boolean var2_2, @NotNull Continuation<? super List<? extends Subscription>> var3_3) {
        block17: {
            block18: {
                block19: {
                    block20: {
                        block16: {
                            block21: {
                                if (!(var3_3 instanceof queryAllSubscriptionsAsync.1)) ** GOTO lbl-1000
                                var35_4 = var3_3;
                                if ((var35_4.label & -2147483648) != 0) {
                                    var35_4.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, var3_3){
                                        Object L$0;
                                        Object L$1;
                                        Object L$2;
                                        Object L$3;
                                        Object L$4;
                                        Object L$5;
                                        Object L$6;
                                        boolean Z$0;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ BillingManager this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.queryAllSubscriptionsAsync(null, false, (Continuation<? super List<? extends Subscription>>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var36_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                block0 : switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (this.credentialsId == null) break block17;
                                        $continuation.L$0 = this;
                                        $continuation.L$1 = skus;
                                        $continuation.Z$0 = isKeepActiveOnError;
                                        $continuation.label = 1;
                                        v0 = this.startConnection((Continuation<? super BillingClient>)$continuation);
                                        if (v0 == var36_6) {
                                            return var36_6;
                                        }
                                        ** GOTO lbl27
                                    }
                                    case 1: {
                                        isKeepActiveOnError = $continuation.Z$0;
                                        skus = (String[])$continuation.L$1;
                                        this = (BillingManager)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl27:
                                        // 2 sources

                                        if ((billingClient = (BillingClient)v0) == null) break block18;
                                        $continuation.L$0 = this;
                                        $continuation.L$1 = skus;
                                        $continuation.L$2 = billingClient;
                                        $continuation.Z$0 = isKeepActiveOnError;
                                        $continuation.label = 2;
                                        var6_8 /* !! */  = $continuation;
                                        var7_9 /* !! */  = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var6_8 /* !! */ ));
                                        cont = (Continuation)var7_9 /* !! */ ;
                                        $i$a$-suspendCoroutine-BillingManager$queryAllSubscriptionsAsync$historyList$1 = false;
                                        billingClient.queryPurchaseHistoryAsync("subs", new PurchaseHistoryResponseListener((Continuation<? super List<? extends PurchaseHistoryRecord>>)cont){
                                            final /* synthetic */ Continuation<List<? extends PurchaseHistoryRecord>> $cont;
                                            {
                                                this.$cont = $cont;
                                            }

                                            public final void onPurchaseHistoryResponse(@NotNull BillingResult result, @Nullable List<PurchaseHistoryRecord> historyList2) {
                                                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                                                if (result.getResponseCode() == 0) {
                                                    this.$cont.resumeWith(Result.constructor-impl(historyList2));
                                                } else {
                                                    Continuation<List<? extends PurchaseHistoryRecord>> continuation = this.$cont;
                                                    Object var4_4 = null;
                                                    continuation.resumeWith(Result.constructor-impl(var4_4));
                                                }
                                            }
                                        });
                                        v1 = var7_9 /* !! */ .getOrThrow();
                                        if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                                        }
                                        v2 = v1;
                                        if (v1 == var36_6) {
                                            return var36_6;
                                        }
                                        ** GOTO lbl55
                                    }
                                    case 2: {
                                        isKeepActiveOnError = $continuation.Z$0;
                                        (BillingClient)$continuation.L$2;
                                        skus = (String[])$continuation.L$1;
                                        this = (BillingManager)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl55:
                                        // 2 sources

                                        var6_8 /* !! */  = historyList = (List)LoggerExtKt.log$default(v2, null, 1, null);
                                        if (var6_8 /* !! */  != null) ** GOTO lbl59
                                        v3 = null;
                                        break block19;
lbl59:
                                        // 1 sources

                                        $this$filter$iv = var6_8 /* !! */ ;
                                        $i$f$filter = false;
                                        var10_13 = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            it = (PurchaseHistoryRecord)element$iv$iv;
                                            $i$a$-filter-BillingManager$queryAllSubscriptionsAsync$2 = false;
                                            var17_20 = it.getSkus();
                                            Intrinsics.checkNotNullExpressionValue((Object)var17_20, (String)"it.skus");
                                            for (T var20_22 : (Iterable)var17_20) {
                                                historySkus = (String)var20_22;
                                                $i$a$-find-BillingManager$queryAllSubscriptionsAsync$2$1 = false;
                                                if (!ArraysKt.contains((Object[])skus, (Object)historySkus)) continue;
                                                v4 = var20_22;
                                                ** GOTO lbl76
                                            }
                                            v4 = null;
lbl76:
                                            // 2 sources

                                            v5 = v4 != null;
                                            if (!v5) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        var7_9 /* !! */  = (List)destination$iv$iv;
                                        $this$flatMap$iv = (Iterable)var7_9 /* !! */ ;
                                        $i$f$flatMap = false;
                                        $this$filterTo$iv$iv = $this$flatMap$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$flatMapTo = false;
                                        var13_16 = $this$flatMapTo$iv$iv.iterator();
lbl88:
                                        // 2 sources

                                        while (var13_16.hasNext()) {
                                            element$iv$iv = var13_16.next();
                                            purchase = (PurchaseHistoryRecord)element$iv$iv;
                                            $i$a$-flatMap-BillingManager$queryAllSubscriptionsAsync$3 = false;
                                            var17_20 = purchase.getSkus();
                                            Intrinsics.checkNotNullExpressionValue((Object)var17_20, (String)"purchase.skus");
                                            $this$mapNotNull$iv = var17_20;
                                            $i$f$mapNotNull = false;
                                            var19_21 = $this$mapNotNull$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$mapNotNullTo = false;
                                            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                            $i$f$forEach = false;
                                            var24_29 = $this$forEach$iv$iv$iv.iterator();
lbl102:
                                            // 3 sources

                                            while (var24_29.hasNext()) {
                                                element$iv$iv = element$iv$iv$iv = var24_29.next();
                                                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                                it = (String)element$iv$iv;
                                                $i$a$-mapNotNull-BillingManager$queryAllSubscriptionsAsync$3$1 = false;
                                                if (!ArraysKt.contains((Object[])skus, (Object)it)) break block0;
                                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                                var30_35 = purchase.getPurchaseToken();
                                                Intrinsics.checkNotNullExpressionValue((Object)var30_35, (String)"purchase.purchaseToken");
                                                $continuation.L$0 = this;
                                                $continuation.L$1 = skus;
                                                $continuation.L$2 = destination$iv$iv;
                                                $continuation.L$3 = var13_16;
                                                $continuation.L$4 = purchase;
                                                $continuation.L$5 = destination$iv$iv;
                                                $continuation.L$6 = var24_29;
                                                $continuation.Z$0 = isKeepActiveOnError;
                                                $continuation.label = 3;
                                                v6 = this.getSubscriptionState(it, var30_35, isKeepActiveOnError != false, (Continuation<? super Subscription>)$continuation);
                                                if (v6 == var36_6) {
                                                    return var36_6;
                                                }
                                                ** GOTO lbl145
                                            }
                                            break block16;
                                        }
                                        break block20;
                                    }
                                    case 3: {
                                        $i$f$flatMap = false;
                                        $i$f$flatMapTo = false;
                                        $i$a$-flatMap-BillingManager$queryAllSubscriptionsAsync$3 = false;
                                        $i$f$mapNotNull = false;
                                        $i$f$mapNotNullTo = false;
                                        $i$f$forEach = false;
                                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                        $i$a$-mapNotNull-BillingManager$queryAllSubscriptionsAsync$3$1 = false;
                                        isKeepActiveOnError = $continuation.Z$0;
                                        var24_29 = (Iterator<T>)$continuation.L$6;
                                        destination$iv$iv = (Collection)$continuation.L$5;
                                        purchase = (PurchaseHistoryRecord)$continuation.L$4;
                                        var13_16 = (Iterator<T>)$continuation.L$3;
                                        destination$iv$iv = (Collection)$continuation.L$2;
                                        skus = (String[])$continuation.L$1;
                                        this = (BillingManager)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v6 = $result;
lbl145:
                                        // 2 sources

                                        v7 = (Subscription)v6;
                                        break block21;
                                    }
                                }
                                v7 = null;
                            }
                            if (v7 == null) ** GOTO lbl102
                            it$iv$iv = v7;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                            ** GOTO lbl102
                        }
                        list$iv$iv = (List)destination$iv$iv;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        ** GOTO lbl88
                    }
                    v3 = (List)destination$iv$iv;
                }
                return v3;
            }
            return null;
        }
        throw new IllegalArgumentException("Please, set credentials id by constructor");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryAllSubscriptionsAsync$default(BillingManager billingManager, String[] stringArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return billingManager.queryAllSubscriptionsAsync(stringArray, bl, (Continuation<? super List<? extends Subscription>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryActiveSubscriptionsAsync(@NotNull String[] var1_1, boolean var2_2, @NotNull Continuation<? super List<? extends Subscription>> var3_3) {
        if (!(var3_3 instanceof queryActiveSubscriptionsAsync.1)) ** GOTO lbl-1000
        var13_4 = var3_3;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ BillingManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.queryActiveSubscriptionsAsync(null, false, (Continuation<? super List<? extends Subscription>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.queryAllSubscriptionsAsync((String[])Arrays.copyOf(skus, ((void)skus).length), isKeepActiveOnError != false, (Continuation<? super List<? extends Subscription>>)$continuation);
                if (v0 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if ((var4_7 = (List)v0) == null) {
                    v1 = null;
                } else {
                    $this$filterIsInstance$iv = var4_7;
                    $i$f$filterIsInstance = false;
                    var7_10 = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Subscription.ActiveSubscription)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v1 = (List)destination$iv$iv;
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryActiveSubscriptionsAsync$default(BillingManager billingManager, String[] stringArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return billingManager.queryActiveSubscriptionsAsync(stringArray, bl, (Continuation<? super List<? extends Subscription>>)continuation);
    }

    private final Object getSubscriptionState(String sku, String token, boolean isKeepActiveOnError, Continuation<? super Subscription> $completion) {
        NetHttpTransport httpTransport = new NetHttpTransport();
        GsonFactory jacksonJsonFactory = GsonFactory.getDefaultInstance();
        String packageName = this.context.getPackageName();
        AndroidPublisher publisher = new AndroidPublisher.Builder((HttpTransport)httpTransport, (JsonFactory)jacksonJsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)this.getGoogleCredentials())).setApplicationName(ContextExtKt.getApplicationName(this.context)).build();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"publisher");
        AndroidPublisher.Purchases.Subscriptions.Get request = new AndroidPublisher.Purchases(publisher).subscriptions().get(packageName, sku, token);
        Ref.BooleanRef isKeepActiveOnErrorMut = new Ref.BooleanRef();
        isKeepActiveOnErrorMut.element = isKeepActiveOnError;
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Subscription>, Object>(request, isKeepActiveOnErrorMut, sku, null){
            int label;
            final /* synthetic */ AndroidPublisher.Purchases.Subscriptions.Get $request;
            final /* synthetic */ Ref.BooleanRef $isKeepActiveOnErrorMut;
            final /* synthetic */ String $sku;
            {
                this.$request = $request;
                this.$isKeepActiveOnErrorMut = $isKeepActiveOnErrorMut;
                this.$sku = $sku;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        SubscriptionPurchase subscriptionPurchase;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            subscriptionPurchase = (SubscriptionPurchase)this.$request.execute();
                        }
                        catch (GoogleJsonResponseException googleJsonResponseException) {
                            this.$isKeepActiveOnErrorMut.element = false;
                            subscriptionPurchase = null;
                        }
                        catch (HttpResponseException httpResponseException) {
                            subscriptionPurchase = null;
                        }
                        boolean bl = this.$isKeepActiveOnErrorMut.element;
                        SubscriptionPurchase subscriptionPurchase2 = subscriptionPurchase;
                        return new Subscription.Builder(subscriptionPurchase2, bl).setSku(this.$sku).build();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Subscription> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startTestPurchase(@NotNull Activity var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof startTestPurchase.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ BillingManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startTestPurchase(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.getSkuDetails(CollectionsKt.listOf((Object)"android.test.purchased"), (Continuation<? super List<? extends SkuDetails>>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                (List)LoggerExtKt.log$default(v0, null, 1, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GoogleCredentials getGoogleCredentials() {
        Integer n = this.credentialsId;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            Closeable closeable = this.context.getResources().openRawResource(it);
            Throwable throwable = null;
            try {
                InputStream is = (InputStream)closeable;
                boolean bl2 = false;
                String[] stringArray = new String[]{PUBLISHER_SCOPE};
                GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)is).createScoped(stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)googleCredentials, (String)"fromStream(`is`)\n       \u2026teScoped(PUBLISHER_SCOPE)");
                GoogleCredentials googleCredentials2 = googleCredentials;
                return googleCredentials2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        throw new IllegalArgumentException("Credential ids not set!");
    }

    public static final /* synthetic */ Object access$startConnection(BillingManager $this, Continuation $completion) {
        return $this.startConnection((Continuation<? super BillingClient>)$completion);
    }

    public static final /* synthetic */ Object access$getSubscriptionState(BillingManager $this, String sku, String token, boolean isKeepActiveOnError, Continuation $completion) {
        return $this.getSubscriptionState(sku, token, isKeepActiveOnError, (Continuation<? super Subscription>)$completion);
    }

    public static final /* synthetic */ void access$setBillingClient$p(BillingManager $this, BillingClient billingClient) {
        $this.billingClient = billingClient;
    }

    public static final /* synthetic */ BillingClient access$getBillingClient$p(BillingManager $this) {
        return $this.billingClient;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/merseyside/utils/billing/BillingManager$BillingConnectionListener;", "", "onConnected", "", "onDisconnected", "onError", "code", "", "utils_release"})
    public static interface BillingConnectionListener {
        public void onConnected();

        public void onError(int var1);

        public void onDisconnected();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/merseyside/utils/billing/BillingManager$OnPurchaseListener;", "", "onError", "", "result", "Lcom/android/billingclient/api/BillingResult;", "onPurchase", "purchase", "Lcom/android/billingclient/api/Purchase;", "utils_release"})
    public static interface OnPurchaseListener {
        public void onPurchase(@NotNull Purchase var1);

        public void onError(@NotNull BillingResult var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/merseyside/utils/billing/BillingManager$Companion;", "", "()V", "PUBLISHER_SCOPE", "", "TEST_SUBSCRIPTION_ID", "utils_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

