/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import android.app.Activity;
import android.content.Context;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a#\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a+\u0010\n\u001a\u00020\u000b*\u00020\f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000e\u001a+\u0010\n\u001a\u00020\u000b*\u00020\u000f2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"isRequestCodeValid", "", "code", "", "isPermissionsGranted", "Landroid/content/Context;", "permissions", "", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "requestPermissions", "", "Landroid/app/Activity;", "requestCode", "(Landroid/app/Activity;[Ljava/lang/String;I)V", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;I)V", "utils_release"})
public final class PermissionManagerKt {
    public static final void requestPermissions(@NotNull Activity $this$requestPermissions, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)$this$requestPermissions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        if (PermissionManagerKt.isRequestCodeValid(requestCode)) {
            if (!PermissionManagerKt.isPermissionsGranted((Context)$this$requestPermissions, Arrays.copyOf(permissions, permissions.length))) {
                ActivityCompat.requestPermissions((Activity)$this$requestPermissions, (String[])permissions, (int)requestCode);
            }
        } else {
            throw new IllegalArgumentException("Request code is not valid");
        }
    }

    public static final void requestPermissions(@NotNull Fragment $this$requestPermissions, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)$this$requestPermissions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        if (PermissionManagerKt.isRequestCodeValid(requestCode)) {
            Context context = $this$requestPermissions.requireContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
            if (!PermissionManagerKt.isPermissionsGranted(context, Arrays.copyOf(permissions, permissions.length))) {
                $this$requestPermissions.requestPermissions(permissions, requestCode);
            }
        } else {
            throw new IllegalArgumentException("Request code is not valid");
        }
    }

    public static final boolean isPermissionsGranted(@NotNull Context $this$isPermissionsGranted, String ... permissions) {
        Intrinsics.checkNotNullParameter((Object)$this$isPermissionsGranted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        for (String permission : permissions) {
            int granted = ContextCompat.checkSelfPermission((Context)$this$isPermissionsGranted, (String)permission);
            if (granted == 0) continue;
            return false;
        }
        return true;
    }

    private static final boolean isRequestCodeValid(int code) {
        return (double)code <= Math.pow(2.0, 16.0) - 1.0;
    }
}

