/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.merseyside.utils.network.NetworkKt;
import com.merseyside.utils.network.NetworkStateListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/merseyside/utils/network/NetworkStateChangeReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "listeners", "", "Lcom/merseyside/utils/network/NetworkStateListener;", "notifyListeners", "", "state", "", "onReceive", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "removeStateListener", "listener", "setStateListener", "utils_release"})
public final class NetworkStateChangeReceiver
extends BroadcastReceiver {
    @NotNull
    private List<NetworkStateListener> listeners;

    public NetworkStateChangeReceiver() {
        boolean bl = false;
        this.listeners = new ArrayList();
    }

    public final void setStateListener(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        if (Intrinsics.areEqual((Object)"android.net.conn.CONNECTIVITY_CHANGE", (Object)intent.getAction())) {
            if (NetworkKt.isOnline(context)) {
                this.notifyListeners(true);
            } else {
                this.notifyListeners(false);
            }
        }
    }

    private final void notifyListeners(boolean state) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetworkStateListener it = (NetworkStateListener)element$iv;
            boolean bl = false;
            it.onConnectionState(state);
        }
    }

    public final void removeStateListener(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }
}

