/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.buffer;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0015\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\r\u0010\u0017\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0013\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0014J(\u0010\u0012\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u0006\u0010\u0013\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/merseyside/utils/buffer/BufferQueue;", "T", "", "capacity", "", "(I)V", "queue", "Lkotlin/collections/ArrayDeque;", "getQueue", "()Lkotlin/collections/ArrayDeque;", "size", "getSize", "()I", "add", "", "value", "(Ljava/lang/Object;)V", "clear", "get", "index", "(I)Ljava/lang/Object;", "getFirst", "()Ljava/lang/Object;", "getLast", "isEmpty", "", "isNotEmpty", "remove", "element", "(Ljava/lang/Object;)Z", "(Lcom/merseyside/utils/buffer/BufferQueue;I)Ljava/lang/Object;", "utils_release"})
public final class BufferQueue<T> {
    private final int capacity;
    @NotNull
    private final ArrayDeque<T> queue;

    public BufferQueue(int capacity) {
        this.capacity = capacity;
        this.queue = new ArrayDeque(this.capacity);
    }

    @NotNull
    public final ArrayDeque<T> getQueue() {
        return this.queue;
    }

    public final int getSize() {
        return this.queue.size();
    }

    public final void add(T value) {
        ArrayDeque<T> arrayDeque = this.queue;
        boolean bl = false;
        boolean bl2 = false;
        ArrayDeque<T> $this$add_u24lambda_u2d0 = arrayDeque;
        boolean bl3 = false;
        if ($this$add_u24lambda_u2d0.size() == this.capacity) {
            $this$add_u24lambda_u2d0.removeFirstOrNull();
        }
        this.getQueue().addLast(value);
    }

    @Nullable
    public final T get(int index) {
        Object object;
        try {
            object = this.queue.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            if (index >= this.capacity) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Capacity is ", (Object)this.capacity));
            }
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public final T getLast() {
        return (T)this.queue.lastOrNull();
    }

    @Nullable
    public final T getFirst() {
        return (T)this.queue.firstOrNull();
    }

    public final void clear() {
        this.queue.clear();
    }

    public final T remove(int index) {
        return (T)this.queue.remove(index);
    }

    public final boolean remove(T element) {
        return this.queue.remove(element);
    }

    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public final boolean isNotEmpty() {
        Collection collection = (Collection)this.queue;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Nullable
    public final <T> T get(@NotNull BufferQueue<T> $this$get, int index) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        return $this$get.get(index);
    }
}

