/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.view.canvas.ext;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import com.merseyside.utils.Logger;
import com.merseyside.utils.view.canvas.Background;
import com.merseyside.utils.view.canvas.CircleCorners;
import com.merseyside.utils.view.canvas.CornerRadius;
import com.merseyside.utils.view.canvas.HorizontalAlign;
import com.merseyside.utils.view.canvas.VerticalAlign;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u001a\"\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\f\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u001a2\u0010\f\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a:\u0010\f\u001a\u00020\u0003*\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\u0015\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017\u001aJ\u0010\u0018\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u001a*\u0010!\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t\u001a*\u0010%\u001a\u00020\u0003*\u00020\u00042\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t\u001a \u0010)\u001a\u00020\u000b*\u00020\u000b2\b\b\u0002\u0010*\u001a\u00020\u00172\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"textGap", "", "drawCircle", "", "Landroid/graphics/Canvas;", "point", "Landroid/graphics/Point;", "radius", "paint", "Landroid/graphics/Paint;", "rect", "Landroid/graphics/Rect;", "drawLine", "from", "to", "startX", "startY", "stopX", "stopY", "Lkotlin/Pair;", "", "drawTextCenter", "text", "", "drawTextOnBaseline", "xBaseline", "yBaseline", "horizontalAlign", "Lcom/merseyside/utils/view/canvas/HorizontalAlign;", "verticalAlign", "Lcom/merseyside/utils/view/canvas/VerticalAlign;", "background", "Lcom/merseyside/utils/view/canvas/Background;", "drawXLine", "x", "fromY", "toY", "drawYLine", "y", "fromX", "toX", "logRect", "tag", "prefix", "utils_release"})
public final class CanvasExtKt {
    private static final float textGap = 5.5f;

    public static final void drawLine(@NotNull Canvas $this$drawLine, float startX, float startY, float stopX, float stopY, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        $this$drawLine.drawLine(startX, startY, stopX, stopY, paint);
    }

    public static final void drawLine(@NotNull Canvas $this$drawLine, @NotNull Point from, @NotNull Point to, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        $this$drawLine.drawLine((float)from.x, (float)from.y, (float)to.x, (float)to.y, paint);
    }

    public static final void drawLine(@NotNull Canvas $this$drawLine, @NotNull Pair<? extends Number, ? extends Number> from, @NotNull Pair<? extends Number, ? extends Number> to, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawLine, (String)"<this>");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        $this$drawLine.drawLine(((Number)from.getFirst()).floatValue(), ((Number)from.getSecond()).floatValue(), ((Number)to.getFirst()).floatValue(), ((Number)to.getSecond()).floatValue(), paint);
    }

    public static final void drawXLine(@NotNull Canvas $this$drawXLine, @NotNull Number x, @NotNull Number fromY, @NotNull Number toY, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawXLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)fromY, (String)"fromY");
        Intrinsics.checkNotNullParameter((Object)toY, (String)"toY");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        $this$drawXLine.drawLine(x.floatValue(), fromY.floatValue(), x.floatValue(), toY.floatValue(), paint);
    }

    public static final void drawYLine(@NotNull Canvas $this$drawYLine, @NotNull Number y, @NotNull Number fromX, @NotNull Number toX, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawYLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)fromX, (String)"fromX");
        Intrinsics.checkNotNullParameter((Object)toX, (String)"toX");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        $this$drawYLine.drawLine(fromX.floatValue(), y.floatValue(), toX.floatValue(), y.floatValue(), paint);
    }

    public static final void drawTextOnBaseline(@NotNull Canvas $this$drawTextOnBaseline, @NotNull String text, @NotNull Number xBaseline, @NotNull Number yBaseline, @NotNull HorizontalAlign horizontalAlign, @NotNull VerticalAlign verticalAlign, @NotNull Paint paint, @Nullable Background background) {
        float f;
        float f2;
        Intrinsics.checkNotNullParameter((Object)$this$drawTextOnBaseline, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)xBaseline, (String)"xBaseline");
        Intrinsics.checkNotNullParameter((Object)yBaseline, (String)"yBaseline");
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalAlign), (String)"horizontalAlign");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalAlign), (String)"verticalAlign");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        paint.setTextAlign(Paint.Align.RIGHT);
        float xBase = xBaseline.floatValue();
        float yBase = yBaseline.floatValue();
        float f3 = paint.getTextSize();
        boolean bl = false;
        boolean bl2 = false;
        float it = f3;
        boolean $i$a$-also-CanvasExtKt$drawTextOnBaseline$textHeight$22 = false;
        if (it == 0.0f) {
            throw new IllegalArgumentException("Text size not set!");
        }
        float textHeight = f3;
        float textWidth = paint.measureText(text);
        float textWidthHalf = textWidth / (float)2;
        float textHeightHalf = textHeight / (float)2;
        HorizontalAlign $i$a$-also-CanvasExtKt$drawTextOnBaseline$textHeight$22 = horizontalAlign;
        int n = WhenMappings.$EnumSwitchMapping$0[$i$a$-also-CanvasExtKt$drawTextOnBaseline$textHeight$22.ordinal()];
        switch (n) {
            case 1: {
                f2 = xBase;
                break;
            }
            case 2: {
                f2 = xBase + textWidthHalf;
                break;
            }
            case 3: {
                f2 = xBase + textWidth;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        float textXCoord = f2;
        Object object = verticalAlign;
        int n2 = WhenMappings.$EnumSwitchMapping$1[((Enum)object).ordinal()];
        switch (n2) {
            case 1: {
                f = yBase;
                break;
            }
            case 2: {
                f = yBase + textHeightHalf;
                break;
            }
            case 3: {
                f = yBase + textHeight;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        float textYCoord = f;
        object = background;
        if (object != null) {
            Unit unit;
            Unit unit2;
            Object object2 = object;
            boolean bl3 = false;
            boolean bl4 = false;
            Object background2 = object2;
            boolean bl5 = false;
            RectF rect = new RectF(textXCoord - textWidth - ((Background)background2).getMargins().getLeft(), textYCoord - textHeight - ((Background)background2).getMargins().getTop(), textXCoord + ((Background)background2).getMargins().getRight(), textYCoord + ((Background)background2).getMargins().getBottom());
            CornerRadius cornerRadius = ((Background)background2).getCornerRadius();
            if (cornerRadius == null) {
                unit2 = null;
            } else {
                CornerRadius cornerRadius2 = cornerRadius;
                boolean bl6 = false;
                boolean bl7 = false;
                CornerRadius radius = cornerRadius2;
                boolean bl8 = false;
                CornerRadius newRadius = radius instanceof CircleCorners ? ((CircleCorners)radius).getCornerRadius(rect) : radius;
                $this$drawTextOnBaseline.drawRoundRect(rect, newRadius.getXRadius().floatValue(), newRadius.getYRadius().floatValue(), ((Background)background2).getPaint());
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit == null) {
                $this$drawTextOnBaseline.drawRect(rect, ((Background)background2).getPaint());
            }
        }
        $this$drawTextOnBaseline.drawText(text, textXCoord, textYCoord - 5.5f, paint);
    }

    public static /* synthetic */ void drawTextOnBaseline$default(Canvas canvas, String string2, Number number, Number number2, HorizontalAlign horizontalAlign, VerticalAlign verticalAlign, Paint paint, Background background, int n, Object object) {
        if ((n & 8) != 0) {
            horizontalAlign = HorizontalAlign.LEFT;
        }
        if ((n & 0x10) != 0) {
            verticalAlign = VerticalAlign.TOP;
        }
        if ((n & 0x40) != 0) {
            background = null;
        }
        CanvasExtKt.drawTextOnBaseline(canvas, string2, number, number2, horizontalAlign, verticalAlign, paint, background);
    }

    public static final void drawCircle(@NotNull Canvas $this$drawCircle, @NotNull Point point, float radius, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawCircle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        $this$drawCircle.drawCircle((float)point.x, (float)point.y, radius, paint);
    }

    public static final void drawCircle(@NotNull Canvas $this$drawCircle, @NotNull Rect rect, float radius, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$drawCircle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        $this$drawCircle.drawCircle((float)rect.width() / 2.0f, (float)rect.height() / 2.0f, radius, paint);
    }

    public static final void drawTextCenter(@NotNull Canvas $this$drawTextCenter, @NotNull Rect rect, @NotNull Paint paint, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$drawTextCenter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int cHeight = rect.height();
        int cWidth = rect.width();
        paint.setTextAlign(Paint.Align.LEFT);
        Rect rect2 = new Rect();
        boolean bl = false;
        boolean bl2 = false;
        Rect $this$drawTextCenter_u24lambda_u2d3 = rect2;
        boolean bl3 = false;
        paint.getTextBounds(text, 0, text.length(), $this$drawTextCenter_u24lambda_u2d3);
        Rect bounds = rect2;
        float x = (float)rect.left + (float)cWidth / 2.0f - (float)bounds.width() / 2.0f - (float)bounds.left;
        float y = (float)rect.top + (float)cHeight / 2.0f + (float)bounds.height() / 2.0f - (float)bounds.bottom;
        $this$drawTextCenter.drawText(text, x, y, paint);
    }

    @NotNull
    public static final Rect logRect(@NotNull Rect $this$logRect, @NotNull String tag, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$logRect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Rect rect = $this$logRect;
        boolean bl = false;
        boolean bl2 = false;
        Rect it = rect;
        boolean bl3 = false;
        Logger.INSTANCE.log(tag, prefix + " left = " + $this$logRect.left + " top = " + $this$logRect.top + "\nright = " + $this$logRect.right + " bottom = " + $this$logRect.bottom);
        return rect;
    }

    public static /* synthetic */ Rect logRect$default(Rect rect, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "Logger";
        }
        if ((n & 2) != 0) {
            string3 = "";
        }
        return CanvasExtKt.logRect(rect, string2, string3);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HorizontalAlign.values().length];
            nArray[HorizontalAlign.LEFT.ordinal()] = 1;
            nArray[HorizontalAlign.CENTER.ordinal()] = 2;
            nArray[HorizontalAlign.RIGHT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VerticalAlign.values().length];
            nArray[VerticalAlign.TOP.ordinal()] = 1;
            nArray[VerticalAlign.CENTER.ordinal()] = 2;
            nArray[VerticalAlign.BOTTOM.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

