/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import com.merseyside.merseyLib.time.TimeUnit;
import com.merseyside.utils.HandlerCanceller;
import com.merseyside.utils.LocaleManager;
import com.merseyside.utils.ext.HandlerExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u001a\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0001\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u001a\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001c\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u0015\u001a\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b\"\u0004\b\u0000\u0010\u001c\u001a\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010 \u001a\u00020\u0001\u001a\u0018\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u000e\u001a\u0018\u0010$\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u000eH\u0007\u001a\u000e\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'\u001a1\u0010(\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001c0)\"\b\b\u0000\u0010\u001c*\u00020*2\u0006\u0010+\u001a\u0002H\u001c2\u0006\u0010,\u001a\u0002H\u001c\u00a2\u0006\u0002\u0010-\u001a\u000e\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020*\u001a\u0006\u00100\u001a\u000201\u001a\u0006\u00102\u001a\u000201\u001a\u0014\u00103\u001a\u0002042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015\u001a\u0016\u00105\u001a\u0004\u0018\u0001042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015\u001a\u0016\u00106\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u000e\u001a\u0010\u00108\u001a\u0002012\b\b\u0002\u00109\u001a\u00020\u0004\u001a\u0014\u0010:\u001a\u00020;2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u0015\u001a\u000e\u0010<\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020*\u00a8\u0006="}, d2={"adjustAlpha", "", "color", "factor", "", "convertDpToPixel", "context", "Landroid/content/Context;", "dp", "convertPixelsToDp", "px", "copyToClipboard", "", "text", "", "label", "delayedMainThread", "Lcom/merseyside/utils/HandlerCanceller;", "delay", "Lcom/merseyside/merseyLib/time/TimeUnit;", "onMain", "Lkotlin/Function0;", "runnable", "Ljava/lang/Runnable;", "delayedThread", "onThread", "emptyMutableList", "", "T", "generateRandomString", "length", "getDimension", "res", "getDrawableByName", "Landroid/graphics/drawable/Drawable;", "name", "getDrawableResourceIdByName", "getLocalizedContext", "localeManager", "Lcom/merseyside/utils/LocaleManager;", "getMinMax", "Lkotlin/Pair;", "", "first", "second", "(Ljava/lang/Number;Ljava/lang/Number;)Lkotlin/Pair;", "getNumberOfDigits", "number", "isExternalStorageReadable", "", "isMainThread", "mainThread", "Landroid/os/Handler;", "mainThreadIfNeeds", "openUrl", "url", "randomBool", "positiveProbability", "runThread", "Ljava/lang/Thread;", "shrinkNumber", "utils_release"})
@JvmName(name="LibUtils")
public final class LibUtils {
    @NotNull
    public static final Context getLocalizedContext(@NotNull LocaleManager localeManager) {
        Intrinsics.checkNotNullParameter((Object)localeManager, (String)"localeManager");
        CharSequence charSequence = localeManager.getLanguage();
        boolean bl = false;
        return charSequence.length() > 0 ? localeManager.setLocale() : localeManager.getContext();
    }

    public static final boolean randomBool(float positiveProbability) {
        Random rand;
        return positiveProbability >= 1.0f ? true : (positiveProbability <= 0.0f ? false : (rand = new Random()).nextFloat() <= positiveProbability);
    }

    public static /* synthetic */ boolean randomBool$default(float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.5f;
        }
        return LibUtils.randomBool(f);
    }

    public static final float convertPixelsToDp(@NotNull Context context, int px) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float density = context.getResources().getDisplayMetrics().density;
        return (float)px / density;
    }

    public static final int convertDpToPixel(@NotNull Context context, float dp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dp * density);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateRandomString(int length) {
        if (length > 0) {
            Integer n;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            List charPool = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
            Iterable $this$map$iv = (Iterable)new IntRange(1, length);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                n = kotlin.random.Random.Default.nextInt(0, charPool.size());
                collection.add(n);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                int it = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                n = charPool.get((int)p0);
                collection.add(n);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }
        return "";
    }

    @NotNull
    public static final Handler mainThread(@NotNull Function0<Unit> onMain) {
        Intrinsics.checkNotNullParameter(onMain, (String)"onMain");
        Handler handler = new Handler(Looper.getMainLooper());
        Function0<Unit> function0 = onMain;
        handler.post(() -> LibUtils.mainThread$lambda-1(function0));
        return handler;
    }

    @Nullable
    public static final Handler mainThreadIfNeeds(@NotNull Function0<Unit> onMain) {
        Handler handler;
        Intrinsics.checkNotNullParameter(onMain, (String)"onMain");
        if (!LibUtils.isMainThread()) {
            handler = LibUtils.mainThread(onMain);
        } else {
            onMain.invoke();
            handler = null;
        }
        return handler;
    }

    @NotNull
    public static final Thread runThread(@NotNull Function0<Unit> onThread) {
        Intrinsics.checkNotNullParameter(onThread, (String)"onThread");
        Thread thread = new Thread(() -> LibUtils.runThread$lambda-2(onThread));
        boolean bl = false;
        boolean bl2 = false;
        Thread $this$runThread_u24lambda_u2d3 = thread;
        boolean bl3 = false;
        $this$runThread_u24lambda_u2d3.start();
        return thread;
    }

    @NotNull
    public static final HandlerCanceller delayedMainThread(@NotNull TimeUnit delay, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(runnable, delay.getMillis());
        return HandlerExtKt.toHandlerCanceller(handler, runnable);
    }

    @NotNull
    public static final HandlerCanceller delayedMainThread(@NotNull TimeUnit delay, @NotNull Function0<Unit> onMain) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter(onMain, (String)"onMain");
        return LibUtils.delayedMainThread(delay, () -> LibUtils.delayedMainThread$lambda-4(onMain));
    }

    @NotNull
    public static final HandlerCanceller delayedThread(@NotNull TimeUnit delay, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        Handler handler = new Handler();
        handler.postDelayed(runnable, delay.getMillis());
        return HandlerExtKt.toHandlerCanceller(handler, runnable);
    }

    @NotNull
    public static final HandlerCanceller delayedThread(@NotNull TimeUnit delay, @NotNull Function0<Unit> onThread) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        Intrinsics.checkNotNullParameter(onThread, (String)"onThread");
        return LibUtils.delayedThread(delay, () -> LibUtils.delayedThread$lambda-5(onThread));
    }

    public static final boolean isMainThread() {
        return Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
    }

    public static final boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return Intrinsics.areEqual((Object)"mounted", (Object)state) || Intrinsics.areEqual((Object)"mounted_ro", (Object)state);
    }

    public static final int getNumberOfDigits(@NotNull Number number) throws NumberFormatException {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        String str = String.valueOf(number.longValue());
        return str.length();
    }

    @NotNull
    public static final String shrinkNumber(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        long l = number.longValue();
        return l < 1000L ? String.valueOf(l) : (l < 1000000L ? l / (long)1000 + "K+" : l / (long)1000000 + "M+");
    }

    public static final void openUrl(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        ContextCompat.startActivity((Context)context, (Intent)browserIntent, null);
    }

    public static final void copyToClipboard(@NotNull Context context, @NotNull String text, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)label, (CharSequence)text);
        Intrinsics.checkNotNullExpressionValue((Object)clipData, (String)"newPlainText(label, text)");
        ClipData clip = clipData;
        clipData = clipboard;
        if (clipData != null) {
            clipData.setPrimaryClip(clip);
        }
    }

    public static /* synthetic */ void copyToClipboard$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "Copied text";
        }
        LibUtils.copyToClipboard(context, string2, string3);
    }

    @Nullable
    public static final Drawable getDrawableByName(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ContextCompat.getDrawable((Context)context, (int)LibUtils.getDrawableResourceIdByName(context, name));
    }

    @DrawableRes
    public static final int getDrawableResourceIdByName(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        Resources resources2 = resources;
        return resources2.getIdentifier(name, "drawable", context.getPackageName());
    }

    @NotNull
    public static final <T> List<T> emptyMutableList() {
        return CollectionsKt.toMutableList((Collection)CollectionsKt.emptyList());
    }

    public static final float getDimension(@NotNull Context context, @DimenRes int res) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDimension(res) / context.getResources().getDisplayMetrics().density;
    }

    @ColorInt
    public static final int adjustAlpha(@ColorInt int color2, float factor) {
        int alpha = MathKt.roundToInt((float)((float)Color.alpha((int)color2) * factor));
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @NotNull
    public static final <T extends Number> Pair<T, T> getMinMax(@NotNull T first, @NotNull T second) {
        Intrinsics.checkNotNullParameter(first, (String)"first");
        Intrinsics.checkNotNullParameter(second, (String)"second");
        int n = first.intValue();
        int n2 = second.intValue();
        int n3 = 0;
        int min = Math.min(n, n2);
        n2 = first.intValue();
        n3 = second.intValue();
        boolean bl = false;
        int max = Math.max(n2, n3);
        return TuplesKt.to((Object)min, (Object)max);
    }

    private static final void mainThread$lambda-1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void runThread$lambda-2(Function0 $onThread) {
        Intrinsics.checkNotNullParameter((Object)$onThread, (String)"$onThread");
        $onThread.invoke();
    }

    private static final void delayedMainThread$lambda-4(Function0 $onMain) {
        Intrinsics.checkNotNullParameter((Object)$onMain, (String)"$onMain");
        $onMain.invoke();
    }

    private static final void delayedThread$lambda-5(Function0 $onThread) {
        Intrinsics.checkNotNullParameter((Object)$onThread, (String)"$onThread");
        $onThread.invoke();
    }
}

