/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.merseyside.utils.network.NetworkKt;
import com.merseyside.utils.network.NetworkStateListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/merseyside/utils/network/NetworkStateChangeReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "listener", "Lcom/merseyside/utils/network/NetworkStateListener;", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "setStateListener", "utils_release"})
public final class NetworkStateChangeReceiver
extends BroadcastReceiver {
    @Nullable
    private NetworkStateListener listener;

    public final void setStateListener(@NotNull NetworkStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        if (Intrinsics.areEqual((Object)"android.net.conn.CONNECTIVITY_CHANGE", (Object)intent.getAction())) {
            if (NetworkKt.isOnline(context)) {
                NetworkStateListener networkStateListener = this.listener;
                if (networkStateListener != null) {
                    networkStateListener.onConnectionState(true);
                }
            } else {
                NetworkStateListener networkStateListener = this.listener;
                if (networkStateListener != null) {
                    networkStateListener.onConnectionState(false);
                }
            }
        }
    }
}

