/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import com.merseyside.utils.ext.RecyclerExtKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/merseyside/utils/SnapOnScrollListener;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "snapHelper", "Landroidx/recyclerview/widget/SnapHelper;", "behavior", "Lcom/merseyside/utils/SnapOnScrollListener$Behavior;", "onSnapPositionChangeListener", "Lcom/merseyside/utils/SnapOnScrollListener$OnSnapPositionChangeListener;", "(Landroidx/recyclerview/widget/SnapHelper;Lcom/merseyside/utils/SnapOnScrollListener$Behavior;Lcom/merseyside/utils/SnapOnScrollListener$OnSnapPositionChangeListener;)V", "getBehavior", "()Lcom/merseyside/utils/SnapOnScrollListener$Behavior;", "setBehavior", "(Lcom/merseyside/utils/SnapOnScrollListener$Behavior;)V", "getOnSnapPositionChangeListener", "()Lcom/merseyside/utils/SnapOnScrollListener$OnSnapPositionChangeListener;", "setOnSnapPositionChangeListener", "(Lcom/merseyside/utils/SnapOnScrollListener$OnSnapPositionChangeListener;)V", "snapPosition", "", "maybeNotifySnapPositionChange", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onScrollStateChanged", "newState", "onScrolled", "dx", "dy", "Behavior", "OnSnapPositionChangeListener", "utils_release"})
public final class SnapOnScrollListener
extends RecyclerView.OnScrollListener {
    @NotNull
    private final SnapHelper snapHelper;
    @NotNull
    private Behavior behavior;
    @Nullable
    private OnSnapPositionChangeListener onSnapPositionChangeListener;
    private int snapPosition;

    public SnapOnScrollListener(@NotNull SnapHelper snapHelper, @NotNull Behavior behavior, @Nullable OnSnapPositionChangeListener onSnapPositionChangeListener) {
        Intrinsics.checkNotNullParameter((Object)snapHelper, (String)"snapHelper");
        Intrinsics.checkNotNullParameter((Object)((Object)behavior), (String)"behavior");
        this.snapHelper = snapHelper;
        this.behavior = behavior;
        this.onSnapPositionChangeListener = onSnapPositionChangeListener;
        this.snapPosition = -1;
    }

    public /* synthetic */ SnapOnScrollListener(SnapHelper snapHelper, Behavior behavior, OnSnapPositionChangeListener onSnapPositionChangeListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            behavior = Behavior.NOTIFY_ON_SCROLL;
        }
        if ((n & 4) != 0) {
            onSnapPositionChangeListener = null;
        }
        this(snapHelper, behavior, onSnapPositionChangeListener);
    }

    @NotNull
    public final Behavior getBehavior() {
        return this.behavior;
    }

    public final void setBehavior(@NotNull Behavior behavior) {
        Intrinsics.checkNotNullParameter((Object)((Object)behavior), (String)"<set-?>");
        this.behavior = behavior;
    }

    @Nullable
    public final OnSnapPositionChangeListener getOnSnapPositionChangeListener() {
        return this.onSnapPositionChangeListener;
    }

    public final void setOnSnapPositionChangeListener(@Nullable OnSnapPositionChangeListener onSnapPositionChangeListener) {
        this.onSnapPositionChangeListener = onSnapPositionChangeListener;
    }

    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        if (this.behavior == Behavior.NOTIFY_ON_SCROLL) {
            this.maybeNotifySnapPositionChange(recyclerView);
        }
    }

    public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        if (this.behavior == Behavior.NOTIFY_ON_SCROLL_STATE_IDLE && newState == 0) {
            this.maybeNotifySnapPositionChange(recyclerView);
        }
    }

    private final void maybeNotifySnapPositionChange(RecyclerView recyclerView) {
        boolean snapPositionChanged;
        int snapPosition = RecyclerExtKt.getSnapPosition(this.snapHelper, recyclerView);
        boolean bl = snapPositionChanged = this.snapPosition != snapPosition;
        if (snapPositionChanged) {
            OnSnapPositionChangeListener onSnapPositionChangeListener = this.onSnapPositionChangeListener;
            if (onSnapPositionChangeListener != null) {
                onSnapPositionChangeListener.onSnapPositionChange(snapPosition);
            }
            this.snapPosition = snapPosition;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/merseyside/utils/SnapOnScrollListener$OnSnapPositionChangeListener;", "", "onSnapPositionChange", "", "position", "", "utils_release"})
    public static interface OnSnapPositionChangeListener {
        public void onSnapPositionChange(int var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/merseyside/utils/SnapOnScrollListener$Behavior;", "", "(Ljava/lang/String;I)V", "NOTIFY_ON_SCROLL", "NOTIFY_ON_SCROLL_STATE_IDLE", "utils_release"})
    public static final class Behavior
    extends Enum<Behavior> {
        public static final /* enum */ Behavior NOTIFY_ON_SCROLL = new Behavior();
        public static final /* enum */ Behavior NOTIFY_ON_SCROLL_STATE_IDLE = new Behavior();
        private static final /* synthetic */ Behavior[] $VALUES;

        public static Behavior[] values() {
            Behavior[] behaviorArray = $VALUES;
            return Arrays.copyOf(behaviorArray, behaviorArray.length);
        }

        public static Behavior valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Behavior.class, value);
        }

        static {
            $VALUES = behaviorArray = new Behavior[]{Behavior.NOTIFY_ON_SCROLL, Behavior.NOTIFY_ON_SCROLL_STATE_IDLE};
        }
    }
}

