/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a8\u0006\f"}, d2={"Lcom/merseyside/utils/reflection/ReflectionUtils;", "", "()V", "getGenericParameterClass", "Ljava/lang/Class;", "actualClass", "genericClass", "parameterIndex", "", "getParameterTypeDeclarationIndex", "typeVariable", "Ljava/lang/reflect/TypeVariable;", "utils_release"})
public final class ReflectionUtils {
    @NotNull
    public static final ReflectionUtils INSTANCE;

    @NotNull
    public final Class<?> getGenericParameterClass(@NotNull Class<?> actualClass, @NotNull Class<?> genericClass, int parameterIndex) {
        Intrinsics.checkNotNullParameter(actualClass, (String)"actualClass");
        Intrinsics.checkNotNullParameter(genericClass, (String)"genericClass");
        Class<?> clazz = actualClass.getSuperclass();
        Intrinsics.checkNotNull(clazz);
        if (!genericClass.isAssignableFrom(clazz)) {
            throw (Throwable)new IllegalArgumentException("Class " + genericClass.getName() + " is not a superclass of " + actualClass.getName() + ".");
        }
        Stack<ParameterizedType> genericClasses = new Stack<ParameterizedType>();
        Class<?> clazz2 = actualClass;
        while (true) {
            Type rawType;
            Type type;
            Type genericSuperclass;
            if (clazz2.getGenericSuperclass() == null) {
                continue;
            }
            boolean isParameterizedType = genericSuperclass instanceof ParameterizedType;
            if (isParameterizedType) {
                Type type2 = genericSuperclass;
                if (type2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                genericClasses.push((ParameterizedType)type2);
            } else {
                genericClasses.clear();
            }
            if (isParameterizedType) {
                Type type3 = genericSuperclass;
                if (type3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                Type type4 = ((ParameterizedType)type3).getRawType();
                type = type4;
                Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"(genericSuperclass as ParameterizedType).rawType");
            } else {
                type = rawType = genericSuperclass;
            }
            if (!(Intrinsics.areEqual((Object)rawType, genericClass) ^ true)) break;
            Intrinsics.checkNotNull(clazz2.getSuperclass());
        }
        Object e = genericClasses.pop();
        Intrinsics.checkNotNullExpressionValue(e, (String)"genericClasses.pop()");
        Type type = ((ParameterizedType)e).getActualTypeArguments()[parameterIndex];
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"genericClasses.pop().act\u2026Arguments[parameterIndex]");
        Type result = type;
        while (result instanceof TypeVariable && !genericClasses.empty()) {
            int actualArgumentIndex = this.getParameterTypeDeclarationIndex((TypeVariable)result);
            Object e2 = genericClasses.pop();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"genericClasses.pop()");
            ParameterizedType type5 = (ParameterizedType)e2;
            Intrinsics.checkNotNullExpressionValue((Object)type5.getActualTypeArguments()[actualArgumentIndex], (String)"type.actualTypeArguments.get(actualArgumentIndex)");
        }
        if (result instanceof TypeVariable) {
            throw (Throwable)new IllegalStateException("Unable to resolve type variable " + result + "." + " Try to replace instances of parametrized class with its non-parameterized subtype.");
        }
        if (result instanceof ParameterizedType) {
            Type type6 = ((ParameterizedType)result).getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"result.rawType");
            result = type6;
        }
        if (!(result instanceof Class)) {
            throw (Throwable)new IllegalStateException("Actual parameter type for " + actualClass.getName() + " is not a Class.");
        }
        return (Class)result;
    }

    /*
     * WARNING - void declaration
     */
    public final int getParameterTypeDeclarationIndex(@NotNull TypeVariable<?> typeVariable) {
        Intrinsics.checkNotNullParameter(typeVariable, (String)"typeVariable");
        Object obj = typeVariable.getGenericDeclaration();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"typeVariable.genericDeclaration");
        Object genericDeclaration = obj;
        TypeVariable<?>[] typeVariableArray = genericDeclaration.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"genericDeclaration.typeParameters");
        TypeVariable<?>[] typeVariables = typeVariableArray;
        Integer actualArgumentIndex = null;
        int n = 0;
        int n2 = typeVariables.length;
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual(typeVariables[i], typeVariable)) {
                actualArgumentIndex = (int)i;
                break;
            }
            ++i;
        }
        Integer n3 = actualArgumentIndex;
        if (n3 == null) {
            throw (Throwable)new IllegalStateException("Argument " + typeVariable.toString() + " is not found in " + genericDeclaration.toString() + ".");
        }
        return n3;
    }

    private ReflectionUtils() {
    }

    static {
        ReflectionUtils reflectionUtils;
        INSTANCE = reflectionUtils = new ReflectionUtils();
    }
}

