/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.billing;

import com.merseyside.utils.time.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\bJ\b\u0010\f\u001a\u00020\rH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0004\u001b\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lcom/merseyside/utils/billing/Period;", "", "()V", "count", "", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "getHumanReadablePeriod", "toTimeUnit", "Lcom/merseyside/utils/time/TimeUnit;", "Companion", "Days", "FourWeeks", "FourteenDays", "Month", "OneMonth", "OneWeek", "OneYear", "SixMonth", "ThreeDays", "ThreeMonth", "Weeks", "Years", "Lcom/merseyside/utils/billing/Period$Days;", "Lcom/merseyside/utils/billing/Period$Weeks;", "Lcom/merseyside/utils/billing/Period$Month;", "Lcom/merseyside/utils/billing/Period$Years;", "utils_release"})
public abstract class Period {
    public static final Companion Companion = new Companion(null);

    public abstract int getCount();

    @NotNull
    public abstract String getUnit();

    @NotNull
    public final String getHumanReadablePeriod() {
        return "" + this.getCount() + ' ' + this.getUnit();
    }

    @NotNull
    public abstract TimeUnit toTimeUnit();

    private Period() {
    }

    public /* synthetic */ Period(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/billing/Period$Days;", "Lcom/merseyside/utils/billing/Period;", "count", "", "(I)V", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "toTimeUnit", "Lcom/merseyside/utils/time/TimeUnit;", "utils_release"})
    public static abstract class Days
    extends Period {
        private final int count;

        @Override
        @NotNull
        public String getUnit() {
            String str = "Day";
            if (this.getCount() > 1) {
                str = str + "s";
            }
            return str;
        }

        @Override
        @NotNull
        public TimeUnit toTimeUnit() {
            return com.merseyside.utils.time.Days.box-impl(com.merseyside.utils.time.Days.constructor-impl(this.getCount()));
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public Days(int count) {
            super(null);
            this.count = count;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/billing/Period$Weeks;", "Lcom/merseyside/utils/billing/Period;", "count", "", "(I)V", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "toTimeUnit", "Lcom/merseyside/utils/time/TimeUnit;", "utils_release"})
    public static abstract class Weeks
    extends Period {
        private final int count;

        @Override
        @NotNull
        public String getUnit() {
            String str = "Week";
            if (this.getCount() > 1) {
                str = str + "s";
            }
            return str;
        }

        @Override
        @NotNull
        public TimeUnit toTimeUnit() {
            return com.merseyside.utils.time.Days.box-impl(com.merseyside.utils.time.Days.constructor-impl(this.getCount() * 7));
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public Weeks(int count) {
            super(null);
            this.count = count;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/billing/Period$Month;", "Lcom/merseyside/utils/billing/Period;", "count", "", "(I)V", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "toTimeUnit", "Lcom/merseyside/utils/time/TimeUnit;", "utils_release"})
    public static abstract class Month
    extends Period {
        private final int count;

        @Override
        @NotNull
        public String getUnit() {
            return "Month";
        }

        @Override
        @NotNull
        public TimeUnit toTimeUnit() {
            return com.merseyside.utils.time.Days.box-impl(com.merseyside.utils.time.Days.constructor-impl(this.getCount() * 30));
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public Month(int count) {
            super(null);
            this.count = count;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/billing/Period$Years;", "Lcom/merseyside/utils/billing/Period;", "count", "", "(I)V", "getCount", "()I", "unit", "", "getUnit", "()Ljava/lang/String;", "toTimeUnit", "Lcom/merseyside/utils/time/TimeUnit;", "utils_release"})
    public static abstract class Years
    extends Period {
        private final int count;

        @Override
        @NotNull
        public String getUnit() {
            String str = "Year";
            if (this.getCount() > 1) {
                str = str + "s";
            }
            return str;
        }

        @Override
        @NotNull
        public TimeUnit toTimeUnit() {
            return com.merseyside.utils.time.Days.box-impl(com.merseyside.utils.time.Days.constructor-impl(this.getCount() * 365));
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public Years(int count) {
            super(null);
            this.count = count;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$ThreeDays;", "Lcom/merseyside/utils/billing/Period$Days;", "()V", "utils_release"})
    public static final class ThreeDays
    extends Days {
        public static final ThreeDays INSTANCE;

        private ThreeDays() {
            super(3);
        }

        static {
            ThreeDays threeDays;
            INSTANCE = threeDays = new ThreeDays();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$OneWeek;", "Lcom/merseyside/utils/billing/Period$Weeks;", "()V", "utils_release"})
    public static final class OneWeek
    extends Weeks {
        public static final OneWeek INSTANCE;

        private OneWeek() {
            super(1);
        }

        static {
            OneWeek oneWeek;
            INSTANCE = oneWeek = new OneWeek();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$FourteenDays;", "Lcom/merseyside/utils/billing/Period$Days;", "()V", "utils_release"})
    public static final class FourteenDays
    extends Days {
        public static final FourteenDays INSTANCE;

        private FourteenDays() {
            super(14);
        }

        static {
            FourteenDays fourteenDays;
            INSTANCE = fourteenDays = new FourteenDays();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$FourWeeks;", "Lcom/merseyside/utils/billing/Period$Weeks;", "()V", "utils_release"})
    public static final class FourWeeks
    extends Weeks {
        public static final FourWeeks INSTANCE;

        private FourWeeks() {
            super(4);
        }

        static {
            FourWeeks fourWeeks;
            INSTANCE = fourWeeks = new FourWeeks();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$OneMonth;", "Lcom/merseyside/utils/billing/Period$Month;", "()V", "utils_release"})
    public static final class OneMonth
    extends Month {
        public static final OneMonth INSTANCE;

        private OneMonth() {
            super(1);
        }

        static {
            OneMonth oneMonth;
            INSTANCE = oneMonth = new OneMonth();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$ThreeMonth;", "Lcom/merseyside/utils/billing/Period$Month;", "()V", "utils_release"})
    public static final class ThreeMonth
    extends Month {
        public static final ThreeMonth INSTANCE;

        private ThreeMonth() {
            super(3);
        }

        static {
            ThreeMonth threeMonth;
            INSTANCE = threeMonth = new ThreeMonth();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$SixMonth;", "Lcom/merseyside/utils/billing/Period$Month;", "()V", "utils_release"})
    public static final class SixMonth
    extends Month {
        public static final SixMonth INSTANCE;

        private SixMonth() {
            super(6);
        }

        static {
            SixMonth sixMonth;
            INSTANCE = sixMonth = new SixMonth();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/merseyside/utils/billing/Period$OneYear;", "Lcom/merseyside/utils/billing/Period$Years;", "()V", "utils_release"})
    public static final class OneYear
    extends Years {
        public static final OneYear INSTANCE;

        private OneYear() {
            super(1);
        }

        static {
            OneYear oneYear;
            INSTANCE = oneYear = new OneYear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/merseyside/utils/billing/Period$Companion;", "", "()V", "stringToPeriod", "Lcom/merseyside/utils/billing/Period;", "period", "", "utils_release"})
    public static final class Companion {
        @NotNull
        public final Period stringToPeriod(@NotNull String period) {
            Period period2;
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            switch (period) {
                case "P3D": {
                    period2 = ThreeDays.INSTANCE;
                    break;
                }
                case "P1W": {
                    period2 = OneWeek.INSTANCE;
                    break;
                }
                case "P14D": {
                    period2 = FourteenDays.INSTANCE;
                    break;
                }
                case "P4W": {
                    period2 = FourWeeks.INSTANCE;
                    break;
                }
                case "P1M": {
                    period2 = OneMonth.INSTANCE;
                    break;
                }
                case "P3M": {
                    period2 = ThreeMonth.INSTANCE;
                    break;
                }
                case "P6M": {
                    period2 = SixMonth.INSTANCE;
                    break;
                }
                case "P1Y": {
                    period2 = OneYear.INSTANCE;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException();
                }
            }
            return period2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

