/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.billing;

import android.text.TextUtils;
import android.util.Base64;
import com.android.billingclient.util.BillingHelper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002J$\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/merseyside/utils/billing/Security;", "", "()V", "KEY_FACTORY_ALGORITHM", "", "SIGNATURE_ALGORITHM", "TAG", "generatePublicKey", "Ljava/security/PublicKey;", "encodedPublicKey", "verify", "", "publicKey", "signedData", "signature", "verifyPurchase", "base64PublicKey", "utils_release"})
public final class Security {
    private static final String TAG = "IABUtil/Security";
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    public static final Security INSTANCE;

    public final boolean verifyPurchase(@Nullable String base64PublicKey, @NotNull String signedData, @Nullable String signature) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)signedData, (String)"signedData");
        if (TextUtils.isEmpty((CharSequence)signedData) || TextUtils.isEmpty((CharSequence)base64PublicKey) || TextUtils.isEmpty((CharSequence)signature)) {
            BillingHelper.logWarn((String)TAG, (String)"Purchase verification failed: missing data.");
            return false;
        }
        PublicKey key = this.generatePublicKey(base64PublicKey);
        return this.verify(key, signedData, signature);
    }

    private final PublicKey generatePublicKey(String encodedPublicKey) throws IOException {
        PublicKey publicKey;
        try {
            byte[] byArray = Base64.decode((String)encodedPublicKey, (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(encodedPublicKey, Base64.DEFAULT)");
            byte[] decodedKey = byArray;
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            Intrinsics.checkExpressionValueIsNotNull((Object)keyFactory, (String)"KeyFactory.getInstance(KEY_FACTORY_ALGORITHM)");
            KeyFactory keyFactory2 = keyFactory;
            PublicKey publicKey2 = keyFactory2.generatePublic(new X509EncodedKeySpec(decodedKey));
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey2, (String)"keyFactory.generatePubli\u2026codedKeySpec(decodedKey))");
            publicKey = publicKey2;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            String msg = "Invalid key specification: " + e;
            BillingHelper.logWarn((String)TAG, (String)msg);
            throw (Throwable)new IOException(msg);
        }
        return publicKey;
    }

    private final boolean verify(PublicKey publicKey, String signedData, String signature) {
        byte[] byArray;
        try {
            byte[] byArray2 = Base64.decode((String)signature, (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Base64.decode(signature, Base64.DEFAULT)");
            byArray = byArray2;
        }
        catch (IllegalArgumentException e) {
            BillingHelper.logWarn((String)TAG, (String)"Base64 decoding failed.");
            return false;
        }
        byte[] signatureBytes = byArray;
        try {
            Signature signature2 = Signature.getInstance(SIGNATURE_ALGORITHM);
            Intrinsics.checkExpressionValueIsNotNull((Object)signature2, (String)"Signature.getInstance(SIGNATURE_ALGORITHM)");
            Signature signatureAlgorithm = signature2;
            signatureAlgorithm.initVerify(publicKey);
            String string2 = signedData;
            Signature signature3 = signatureAlgorithm;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray3 = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray4 = byArray3;
            signature3.update(byArray4);
            if (!signatureAlgorithm.verify(signatureBytes)) {
                BillingHelper.logWarn((String)TAG, (String)"Signature verification failed.");
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            BillingHelper.logWarn((String)TAG, (String)"Invalid key specification.");
        }
        catch (SignatureException e) {
            BillingHelper.logWarn((String)TAG, (String)"Signature exception.");
        }
        return false;
    }

    private Security() {
    }

    static {
        Security security;
        INSTANCE = security = new Security();
    }
}

