/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.merseyLib.utils.time;

import android.annotation.SuppressLint;
import android.content.Context;
import com.merseyside.merseyLib.utils.LocaleManager;
import com.merseyside.merseyLib.utils.time.Millis;
import com.merseyside.merseyLib.utils.time.TimeUnit;
import com.merseyside.merseyLib.utils.time.TimeZone;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0004\u001a\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\"\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a$\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u001a\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000f"}, d2={"getCurrentTimeMillis", "", "timeZone", "Lcom/merseyside/merseyLib/utils/time/TimeZone;", "", "getCurrentTimeUnit", "Lcom/merseyside/merseyLib/utils/time/TimeUnit;", "getDate", "timestamp", "context", "Landroid/content/Context;", "getDateWithTime", "getFormattedDate", "pattern", "getHoursMinutes", "utils_release"})
public final class TimeKt {
    public static final long getCurrentTimeMillis(@NotNull TimeZone timeZone) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeZone), (String)"timeZone");
        return TimeKt.getCurrentTimeMillis(timeZone.name());
    }

    public static /* synthetic */ long getCurrentTimeMillis$default(TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = TimeZone.GMT;
        }
        return TimeKt.getCurrentTimeMillis(timeZone);
    }

    public static final long getCurrentTimeMillis(@NotNull String timeZone) {
        java.util.TimeZone value;
        Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
        String string = timeZone;
        java.util.TimeZone timeZone2 = Intrinsics.areEqual((Object)string, (Object)TimeZone.SYSTEM.name()) ? null : (value = Intrinsics.areEqual((Object)string, (Object)TimeZone.GMT.name()) ? java.util.TimeZone.getTimeZone("GMT") : java.util.TimeZone.getTimeZone(timeZone));
        if (value == null) {
            java.util.TimeZone timeZone3 = java.util.TimeZone.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)timeZone3, (String)"java.util.TimeZone.getDefault()");
            int n = timeZone3.getRawOffset();
            java.util.TimeZone timeZone4 = java.util.TimeZone.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)timeZone4, (String)"java.util.TimeZone.getDefault()");
            int offset = n + timeZone4.getDSTSavings();
            return System.currentTimeMillis() + (long)offset;
        }
        Calendar calendar = Calendar.getInstance(java.util.TimeZone.getTimeZone("GMT"));
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance(jav\u2026eZone.getTimeZone(\"GMT\"))");
        return calendar.getTimeInMillis();
    }

    @NotNull
    public static final TimeUnit getCurrentTimeUnit(@NotNull TimeZone timeZone) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeZone), (String)"timeZone");
        return TimeKt.getCurrentTimeUnit(timeZone.name());
    }

    public static /* synthetic */ TimeUnit getCurrentTimeUnit$default(TimeZone timeZone, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = TimeZone.GMT;
        }
        return TimeKt.getCurrentTimeUnit(timeZone);
    }

    @NotNull
    public static final TimeUnit getCurrentTimeUnit(@NotNull String timeZone) {
        Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
        return Millis.box-impl(Millis.constructor-impl(TimeKt.getCurrentTimeMillis(timeZone)));
    }

    @NotNull
    public static final String getHoursMinutes(long timestamp, @Nullable Context context) {
        return TimeKt.getFormattedDate(timestamp, "hh:mm", context);
    }

    public static /* synthetic */ String getHoursMinutes$default(long l, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        return TimeKt.getHoursMinutes(l, context);
    }

    @NotNull
    public static final String getHoursMinutes(@NotNull TimeUnit timestamp, @Nullable Context context) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return TimeKt.getHoursMinutes(timestamp.toMillisLong(), context);
    }

    public static /* synthetic */ String getHoursMinutes$default(TimeUnit timeUnit, Context context, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        return TimeKt.getHoursMinutes(timeUnit, context);
    }

    @NotNull
    public static final String getDate(long timestamp, @Nullable Context context) {
        return TimeKt.getFormattedDate(timestamp, "dd.MM.YYYY", context);
    }

    @NotNull
    public static final String getDate(@NotNull TimeUnit timestamp, @Nullable Context context) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return TimeKt.getDate(timestamp.toMillisLong(), context);
    }

    @NotNull
    public static final String getDateWithTime(long timestamp, @Nullable Context context) {
        return TimeKt.getFormattedDate(timestamp, "dd-MM-YYYY hh:mm", context);
    }

    @NotNull
    public static final String getDateWithTime(@NotNull TimeUnit timestamp, @Nullable Context context) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        return TimeKt.getDateWithTime(timestamp.toMillisLong(), context);
    }

    @NotNull
    public static final String getFormattedDate(@NotNull TimeUnit timestamp, @NotNull String pattern, @Nullable Context context) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        return TimeKt.getFormattedDate(timestamp.toMillisLong(), pattern, context);
    }

    public static /* synthetic */ String getFormattedDate$default(TimeUnit timeUnit, String string, Context context, int n, Object object) {
        if ((n & 4) != 0) {
            context = null;
        }
        return TimeKt.getFormattedDate(timeUnit, string, context);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    @NotNull
    public static final String getFormattedDate(long timestamp, @NotNull String pattern, @Nullable Context context) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Locale locale = null;
        if (context != null) {
            locale = new LocaleManager(context).getCurrentLocale();
        }
        try {
            SimpleDateFormat sdf = locale != null ? new SimpleDateFormat(pattern, locale) : new SimpleDateFormat(pattern);
            Date netDate = new Date(timestamp);
            String string2 = sdf.format(netDate);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sdf.format(netDate)");
            string = string2;
        }
        catch (Exception e) {
            string = e.toString();
        }
        return string;
    }

    public static /* synthetic */ String getFormattedDate$default(long l, String string, Context context, int n, Object object) {
        if ((n & 4) != 0) {
            context = null;
        }
        return TimeKt.getFormattedDate(l, string, context);
    }
}

