/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy.presentation.view.animatedCheckButton;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatButton;
import com.merseyside.animators.AnimatorList;
import com.merseyside.animators.Approach;
import com.merseyside.animators.BaseAnimator;
import com.merseyside.animators.animator.ColorAnimator;
import com.merseyside.archy.R;
import com.merseyside.archy.presentation.view.animatedCheckButton.AnimatedCheckButton;
import com.merseyside.archy.presentation.view.animatedCheckButton.ICheckableView;
import com.merseyside.utils.Logger;
import com.merseyside.utils.ext.CollectionExtKt;
import com.merseyside.utils.ext.DrawableExtKt;
import com.merseyside.utils.ext.StringExtKt;
import com.merseyside.utils.ext.ViewExtKt;
import com.merseyside.utils.time.Millis;
import com.merseyside.utils.time.TimeUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020(H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u00100\u001a\u00020(2\b\b\u0001\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u00101\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u00102\u001a\u00020(2\b\b\u0001\u0010\u000f\u001a\u00020\u000bJ\u000e\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020\rJ\u0010\u00105\u001a\u00020(2\b\b\u0001\u0010\u000f\u001a\u00020\u000bJ\u000e\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u0013J\u0012\u00108\u001a\u00020(2\b\b\u0001\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u00109\u001a\u00020(2\b\b\u0001\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010:\u001a\u00020(2\u0006\u00104\u001a\u00020\rJ\u0010\u0010;\u001a\u00020(2\b\b\u0001\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010<\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020(2\b\b\u0001\u0010\u000f\u001a\u00020\u000bJ\u001a\u0010=\u001a\u00020(2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR&\u0010!\u001a\u0004\u0018\u00010\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u000b8\u0002@BX\u0083\u000e\u00a2\u0006\n\n\u0002\u0010$\"\u0004\b\"\u0010#R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/merseyside/archy/presentation/view/animatedCheckButton/AnimatedCheckButton;", "Landroidx/appcompat/widget/AppCompatButton;", "Lcom/merseyside/archy/presentation/view/animatedCheckButton/ICheckableView;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "animator", "Lcom/merseyside/animators/AnimatorList;", "checkedColor", "", "checkedText", "", "checkedTextColor", "color", "defaultText", "defaultTextColor", "isCheckable", "", "()Z", "setCheckable", "(Z)V", "isChecked", "isClickableWhenTransition", "isInitialized", "listener", "Lcom/merseyside/archy/presentation/view/animatedCheckButton/ICheckableView$OnCheckedListener;", "getListener", "()Lcom/merseyside/archy/presentation/view/animatedCheckButton/ICheckableView$OnCheckedListener;", "setListener", "(Lcom/merseyside/archy/presentation/view/animatedCheckButton/ICheckableView$OnCheckedListener;)V", "value", "middleColor", "setMiddleColor", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "onClick", "Lkotlin/Function1;", "Landroid/view/View;", "", "animateState", "changeState", "doLayout", "getDrawables", "", "Landroid/graphics/drawable/Drawable;", "loadAttrs", "setBackground", "setChecked", "setCheckedColor", "setCheckedText", "text", "setCheckedTextColor", "setClickableWhenTransition", "isClickable", "setCompoundDrawablesColor", "setDefaultColor", "setDefaultText", "setDefaultTextColor", "setForceChecked", "setOnClick", "click", "Companion", "archy_release"})
public final class AnimatedCheckButton
extends AppCompatButton
implements ICheckableView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ICheckableView.OnCheckedListener listener;
    @Nullable
    private AnimatorList animator;
    @Nullable
    private String defaultText;
    @Nullable
    private String checkedText;
    private boolean isInitialized;
    private boolean isChecked;
    private boolean isCheckable;
    private boolean isClickableWhenTransition;
    @NotNull
    private Function1<? super View, Unit> onClick;
    @ColorInt
    private int color;
    @ColorInt
    @Nullable
    private Integer middleColor;
    @ColorInt
    private int checkedColor;
    @ColorInt
    private int defaultTextColor;
    @ColorInt
    private int checkedTextColor;
    private static final int NO_VALUE = -2;
    private static long duration = Millis.constructor-impl((long)400L);

    public AnimatedCheckButton(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.isCheckable = true;
        this.onClick = onClick.1.INSTANCE;
        this.color = -2;
        this.checkedColor = -2;
        this.defaultTextColor = -2;
        this.checkedTextColor = -2;
        this.loadAttrs(attributeSet);
        this.doLayout();
    }

    @Override
    @Nullable
    public ICheckableView.OnCheckedListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable ICheckableView.OnCheckedListener onCheckedListener) {
        this.listener = onCheckedListener;
    }

    @Override
    public boolean isCheckable() {
        return this.isCheckable;
    }

    @Override
    public void setCheckable(boolean bl) {
        this.isCheckable = bl;
    }

    private final void setMiddleColor(Integer value) {
        Integer n = value;
        int n2 = -2;
        this.middleColor = n != null && n == n2 ? (Integer)null : value;
    }

    private final void loadAttrs(AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.AnimatedCheckButton, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attributeSet, R.styleable.AnimatedCheckButton, 0, 0)");
        TypedArray array = typedArray;
        this.setCheckable(array.getBoolean(R.styleable.AnimatedCheckButton_android_checkable, this.isCheckable()));
        this.color = array.getColor(R.styleable.AnimatedCheckButton_color, -2);
        this.setMiddleColor((Integer)array.getColor(R.styleable.AnimatedCheckButton_middleColor, -2));
        this.checkedColor = array.getColor(R.styleable.AnimatedCheckButton_checkedColor, -2);
        duration = Millis.constructor-impl((long)array.getInteger(R.styleable.AnimatedCheckButton_duration, 400));
        this.isChecked = array.getBoolean(R.styleable.AnimatedCheckButton_android_checked, false);
        this.checkedTextColor = array.getColor(R.styleable.AnimatedCheckButton_checkedTextColor, -2);
        this.defaultTextColor = array.getColor(R.styleable.AnimatedCheckButton_defaultTextColor, -2);
        this.defaultText = array.getString(R.styleable.AnimatedCheckButton_defaultText);
        this.checkedText = array.getString(R.styleable.AnimatedCheckButton_checkedText);
        array.recycle();
    }

    private final void doLayout() {
        this.setForceChecked(this.isChecked);
        ViewExtKt.onClick((View)((View)this), (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AnimatedCheckButton this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AnimatedCheckButton.access$getOnClick$p(this.this$0).invoke((Object)this.this$0);
                if (this.this$0.isCheckable()) {
                    AnimatedCheckButton.access$setChecked$p(this.this$0, !AnimatedCheckButton.access$isChecked$p(this.this$0));
                    AnimatedCheckButton.access$changeState(this.this$0);
                }
            }
        }));
        this.isInitialized = true;
    }

    private final void changeState() {
        ICheckableView.OnCheckedListener onCheckedListener = this.getListener();
        if (onCheckedListener != null) {
            onCheckedListener.onChecked(this.isChecked);
        }
        this.animateState();
    }

    private final void setBackground(@ColorInt int color) {
        if (color != -2) {
            Drawable drawable = this.getBackground().mutate();
            Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"background.mutate()");
            Drawable drawable2 = drawable;
            Logger.INSTANCE.log((Object)this, (Object)drawable2);
            DrawableExtKt.setColor((Drawable)drawable2, (int)color);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void animateState() {
        AnimatorList animatorList;
        if (this.animator == null) {
            Unit unit;
            ColorAnimator.Builder $this$animateState_u24lambda_u2d2_u24lambda_u2d0;
            Object[] objectArray;
            void var12_11;
            boolean bl;
            boolean bl2;
            ColorAnimator.Builder builder;
            void $this$animateState_u24lambda_u2d2;
            animatorList = new AnimatorList(Approach.TOGETHER);
            boolean bl3 = false;
            boolean bl4 = false;
            AnimatorList animatorList2 = animatorList;
            AnimatedCheckButton animatedCheckButton = this;
            boolean bl5 = false;
            $this$animateState_u24lambda_u2d2.setLegacyReverse(true);
            if (this.color != -2 && this.checkedColor != -2) {
                builder = new ColorAnimator.Builder((View)this, null, (TimeUnit)Millis.box-impl((long)duration), null, false, 26, null);
                bl2 = false;
                bl = false;
                ColorAnimator.Builder builder2 = builder;
                var12_11 = $this$animateState_u24lambda_u2d2;
                boolean bl6 = false;
                objectArray = new Integer[]{this.color, this.middleColor, this.checkedColor};
                int[] nArray = CollectionsKt.toIntArray((Collection)CollectionsKt.listOfNotNull((Object[])objectArray));
                $this$animateState_u24lambda_u2d2_u24lambda_u2d0.values(Arrays.copyOf(nArray, nArray.length));
                unit = Unit.INSTANCE;
                ColorAnimator.Builder builder3 = builder;
                var12_11.addAnimator((BaseAnimator)new ColorAnimator(builder3));
            }
            if (this.defaultTextColor != -2 && this.checkedTextColor != -2) {
                void $this$animateState_u24lambda_u2d2_u24lambda_u2d1;
                builder = new ColorAnimator.Builder((View)this, null, (TimeUnit)Millis.box-impl((long)duration), "textColor", false, 18, null);
                bl2 = false;
                bl = false;
                $this$animateState_u24lambda_u2d2_u24lambda_u2d0 = builder;
                var12_11 = $this$animateState_u24lambda_u2d2;
                boolean bl7 = false;
                objectArray = new int[2];
                objectArray[0] = this.defaultTextColor;
                objectArray[1] = this.checkedTextColor;
                $this$animateState_u24lambda_u2d2_u24lambda_u2d1.values((int[])objectArray);
                unit = Unit.INSTANCE;
                ColorAnimator.Builder builder4 = builder;
                var12_11.addAnimator((BaseAnimator)new ColorAnimator(builder4));
                CollectionExtKt.forEachNotNull(this.getDrawables(), (Function1)((Function1)new Function1<Drawable, Unit>((AnimatorList)$this$animateState_u24lambda_u2d2, this){
                    final /* synthetic */ AnimatorList $this_apply;
                    final /* synthetic */ AnimatedCheckButton this$0;
                    {
                        this.$this_apply = $receiver;
                        this.this$0 = $receiver2;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Drawable drawable) {
                        void $this$invoke_u24lambda_u2d0;
                        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
                        ColorAnimator.Builder builder = new ColorAnimator.Builder(null, drawable, (TimeUnit)Millis.box-impl((long)AnimatedCheckButton.access$getDuration$cp()), null, true, 9, null);
                        AnimatedCheckButton animatedCheckButton = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        ColorAnimator.Builder builder2 = builder;
                        AnimatorList animatorList = this.$this_apply;
                        boolean bl3 = false;
                        int[] nArray = new int[]{AnimatedCheckButton.access$getDefaultTextColor$p(animatedCheckButton), AnimatedCheckButton.access$getCheckedTextColor$p(animatedCheckButton)};
                        $this$invoke_u24lambda_u2d0.values(nArray);
                        Unit unit = Unit.INSTANCE;
                        ColorAnimator.Builder builder3 = builder;
                        animatorList.addAnimator((BaseAnimator)new ColorAnimator(builder3));
                    }
                }));
            }
            Unit unit2 = Unit.INSTANCE;
            animatedCheckButton.animator = animatorList;
        }
        if (!this.isClickableWhenTransition) {
            this.setClickable(false);
            animatorList = this.animator;
            Intrinsics.checkNotNull((Object)animatorList);
            animatorList.setOnEndCallback((Function2)new Function2<Animator, Boolean, Unit>(this){
                final /* synthetic */ AnimatedCheckButton this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@Nullable Animator $noName_0, boolean $noName_1) {
                    this.this$0.setClickable(true);
                }
            });
        }
        if (this.isChecked) {
            if (this.checkedText != null) {
                this.setText(this.checkedText);
            }
            animatorList = this.animator;
            Intrinsics.checkNotNull((Object)animatorList);
            animatorList.start();
        } else {
            if (this.defaultText != null) {
                this.setText(this.defaultText);
            }
            animatorList = this.animator;
            Intrinsics.checkNotNull((Object)animatorList);
            animatorList.reverse();
        }
    }

    private final List<Drawable> getDrawables() {
        Drawable[] drawableArray = this.getCompoundDrawablesRelative();
        Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"compoundDrawablesRelative");
        return ArraysKt.toList((Object[])drawableArray);
    }

    private final void setCompoundDrawablesColor(@ColorInt int color) {
        CollectionExtKt.forEachNotNull(this.getDrawables(), (Function1)((Function1)new Function1<Drawable, Unit>(color){
            final /* synthetic */ int $color;
            {
                this.$color = $color;
                super(1);
            }

            public final void invoke(@NotNull Drawable compoundDrawable) {
                Intrinsics.checkNotNullParameter((Object)compoundDrawable, (String)"compoundDrawable");
                compoundDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.$color, PorterDuff.Mode.SRC_IN));
            }
        }));
    }

    @Override
    public boolean isChecked() {
        return this.isChecked;
    }

    @Override
    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
        if (this.isInitialized) {
            this.changeState();
        }
    }

    @Override
    public void setForceChecked(boolean isChecked) {
        CharSequence charSequence;
        this.isChecked = isChecked;
        if (isChecked) {
            this.setBackground(this.checkedColor);
            if (this.checkedTextColor != -2) {
                this.setTextColor(this.checkedTextColor);
                this.setCompoundDrawablesColor(this.checkedTextColor);
            }
            charSequence = StringExtKt.isNotNullAndEmpty((String)this.checkedText) ? (CharSequence)this.checkedText : this.getText();
        } else {
            this.setBackground(this.color);
            if (this.color != -2) {
                this.setTextColor(this.defaultTextColor);
                this.setCompoundDrawablesColor(this.defaultTextColor);
            }
            charSequence = StringExtKt.isNotNullAndEmpty((String)this.defaultText) ? (CharSequence)this.defaultText : this.getText();
        }
        this.setText(charSequence);
    }

    public final void setDefaultColor(@ColorInt int color) {
        this.color = color;
        this.animator = null;
    }

    public final void setMiddleColor(@ColorInt int color) {
        this.setMiddleColor((Integer)color);
    }

    public final void setCheckedColor(@ColorInt int color) {
        this.checkedColor = color;
        this.animator = null;
    }

    public final void setDefaultTextColor(@ColorInt int color) {
        this.defaultTextColor = color;
        this.animator = null;
    }

    public final void setCheckedTextColor(@ColorInt int color) {
        this.checkedTextColor = color;
        this.animator = null;
    }

    public final void setDefaultText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.defaultText = text;
    }

    public final void setCheckedText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.checkedText = text;
    }

    public final void setClickableWhenTransition(boolean isClickable) {
        this.isClickableWhenTransition = isClickable;
    }

    public final void setOnClick(@NotNull Function1<? super View, Unit> click) {
        Intrinsics.checkNotNullParameter(click, (String)"click");
        this.onClick = click;
    }

    @Override
    public void setOnCheckedListener(@NotNull ICheckableView.OnCheckedListener listener) {
        ICheckableView.DefaultImpls.setOnCheckedListener(this, listener);
    }

    public static final /* synthetic */ Function1 access$getOnClick$p(AnimatedCheckButton $this) {
        return $this.onClick;
    }

    public static final /* synthetic */ void access$setChecked$p(AnimatedCheckButton $this, boolean bl) {
        $this.isChecked = bl;
    }

    public static final /* synthetic */ boolean access$isChecked$p(AnimatedCheckButton $this) {
        return $this.isChecked;
    }

    public static final /* synthetic */ void access$changeState(AnimatedCheckButton $this) {
        $this.changeState();
    }

    public static final /* synthetic */ long access$getDuration$cp() {
        return duration;
    }

    public static final /* synthetic */ int access$getDefaultTextColor$p(AnimatedCheckButton $this) {
        return $this.defaultTextColor;
    }

    public static final /* synthetic */ int access$getCheckedTextColor$p(AnimatedCheckButton $this) {
        return $this.checkedTextColor;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\b"}, d2={"Lcom/merseyside/archy/presentation/view/animatedCheckButton/AnimatedCheckButton$Companion;", "", "()V", "NO_VALUE", "", "duration", "Lcom/merseyside/utils/time/Millis;", "J", "archy_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

