/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.adapters.base;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.paging.PagedListAdapter;
import androidx.recyclerview.widget.DiffUtil;
import com.merseyside.adapters.callback.HasOnItemClickListener;
import com.merseyside.adapters.callback.OnItemClickListener;
import com.merseyside.adapters.model.AdapterViewModel;
import com.merseyside.adapters.view.BaseBindingHolder;
import com.merseyside.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00060\u00052\b\u0012\u0004\u0012\u0002H\u00010\u0007:\u000201B\u0013\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H$J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H$J\b\u0010\u001c\u001a\u00020\u0017H\u0017J\b\u0010\u001d\u001a\u00020\u0012H\u0014J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0018\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0016J\u001a\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.J\u001c\u0010/\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H\u0002R\"\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/merseyside/adapters/base/PagedAdapter;", "M", "", "T", "Lcom/merseyside/adapters/model/AdapterViewModel;", "Landroidx/paging/PagedListAdapter;", "Lcom/merseyside/adapters/view/BaseBindingHolder;", "Lcom/merseyside/adapters/callback/HasOnItemClickListener;", "diffUtil", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "(Landroidx/recyclerview/widget/DiffUtil$ItemCallback;)V", "listener", "Lcom/merseyside/adapters/callback/OnItemClickListener;", "getListener", "()Lcom/merseyside/adapters/callback/OnItemClickListener;", "setListener", "(Lcom/merseyside/adapters/callback/OnItemClickListener;)V", "networkState", "Lcom/merseyside/adapters/base/PagedAdapter$INetworkState;", "createItemViewModel", "obj", "(Ljava/lang/Object;)Lcom/merseyside/adapters/model/AdapterViewModel;", "getBindingVariable", "", "getItemCount", "getItemViewType", "position", "getLayoutIdForPosition", "getNetworkConnectionLayout", "getNetworkConnectionModel", "getViewHolder", "binding", "Landroidx/databinding/ViewDataBinding;", "hasExtraRow", "", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setNetworkState", "newNetworkState", "Lcom/merseyside/adapters/base/PagedAdapter$NetworkState;", "msg", "", "setupNetworkItem", "INetworkState", "NetworkState", "adapters_release"})
public abstract class PagedAdapter<M, T extends AdapterViewModel<M>>
extends PagedListAdapter<M, BaseBindingHolder>
implements HasOnItemClickListener<M> {
    @Nullable
    private OnItemClickListener<M> listener;
    @Nullable
    private INetworkState networkState;

    public PagedAdapter(@NotNull DiffUtil.ItemCallback<M> diffUtil) {
        Intrinsics.checkNotNullParameter(diffUtil, (String)"diffUtil");
        super(diffUtil);
    }

    @Override
    @Nullable
    public OnItemClickListener<M> getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable OnItemClickListener<M> onItemClickListener) {
        this.listener = onItemClickListener;
    }

    @NotNull
    public BaseBindingHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(parent.context)");
        LayoutInflater layoutInflater2 = layoutInflater;
        ViewDataBinding viewDataBinding = DataBindingUtil.inflate((LayoutInflater)layoutInflater2, (int)viewType, (ViewGroup)parent, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)viewDataBinding, (String)"inflate(layoutInflater, viewType, parent, false)");
        ViewDataBinding binding = viewDataBinding;
        return this.getViewHolder(binding);
    }

    @NotNull
    protected abstract T createItemViewModel(@NotNull M var1);

    protected abstract int getLayoutIdForPosition(int var1);

    protected abstract int getBindingVariable();

    @NotNull
    protected INetworkState getNetworkConnectionModel() {
        throw new IllegalArgumentException("You have to override this methodin order to use network states");
    }

    public int getItemViewType(int position) {
        return this.hasExtraRow() && position == this.getItemCount() - 1 ? this.getNetworkConnectionLayout() : this.getLayoutIdForPosition(position);
    }

    public void onBindViewHolder(@NotNull BaseBindingHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        if (this.hasExtraRow() && position == this.getItemCount() - 1) {
            int n = this.getBindingVariable();
            INetworkState iNetworkState = this.networkState;
            Intrinsics.checkNotNull((Object)iNetworkState);
            holder.bind(n, iNetworkState);
        } else {
            Object obj = this.getItem(position);
            if (obj != null) {
                holder.bind(this.getBindingVariable(), this.createItemViewModel(obj));
                holder.itemView.setOnClickListener(arg_0 -> PagedAdapter.onBindViewHolder$lambda-0(this, obj, arg_0));
            }
        }
    }

    @NotNull
    public BaseBindingHolder getViewHolder(@NotNull ViewDataBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        return new BaseBindingHolder(binding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasExtraRow() {
        if (this.networkState == null) return false;
        INetworkState iNetworkState = this.networkState;
        Intrinsics.checkNotNull((Object)iNetworkState);
        if (iNetworkState.getNetworkState() == NetworkState.CONNECTED) return false;
        return true;
    }

    @LayoutRes
    public int getNetworkConnectionLayout() {
        return 0;
    }

    public int getItemCount() {
        return super.getItemCount() + (this.hasExtraRow() ? 1 : 0);
    }

    public final void setNetworkState(@NotNull NetworkState newNetworkState, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)newNetworkState), (String)"newNetworkState");
        Logger.INSTANCE.log((Object)this, (Object)Intrinsics.stringPlus((String)"set network state ", (Object)((Object)newNetworkState)));
        if (this.networkState == null) {
            this.networkState = this.getNetworkConnectionModel();
        }
        INetworkState iNetworkState = this.networkState;
        Intrinsics.checkNotNull((Object)iNetworkState);
        NetworkState previousState = iNetworkState.getNetworkState();
        boolean hadExtraRow = this.hasExtraRow();
        this.setupNetworkItem(newNetworkState, msg);
        boolean hasExtraRow = this.hasExtraRow();
        if (hadExtraRow != hasExtraRow) {
            if (hadExtraRow) {
                this.notifyItemRemoved(super.getItemCount());
            } else {
                this.notifyItemInserted(super.getItemCount());
            }
        } else if (hasExtraRow && previousState != newNetworkState) {
            this.notifyItemChanged(this.getItemCount() - 1);
        }
    }

    public static /* synthetic */ void setNetworkState$default(PagedAdapter pagedAdapter, NetworkState networkState, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setNetworkState");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        pagedAdapter.setNetworkState(networkState, string);
    }

    private final void setupNetworkItem(NetworkState networkState, String msg) {
        INetworkState iNetworkState = this.networkState;
        if (iNetworkState != null) {
            INetworkState iNetworkState2;
            INetworkState $this$setupNetworkItem_u24lambda_u2d1 = iNetworkState2 = iNetworkState;
            boolean bl = false;
            $this$setupNetworkItem_u24lambda_u2d1.onStateChanged(networkState);
            if (msg != null) {
                $this$setupNetworkItem_u24lambda_u2d1.setMessage(msg);
            }
        }
    }

    static /* synthetic */ void setupNetworkItem$default(PagedAdapter pagedAdapter, NetworkState networkState, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setupNetworkItem");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        pagedAdapter.setupNetworkItem(networkState, string);
    }

    @Override
    public void setOnItemClickListener(@Nullable OnItemClickListener<M> listener2) {
        HasOnItemClickListener.DefaultImpls.setOnItemClickListener(this, listener2);
    }

    private static final void onBindViewHolder$lambda-0(PagedAdapter this$0, Object $obj, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        OnItemClickListener<Object> onItemClickListener = this$0.getListener();
        if (onItemClickListener != null) {
            onItemClickListener.onItemClicked($obj);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/merseyside/adapters/base/PagedAdapter$NetworkState;", "", "(Ljava/lang/String;I)V", "ERROR", "NO_CONNECTION", "CONNECTED", "LOADING", "adapters_release"})
    public static final class NetworkState
    extends Enum<NetworkState> {
        public static final /* enum */ NetworkState ERROR = new NetworkState();
        public static final /* enum */ NetworkState NO_CONNECTION = new NetworkState();
        public static final /* enum */ NetworkState CONNECTED = new NetworkState();
        public static final /* enum */ NetworkState LOADING = new NetworkState();
        private static final /* synthetic */ NetworkState[] $VALUES;

        public static NetworkState[] values() {
            return (NetworkState[])$VALUES.clone();
        }

        public static NetworkState valueOf(String value) {
            return Enum.valueOf(NetworkState.class, value);
        }

        static {
            $VALUES = networkStateArray = new NetworkState[]{NetworkState.ERROR, NetworkState.NO_CONNECTION, NetworkState.CONNECTED, NetworkState.LOADING};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\nJ\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\u000b"}, d2={"Lcom/merseyside/adapters/base/PagedAdapter$INetworkState;", "", "getNetworkState", "Lcom/merseyside/adapters/base/PagedAdapter$NetworkState;", "onStateChanged", "", "state", "setMessage", "msg", "", "OnRetryListener", "adapters_release"})
    public static interface INetworkState {
        public void setMessage(@NotNull String var1);

        public void onStateChanged(@NotNull NetworkState var1);

        @NotNull
        public NetworkState getNetworkState();

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/merseyside/adapters/base/PagedAdapter$INetworkState$OnRetryListener;", "", "onRetry", "", "adapters_release"})
        public static interface OnRetryListener {
            public void onRetry();
        }
    }
}

