/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.opengl.EGLContext;
import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import com.daasuu.mp4compose.FillMode;
import com.daasuu.mp4compose.FillModeCustomItem;
import com.daasuu.mp4compose.Rotation;
import com.daasuu.mp4compose.VideoFormatMimeType;
import com.daasuu.mp4compose.composer.AudioComposer;
import com.daasuu.mp4compose.composer.IAudioComposer;
import com.daasuu.mp4compose.composer.MuxRender;
import com.daasuu.mp4compose.composer.RemixAudioComposer;
import com.daasuu.mp4compose.composer.VideoComposer;
import com.daasuu.mp4compose.filter.GlFilter;
import com.daasuu.mp4compose.logger.Logger;
import com.daasuu.mp4compose.source.DataSource;
import java.io.FileDescriptor;
import java.io.IOException;

class Mp4ComposerEngine {
    private static final String TAG = "Mp4ComposerEngine";
    private static final String AUDIO_PREFIX = "audio/";
    private static final String VIDEO_PREFIX = "video/";
    private static final double PROGRESS_UNKNOWN = -1.0;
    private static final long SLEEP_TO_WAIT_TRACK_TRANSCODERS = 10L;
    private static final long PROGRESS_INTERVAL_STEPS = 10L;
    private VideoComposer videoComposer;
    private IAudioComposer audioComposer;
    private MediaExtractor mediaExtractor;
    private MediaMuxer mediaMuxer;
    private ProgressCallback progressCallback;
    private long durationUs;
    private MediaMetadataRetriever mediaMetadataRetriever;
    private volatile boolean canceled;
    private final Logger logger;
    private long trimStartMs;
    private long trimEndMs;

    Mp4ComposerEngine(@NonNull Logger logger) {
        this.logger = logger;
    }

    void setProgressCallback(ProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compose(DataSource srcDataSource, String destSrc, FileDescriptor destFileDescriptor, Size outputResolution, GlFilter filter, int bitrate, boolean mute, Rotation rotation, Size inputResolution, FillMode fillMode, FillModeCustomItem fillModeCustomItem, float timeScale, boolean isPitchChanged, boolean flipVertical, boolean flipHorizontal, long trimStartMs, long trimEndMs, VideoFormatMimeType videoFormatMimeType, EGLContext shareContext) throws IOException {
        try {
            this.mediaExtractor = new MediaExtractor();
            this.mediaExtractor.setDataSource(srcDataSource.getFileDescriptor());
            this.mediaMuxer = Build.VERSION.SDK_INT >= 26 && destSrc == null ? new MediaMuxer(destFileDescriptor, 0) : new MediaMuxer(destSrc, 0);
            this.mediaMetadataRetriever = new MediaMetadataRetriever();
            this.mediaMetadataRetriever.setDataSource(srcDataSource.getFileDescriptor());
            this.trimStartMs = trimStartMs;
            this.trimEndMs = trimEndMs;
            if (trimEndMs != -1L) {
                this.durationUs = (trimEndMs - trimStartMs) * 1000L;
            } else {
                try {
                    this.durationUs = Long.parseLong(this.mediaMetadataRetriever.extractMetadata(9)) * 1000L;
                }
                catch (NumberFormatException e) {
                    this.durationUs = -1L;
                }
            }
            this.logger.debug(TAG, "Duration (us): " + this.durationUs);
            MuxRender muxRender = new MuxRender(this.mediaMuxer, this.logger);
            int videoTrackIndex = -1;
            int audioTrackIndex = -1;
            for (int i = 0; i < this.mediaExtractor.getTrackCount(); ++i) {
                MediaFormat mediaFormat = this.mediaExtractor.getTrackFormat(i);
                String mimeType = mediaFormat.getString("mime");
                if (mimeType == null) continue;
                if (mimeType.startsWith(VIDEO_PREFIX)) {
                    videoTrackIndex = i;
                    continue;
                }
                if (!mimeType.startsWith(AUDIO_PREFIX)) continue;
                audioTrackIndex = i;
            }
            MediaFormat actualVideoOutputFormat = Mp4ComposerEngine.createVideoOutputFormatWithAvailableEncoders(videoFormatMimeType, bitrate, outputResolution);
            if (Build.VERSION.SDK_INT == 21) {
                actualVideoOutputFormat.setInteger("frame-rate", 30);
            }
            this.videoComposer = new VideoComposer(this.mediaExtractor, videoTrackIndex, actualVideoOutputFormat, muxRender, timeScale, trimStartMs, trimEndMs, this.logger);
            this.videoComposer.setUp(filter, rotation, outputResolution, inputResolution, fillMode, fillModeCustomItem, flipVertical, flipHorizontal, shareContext);
            this.mediaExtractor.selectTrack(videoTrackIndex);
            if (audioTrackIndex >= 0 && this.mediaMetadataRetriever.extractMetadata(16) != null && !mute) {
                MediaFormat inputMediaFormat = this.mediaExtractor.getTrackFormat(audioTrackIndex);
                MediaFormat outputMediaFormat = Mp4ComposerEngine.createAudioOutputFormat(inputMediaFormat);
                this.audioComposer = (double)timeScale >= 0.99 && (double)timeScale <= 1.01 && outputMediaFormat.equals(inputMediaFormat) ? new AudioComposer(this.mediaExtractor, audioTrackIndex, muxRender, trimStartMs, trimEndMs, this.logger) : new RemixAudioComposer(this.mediaExtractor, audioTrackIndex, outputMediaFormat, muxRender, timeScale, isPitchChanged, trimStartMs, trimEndMs);
                this.audioComposer.setup();
                this.mediaExtractor.selectTrack(audioTrackIndex);
                this.mediaExtractor.seekTo(trimStartMs * 1000L, 0);
                this.runPipelines();
            } else {
                this.mediaExtractor.seekTo(trimStartMs * 1000L, 0);
                this.runPipelinesNoAudio();
            }
            this.mediaMuxer.stop();
        }
        finally {
            try {
                if (this.videoComposer != null) {
                    this.videoComposer.release();
                    this.videoComposer = null;
                }
                if (this.audioComposer != null) {
                    this.audioComposer.release();
                    this.audioComposer = null;
                }
                if (this.mediaExtractor != null) {
                    this.mediaExtractor.release();
                    this.mediaExtractor = null;
                }
            }
            catch (RuntimeException e) {
                this.logger.error(TAG, "Could not shutdown mediaExtractor, codecs and mediaMuxer pipeline.", e);
            }
            try {
                if (this.mediaMuxer != null) {
                    this.mediaMuxer.release();
                    this.mediaMuxer = null;
                }
            }
            catch (RuntimeException e) {
                this.logger.error(TAG, "Failed to release mediaMuxer.", e);
            }
            try {
                if (this.mediaMetadataRetriever != null) {
                    this.mediaMetadataRetriever.release();
                    this.mediaMetadataRetriever = null;
                }
            }
            catch (RuntimeException e) {
                this.logger.error(TAG, "Failed to release mediaMetadataRetriever.", e);
            }
        }
    }

    void cancel() {
        this.canceled = true;
    }

    boolean isCanceled() {
        return this.canceled;
    }

    @NonNull
    private static MediaFormat createVideoOutputFormatWithAvailableEncoders(@NonNull VideoFormatMimeType mimeType, int bitrate, @NonNull Size outputResolution) {
        MediaFormat mediaFormat;
        MediaCodecList mediaCodecList = new MediaCodecList(0);
        if (mimeType != VideoFormatMimeType.AUTO && mediaCodecList.findEncoderForFormat(mediaFormat = Mp4ComposerEngine.createVideoFormat(mimeType.getFormat(), bitrate, outputResolution)) != null) {
            return mediaFormat;
        }
        MediaFormat hevcMediaFormat = Mp4ComposerEngine.createVideoFormat(VideoFormatMimeType.HEVC.getFormat(), bitrate, outputResolution);
        if (mediaCodecList.findEncoderForFormat(hevcMediaFormat) != null) {
            return hevcMediaFormat;
        }
        MediaFormat avcMediaFormat = Mp4ComposerEngine.createVideoFormat(VideoFormatMimeType.AVC.getFormat(), bitrate, outputResolution);
        if (mediaCodecList.findEncoderForFormat(avcMediaFormat) != null) {
            return avcMediaFormat;
        }
        MediaFormat mp4vesMediaFormat = Mp4ComposerEngine.createVideoFormat(VideoFormatMimeType.MPEG4.getFormat(), bitrate, outputResolution);
        if (mediaCodecList.findEncoderForFormat(mp4vesMediaFormat) != null) {
            return mp4vesMediaFormat;
        }
        return Mp4ComposerEngine.createVideoFormat(VideoFormatMimeType.H263.getFormat(), bitrate, outputResolution);
    }

    @NonNull
    private static MediaFormat createAudioOutputFormat(@NonNull MediaFormat inputFormat) {
        if ("audio/mp4a-latm".equals(inputFormat.getString("mime"))) {
            return inputFormat;
        }
        MediaFormat outputFormat = new MediaFormat();
        outputFormat.setString("mime", "audio/mp4a-latm");
        outputFormat.setInteger("aac-profile", 39);
        outputFormat.setInteger("sample-rate", inputFormat.getInteger("sample-rate"));
        outputFormat.setInteger("bitrate", 128000);
        outputFormat.setInteger("channel-count", inputFormat.getInteger("channel-count"));
        return outputFormat;
    }

    @NonNull
    private static MediaFormat createVideoFormat(@NonNull String mimeType, int bitrate, @NonNull Size outputResolution) {
        MediaFormat outputFormat = MediaFormat.createVideoFormat((String)mimeType, (int)outputResolution.getWidth(), (int)outputResolution.getHeight());
        outputFormat.setInteger("bitrate", bitrate);
        if (Build.VERSION.SDK_INT != 21) {
            outputFormat.setInteger("frame-rate", 30);
        }
        outputFormat.setInteger("i-frame-interval", 1);
        outputFormat.setInteger("color-format", 2130708361);
        return outputFormat;
    }

    private void runPipelines() {
        long loopCount = 0L;
        if (this.durationUs <= 0L && this.progressCallback != null) {
            this.progressCallback.onProgress(-1.0);
        }
        while (!(this.canceled || this.videoComposer.isFinished() && this.audioComposer.isFinished())) {
            boolean stepped = this.videoComposer.stepPipeline() || this.audioComposer.stepPipeline();
            if (this.durationUs > 0L && ++loopCount % 10L == 0L) {
                long writtenPresentationVideoTimeUs = this.videoComposer.getWrittenPresentationTimeUs();
                if (this.progressCallback != null) {
                    this.progressCallback.onCurrentWrittenVideoTime(writtenPresentationVideoTimeUs);
                }
                double videoProgress = this.videoComposer.isFinished() ? 1.0 : Math.min(1.0, (double)this.getWrittenPresentationTimeUs(writtenPresentationVideoTimeUs) / (double)this.durationUs);
                double audioProgress = this.audioComposer.isFinished() ? 1.0 : Math.min(1.0, (double)this.getWrittenPresentationTimeUs(this.audioComposer.getWrittenPresentationTimeUs()) / (double)this.durationUs);
                double progress = (videoProgress + audioProgress) / 2.0;
                if (this.progressCallback != null) {
                    this.progressCallback.onProgress(progress);
                }
            }
            if (stepped) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private long getWrittenPresentationTimeUs(long time) {
        return Math.max(0L, time - this.trimStartMs * 1000L);
    }

    private void runPipelinesNoAudio() {
        long loopCount = 0L;
        if (this.durationUs <= 0L && this.progressCallback != null) {
            this.progressCallback.onProgress(-1.0);
        }
        while (!this.canceled && !this.videoComposer.isFinished()) {
            boolean stepped = this.videoComposer.stepPipeline();
            if (this.durationUs > 0L && ++loopCount % 10L == 0L) {
                double videoProgress;
                long writtenPresentationVideoTimeUs = this.videoComposer.getWrittenPresentationTimeUs();
                if (this.progressCallback != null) {
                    this.progressCallback.onCurrentWrittenVideoTime(writtenPresentationVideoTimeUs);
                }
                double d = videoProgress = this.videoComposer.isFinished() ? 1.0 : Math.min(1.0, (double)this.getWrittenPresentationTimeUs(writtenPresentationVideoTimeUs) / (double)this.durationUs);
                if (this.progressCallback != null) {
                    this.progressCallback.onProgress(videoProgress);
                }
            }
            if (stepped) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static interface ProgressCallback {
        public void onProgress(double var1);

        public void onCurrentWrittenVideoTime(long var1);
    }
}

