/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import com.daasuu.mp4compose.SampleType;
import com.daasuu.mp4compose.composer.AudioChannelWithSP;
import com.daasuu.mp4compose.composer.IAudioComposer;
import com.daasuu.mp4compose.composer.MuxRender;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

class RemixAudioComposer
implements IAudioComposer {
    private static final SampleType SAMPLE_TYPE = SampleType.AUDIO;
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SHOULD_RETRY_IMMEDIATELY = 1;
    private static final int DRAIN_STATE_CONSUMED = 2;
    private final MediaExtractor extractor;
    private final MuxRender muxer;
    private long writtenPresentationTimeUs;
    private final int trackIndex;
    private final MediaFormat outputFormat;
    private final MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    private MediaCodec decoder;
    private MediaCodec encoder;
    private MediaFormat actualOutputFormat;
    private boolean isExtractorEOS;
    private boolean isDecoderEOS;
    private boolean isEncoderEOS;
    private boolean decoderStarted;
    private boolean encoderStarted;
    private AudioChannelWithSP audioChannel;
    private final float timeScale;
    private final boolean isPitchChanged;
    private final long trimStartUs;
    private final long trimEndUs;
    int numTracks = 0;
    private boolean addPrimingDelay;
    private int frameCounter;
    private long primingDelay;

    RemixAudioComposer(MediaExtractor extractor, int trackIndex, MediaFormat outputFormat, MuxRender muxer, float timeScale, boolean isPitchChanged, long trimStartMs, long trimEndMs) {
        this.extractor = extractor;
        this.trackIndex = trackIndex;
        this.outputFormat = outputFormat;
        this.muxer = muxer;
        this.timeScale = timeScale;
        this.isPitchChanged = isPitchChanged;
        this.trimStartUs = TimeUnit.MILLISECONDS.toMicros(trimStartMs);
        this.trimEndUs = trimEndMs == -1L ? trimEndMs : TimeUnit.MILLISECONDS.toMicros(trimEndMs);
    }

    @Override
    public void setup() {
        this.extractor.selectTrack(this.trackIndex);
        try {
            this.encoder = MediaCodec.createEncoderByType((String)this.outputFormat.getString("mime"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.encoder.configure(this.outputFormat, null, null, 1);
        this.encoder.start();
        this.encoderStarted = true;
        MediaFormat inputFormat = this.extractor.getTrackFormat(this.trackIndex);
        try {
            this.decoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.decoder.configure(inputFormat, null, null, 0);
        this.decoder.start();
        this.decoderStarted = true;
        this.audioChannel = new AudioChannelWithSP(this.decoder, this.encoder, this.outputFormat, this.timeScale, this.isPitchChanged);
    }

    @Override
    public boolean stepPipeline() {
        boolean busy = false;
        while (this.drainEncoder(0L) != 0) {
            busy = true;
        }
        while (!this.audioChannel.isAnyPendingBuffIndex()) {
            int status = this.drainDecoder(0L);
            if (status != 0) {
                busy = true;
            }
            if (status == 1) continue;
        }
        while (this.audioChannel.feedEncoder(0L)) {
            busy = true;
        }
        while (this.drainExtractor(0L) != 0) {
            busy = true;
        }
        return busy;
    }

    private int drainExtractor(long timeoutUs) {
        if (this.isExtractorEOS) {
            return 0;
        }
        int trackIndex = this.extractor.getSampleTrackIndex();
        if (trackIndex >= 0 && trackIndex != this.trackIndex) {
            return 0;
        }
        int result = this.decoder.dequeueInputBuffer(timeoutUs);
        if (result < 0) {
            return 0;
        }
        if (trackIndex < 0) {
            this.isExtractorEOS = true;
            this.decoder.queueInputBuffer(result, 0, 0, 0L, 4);
            return 0;
        }
        int sampleSize = this.extractor.readSampleData(this.decoder.getInputBuffer(result), 0);
        boolean isKeyFrame = (this.extractor.getSampleFlags() & 1) != 0;
        this.decoder.queueInputBuffer(result, 0, sampleSize, this.extractor.getSampleTime(), isKeyFrame ? 1 : 0);
        this.extractor.advance();
        ++this.numTracks;
        return 2;
    }

    private int drainDecoder(long timeoutUs) {
        if (this.isDecoderEOS) {
            return 0;
        }
        int result = this.decoder.dequeueOutputBuffer(this.bufferInfo, timeoutUs);
        switch (result) {
            case -1: {
                return 0;
            }
            case -2: {
                this.audioChannel.setActualDecodedFormat(this.decoder.getOutputFormat());
            }
            case -3: {
                return 1;
            }
        }
        if ((this.bufferInfo.flags & 4) != 0) {
            this.isDecoderEOS = true;
            this.audioChannel.drainDecoderBufferAndQueue(-1, 0L);
        } else if (this.bufferInfo.size > 0) {
            this.audioChannel.drainDecoderBufferAndQueue(result, this.bufferInfo.presentationTimeUs);
        }
        return 2;
    }

    private int drainEncoder(long timeoutUs) {
        if (this.isEncoderEOS) {
            return 0;
        }
        int result = this.encoder.dequeueOutputBuffer(this.bufferInfo, timeoutUs);
        switch (result) {
            case -1: {
                return 0;
            }
            case -2: {
                if (this.actualOutputFormat != null) {
                    throw new RuntimeException("Audio output format changed twice.");
                }
                this.actualOutputFormat = this.encoder.getOutputFormat();
                this.addPrimingDelay = "audio/mp4a-latm".equals(this.actualOutputFormat.getString("mime"));
                this.muxer.setOutputFormat(SAMPLE_TYPE, this.actualOutputFormat);
                return 1;
            }
            case -3: {
                return 1;
            }
        }
        if (this.actualOutputFormat == null) {
            throw new RuntimeException("Could not determine actual output format.");
        }
        if ((this.bufferInfo.flags & 4) != 0) {
            this.isEncoderEOS = true;
            this.bufferInfo.set(0, 0, 0L, this.bufferInfo.flags);
        }
        if ((this.bufferInfo.flags & 2) != 0) {
            this.encoder.releaseOutputBuffer(result, false);
            return 1;
        }
        this.muxer.writeSampleData(SAMPLE_TYPE, this.encoder.getOutputBuffer(result), this.bufferInfo);
        this.writtenPresentationTimeUs = this.bufferInfo.presentationTimeUs;
        this.encoder.releaseOutputBuffer(result, false);
        return 2;
    }

    @Override
    public long getWrittenPresentationTimeUs() {
        return (long)((float)this.writtenPresentationTimeUs * this.timeScale);
    }

    @Override
    public boolean isFinished() {
        return this.isEncoderEOS;
    }

    @Override
    public void release() {
        if (this.decoder != null) {
            if (this.decoderStarted) {
                this.decoder.stop();
            }
            this.decoder.release();
            this.decoder = null;
        }
        if (this.encoder != null) {
            if (this.encoderStarted) {
                this.encoder.stop();
            }
            this.encoder.release();
            this.encoder = null;
        }
    }
}

