/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.bl;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.daasuu.bl.ArrowDirection;

class Bubble
extends Drawable {
    private RectF mRect;
    private Path mPath = new Path();
    private Paint mPaint = new Paint(1);
    private Path mStrokePath;
    private Paint mStrokePaint;
    private float mArrowWidth;
    private float mCornersRadius;
    private float mArrowHeight;
    private float mArrowPosition;
    private float mStrokeWidth;

    public Bubble(RectF rect, float arrowWidth, float cornersRadius, float arrowHeight, float arrowPosition, float strokeWidth, int strokeColor, int bubbleColor, ArrowDirection arrowDirection) {
        this.mRect = rect;
        this.mArrowWidth = arrowWidth;
        this.mCornersRadius = cornersRadius;
        this.mArrowHeight = arrowHeight;
        this.mArrowPosition = arrowPosition;
        this.mStrokeWidth = strokeWidth;
        this.mPaint.setColor(bubbleColor);
        if (strokeWidth > 0.0f) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setColor(strokeColor);
            this.mStrokePath = new Path();
            this.initPath(arrowDirection, this.mPath, strokeWidth);
            this.initPath(arrowDirection, this.mStrokePath, 0.0f);
        } else {
            this.initPath(arrowDirection, this.mPath, 0.0f);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
    }

    public void draw(Canvas canvas) {
        if (this.mStrokeWidth > 0.0f) {
            canvas.drawPath(this.mStrokePath, this.mStrokePaint);
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getIntrinsicWidth() {
        return (int)this.mRect.width();
    }

    public int getIntrinsicHeight() {
        return (int)this.mRect.height();
    }

    private void initPath(ArrowDirection arrowDirection, Path path, float strokeWidth) {
        switch (arrowDirection) {
            case LEFT: 
            case LEFT_CENTER: {
                if (this.mCornersRadius <= 0.0f) {
                    this.initLeftSquarePath(this.mRect, path, strokeWidth);
                    break;
                }
                if (strokeWidth > 0.0f && strokeWidth > this.mCornersRadius) {
                    this.initLeftSquarePath(this.mRect, path, strokeWidth);
                    break;
                }
                this.initLeftRoundedPath(this.mRect, path, strokeWidth);
                break;
            }
            case TOP: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                if (this.mCornersRadius <= 0.0f) {
                    this.initTopSquarePath(this.mRect, path, strokeWidth);
                    break;
                }
                if (strokeWidth > 0.0f && strokeWidth > this.mCornersRadius) {
                    this.initTopSquarePath(this.mRect, path, strokeWidth);
                    break;
                }
                this.initTopRoundedPath(this.mRect, path, strokeWidth);
                break;
            }
            case RIGHT: 
            case RIGHT_CENTER: {
                if (this.mCornersRadius <= 0.0f) {
                    this.initRightSquarePath(this.mRect, path, strokeWidth);
                    break;
                }
                if (strokeWidth > 0.0f && strokeWidth > this.mCornersRadius) {
                    this.initRightSquarePath(this.mRect, path, strokeWidth);
                    break;
                }
                this.initRightRoundedPath(this.mRect, path, strokeWidth);
                break;
            }
            case BOTTOM: 
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: {
                if (this.mCornersRadius <= 0.0f) {
                    this.initBottomSquarePath(this.mRect, path, strokeWidth);
                    break;
                }
                if (strokeWidth > 0.0f && strokeWidth > this.mCornersRadius) {
                    this.initBottomSquarePath(this.mRect, path, strokeWidth);
                    break;
                }
                this.initBottomRoundedPath(this.mRect, path, strokeWidth);
            }
        }
    }

    private void initLeftRoundedPath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(this.mArrowWidth + rect.left + this.mCornersRadius + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - this.mCornersRadius - strokeWidth, rect.top + strokeWidth);
        path.arcTo(new RectF(rect.right - this.mCornersRadius, rect.top + strokeWidth, rect.right - strokeWidth, this.mCornersRadius + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right - strokeWidth, rect.bottom - this.mCornersRadius - strokeWidth);
        path.arcTo(new RectF(rect.right - this.mCornersRadius, rect.bottom - this.mCornersRadius, rect.right - strokeWidth, rect.bottom - strokeWidth), 0.0f, 90.0f);
        path.lineTo(rect.left + this.mArrowWidth + this.mCornersRadius + strokeWidth, rect.bottom - strokeWidth);
        path.arcTo(new RectF(rect.left + this.mArrowWidth + strokeWidth, rect.bottom - this.mCornersRadius, this.mCornersRadius + rect.left + this.mArrowWidth, rect.bottom - strokeWidth), 90.0f, 90.0f);
        path.lineTo(rect.left + this.mArrowWidth + strokeWidth, this.mArrowHeight + this.mArrowPosition - strokeWidth / 2.0f);
        path.lineTo(rect.left + strokeWidth + strokeWidth, this.mArrowPosition + this.mArrowHeight / 2.0f);
        path.lineTo(rect.left + this.mArrowWidth + strokeWidth, this.mArrowPosition + strokeWidth / 2.0f);
        path.lineTo(rect.left + this.mArrowWidth + strokeWidth, rect.top + this.mCornersRadius + strokeWidth);
        path.arcTo(new RectF(rect.left + this.mArrowWidth + strokeWidth, rect.top + strokeWidth, this.mCornersRadius + rect.left + this.mArrowWidth, this.mCornersRadius + rect.top), 180.0f, 90.0f);
        path.close();
    }

    private void initLeftSquarePath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(this.mArrowWidth + rect.left + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + this.mArrowWidth + strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + this.mArrowWidth + strokeWidth, this.mArrowHeight + this.mArrowPosition - strokeWidth / 2.0f);
        path.lineTo(rect.left + strokeWidth + strokeWidth, this.mArrowPosition + this.mArrowHeight / 2.0f);
        path.lineTo(rect.left + this.mArrowWidth + strokeWidth, this.mArrowPosition + strokeWidth / 2.0f);
        path.lineTo(rect.left + this.mArrowWidth + strokeWidth, rect.top + strokeWidth);
        path.close();
    }

    private void initTopRoundedPath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + Math.min(this.mArrowPosition, this.mCornersRadius) + strokeWidth, rect.top + this.mArrowHeight + strokeWidth);
        path.lineTo(rect.left + this.mArrowPosition + strokeWidth / 2.0f, rect.top + this.mArrowHeight + strokeWidth);
        path.lineTo(rect.left + this.mArrowWidth / 2.0f + this.mArrowPosition, rect.top + strokeWidth + strokeWidth);
        path.lineTo(rect.left + this.mArrowWidth + this.mArrowPosition - strokeWidth / 2.0f, rect.top + this.mArrowHeight + strokeWidth);
        path.lineTo(rect.right - this.mCornersRadius - strokeWidth, rect.top + this.mArrowHeight + strokeWidth);
        path.arcTo(new RectF(rect.right - this.mCornersRadius, rect.top + this.mArrowHeight + strokeWidth, rect.right - strokeWidth, this.mCornersRadius + rect.top + this.mArrowHeight), 270.0f, 90.0f);
        path.lineTo(rect.right - strokeWidth, rect.bottom - this.mCornersRadius - strokeWidth);
        path.arcTo(new RectF(rect.right - this.mCornersRadius, rect.bottom - this.mCornersRadius, rect.right - strokeWidth, rect.bottom - strokeWidth), 0.0f, 90.0f);
        path.lineTo(rect.left + this.mCornersRadius + strokeWidth, rect.bottom - strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.bottom - this.mCornersRadius, this.mCornersRadius + rect.left, rect.bottom - strokeWidth), 90.0f, 90.0f);
        path.lineTo(rect.left + strokeWidth, rect.top + this.mArrowHeight + this.mCornersRadius + strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.top + this.mArrowHeight + strokeWidth, this.mCornersRadius + rect.left, this.mCornersRadius + rect.top + this.mArrowHeight), 180.0f, 90.0f);
        path.close();
    }

    private void initTopSquarePath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + this.mArrowPosition + strokeWidth, rect.top + this.mArrowHeight + strokeWidth);
        path.lineTo(rect.left + this.mArrowPosition + strokeWidth / 2.0f, rect.top + this.mArrowHeight + strokeWidth);
        path.lineTo(rect.left + this.mArrowWidth / 2.0f + this.mArrowPosition, rect.top + strokeWidth + strokeWidth);
        path.lineTo(rect.left + this.mArrowWidth + this.mArrowPosition - strokeWidth / 2.0f, rect.top + this.mArrowHeight + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.top + this.mArrowHeight + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.top + this.mArrowHeight + strokeWidth);
        path.lineTo(rect.left + this.mArrowPosition + strokeWidth, rect.top + this.mArrowHeight + strokeWidth);
        path.close();
    }

    private void initRightRoundedPath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + this.mCornersRadius + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - this.mCornersRadius - this.mArrowWidth - strokeWidth, rect.top + strokeWidth);
        path.arcTo(new RectF(rect.right - this.mCornersRadius - this.mArrowWidth, rect.top + strokeWidth, rect.right - this.mArrowWidth - strokeWidth, this.mCornersRadius + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right - this.mArrowWidth - strokeWidth, this.mArrowPosition + strokeWidth / 2.0f);
        path.lineTo(rect.right - strokeWidth - strokeWidth, this.mArrowPosition + this.mArrowHeight / 2.0f);
        path.lineTo(rect.right - this.mArrowWidth - strokeWidth, this.mArrowPosition + this.mArrowHeight - strokeWidth / 2.0f);
        path.lineTo(rect.right - this.mArrowWidth - strokeWidth, rect.bottom - this.mCornersRadius - strokeWidth);
        path.arcTo(new RectF(rect.right - this.mCornersRadius - this.mArrowWidth, rect.bottom - this.mCornersRadius, rect.right - this.mArrowWidth - strokeWidth, rect.bottom - strokeWidth), 0.0f, 90.0f);
        path.lineTo(rect.left + this.mArrowWidth + strokeWidth, rect.bottom - strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.bottom - this.mCornersRadius, this.mCornersRadius + rect.left, rect.bottom - strokeWidth), 90.0f, 90.0f);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.top + strokeWidth, this.mCornersRadius + rect.left, this.mCornersRadius + rect.top), 180.0f, 90.0f);
        path.close();
    }

    private void initRightSquarePath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - this.mArrowWidth - strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.right - this.mArrowWidth - strokeWidth, this.mArrowPosition + strokeWidth / 2.0f);
        path.lineTo(rect.right - strokeWidth - strokeWidth, this.mArrowPosition + this.mArrowHeight / 2.0f);
        path.lineTo(rect.right - this.mArrowWidth - strokeWidth, this.mArrowPosition + this.mArrowHeight - strokeWidth / 2.0f);
        path.lineTo(rect.right - this.mArrowWidth - strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.bottom - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.top + strokeWidth);
        path.close();
    }

    private void initBottomRoundedPath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + this.mCornersRadius + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.width() - this.mCornersRadius - strokeWidth, rect.top + strokeWidth);
        path.arcTo(new RectF(rect.right - this.mCornersRadius, rect.top + strokeWidth, rect.right - strokeWidth, this.mCornersRadius + rect.top), 270.0f, 90.0f);
        path.lineTo(rect.right - strokeWidth, rect.bottom - this.mArrowHeight - this.mCornersRadius - strokeWidth);
        path.arcTo(new RectF(rect.right - this.mCornersRadius, rect.bottom - this.mCornersRadius - this.mArrowHeight, rect.right - strokeWidth, rect.bottom - this.mArrowHeight - strokeWidth), 0.0f, 90.0f);
        path.lineTo(rect.left + this.mArrowWidth + this.mArrowPosition - strokeWidth / 2.0f, rect.bottom - this.mArrowHeight - strokeWidth);
        path.lineTo(rect.left + this.mArrowPosition + this.mArrowWidth / 2.0f, rect.bottom - strokeWidth - strokeWidth);
        path.lineTo(rect.left + this.mArrowPosition + strokeWidth / 2.0f, rect.bottom - this.mArrowHeight - strokeWidth);
        path.lineTo(rect.left + Math.min(this.mCornersRadius, this.mArrowPosition) + strokeWidth, rect.bottom - this.mArrowHeight - strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.bottom - this.mCornersRadius - this.mArrowHeight, this.mCornersRadius + rect.left, rect.bottom - this.mArrowHeight - strokeWidth), 90.0f, 90.0f);
        path.lineTo(rect.left + strokeWidth, rect.top + this.mCornersRadius + strokeWidth);
        path.arcTo(new RectF(rect.left + strokeWidth, rect.top + strokeWidth, this.mCornersRadius + rect.left, this.mCornersRadius + rect.top), 180.0f, 90.0f);
        path.close();
    }

    private void initBottomSquarePath(RectF rect, Path path, float strokeWidth) {
        path.moveTo(rect.left + strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.top + strokeWidth);
        path.lineTo(rect.right - strokeWidth, rect.bottom - this.mArrowHeight - strokeWidth);
        path.lineTo(rect.left + this.mArrowWidth + this.mArrowPosition - strokeWidth / 2.0f, rect.bottom - this.mArrowHeight - strokeWidth);
        path.lineTo(rect.left + this.mArrowPosition + this.mArrowWidth / 2.0f, rect.bottom - strokeWidth - strokeWidth);
        path.lineTo(rect.left + this.mArrowPosition + strokeWidth / 2.0f, rect.bottom - this.mArrowHeight - strokeWidth);
        path.lineTo(rect.left + this.mArrowPosition + strokeWidth, rect.bottom - this.mArrowHeight - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.bottom - this.mArrowHeight - strokeWidth);
        path.lineTo(rect.left + strokeWidth, rect.top + strokeWidth);
        path.close();
    }
}

