/*
 * Decompiled with CFR 0.152.
 */
package com.mvc.imagepicker;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.util.Log;

public final class ImageRotator {
    private static final String TAG = ImageRotator.class.getSimpleName();

    private ImageRotator() {
    }

    public static int getRotation(Context context, Uri imageUri, boolean fromCamera) {
        int rotation = fromCamera ? ImageRotator.getRotationFromCamera(context, imageUri) : ImageRotator.getRotationFromGallery(context, imageUri);
        Log.i((String)TAG, (String)("Image rotation: " + rotation));
        return rotation;
    }

    private static int getRotationFromCamera(Context context, Uri imageFile) {
        int rotate = 0;
        try {
            context.getContentResolver().notifyChange(imageFile, null);
            ExifInterface exif = new ExifInterface(imageFile.getPath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                    break;
                }
                default: {
                    rotate = 0;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rotate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getRotationFromGallery(Context context, Uri imageUri) {
        int result = 0;
        String[] columns = new String[]{"orientation"};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(imageUri, columns, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int orientationColumnIndex = cursor.getColumnIndex(columns[0]);
                result = cursor.getInt(orientationColumnIndex);
            }
        }
        return result;
    }

    public static Bitmap rotate(Bitmap bitmap, int degrees) {
        if (bitmap != null && degrees != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degrees);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        return bitmap;
    }
}

