/*
 * Decompiled with CFR 0.152.
 */
package com.mvc.imagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.mvc.imagepicker.ImageRotator;
import com.mvc.imagepicker.R;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ImagePicker {
    public static final int PICK_IMAGE_REQUEST_CODE = 234;
    private static final int DEFAULT_MIN_WIDTH_QUALITY = 400;
    private static final int DEFAULT_MIN_HEIGHT_QUALITY = 400;
    private static final String TAG = ImagePicker.class.getSimpleName();
    private static final String TEMP_IMAGE_NAME = "tempImage";
    private static int minWidthQuality = 400;
    private static int minHeightQuality = 400;

    private ImagePicker() {
    }

    public static void pickImage(Activity activity) {
        String chooserTitle = activity.getString(R.string.pick_image_intent_text);
        ImagePicker.pickImage(activity, chooserTitle);
    }

    public static void pickImage(Fragment fragment) {
        String chooserTitle = fragment.getString(R.string.pick_image_intent_text);
        ImagePicker.pickImage(fragment, chooserTitle);
    }

    public static void pickImage(Activity activity, String chooserTitle) {
        Intent chooseImageIntent = ImagePicker.getPickImageIntent((Context)activity, chooserTitle);
        activity.startActivityForResult(chooseImageIntent, 234);
    }

    public static void pickImage(Fragment fragment, String chooserTitle) {
        Intent chooseImageIntent = ImagePicker.getPickImageIntent(fragment.getContext(), chooserTitle);
        fragment.startActivityForResult(chooseImageIntent, 234);
    }

    public static Intent getPickImageIntent(Context context, String chooserTitle) {
        Intent chooserIntent = null;
        List<Intent> intentList = new ArrayList<Intent>();
        Intent pickIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        intentList = ImagePicker.addIntentsToList(context, intentList, pickIntent);
        if (!ImagePicker.appManifestContainsPermission(context, "android.permission.CAMERA") || ImagePicker.hasCameraAccess(context)) {
            Intent takePhotoIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            takePhotoIntent.putExtra("return-data", true);
            takePhotoIntent.putExtra("output", (Parcelable)Uri.fromFile((File)ImagePicker.getTemporalFile(context)));
            intentList = ImagePicker.addIntentsToList(context, intentList, takePhotoIntent);
        }
        if (intentList.size() > 0) {
            chooserIntent = Intent.createChooser((Intent)intentList.remove(intentList.size() - 1), (CharSequence)chooserTitle);
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", intentList.toArray(new Parcelable[intentList.size()]));
        }
        return chooserIntent;
    }

    private static List<Intent> addIntentsToList(Context context, List<Intent> list, Intent intent) {
        Log.i((String)TAG, (String)("Adding intents of type: " + intent.getAction()));
        List resInfo = context.getPackageManager().queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : resInfo) {
            String packageName = resolveInfo.activityInfo.packageName;
            Intent targetedIntent = new Intent(intent);
            targetedIntent.setPackage(packageName);
            list.add(targetedIntent);
            Log.i((String)TAG, (String)("App package: " + packageName));
        }
        return list;
    }

    private static boolean hasCameraAccess(Context context) {
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0;
    }

    private static boolean appManifestContainsPermission(Context context, String permission2) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 4096);
            String[] requestedPermissions = null;
            if (packageInfo != null) {
                requestedPermissions = packageInfo.requestedPermissions;
            }
            if (requestedPermissions == null) {
                return false;
            }
            if (requestedPermissions.length > 0) {
                List<String> requestedPermissionsList = Arrays.asList(requestedPermissions);
                return requestedPermissionsList.contains(permission2);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Bitmap getImageFromResult(Context context, int requestCode, int resultCode, Intent imageReturnedIntent) {
        Log.i((String)TAG, (String)("getImageFromResult() called with: resultCode = [" + resultCode + "]"));
        Bitmap bm = null;
        if (resultCode == -1 && requestCode == 234) {
            File imageFile = ImagePicker.getTemporalFile(context);
            boolean isCamera = imageReturnedIntent == null || imageReturnedIntent.getData() == null || imageReturnedIntent.getData().toString().contains(imageFile.toString());
            Uri selectedImage = isCamera ? Uri.fromFile((File)imageFile) : imageReturnedIntent.getData();
            Log.i((String)TAG, (String)("selectedImage: " + selectedImage));
            bm = ImagePicker.getImageResized(context, selectedImage);
            int rotation = ImageRotator.getRotation(context, selectedImage, isCamera);
            bm = ImageRotator.rotate(bm, rotation);
        }
        return bm;
    }

    private static File getTemporalFile(Context context) {
        return new File(context.getExternalCacheDir(), TEMP_IMAGE_NAME);
    }

    private static Bitmap getImageResized(Context context, Uri selectedImage) {
        Bitmap bm;
        int[] sampleSizes = new int[]{5, 3, 2, 1};
        int i = 0;
        while ((bm = ImagePicker.decodeBitmap(context, selectedImage, sampleSizes[i])) != null && (bm.getWidth() < minWidthQuality || bm.getHeight() < minHeightQuality) && ++i < sampleSizes.length) {
        }
        Log.i((String)TAG, (String)("Final bitmap width = " + (bm != null ? Integer.valueOf(bm.getWidth()) : "No final bitmap")));
        return bm;
    }

    private static Bitmap decodeBitmap(Context context, Uri theUri, int sampleSize) {
        Bitmap actuallyUsableBitmap = null;
        AssetFileDescriptor fileDescriptor = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = sampleSize;
        try {
            fileDescriptor = context.getContentResolver().openAssetFileDescriptor(theUri, "r");
            actuallyUsableBitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
            if (actuallyUsableBitmap != null) {
                Log.i((String)TAG, (String)("Trying sample size " + options.inSampleSize + "\t\tBitmap width: " + actuallyUsableBitmap.getWidth() + "\theight: " + actuallyUsableBitmap.getHeight()));
            }
            fileDescriptor.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return actuallyUsableBitmap;
    }

    public static void setMinQuality(int minWidthQuality, int minHeightQuality) {
        ImagePicker.minWidthQuality = minWidthQuality;
        ImagePicker.minHeightQuality = minHeightQuality;
    }
}

