/*
 * Decompiled with CFR 0.152.
 */
package com.mackhartley.roundedprogressbar;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.annotation.ColorInt;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.mackhartley.roundedprogressbar.CornerRadius;
import com.mackhartley.roundedprogressbar.ProgressTextFormatter;
import com.mackhartley.roundedprogressbar.ProgressTextOverlay;
import com.mackhartley.roundedprogressbar.R;
import com.mackhartley.roundedprogressbar.RoundedProgressBar$WhenMappings;
import com.mackhartley.roundedprogressbar.ext.DrawableExtKt;
import com.mackhartley.roundedprogressbar.utils.MiscUtilsKt;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 q2\u00020\u0001:\u0002qrB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0013H\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0002J\u0016\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0014J\u0016\u0010<\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0014J\u0010\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020\u00132\u0006\u0010A\u001a\u00020\u0013H\u0002J\u0006\u0010B\u001a\u00020\u0013J\u0010\u0010C\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0013H\u0002J\u0010\u0010E\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u0013H\u0002J\u0012\u0010F\u001a\u0002082\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010G\u001a\u0002082\u0006\u0010H\u001a\u00020IH\u0014J\u0010\u0010J\u001a\u0002082\u0006\u0010K\u001a\u00020;H\u0016J\n\u0010L\u001a\u0004\u0018\u00010;H\u0016J(\u0010M\u001a\u0002082\u0006\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020\u0007H\u0014J\b\u0010R\u001a\u000208H\u0002J\u000e\u0010S\u001a\u0002082\u0006\u0010T\u001a\u00020\nJ\u0010\u0010U\u001a\u0002082\b\b\u0001\u0010V\u001a\u00020\u0007J\u0010\u0010W\u001a\u0002082\b\b\u0001\u0010V\u001a\u00020\u0007J\u000e\u0010X\u001a\u0002082\u0006\u0010Y\u001a\u00020\u000eJ\u0016\u0010X\u001a\u0002082\u0006\u0010Y\u001a\u00020\u000e2\u0006\u0010Z\u001a\u00020[J&\u0010X\u001a\u0002082\u0006\u0010\\\u001a\u00020\u000e2\u0006\u0010]\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020\u000eJ\u000e\u0010`\u001a\u0002082\u0006\u0010a\u001a\u00020\u0015J\u0010\u0010b\u001a\u0002082\b\b\u0001\u0010V\u001a\u00020\u0007J\u0018\u0010c\u001a\u0002082\u0006\u0010A\u001a\u00020\u00132\b\b\u0002\u0010d\u001a\u00020\u001cJ\u0010\u0010e\u001a\u0002082\b\b\u0001\u0010V\u001a\u00020\u0007J\u000e\u0010f\u001a\u0002082\u0006\u0010g\u001a\u00020hJ\u000e\u0010i\u001a\u0002082\u0006\u0010j\u001a\u00020\u001cJ\u000e\u0010k\u001a\u0002082\u0006\u0010l\u001a\u00020\u000eJ\u000e\u0010m\u001a\u0002082\u0006\u0010n\u001a\u00020\u000eJ\u000e\u0010/\u001a\u0002082\u0006\u0010o\u001a\u00020\u001cJ\b\u0010p\u001a\u000208H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lcom/mackhartley/roundedprogressbar/RoundedProgressBar;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animationLength", "", "backgroundDrawableColor", "backgroundTextColor", "cornerRadiusBL", "", "cornerRadiusBR", "cornerRadiusTL", "cornerRadiusTR", "curProgress", "", "customFontPath", "", "defaultAnimationLength", "defaultBackgroundDrawableColor", "defaultBackgroundTextColor", "defaultCornerRadius", "defaultFontPath", "defaultIsRadiusRestricted", "", "defaultProgressDrawableColor", "defaultProgressTextColor", "defaultProgressValue", "defaultShowProgressText", "defaultTextPadding", "defaultTextSize", "isRadiusRestricted", "lastReportedHeight", "lastReportedWidth", "prevTextPositionRatio", "progressBar", "Landroid/widget/ProgressBar;", "progressDrawableColor", "progressTextColor", "progressTextOverlay", "Lcom/mackhartley/roundedprogressbar/ProgressTextOverlay;", "roundedCornersClipPath", "Landroid/graphics/Path;", "showProgressText", "textPadding", "textSize", "calculateScaleDrawableLevel", "curPercentage", "createRoundedBackgroundDrawable", "Landroid/graphics/drawable/Drawable;", "createRoundedProgressDrawable", "dispatchRestoreInstanceState", "", "container", "Landroid/util/SparseArray;", "Landroid/os/Parcelable;", "dispatchSaveInstanceState", "getCornerRadiusFromAttrs", "rpbAttributes", "Landroid/content/res/TypedArray;", "getNormalizedValue", "progressPercentage", "getProgressPercentage", "getScaledProgressValue", "preScaledValue", "getTextPositionRatio", "initAttributes", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onRestoreInstanceState", "state", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "redrawCorners", "setAnimationLength", "newAnimationLength", "setBackgroundDrawableColor", "newColor", "setBackgroundTextColor", "setCornerRadius", "newRadius", "cornerToModify", "Lcom/mackhartley/roundedprogressbar/CornerRadius;", "topLeftRadius", "topRightRadius", "bottomRightRadius", "bottomLeftRadius", "setCustomFontPath", "newFontPath", "setProgressDrawableColor", "setProgressPercentage", "shouldAnimate", "setProgressTextColor", "setProgressTextFormatter", "newProgressTextFormatter", "Lcom/mackhartley/roundedprogressbar/ProgressTextFormatter;", "setRadiusRestricted", "isRestricted", "setTextPadding", "newTextPadding", "setTextSize", "newTextSize", "shouldShowProgressText", "updateCanvasClipBounds", "Companion", "SavedState", "roundedprogressbar_release"})
public final class RoundedProgressBar
extends ConstraintLayout {
    private final int defaultProgressValue = 0;
    @ColorInt
    private final int defaultProgressDrawableColor;
    @ColorInt
    private final int defaultBackgroundDrawableColor;
    private final int defaultAnimationLength;
    private final float defaultCornerRadius;
    private final boolean defaultIsRadiusRestricted = true;
    private final float defaultTextSize;
    @ColorInt
    private final int defaultProgressTextColor;
    @ColorInt
    private final int defaultBackgroundTextColor;
    private final boolean defaultShowProgressText = true;
    private final float defaultTextPadding;
    private final String defaultFontPath = "";
    private double curProgress;
    private float prevTextPositionRatio;
    @ColorInt
    private int progressDrawableColor;
    @ColorInt
    private int backgroundDrawableColor;
    private long animationLength;
    private float cornerRadiusTL;
    private float cornerRadiusTR;
    private float cornerRadiusBR;
    private float cornerRadiusBL;
    private boolean isRadiusRestricted;
    private int lastReportedHeight;
    private int lastReportedWidth;
    private float textSize;
    @ColorInt
    private int progressTextColor;
    @ColorInt
    private int backgroundTextColor;
    private boolean showProgressText;
    private float textPadding;
    private String customFontPath;
    private final ProgressBar progressBar;
    private final ProgressTextOverlay progressTextOverlay;
    private Path roundedCornersClipPath;
    private static final double MAX_PROGRESS = 100.0;
    private static final double MIN_PROGRESS = 0.0;
    private static final int PROGRESS_BAR_MAX = 100;
    private static final int PROGRESS_SCALAR = 10;
    private static final int INITIAL_PROGRESS_VALUE = 0;
    private static final double SCALE_DRAWABLE_MULTIPLIER = 100.0;
    private static final int PROG_BACKGROUND_LAYER_INDEX = 0;
    private static final int PROG_DRAWABLE_LAYER_INDEX = 1;
    private static final float NO_CORNER_RADIUS_ATTR_SET = -1.0f;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final void initAttributes(AttributeSet attrs) {
        String newFontPath;
        float newTextPadding;
        boolean newIsRadiusRestricted;
        int newAnimationLength;
        boolean newShowProgressText;
        int newBackgroundTextColor;
        int newProgressTextColor;
        float newTextSize;
        int newBackgroundDrawableColor;
        int newProgressDrawableColor;
        if (attrs == null) {
            return;
        }
        TypedArray rpbAttributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.RoundedProgressBar);
        int newProgressValue = rpbAttributes.getInteger(R.styleable.RoundedProgressBar_rpbProgress, this.defaultProgressValue);
        if (newProgressValue != this.defaultProgressValue) {
            RoundedProgressBar.setProgressPercentage$default(this, newProgressValue, false, 2, null);
        }
        if ((newProgressDrawableColor = rpbAttributes.getColor(R.styleable.RoundedProgressBar_rpbProgressColor, this.defaultProgressDrawableColor)) != this.defaultProgressDrawableColor) {
            this.setProgressDrawableColor(newProgressDrawableColor);
        }
        if ((newBackgroundDrawableColor = rpbAttributes.getColor(R.styleable.RoundedProgressBar_rpbBackgroundColor, this.defaultBackgroundDrawableColor)) != this.defaultBackgroundDrawableColor) {
            this.setBackgroundDrawableColor(newBackgroundDrawableColor);
        }
        if ((newTextSize = rpbAttributes.getDimension(R.styleable.RoundedProgressBar_rpbTextSize, this.defaultTextSize)) != this.defaultTextSize) {
            this.setTextSize(newTextSize);
        }
        if ((newProgressTextColor = rpbAttributes.getColor(R.styleable.RoundedProgressBar_rpbProgressTextColor, this.defaultProgressTextColor)) != this.defaultProgressTextColor) {
            this.setProgressTextColor(newProgressTextColor);
        }
        if ((newBackgroundTextColor = rpbAttributes.getColor(R.styleable.RoundedProgressBar_rpbBackgroundTextColor, this.defaultBackgroundTextColor)) != this.defaultBackgroundTextColor) {
            this.setBackgroundTextColor(newBackgroundTextColor);
        }
        if ((newShowProgressText = rpbAttributes.getBoolean(R.styleable.RoundedProgressBar_rpbShowProgressText, this.defaultShowProgressText)) != this.defaultShowProgressText) {
            this.showProgressText(newShowProgressText);
        }
        if ((newAnimationLength = rpbAttributes.getInteger(R.styleable.RoundedProgressBar_rpbAnimationLength, this.defaultAnimationLength)) != this.defaultAnimationLength) {
            this.setAnimationLength(newAnimationLength);
        }
        if ((newIsRadiusRestricted = rpbAttributes.getBoolean(R.styleable.RoundedProgressBar_rpbIsRadiusRestricted, this.defaultIsRadiusRestricted)) != this.defaultIsRadiusRestricted) {
            this.setRadiusRestricted(newIsRadiusRestricted);
        }
        if ((newTextPadding = rpbAttributes.getDimension(R.styleable.RoundedProgressBar_rpbTextPadding, this.defaultTextPadding)) != this.defaultTextPadding) {
            this.setTextPadding(newTextPadding);
        }
        if ((newFontPath = rpbAttributes.getString(R.styleable.RoundedProgressBar_rpbCustomFontPath)) != null && Intrinsics.areEqual((Object)newFontPath, (Object)this.defaultFontPath) ^ true) {
            this.setCustomFontPath(newFontPath);
        }
        TypedArray typedArray = rpbAttributes;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"rpbAttributes");
        this.getCornerRadiusFromAttrs(typedArray);
        rpbAttributes.recycle();
    }

    private final void getCornerRadiusFromAttrs(TypedArray rpbAttributes) {
        float newCornerRadiusBL;
        float newCornerRadiusBR;
        float newCornerRadiusTR;
        float newCornerRadiusTL;
        float resultingCornerRadiusTL = this.defaultCornerRadius;
        float resultingCornerRadiusTR = this.defaultCornerRadius;
        float resultingCornerRadiusBR = this.defaultCornerRadius;
        float resultingCornerRadiusBL = this.defaultCornerRadius;
        float newBlanketCornerRadius = rpbAttributes.getDimension(R.styleable.RoundedProgressBar_rpbCornerRadius, -1.0f);
        if (newBlanketCornerRadius != -1.0f) {
            resultingCornerRadiusTL = newBlanketCornerRadius;
            resultingCornerRadiusTR = newBlanketCornerRadius;
            resultingCornerRadiusBR = newBlanketCornerRadius;
            resultingCornerRadiusBL = newBlanketCornerRadius;
        }
        if ((newCornerRadiusTL = rpbAttributes.getDimension(R.styleable.RoundedProgressBar_rpbCornerRadiusTopLeft, -1.0f)) != -1.0f) {
            resultingCornerRadiusTL = newCornerRadiusTL;
        }
        if ((newCornerRadiusTR = rpbAttributes.getDimension(R.styleable.RoundedProgressBar_rpbCornerRadiusTopRight, -1.0f)) != -1.0f) {
            resultingCornerRadiusTR = newCornerRadiusTR;
        }
        if ((newCornerRadiusBR = rpbAttributes.getDimension(R.styleable.RoundedProgressBar_rpbCornerRadiusBottomRight, -1.0f)) != -1.0f) {
            resultingCornerRadiusBR = newCornerRadiusBR;
        }
        if ((newCornerRadiusBL = rpbAttributes.getDimension(R.styleable.RoundedProgressBar_rpbCornerRadiusBottomLeft, -1.0f)) != -1.0f) {
            resultingCornerRadiusBL = newCornerRadiusBL;
        }
        this.setCornerRadius(resultingCornerRadiusTL, resultingCornerRadiusTR, resultingCornerRadiusBR, resultingCornerRadiusBL);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.lastReportedHeight = h;
        this.lastReportedWidth = w;
        this.redrawCorners();
    }

    private final void redrawCorners() {
        this.setCornerRadius(this.cornerRadiusTL, this.cornerRadiusTR, this.cornerRadiusBR, this.cornerRadiusBL);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.clipPath(this.roundedCornersClipPath);
    }

    private final void updateCanvasClipBounds() {
        int height = this.lastReportedHeight;
        int width = this.lastReportedWidth;
        float radiusTL = MiscUtilsKt.calculateAppropriateCornerRadius(this.cornerRadiusTL, height, this.isRadiusRestricted);
        float radiusTR = MiscUtilsKt.calculateAppropriateCornerRadius(this.cornerRadiusTR, height, this.isRadiusRestricted);
        float radiusBR = MiscUtilsKt.calculateAppropriateCornerRadius(this.cornerRadiusBR, height, this.isRadiusRestricted);
        float radiusBL = MiscUtilsKt.calculateAppropriateCornerRadius(this.cornerRadiusBL, height, this.isRadiusRestricted);
        this.roundedCornersClipPath.reset();
        float[] cornerRadiusList = new float[]{radiusTL, radiusTL, radiusTR, radiusTR, radiusBR, radiusBR, radiusBL, radiusBL};
        this.roundedCornersClipPath.addRoundRect(0.0f, 0.0f, (float)width, (float)height, cornerRadiusList, Path.Direction.CW);
        this.invalidate();
    }

    private final Drawable createRoundedBackgroundDrawable() {
        ShapeDrawable newBgDrawable = new ShapeDrawable((Shape)new RectShape());
        DrawableExtKt.setDrawableTint((Drawable)newBgDrawable, this.backgroundDrawableColor);
        return (Drawable)newBgDrawable;
    }

    private final Drawable createRoundedProgressDrawable() {
        float topLeftRadius = MiscUtilsKt.calculateAppropriateCornerRadius(this.cornerRadiusTL, this.lastReportedHeight, this.isRadiusRestricted);
        float topRightRadius = MiscUtilsKt.calculateAppropriateCornerRadius(this.cornerRadiusTR, this.lastReportedHeight, this.isRadiusRestricted);
        float bottomRightRadius = MiscUtilsKt.calculateAppropriateCornerRadius(this.cornerRadiusBR, this.lastReportedHeight, this.isRadiusRestricted);
        float bottomLeftRadius = MiscUtilsKt.calculateAppropriateCornerRadius(this.cornerRadiusBL, this.lastReportedHeight, this.isRadiusRestricted);
        float[] cornerRadiusValues = new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius};
        ShapeDrawable roundedDrawable = new ShapeDrawable((Shape)new RoundRectShape(cornerRadiusValues, null, null));
        DrawableExtKt.setDrawableTint((Drawable)roundedDrawable, this.progressDrawableColor);
        return (Drawable)new ScaleDrawable((Drawable)roundedDrawable, 0x800003, 1.0f, -1.0f);
    }

    private final int calculateScaleDrawableLevel(double curPercentage) {
        return MathKt.roundToInt((double)(curPercentage * 100.0));
    }

    private final double getNormalizedValue(double progressPercentage) {
        return progressPercentage < 0.0 ? 0.0 : (progressPercentage > 100.0 ? 100.0 : progressPercentage);
    }

    private final int getScaledProgressValue(double preScaledValue) {
        return (int)(preScaledValue * (double)10);
    }

    private final float getTextPositionRatio(double progressPercentage) {
        return (float)(progressPercentage / (double)100);
    }

    public final void setProgressPercentage(double progressPercentage, boolean shouldAnimate) {
        double normalizedProgress = this.getNormalizedValue(progressPercentage);
        int scaledProgressValue = this.getScaledProgressValue(normalizedProgress);
        float textPositionRatio = this.getTextPositionRatio(normalizedProgress);
        if (shouldAnimate) {
            ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)this.progressBar, (String)"progress", (int[])new int[]{scaledProgressValue}).setDuration(this.animationLength);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator, (String)"ObjectAnimator\n         \u2026Duration(animationLength)");
            ObjectAnimator barAnim = objectAnimator;
            ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this.progressTextOverlay), (String)"progress", (float[])new float[]{this.prevTextPositionRatio, textPositionRatio}).setDuration(this.animationLength);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator2, (String)"ObjectAnimator\n         \u2026Duration(animationLength)");
            ObjectAnimator textAnim = objectAnimator2;
            textAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                final /* synthetic */ RoundedProgressBar this$0;

                public final void onAnimationUpdate(ValueAnimator it) {
                    ValueAnimator valueAnimator = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                    Object object = valueAnimator.getAnimatedValue();
                    if (!(object instanceof Float)) {
                        object = null;
                    }
                    Float f = (Float)object;
                    RoundedProgressBar.access$setPrevTextPositionRatio$p(this.this$0, f != null ? f.floatValue() : 0.0f);
                }
                {
                    this.this$0 = roundedProgressBar;
                }
            });
            AnimatorSet animatorSet = new AnimatorSet();
            boolean bl = false;
            boolean bl2 = false;
            AnimatorSet $this$apply = animatorSet;
            boolean bl3 = false;
            $this$apply.play((Animator)barAnim).with((Animator)textAnim);
            AnimatorSet animSet = animatorSet;
            animSet.start();
        } else {
            this.progressBar.setProgress(scaledProgressValue);
            this.progressTextOverlay.setProgress(textPositionRatio);
        }
        this.prevTextPositionRatio = textPositionRatio;
        this.curProgress = normalizedProgress;
    }

    public static /* synthetic */ void setProgressPercentage$default(RoundedProgressBar roundedProgressBar, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        roundedProgressBar.setProgressPercentage(d, bl);
    }

    public final double getProgressPercentage() {
        return this.curProgress;
    }

    public final void setProgressDrawableColor(@ColorInt int newColor) {
        Drawable layerToModify;
        this.progressDrawableColor = newColor;
        Drawable drawable = this.progressBar.getProgressDrawable();
        if (drawable == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }
        Drawable drawable2 = layerToModify = ((LayerDrawable)drawable).getDrawable(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"layerToModify");
        DrawableExtKt.setDrawableTint(drawable2, newColor);
    }

    public final void setBackgroundDrawableColor(@ColorInt int newColor) {
        Drawable layerToModify;
        this.backgroundDrawableColor = newColor;
        Drawable drawable = this.progressBar.getProgressDrawable();
        if (drawable == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }
        Drawable drawable2 = layerToModify = ((LayerDrawable)drawable).getDrawable(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"layerToModify");
        DrawableExtKt.setDrawableTint(drawable2, newColor);
    }

    public final void setProgressTextColor(@ColorInt int newColor) {
        this.progressTextColor = newColor;
        this.progressTextOverlay.setProgressTextColor(newColor);
    }

    public final void setBackgroundTextColor(@ColorInt int newColor) {
        this.backgroundTextColor = newColor;
        this.progressTextOverlay.setBackgroundTextColor(newColor);
    }

    public final void setTextSize(float newTextSize) {
        this.textSize = newTextSize;
        this.progressTextOverlay.setTextSize(newTextSize);
    }

    public final void showProgressText(boolean shouldShowProgressText) {
        this.showProgressText = shouldShowProgressText;
        this.progressTextOverlay.showProgressText(shouldShowProgressText);
    }

    public final void setAnimationLength(long newAnimationLength) {
        this.animationLength = newAnimationLength;
    }

    public final void setCornerRadius(float newRadius, @NotNull CornerRadius cornerToModify) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cornerToModify), (String)"cornerToModify");
        switch (RoundedProgressBar$WhenMappings.$EnumSwitchMapping$0[cornerToModify.ordinal()]) {
            case 1: {
                this.setCornerRadius(newRadius, this.cornerRadiusTR, this.cornerRadiusBR, this.cornerRadiusBL);
                break;
            }
            case 2: {
                this.setCornerRadius(this.cornerRadiusTL, newRadius, this.cornerRadiusBR, this.cornerRadiusBL);
                break;
            }
            case 3: {
                this.setCornerRadius(this.cornerRadiusTL, this.cornerRadiusTR, newRadius, this.cornerRadiusBL);
                break;
            }
            case 4: {
                this.setCornerRadius(this.cornerRadiusTL, this.cornerRadiusTR, this.cornerRadiusBR, newRadius);
                break;
            }
        }
    }

    public final void setCornerRadius(float newRadius) {
        this.setCornerRadius(newRadius, newRadius, newRadius, newRadius);
    }

    public final void setCornerRadius(float topLeftRadius, float topRightRadius, float bottomRightRadius, float bottomLeftRadius) {
        Drawable currentProgressDrawable;
        this.cornerRadiusTL = topLeftRadius;
        this.cornerRadiusTR = topRightRadius;
        this.cornerRadiusBR = bottomRightRadius;
        this.cornerRadiusBL = bottomLeftRadius;
        this.updateCanvasClipBounds();
        LayerDrawable newProgressDrawable = new LayerDrawable(new Drawable[]{this.createRoundedBackgroundDrawable(), this.createRoundedProgressDrawable()});
        this.progressBar.setProgressDrawable((Drawable)newProgressDrawable);
        Drawable drawable = this.progressBar.getProgressDrawable();
        if (drawable == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.LayerDrawable");
        }
        Drawable drawable2 = currentProgressDrawable = ((LayerDrawable)drawable).getDrawable(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"currentProgressDrawable");
        drawable2.setLevel(this.calculateScaleDrawableLevel(this.getProgressPercentage()));
    }

    public final void setRadiusRestricted(boolean isRestricted) {
        this.isRadiusRestricted = isRestricted;
        this.redrawCorners();
    }

    public final void setTextPadding(float newTextPadding) {
        this.textPadding = newTextPadding;
        this.progressTextOverlay.setTextPadding(newTextPadding);
    }

    public final void setProgressTextFormatter(@NotNull ProgressTextFormatter newProgressTextFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)newProgressTextFormatter, (String)"newProgressTextFormatter");
        this.progressTextOverlay.setProgressTextFormatter(newProgressTextFormatter);
    }

    public final void setCustomFontPath(@NotNull String newFontPath) {
        Intrinsics.checkParameterIsNotNull((Object)newFontPath, (String)"newFontPath");
        this.customFontPath = newFontPath;
        this.progressTextOverlay.setCustomFontPath(this.customFontPath);
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.setSavedCurProgress(this.curProgress);
        savedState.setSavedPrevTextPositionRatio(this.prevTextPositionRatio);
        savedState.setSavedProgressDrawableColor(this.progressDrawableColor);
        savedState.setSavedBackgroundDrawableColor(this.backgroundDrawableColor);
        savedState.setSavedAnimationLength(this.animationLength);
        savedState.setSavedCornerRadiusTL(this.cornerRadiusTL);
        savedState.setSavedCornerRadiusTR(this.cornerRadiusTR);
        savedState.setSavedCornerRadiusBR(this.cornerRadiusBR);
        savedState.setSavedCornerRadiusBL(this.cornerRadiusBL);
        savedState.setSavedIsRadiusRestricted(this.isRadiusRestricted);
        savedState.setSavedTextSize(this.textSize);
        savedState.setSavedProgressTextColor(this.progressTextColor);
        savedState.setSavedBackgroundTextColor(this.backgroundTextColor);
        savedState.setSavedShowProgressText(this.showProgressText);
        savedState.setSavedTextPadding(this.textPadding);
        savedState.setSavedCustomFontPath(this.customFontPath);
        return (Parcelable)savedState;
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state instanceof SavedState) {
            super.onRestoreInstanceState(((SavedState)state).getSuperState());
            this.curProgress = ((SavedState)state).getSavedCurProgress();
            this.prevTextPositionRatio = ((SavedState)state).getSavedPrevTextPositionRatio();
            this.progressDrawableColor = ((SavedState)state).getSavedProgressDrawableColor();
            this.backgroundDrawableColor = ((SavedState)state).getSavedBackgroundDrawableColor();
            this.animationLength = ((SavedState)state).getSavedAnimationLength();
            this.cornerRadiusTL = ((SavedState)state).getSavedCornerRadiusTL();
            this.cornerRadiusTR = ((SavedState)state).getSavedCornerRadiusTR();
            this.cornerRadiusBR = ((SavedState)state).getSavedCornerRadiusBR();
            this.cornerRadiusBL = ((SavedState)state).getSavedCornerRadiusBL();
            this.isRadiusRestricted = ((SavedState)state).getSavedIsRadiusRestricted();
            this.setCornerRadius(this.cornerRadiusTL, this.cornerRadiusTR, this.cornerRadiusBR, this.cornerRadiusBL);
            this.setBackgroundDrawableColor(this.backgroundDrawableColor);
            this.setProgressDrawableColor(this.progressDrawableColor);
            this.setProgressPercentage(this.curProgress, false);
            this.textSize = ((SavedState)state).getSavedTextSize();
            this.progressTextColor = ((SavedState)state).getSavedProgressTextColor();
            this.backgroundTextColor = ((SavedState)state).getSavedBackgroundTextColor();
            this.showProgressText = ((SavedState)state).getSavedShowProgressText();
            this.textPadding = ((SavedState)state).getSavedTextPadding();
            this.customFontPath = ((SavedState)state).getSavedCustomFontPath();
            this.setTextSize(this.textSize);
            this.setProgressTextColor(this.progressTextColor);
            this.setBackgroundTextColor(this.backgroundTextColor);
            this.showProgressText(this.showProgressText);
            this.setTextPadding(this.textPadding);
            this.setCustomFontPath(this.customFontPath);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void dispatchSaveInstanceState(@NotNull SparseArray<Parcelable> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        this.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(@NotNull SparseArray<Parcelable> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        this.dispatchThawSelfOnly(container);
    }

    @JvmOverloads
    public RoundedProgressBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        View view;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.defaultProgressDrawableColor = ContextCompat.getColor((Context)context, (int)R.color.rpb_default_progress_color);
        this.defaultBackgroundDrawableColor = ContextCompat.getColor((Context)context, (int)R.color.rpb_default_progress_bg_color);
        this.defaultAnimationLength = context.getResources().getInteger(R.integer.rpb_default_animation_duration);
        this.defaultCornerRadius = context.getResources().getDimension(R.dimen.rpb_default_corner_radius);
        this.defaultIsRadiusRestricted = true;
        this.defaultTextSize = context.getResources().getDimension(R.dimen.rpb_default_text_size);
        this.defaultProgressTextColor = ContextCompat.getColor((Context)context, (int)R.color.rpb_default_text_color);
        this.defaultBackgroundTextColor = ContextCompat.getColor((Context)context, (int)R.color.rpb_default_text_color);
        this.defaultShowProgressText = true;
        this.defaultTextPadding = context.getResources().getDimension(R.dimen.rpb_default_text_padding);
        this.defaultFontPath = "";
        this.progressDrawableColor = this.defaultProgressDrawableColor;
        this.backgroundDrawableColor = this.defaultBackgroundDrawableColor;
        this.animationLength = this.defaultAnimationLength;
        this.cornerRadiusTL = this.defaultCornerRadius;
        this.cornerRadiusTR = this.defaultCornerRadius;
        this.cornerRadiusBR = this.defaultCornerRadius;
        this.cornerRadiusBL = this.defaultCornerRadius;
        this.isRadiusRestricted = this.defaultIsRadiusRestricted;
        this.textSize = this.defaultTextSize;
        this.progressTextColor = this.defaultProgressTextColor;
        this.backgroundTextColor = this.defaultBackgroundTextColor;
        this.showProgressText = this.defaultShowProgressText;
        this.textPadding = this.defaultTextPadding;
        this.customFontPath = this.defaultFontPath;
        this.roundedCornersClipPath = new Path();
        this.setSaveEnabled(true);
        this.setWillNotDraw(false);
        View view2 = view = LayoutInflater.from((Context)context).inflate(R.layout.layout_rounded_progress_bar, (ViewGroup)this, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
        ProgressBar progressBar = (ProgressBar)view2.findViewById(R.id.rounded_progress_bar);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"view.rounded_progress_bar");
        this.progressBar = progressBar;
        ProgressTextOverlay progressTextOverlay = (ProgressTextOverlay)view.findViewById(R.id.progress_text_overlay);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)progressTextOverlay), (String)"view.progress_text_overlay");
        this.progressTextOverlay = progressTextOverlay;
        this.progressBar.setMax(1000);
        this.initAttributes(attrs);
        this.addView(view);
    }

    public /* synthetic */ RoundedProgressBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public RoundedProgressBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RoundedProgressBar(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ float access$getPrevTextPositionRatio$p(RoundedProgressBar $this) {
        return $this.prevTextPositionRatio;
    }

    public static final /* synthetic */ void access$setPrevTextPositionRatio$p(RoundedProgressBar $this, float f) {
        $this.prevTextPositionRatio = f;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 N2\u00020\u0001:\u0001NB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u00062\u0006\u0010M\u001a\u00020\u000fH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001a\"\u0004\b:\u0010\u001cR\u001e\u0010;\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0011\"\u0004\b=\u0010\u0013R\u001e\u0010>\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0011\"\u0004\b@\u0010\u0013R\u001a\u0010A\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u00105\"\u0004\bC\u00107R\u001a\u0010D\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u001a\"\u0004\bF\u0010\u001cR\u001a\u0010G\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u001a\"\u0004\bI\u0010\u001c\u00a8\u0006O"}, d2={"Lcom/mackhartley/roundedprogressbar/RoundedProgressBar$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "savedAnimationLength", "", "getSavedAnimationLength", "()J", "setSavedAnimationLength", "(J)V", "savedBackgroundDrawableColor", "", "getSavedBackgroundDrawableColor", "()I", "setSavedBackgroundDrawableColor", "(I)V", "savedBackgroundTextColor", "getSavedBackgroundTextColor", "setSavedBackgroundTextColor", "savedCornerRadiusBL", "", "getSavedCornerRadiusBL", "()F", "setSavedCornerRadiusBL", "(F)V", "savedCornerRadiusBR", "getSavedCornerRadiusBR", "setSavedCornerRadiusBR", "savedCornerRadiusTL", "getSavedCornerRadiusTL", "setSavedCornerRadiusTL", "savedCornerRadiusTR", "getSavedCornerRadiusTR", "setSavedCornerRadiusTR", "savedCurProgress", "", "getSavedCurProgress", "()D", "setSavedCurProgress", "(D)V", "savedCustomFontPath", "", "getSavedCustomFontPath", "()Ljava/lang/String;", "setSavedCustomFontPath", "(Ljava/lang/String;)V", "savedIsRadiusRestricted", "", "getSavedIsRadiusRestricted", "()Z", "setSavedIsRadiusRestricted", "(Z)V", "savedPrevTextPositionRatio", "getSavedPrevTextPositionRatio", "setSavedPrevTextPositionRatio", "savedProgressDrawableColor", "getSavedProgressDrawableColor", "setSavedProgressDrawableColor", "savedProgressTextColor", "getSavedProgressTextColor", "setSavedProgressTextColor", "savedShowProgressText", "getSavedShowProgressText", "setSavedShowProgressText", "savedTextPadding", "getSavedTextPadding", "setSavedTextPadding", "savedTextSize", "getSavedTextSize", "setSavedTextSize", "writeToParcel", "", "out", "flags", "Companion", "roundedprogressbar_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        private double savedCurProgress;
        private float savedPrevTextPositionRatio;
        @ColorInt
        private int savedProgressDrawableColor;
        @ColorInt
        private int savedBackgroundDrawableColor;
        private long savedAnimationLength;
        private float savedCornerRadiusTL;
        private float savedCornerRadiusTR;
        private float savedCornerRadiusBR;
        private float savedCornerRadiusBL;
        private boolean savedIsRadiusRestricted;
        private float savedTextSize;
        @ColorInt
        private int savedProgressTextColor;
        @ColorInt
        private int savedBackgroundTextColor;
        private boolean savedShowProgressText;
        private float savedTextPadding;
        @NotNull
        private String savedCustomFontPath;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        public final double getSavedCurProgress() {
            return this.savedCurProgress;
        }

        public final void setSavedCurProgress(double d) {
            this.savedCurProgress = d;
        }

        public final float getSavedPrevTextPositionRatio() {
            return this.savedPrevTextPositionRatio;
        }

        public final void setSavedPrevTextPositionRatio(float f) {
            this.savedPrevTextPositionRatio = f;
        }

        public final int getSavedProgressDrawableColor() {
            return this.savedProgressDrawableColor;
        }

        public final void setSavedProgressDrawableColor(int n) {
            this.savedProgressDrawableColor = n;
        }

        public final int getSavedBackgroundDrawableColor() {
            return this.savedBackgroundDrawableColor;
        }

        public final void setSavedBackgroundDrawableColor(int n) {
            this.savedBackgroundDrawableColor = n;
        }

        public final long getSavedAnimationLength() {
            return this.savedAnimationLength;
        }

        public final void setSavedAnimationLength(long l) {
            this.savedAnimationLength = l;
        }

        public final float getSavedCornerRadiusTL() {
            return this.savedCornerRadiusTL;
        }

        public final void setSavedCornerRadiusTL(float f) {
            this.savedCornerRadiusTL = f;
        }

        public final float getSavedCornerRadiusTR() {
            return this.savedCornerRadiusTR;
        }

        public final void setSavedCornerRadiusTR(float f) {
            this.savedCornerRadiusTR = f;
        }

        public final float getSavedCornerRadiusBR() {
            return this.savedCornerRadiusBR;
        }

        public final void setSavedCornerRadiusBR(float f) {
            this.savedCornerRadiusBR = f;
        }

        public final float getSavedCornerRadiusBL() {
            return this.savedCornerRadiusBL;
        }

        public final void setSavedCornerRadiusBL(float f) {
            this.savedCornerRadiusBL = f;
        }

        public final boolean getSavedIsRadiusRestricted() {
            return this.savedIsRadiusRestricted;
        }

        public final void setSavedIsRadiusRestricted(boolean bl) {
            this.savedIsRadiusRestricted = bl;
        }

        public final float getSavedTextSize() {
            return this.savedTextSize;
        }

        public final void setSavedTextSize(float f) {
            this.savedTextSize = f;
        }

        public final int getSavedProgressTextColor() {
            return this.savedProgressTextColor;
        }

        public final void setSavedProgressTextColor(int n) {
            this.savedProgressTextColor = n;
        }

        public final int getSavedBackgroundTextColor() {
            return this.savedBackgroundTextColor;
        }

        public final void setSavedBackgroundTextColor(int n) {
            this.savedBackgroundTextColor = n;
        }

        public final boolean getSavedShowProgressText() {
            return this.savedShowProgressText;
        }

        public final void setSavedShowProgressText(boolean bl) {
            this.savedShowProgressText = bl;
        }

        public final float getSavedTextPadding() {
            return this.savedTextPadding;
        }

        public final void setSavedTextPadding(float f) {
            this.savedTextPadding = f;
        }

        @NotNull
        public final String getSavedCustomFontPath() {
            return this.savedCustomFontPath;
        }

        public final void setSavedCustomFontPath(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.savedCustomFontPath = string;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeDouble(this.savedCurProgress);
            out.writeFloat(this.savedPrevTextPositionRatio);
            out.writeInt(this.savedProgressDrawableColor);
            out.writeInt(this.savedBackgroundDrawableColor);
            out.writeLong(this.savedAnimationLength);
            out.writeFloat(this.savedCornerRadiusTL);
            out.writeFloat(this.savedCornerRadiusTR);
            out.writeFloat(this.savedCornerRadiusBR);
            out.writeFloat(this.savedCornerRadiusBL);
            out.writeByte(this.savedIsRadiusRestricted ? (byte)1 : (byte)0);
            out.writeFloat(this.savedTextSize);
            out.writeInt(this.savedProgressTextColor);
            out.writeInt(this.savedBackgroundTextColor);
            out.writeByte(this.savedShowProgressText ? (byte)1 : (byte)0);
            out.writeFloat(this.savedTextPadding);
            out.writeString(this.savedCustomFontPath);
        }

        public SavedState(@Nullable Parcelable superState) {
            super(superState);
            this.savedIsRadiusRestricted = true;
            this.savedShowProgressText = true;
            this.savedCustomFontPath = "";
        }

        public SavedState(@NotNull Parcel source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source);
            this.savedIsRadiusRestricted = true;
            this.savedShowProgressText = true;
            this.savedCustomFontPath = "";
            this.savedCurProgress = source.readDouble();
            this.savedPrevTextPositionRatio = source.readFloat();
            this.savedProgressDrawableColor = source.readInt();
            this.savedBackgroundDrawableColor = source.readInt();
            this.savedAnimationLength = source.readLong();
            this.savedCornerRadiusTL = source.readFloat();
            this.savedCornerRadiusTR = source.readFloat();
            this.savedCornerRadiusBR = source.readFloat();
            this.savedCornerRadiusBL = source.readFloat();
            this.savedIsRadiusRestricted = source.readByte() != (byte)0;
            this.savedTextSize = source.readFloat();
            this.savedProgressTextColor = source.readInt();
            this.savedBackgroundTextColor = source.readInt();
            this.savedShowProgressText = source.readByte() != (byte)0;
            this.savedTextPadding = source.readFloat();
            String string = source.readString();
            if (string == null) {
                string = "";
            }
            this.savedCustomFontPath = string;
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel source) {
                    Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                    return new SavedState(source);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/mackhartley/roundedprogressbar/RoundedProgressBar$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/mackhartley/roundedprogressbar/RoundedProgressBar$SavedState;", "CREATOR$annotations", "roundedprogressbar_release"})
        public static final class Companion {
            public static /* synthetic */ void CREATOR$annotations() {
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/mackhartley/roundedprogressbar/RoundedProgressBar$Companion;", "", "()V", "INITIAL_PROGRESS_VALUE", "", "MAX_PROGRESS", "", "MIN_PROGRESS", "NO_CORNER_RADIUS_ATTR_SET", "", "PROGRESS_BAR_MAX", "PROGRESS_SCALAR", "PROG_BACKGROUND_LAYER_INDEX", "PROG_DRAWABLE_LAYER_INDEX", "SCALE_DRAWABLE_MULTIPLIER", "roundedprogressbar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

