/*
 * Decompiled with CFR 0.152.
 */
package com.ctetin.expandabletextviewlibrary;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.PatternsCompat;
import android.support.v7.widget.AppCompatTextView;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.ctetin.expandabletextviewlibrary.R;
import com.ctetin.expandabletextviewlibrary.app.LinkType;
import com.ctetin.expandabletextviewlibrary.app.StatusType;
import com.ctetin.expandabletextviewlibrary.model.ExpandableStatusFix;
import com.ctetin.expandabletextviewlibrary.model.FormatData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpandableTextView
extends AppCompatTextView {
    private static final int DEF_MAX_LINE = 4;
    public static String TEXT_CONTRACT = "\u6536\u8d77";
    public static String TEXT_EXPEND = "\u5c55\u5f00";
    public static final String Space = " ";
    public static String TEXT_TARGET = "\u7f51\u9875\u94fe\u63a5";
    public static final String IMAGE_TARGET = "\u56fe";
    public static final String TARGET = "\u56fe" + TEXT_TARGET;
    public static final String DEFAULT_CONTENT = "                                                                                                                                                                                                                                                                                                                           ";
    private static int retryTime = 0;
    public static final String regexp_mention = "@[\\w\\p{InCJKUnifiedIdeographs}-]{1,26}";
    public static final String self_regex = "\\[([^\\[]*)\\]\\(([^\\(]*)\\)";
    private TextPaint mPaint;
    boolean linkHit;
    private Context mContext;
    private ExpandableStatusFix mModel;
    private DynamicLayout mDynamicLayout;
    private int mLimitLines;
    private int currentLines;
    private int mWidth;
    private Drawable mLinkDrawable = null;
    private OnLinkClickListener linkClickListener;
    private boolean mNeedContract = true;
    private FormatData mFormatData;
    private boolean mNeedExpend = true;
    private boolean mNeedMention = true;
    private boolean mNeedLink = true;
    private boolean mNeedSelf = false;
    private boolean mNeedAlwaysShowRight = false;
    private boolean mNeedAnimation = true;
    private int mLineCount;
    private CharSequence mContent;
    private int mExpandTextColor;
    private int mMentionTextColor;
    private int mLinkTextColor;
    private int mSelfTextColor;
    private int mContractTextColor;
    private String mExpandString;
    private String mContractString;
    private String mEndExpandContent;
    private int mEndExpandTextColor;
    boolean dontConsumeNonUrlClicks = true;

    public ExpandableTextView(Context context) {
        this(context, null);
    }

    public ExpandableTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public ExpandableTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
        this.setMovementMethod((MovementMethod)LocalLinkMovementMethod.getInstance());
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TEXT_CONTRACT = context.getString(R.string.social_contract);
        TEXT_EXPEND = context.getString(R.string.social_expend);
        TEXT_TARGET = context.getString(R.string.social_text_target);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableTextView, defStyleAttr, 0);
            this.mLimitLines = a.getInt(R.styleable.ExpandableTextView_ep_max_line, 4);
            this.mNeedExpend = a.getBoolean(R.styleable.ExpandableTextView_ep_need_expand, true);
            this.mNeedContract = a.getBoolean(R.styleable.ExpandableTextView_ep_need_contract, false);
            this.mNeedAnimation = a.getBoolean(R.styleable.ExpandableTextView_ep_need_animation, true);
            this.mNeedSelf = a.getBoolean(R.styleable.ExpandableTextView_ep_need_self, false);
            this.mNeedMention = a.getBoolean(R.styleable.ExpandableTextView_ep_need_mention, true);
            this.mNeedLink = a.getBoolean(R.styleable.ExpandableTextView_ep_need_link, true);
            this.mNeedAlwaysShowRight = a.getBoolean(R.styleable.ExpandableTextView_ep_need_always_showright, false);
            this.mContractString = a.getString(R.styleable.ExpandableTextView_ep_contract_text);
            this.mExpandString = a.getString(R.styleable.ExpandableTextView_ep_expand_text);
            if (TextUtils.isEmpty((CharSequence)this.mExpandString)) {
                this.mExpandString = TEXT_EXPEND;
            }
            if (TextUtils.isEmpty((CharSequence)this.mContractString)) {
                this.mContractString = TEXT_CONTRACT;
            }
            this.mExpandTextColor = a.getColor(R.styleable.ExpandableTextView_ep_expand_color, Color.parseColor((String)"#999999"));
            this.mEndExpandTextColor = a.getColor(R.styleable.ExpandableTextView_ep_expand_color, Color.parseColor((String)"#999999"));
            this.mContractTextColor = a.getColor(R.styleable.ExpandableTextView_ep_contract_color, Color.parseColor((String)"#999999"));
            this.mLinkTextColor = a.getColor(R.styleable.ExpandableTextView_ep_link_color, Color.parseColor((String)"#FF6200"));
            this.mSelfTextColor = a.getColor(R.styleable.ExpandableTextView_ep_self_color, Color.parseColor((String)"#FF6200"));
            this.mMentionTextColor = a.getColor(R.styleable.ExpandableTextView_ep_mention_color, Color.parseColor((String)"#FF6200"));
            int resId = a.getResourceId(R.styleable.ExpandableTextView_ep_link_res, R.mipmap.link);
            this.mLinkDrawable = this.getResources().getDrawable(resId);
            this.currentLines = this.mLimitLines;
            a.recycle();
        } else {
            this.mLinkDrawable = context.getResources().getDrawable(R.mipmap.link);
        }
        this.mContext = context;
        this.mPaint = this.getPaint();
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mLinkDrawable.setBounds(0, 0, 30, 30);
    }

    private SpannableStringBuilder setRealContent(CharSequence content) {
        this.mFormatData = this.formatData(content);
        this.mDynamicLayout = new DynamicLayout((CharSequence)this.mFormatData.getFormatedContent(), this.mPaint, this.mWidth, Layout.Alignment.ALIGN_NORMAL, 1.2f, 0.0f, true);
        this.mLineCount = this.mDynamicLayout.getLineCount();
        if (!this.mNeedExpend || this.mLineCount <= this.mLimitLines) {
            return this.dealLink(this.mFormatData, false);
        }
        return this.dealLink(this.mFormatData, true);
    }

    public void setEndExpendContent(String endExpendContent) {
        this.mEndExpandContent = endExpendContent;
    }

    public void setContent(final String content) {
        this.mContent = content;
        this.currentLines = this.mLimitLines;
        if (this.mWidth <= 0 && this.getWidth() > 0) {
            this.mWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        }
        if (this.mWidth <= 0) {
            if (retryTime > 10) {
                this.setText(DEFAULT_CONTENT);
            }
            this.post(new Runnable(){

                @Override
                public void run() {
                    retryTime++;
                    ExpandableTextView.this.setContent(content);
                }
            });
        } else {
            this.setRealContent(content);
        }
    }

    private String getExpandEndContent() {
        if (TextUtils.isEmpty((CharSequence)this.mEndExpandContent)) {
            return String.format(Locale.getDefault(), "  %s", this.mContractString);
        }
        return String.format(Locale.getDefault(), "  %s  %s", this.mEndExpandContent, this.mContractString);
    }

    private String getHideEndContent() {
        if (TextUtils.isEmpty((CharSequence)this.mEndExpandContent)) {
            return String.format(Locale.getDefault(), this.mNeedAlwaysShowRight ? "  %s" : "...  %s", this.mExpandString);
        }
        return String.format(Locale.getDefault(), this.mNeedAlwaysShowRight ? "  %s  %s" : "...  %s  %s", this.mEndExpandContent, this.mExpandString);
    }

    private SpannableStringBuilder dealLink(FormatData formatData, boolean ignoreMore) {
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        if (this.mModel != null && this.mModel.getStatus() != null) {
            boolean isHide = false;
            if (this.mModel.getStatus() != null) {
                isHide = this.mModel.getStatus().equals((Object)StatusType.STATUS_CONTRACT);
            }
            if (isHide) {
                this.currentLines = this.mLimitLines + (this.mLineCount - this.mLimitLines);
            } else if (this.mNeedContract) {
                this.currentLines = this.mLimitLines;
            }
        }
        if (ignoreMore) {
            if (this.currentLines < this.mLineCount) {
                float emptyWidth;
                int index = this.currentLines - 1;
                int endPosition = this.mDynamicLayout.getLineEnd(index);
                int startPosition = this.mDynamicLayout.getLineStart(index);
                float lineWidth = this.mDynamicLayout.getLineWidth(index);
                String endString = this.getHideEndContent();
                int fitPosition = this.getFitPosition(endString, endPosition, startPosition, lineWidth, this.mPaint.measureText(endString), 0.0f);
                String substring = formatData.getFormatedContent().substring(0, fitPosition);
                if (substring.endsWith("\n")) {
                    substring = substring.substring(0, substring.length() - "\n".length());
                }
                ssb.append((CharSequence)substring);
                if (this.mNeedAlwaysShowRight && (emptyWidth = (float)this.getWidth() - lineWidth - this.mPaint.measureText(endString)) > 0.0f) {
                    float measureText = this.mPaint.measureText(Space);
                    int count = 0;
                    while (measureText * (float)count < emptyWidth) {
                        ++count;
                    }
                    --count;
                    for (int i = 0; i < count; ++i) {
                        ssb.append((CharSequence)Space);
                    }
                }
                ssb.append((CharSequence)endString);
                int expendLength = TextUtils.isEmpty((CharSequence)this.mEndExpandContent) ? 0 : 2 + this.mEndExpandContent.length();
                ssb.setSpan((Object)new ClickableSpan(){

                    public void onClick(View widget) {
                        if (ExpandableTextView.this.mModel != null) {
                            ExpandableTextView.this.mModel.setStatus(StatusType.STATUS_CONTRACT);
                            ExpandableTextView.this.action(ExpandableTextView.this.mModel.getStatus());
                        } else {
                            ExpandableTextView.this.action();
                        }
                    }

                    public void updateDrawState(TextPaint ds) {
                        super.updateDrawState(ds);
                        ds.setColor(ExpandableTextView.this.mExpandTextColor);
                        ds.setUnderlineText(false);
                    }
                }, ssb.length() - this.mExpandString.length() - expendLength, ssb.length(), 17);
            } else {
                ssb.append((CharSequence)formatData.getFormatedContent());
                if (this.mNeedContract) {
                    String endString = this.getExpandEndContent();
                    if (this.mNeedAlwaysShowRight) {
                        int index = this.mDynamicLayout.getLineCount() - 1;
                        float lineWidth = this.mDynamicLayout.getLineWidth(index);
                        float emptyWidth = (float)this.getWidth() - lineWidth - this.mPaint.measureText(endString);
                        if (emptyWidth > 0.0f) {
                            float measureText = this.mPaint.measureText(Space);
                            int count = 0;
                            while (measureText * (float)count < emptyWidth) {
                                ++count;
                            }
                            --count;
                            for (int i = 0; i < count; ++i) {
                                ssb.append((CharSequence)Space);
                            }
                        }
                    }
                    ssb.append((CharSequence)endString);
                    int expendLength = TextUtils.isEmpty((CharSequence)this.mEndExpandContent) ? 0 : 2 + this.mEndExpandContent.length();
                    ssb.setSpan((Object)new ClickableSpan(){

                        public void onClick(View widget) {
                            if (ExpandableTextView.this.mModel != null) {
                                ExpandableTextView.this.mModel.setStatus(StatusType.STATUS_EXPAND);
                                ExpandableTextView.this.action(ExpandableTextView.this.mModel.getStatus());
                            } else {
                                ExpandableTextView.this.action();
                            }
                        }

                        public void updateDrawState(TextPaint ds) {
                            super.updateDrawState(ds);
                            ds.setColor(ExpandableTextView.this.mContractTextColor);
                            ds.setUnderlineText(false);
                        }
                    }, ssb.length() - this.mContractString.length() - expendLength, ssb.length(), 17);
                } else if (!TextUtils.isEmpty((CharSequence)this.mEndExpandContent)) {
                    ssb.append((CharSequence)this.mEndExpandContent);
                    ssb.setSpan((Object)new ForegroundColorSpan(this.mEndExpandTextColor), ssb.length() - this.mEndExpandContent.length(), ssb.length(), 17);
                }
            }
        } else {
            ssb.append((CharSequence)formatData.getFormatedContent());
            if (!TextUtils.isEmpty((CharSequence)this.mEndExpandContent)) {
                ssb.append((CharSequence)this.mEndExpandContent);
                ssb.setSpan((Object)new ForegroundColorSpan(this.mEndExpandTextColor), ssb.length() - this.mEndExpandContent.length(), ssb.length(), 17);
            }
        }
        List<FormatData.PositionData> positionDatas = formatData.getPositionDatas();
        for (FormatData.PositionData data : positionDatas) {
            if (ssb.length() < data.getEnd()) continue;
            if (data.getType().equals((Object)LinkType.LINK_TYPE)) {
                if (this.mNeedExpend && ignoreMore) {
                    int fitPosition = ssb.length() - this.getHideEndContent().length();
                    if (data.getStart() >= fitPosition) continue;
                    SelfImageSpan imageSpan = new SelfImageSpan(this.mLinkDrawable, 1);
                    ssb.setSpan((Object)imageSpan, data.getStart(), data.getStart() + 1, 18);
                    int endPosition = data.getEnd();
                    if (this.currentLines < this.mLineCount && fitPosition > data.getStart() + 1 && fitPosition < data.getEnd()) {
                        endPosition = fitPosition;
                    }
                    if (data.getStart() + 1 >= fitPosition) continue;
                    this.addUrl(ssb, data, endPosition);
                    continue;
                }
                SelfImageSpan imageSpan = new SelfImageSpan(this.mLinkDrawable, 1);
                ssb.setSpan((Object)imageSpan, data.getStart(), data.getStart() + 1, 18);
                this.addUrl(ssb, data, data.getEnd());
                continue;
            }
            if (data.getType().equals((Object)LinkType.MENTION_TYPE)) {
                if (this.mNeedExpend && ignoreMore) {
                    int fitPosition = ssb.length() - this.getHideEndContent().length();
                    if (data.getStart() >= fitPosition) continue;
                    int endPosition = data.getEnd();
                    if (this.currentLines < this.mLineCount && fitPosition < data.getEnd()) {
                        endPosition = fitPosition;
                    }
                    this.addMention(ssb, data, endPosition);
                    continue;
                }
                this.addMention(ssb, data, data.getEnd());
                continue;
            }
            if (!data.getType().equals((Object)LinkType.SELF)) continue;
            if (this.mNeedExpend && ignoreMore) {
                int fitPosition = ssb.length() - this.getHideEndContent().length();
                if (data.getStart() >= fitPosition) continue;
                int endPosition = data.getEnd();
                if (this.currentLines < this.mLineCount && fitPosition < data.getEnd()) {
                    endPosition = fitPosition;
                }
                this.addSelf(ssb, data, endPosition);
                continue;
            }
            this.addSelf(ssb, data, data.getEnd());
        }
        this.setHighlightColor(0);
        this.setText((CharSequence)ssb);
        return ssb;
    }

    private int getFitSpaceCount(float emptyWidth, float endStringWidth) {
        float measureText = this.mPaint.measureText(Space);
        int count = 0;
        while (endStringWidth + measureText * (float)count < emptyWidth) {
            ++count;
        }
        return --count;
    }

    private void addSelf(SpannableStringBuilder ssb, final FormatData.PositionData data, int endPosition) {
        ssb.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                if (ExpandableTextView.this.linkClickListener != null) {
                    ExpandableTextView.this.linkClickListener.onLinkClickListener(LinkType.SELF, data.getSelfAim(), data.getSelfContent());
                }
            }

            public void updateDrawState(TextPaint ds) {
                ds.setColor(ExpandableTextView.this.mSelfTextColor);
                ds.setUnderlineText(false);
            }
        }, data.getStart(), endPosition, 17);
    }

    private void addMention(SpannableStringBuilder ssb, final FormatData.PositionData data, int endPosition) {
        ssb.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                if (ExpandableTextView.this.linkClickListener != null) {
                    ExpandableTextView.this.linkClickListener.onLinkClickListener(LinkType.MENTION_TYPE, data.getUrl(), null);
                }
            }

            public void updateDrawState(TextPaint ds) {
                ds.setColor(ExpandableTextView.this.mMentionTextColor);
                ds.setUnderlineText(false);
            }
        }, data.getStart(), endPosition, 17);
    }

    private void addUrl(SpannableStringBuilder ssb, final FormatData.PositionData data, int endPosition) {
        ssb.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                if (ExpandableTextView.this.linkClickListener != null) {
                    ExpandableTextView.this.linkClickListener.onLinkClickListener(LinkType.LINK_TYPE, data.getUrl(), null);
                } else {
                    Intent intent = new Intent();
                    intent.setAction("android.intent.action.VIEW");
                    intent.setFlags(0x10000000);
                    Uri url = Uri.parse((String)data.getUrl());
                    intent.setData(url);
                    ExpandableTextView.this.mContext.startActivity(intent);
                }
            }

            public void updateDrawState(TextPaint ds) {
                ds.setColor(ExpandableTextView.this.mLinkTextColor);
                ds.setUnderlineText(false);
            }
        }, data.getStart() + 1, endPosition, 17);
    }

    public void setCurrStatus(StatusType type) {
        this.action(type);
    }

    private void action() {
        this.action(null);
    }

    private void action(StatusType type) {
        boolean isHide;
        boolean bl = isHide = this.currentLines < this.mLineCount;
        if (type != null) {
            this.mNeedAnimation = false;
        }
        if (this.mNeedAnimation) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            final boolean finalIsHide = isHide;
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    Float value = (Float)animation.getAnimatedValue();
                    if (finalIsHide) {
                        ExpandableTextView.this.currentLines = ExpandableTextView.this.mLimitLines + (int)((float)(ExpandableTextView.this.mLineCount - ExpandableTextView.this.mLimitLines) * value.floatValue());
                    } else if (ExpandableTextView.this.mNeedContract) {
                        ExpandableTextView.this.currentLines = ExpandableTextView.this.mLimitLines + (int)((float)(ExpandableTextView.this.mLineCount - ExpandableTextView.this.mLimitLines) * (1.0f - value.floatValue()));
                    }
                    ExpandableTextView.this.setText((CharSequence)ExpandableTextView.this.setRealContent(ExpandableTextView.this.mContent));
                }
            });
            valueAnimator.setDuration(100L);
            valueAnimator.start();
        } else {
            if (isHide) {
                this.currentLines = this.mLimitLines + (this.mLineCount - this.mLimitLines);
            } else if (this.mNeedContract) {
                this.currentLines = this.mLimitLines;
            }
            this.setText((CharSequence)this.setRealContent(this.mContent));
        }
    }

    private int getFitPosition(String endString, int endPosition, int startPosition, float lineWidth, float endStringWith, float offset) {
        int position = (int)((lineWidth - (endStringWith + offset)) * (float)(endPosition - startPosition) / lineWidth);
        if (position <= endString.length()) {
            return endPosition;
        }
        float measureText = this.mPaint.measureText(this.mFormatData.getFormatedContent().substring(startPosition, startPosition + position));
        if (measureText <= lineWidth - endStringWith) {
            return startPosition + position;
        }
        return this.getFitPosition(endString, endPosition, startPosition, lineWidth, endStringWith, offset + this.mPaint.measureText(Space));
    }

    private FormatData formatData(CharSequence content) {
        ArrayList<FormatData.PositionData> datasMention;
        FormatData formatData = new FormatData();
        ArrayList<FormatData.PositionData> datas = new ArrayList<FormatData.PositionData>();
        Pattern pattern = Pattern.compile(self_regex, 2);
        Matcher matcher = pattern.matcher(content);
        StringBuffer newResult = new StringBuffer();
        int start = 0;
        int end = 0;
        int temp = 0;
        if (this.mNeedSelf) {
            datasMention = new ArrayList<FormatData.PositionData>();
            while (matcher.find()) {
                start = matcher.start();
                end = matcher.end();
                newResult.append(content.toString().substring(temp, start));
                String result = matcher.group();
                if (TextUtils.isEmpty((CharSequence)result)) continue;
                String aimSrt = result.substring(result.indexOf("[") + 1, result.indexOf("]"));
                String contentSrt = result.substring(result.indexOf("(") + 1, result.indexOf(")"));
                datasMention.add(new FormatData.PositionData(newResult.length() + 1, newResult.length() + 2 + aimSrt.length(), aimSrt, contentSrt, LinkType.SELF));
                newResult.append(Space + aimSrt + Space);
                temp = end;
            }
            datas.addAll(datasMention);
        }
        newResult.append(content.toString().substring(end, content.toString().length()));
        content = newResult.toString();
        newResult = new StringBuffer();
        start = 0;
        end = 0;
        temp = 0;
        if (this.mNeedLink) {
            pattern = PatternsCompat.AUTOLINK_WEB_URL;
            matcher = pattern.matcher(content);
            while (matcher.find()) {
                start = matcher.start();
                end = matcher.end();
                newResult.append(content.toString().substring(temp, start));
                datas.add(new FormatData.PositionData(newResult.length() + 1, newResult.length() + 2 + TARGET.length(), matcher.group(), LinkType.LINK_TYPE));
                newResult.append(Space + TARGET + Space);
                temp = end;
            }
        }
        newResult.append(content.toString().substring(end, content.toString().length()));
        if (this.mNeedMention) {
            pattern = Pattern.compile(regexp_mention, 2);
            matcher = pattern.matcher(newResult.toString());
            datasMention = new ArrayList();
            while (matcher.find()) {
                datasMention.add(new FormatData.PositionData(matcher.start(), matcher.end(), matcher.group(), LinkType.MENTION_TYPE));
            }
            datas.addAll(0, datasMention);
        }
        formatData.setFormatedContent(newResult.toString());
        formatData.setPositionDatas(datas);
        return formatData;
    }

    public void bind(ExpandableStatusFix model) {
        this.mModel = model;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        this.linkHit = false;
        boolean res = super.onTouchEvent(event);
        if (this.dontConsumeNonUrlClicks) {
            return this.linkHit;
        }
        if (action == 1) {
            this.setTextIsSelectable(false);
        }
        return res;
    }

    public OnLinkClickListener getLinkClickListener() {
        return this.linkClickListener;
    }

    public void setLinkClickListener(OnLinkClickListener linkClickListener) {
        this.linkClickListener = linkClickListener;
    }

    public boolean ismNeedMention() {
        return this.mNeedMention;
    }

    public void setNeedMention(boolean mNeedMention) {
        this.mNeedMention = mNeedMention;
    }

    public Drawable getLinkDrawable() {
        return this.mLinkDrawable;
    }

    public void setLinkDrawable(Drawable mLinkDrawable) {
        this.mLinkDrawable = mLinkDrawable;
    }

    public boolean isNeedContract() {
        return this.mNeedContract;
    }

    public void setNeedContract(boolean mNeedContract) {
        this.mNeedContract = mNeedContract;
    }

    public boolean isNeedExpend() {
        return this.mNeedExpend;
    }

    public void setNeedExpend(boolean mNeedExpend) {
        this.mNeedExpend = mNeedExpend;
    }

    public boolean isNeedAnimation() {
        return this.mNeedAnimation;
    }

    public void setNeedAnimation(boolean mNeedAnimation) {
        this.mNeedAnimation = mNeedAnimation;
    }

    public int getExpandableLineCount() {
        return this.mLineCount;
    }

    public void setExpandableLineCount(int mLineCount) {
        this.mLineCount = mLineCount;
    }

    public int getExpandTextColor() {
        return this.mExpandTextColor;
    }

    public void setExpandTextColor(int mExpandTextColor) {
        this.mExpandTextColor = mExpandTextColor;
    }

    public int getExpandableLinkTextColor() {
        return this.mLinkTextColor;
    }

    public void setExpandableLinkTextColor(int mLinkTextColor) {
        this.mLinkTextColor = mLinkTextColor;
    }

    public int getContractTextColor() {
        return this.mContractTextColor;
    }

    public void setContractTextColor(int mContractTextColor) {
        this.mContractTextColor = mContractTextColor;
    }

    public String getExpandString() {
        return this.mExpandString;
    }

    public void setExpandString(String mExpandString) {
        this.mExpandString = mExpandString;
    }

    public String getContractString() {
        return this.mContractString;
    }

    public void setContractString(String mContractString) {
        this.mContractString = mContractString;
    }

    public int getEndExpandTextColor() {
        return this.mEndExpandTextColor;
    }

    public void setEndExpandTextColor(int mEndExpandTextColor) {
        this.mEndExpandTextColor = mEndExpandTextColor;
    }

    public boolean isNeedLink() {
        return this.mNeedLink;
    }

    public void setNeedLink(boolean mNeedLink) {
        this.mNeedLink = mNeedLink;
    }

    public int getSelfTextColor() {
        return this.mSelfTextColor;
    }

    public void setSelfTextColor(int mSelfTextColor) {
        this.mSelfTextColor = mSelfTextColor;
    }

    public boolean isNeedSelf() {
        return this.mNeedSelf;
    }

    public void setNeedSelf(boolean mNeedSelf) {
        this.mNeedSelf = mNeedSelf;
    }

    public boolean isNeedAlwaysShowRight() {
        return this.mNeedAlwaysShowRight;
    }

    public void setNeedAlwaysShowRight(boolean mNeedAlwaysShowRight) {
        this.mNeedAlwaysShowRight = mNeedAlwaysShowRight;
    }

    public static interface OnLinkClickListener {
        public void onLinkClickListener(LinkType var1, String var2, String var3);
    }

    public static class LocalLinkMovementMethod
    extends LinkMovementMethod {
        static LocalLinkMovementMethod sInstance;

        public static LocalLinkMovementMethod getInstance() {
            if (sInstance == null) {
                sInstance = new LocalLinkMovementMethod();
            }
            return sInstance;
        }

        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            int action = event.getAction();
            if (action == 1 || action == 0) {
                int line;
                int x = (int)event.getX();
                int y = (int)event.getY();
                x -= widget.getTotalPaddingLeft();
                y -= widget.getTotalPaddingTop();
                Layout layout = widget.getLayout();
                int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
                ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
                if (link.length != 0) {
                    if (action == 1) {
                        link[0].onClick((View)widget);
                    } else if (action == 0) {
                        Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                    }
                    if (widget instanceof ExpandableTextView) {
                        ((ExpandableTextView)widget).linkHit = true;
                    }
                    return true;
                }
                Selection.removeSelection((Spannable)buffer);
                Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
                return false;
            }
            return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
        }
    }

    class SelfImageSpan
    extends ImageSpan {
        private Drawable drawable;

        public SelfImageSpan(Drawable d, int verticalAlignment) {
            super(d, verticalAlignment);
            this.drawable = d;
        }

        public Drawable getDrawable() {
            return this.drawable;
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Drawable b = this.getDrawable();
            Paint.FontMetricsInt fm = paint.getFontMetricsInt();
            int transY = (y + fm.descent + y + fm.ascent) / 2 - b.getBounds().bottom / 2;
            canvas.save();
            canvas.translate(x, (float)transY);
            b.draw(canvas);
            canvas.restore();
        }
    }
}

