/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.immersion;

import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;

public class CropRomUtils {
    private static Integer romType;

    public static int getLightStatausBarAvailableRomType() {
        if (romType != null) {
            return romType;
        }
        if (CropRomUtils.isMIUIV6OrAbove()) {
            romType = 1;
            return romType;
        }
        if (CropRomUtils.isFlymeV4OrAbove()) {
            romType = 2;
            return romType;
        }
        if (CropRomUtils.isAndroid5OrAbove()) {
            romType = 3;
            return romType;
        }
        romType = 4;
        return romType;
    }

    private static boolean isFlymeV4OrAbove() {
        return CropRomUtils.getFlymeVersion() >= 4;
    }

    public static int getFlymeVersion() {
        String displayId = Build.DISPLAY;
        if (!TextUtils.isEmpty((CharSequence)displayId) && displayId.contains("Flyme")) {
            displayId = displayId.replaceAll("Flyme", "");
            displayId = displayId.replaceAll("OS", "");
            String version = (displayId = displayId.replaceAll(" ", "")).substring(0, 1);
            if (version != null) {
                return CropRomUtils.stringToInt(version);
            }
        }
        return 0;
    }

    private static boolean isMIUIV6OrAbove() {
        String miuiVersionCodeStr = CropRomUtils.getSystemProperty("ro.miui.ui.version.code");
        if (!TextUtils.isEmpty((CharSequence)miuiVersionCodeStr)) {
            try {
                int miuiVersionCode = Integer.parseInt(miuiVersionCodeStr);
                if (miuiVersionCode >= 4) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static int getMIUIVersionCode() {
        String miuiVersionCodeStr = CropRomUtils.getSystemProperty("ro.miui.ui.version.code");
        int miuiVersionCode = 0;
        if (!TextUtils.isEmpty((CharSequence)miuiVersionCodeStr)) {
            try {
                miuiVersionCode = Integer.parseInt(miuiVersionCodeStr);
                return miuiVersionCode;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return miuiVersionCode;
    }

    private static boolean isAndroid5OrAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemProperty(String propName) {
        String line;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            String string2 = null;
            return string2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return line;
    }

    public static int stringToInt(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]+$");
        if (pattern.matcher(str).matches()) {
            return Integer.valueOf(str);
        }
        return 0;
    }

    public class AvailableRomType {
        public static final int MIUI = 1;
        public static final int FLYME = 2;
        public static final int ANDROID_NATIVE = 3;
        public static final int NA = 4;
    }
}

