/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnCallbackListener;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ValueOf;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.InputStream;

public class MediaUtils {
    @Nullable
    public static Uri createImageUri(Context context, String suffixType) {
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        values.put("datetaken", time);
        values.put("mime_type", TextUtils.isEmpty((CharSequence)suffixType) ? "image/jpeg" : suffixType);
        if (status.equals("mounted")) {
            values.put("relative_path", "DCIM/Camera");
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)"external"), values);
        } else {
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Images.Media.getContentUri((String)"internal"), values);
        }
        return imageFilePath[0];
    }

    @Nullable
    public static Uri createVideoUri(Context context, String suffixType) {
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        values.put("datetaken", time);
        values.put("mime_type", TextUtils.isEmpty((CharSequence)suffixType) ? "video/mp4" : suffixType);
        if (status.equals("mounted")) {
            values.put("relative_path", Environment.DIRECTORY_MOVIES);
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Video.Media.getContentUri((String)"external"), values);
        } else {
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Video.Media.getContentUri((String)"internal"), values);
        }
        return imageFilePath[0];
    }

    public static long extractDuration(Context context, boolean isAndroidQ, String path) {
        return isAndroidQ ? MediaUtils.getLocalDuration(context, Uri.parse((String)path)) : MediaUtils.getLocalDuration(path);
    }

    public static boolean isLongImg(LocalMedia media) {
        if (null != media) {
            int newHeight;
            int width = media.getWidth();
            int height = media.getHeight();
            return height > (newHeight = width * 3);
        }
        return false;
    }

    public static boolean isLongImg(int width, int height) {
        int newHeight = width * 3;
        return height > newHeight;
    }

    private static long getLocalDuration(Context context, Uri uri) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            return Long.parseLong(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long getLocalDuration(String path) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(path);
            return Long.parseLong(mmr.extractMetadata(9));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getImageSizeForUrlToAndroidQ(Context context, String url) {
        int[] size = new int[2];
        try (Cursor query = null;){
            if (Build.VERSION.SDK_INT >= 26 && (query = context.getApplicationContext().getContentResolver().query(Uri.parse((String)url), null, null, null)) != null) {
                query.moveToFirst();
                size[0] = query.getInt(query.getColumnIndexOrThrow("width"));
                size[1] = query.getInt(query.getColumnIndexOrThrow("height"));
            }
        }
        return size;
    }

    public static int[] getVideoSizeForUrl(String url) {
        int[] size = new int[2];
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(url);
            size[0] = ValueOf.toInt(mmr.extractMetadata(18));
            size[1] = ValueOf.toInt(mmr.extractMetadata(19));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int[] getVideoSizeForUri(Context context, Uri uri) {
        int[] size = new int[2];
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            size[0] = ValueOf.toInt(mmr.extractMetadata(18));
            size[1] = ValueOf.toInt(mmr.extractMetadata(19));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int[] getImageSizeForUrl(String url) {
        int[] size = new int[2];
        try {
            ExifInterface exifInterface = new ExifInterface(url);
            int width = exifInterface.getAttributeInt("ImageWidth", 1);
            int height = exifInterface.getAttributeInt("ImageLength", 1);
            size[0] = width;
            size[1] = height;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getImageSizeForUri(Context context, Uri uri) {
        ParcelFileDescriptor fileDescriptor;
        int[] size;
        block4: {
            size = new int[2];
            fileDescriptor = null;
            try {
                fileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
                if (fileDescriptor == null) break block4;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
                size[0] = options.outWidth;
                size[1] = options.outHeight;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    PictureFileUtils.close(fileDescriptor);
                    throw throwable;
                }
                PictureFileUtils.close((Closeable)fileDescriptor);
            }
        }
        PictureFileUtils.close((Closeable)fileDescriptor);
        return size;
    }

    public static void removeMedia(Context context, int id2) {
        try {
            ContentResolver cr = context.getApplicationContext().getContentResolver();
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = "_id=?";
            cr.delete(uri, selection, new String[]{Long.toString(id2)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDCIMLastImageId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getDCIMCameraPath();
            String ORDER_BY = "_id DESC";
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            data = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, selection, selectionArgs, ORDER_BY);
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                int id2 = data.getInt(data.getColumnIndex("_id"));
                long date = data.getLong(data.getColumnIndex("date_added"));
                int duration = DateUtils.dateDiffer(date);
                int n = duration <= 1 ? id2 : -1;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCameraFirstBucketId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getDCIMCameraPath();
            String ORDER_BY = "_id DESC";
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, selection, selectionArgs, ORDER_BY);
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                long l = data.getLong(data.getColumnIndex("bucket_id"));
                return l;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getAudioFilePathFromUri(Context context, Uri uri) {
        String path = "";
        try (Cursor cursor = null;){
            cursor = context.getApplicationContext().getContentResolver().query(uri, null, null, null, null);
            if (cursor != null) {
                cursor.moveToFirst();
                int index = cursor.getColumnIndex("_data");
                path = cursor.getString(index);
            }
        }
        return path;
    }

    public static int getVideoOrientationForUrl(String path) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(path);
            int rotation = ValueOf.toInt(mmr.extractMetadata(24));
            switch (rotation) {
                case 90: {
                    return 6;
                }
                case 270: {
                    return 8;
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getVideoOrientationForUri(Context context, Uri uri) {
        try {
            MediaMetadataRetriever mmr = new MediaMetadataRetriever();
            mmr.setDataSource(context, uri);
            int orientation = ValueOf.toInt(mmr.extractMetadata(24));
            switch (orientation) {
                case 90: {
                    return 6;
                }
                case 270: {
                    return 8;
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getImageOrientationForUrl(Context context, String url) {
        ExifInterface exifInterface = null;
        InputStream inputStream = null;
        try {
            if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(url)) {
                inputStream = context.getContentResolver().openInputStream(Uri.parse((String)url));
                if (inputStream != null) {
                    exifInterface = new ExifInterface(inputStream);
                }
            } else {
                exifInterface = new ExifInterface(url);
            }
            int n = exifInterface != null ? exifInterface.getAttributeInt("Orientation", 1) : 0;
            PictureFileUtils.close(inputStream);
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            PictureFileUtils.close(inputStream);
        }
    }

    public static void setOrientationAsynchronous(final Context context, final LocalMedia media, final OnCallbackListener<LocalMedia> listener) {
        if (media.getOrientation() != -1) {
            if (listener != null) {
                listener.onCall(media);
            }
            return;
        }
        PictureThreadUtils.executeByCached(new PictureThreadUtils.SimpleTask<Integer>(){

            @Override
            public Integer doInBackground() {
                int orientation = 0;
                if (PictureMimeType.isHasImage(media.getMimeType())) {
                    orientation = MediaUtils.getImageOrientationForUrl(context, media.getPath());
                } else if (PictureMimeType.isHasVideo(media.getMimeType())) {
                    orientation = PictureMimeType.isContent(media.getPath()) ? MediaUtils.getVideoOrientationForUri(context, Uri.parse((String)media.getPath())) : MediaUtils.getVideoOrientationForUrl(media.getPath());
                }
                return orientation;
            }

            @Override
            public void onSuccess(Integer orientation) {
                if (orientation == 6 || orientation == 8) {
                    int width = media.getWidth();
                    int height = media.getHeight();
                    media.setWidth(height);
                    media.setHeight(width);
                }
                media.setOrientation(orientation);
                if (listener != null) {
                    listener.onCall(media);
                }
            }
        });
    }

    public static void setOrientationSynchronous(Context context, LocalMedia media) {
        int orientation = 0;
        if (PictureMimeType.isHasImage(media.getMimeType())) {
            orientation = MediaUtils.getImageOrientationForUrl(context, media.getPath());
        } else if (PictureMimeType.isHasVideo(media.getMimeType())) {
            orientation = PictureMimeType.isContent(media.getPath()) ? MediaUtils.getVideoOrientationForUri(context, Uri.parse((String)media.getPath())) : MediaUtils.getVideoOrientationForUrl(media.getPath());
        }
        if (orientation == 6 || orientation == 8) {
            int width = media.getWidth();
            int height = media.getHeight();
            media.setWidth(height);
            media.setHeight(width);
        }
        media.setOrientation(orientation);
    }
}

