/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BroadcastManager {
    private static final String TAG = BroadcastManager.class.getSimpleName();
    private LocalBroadcastManager localBroadcastManager;
    private Intent intent;
    private String action;

    public static BroadcastManager getInstance(Context ctx) {
        BroadcastManager broadcastManager = new BroadcastManager();
        broadcastManager.localBroadcastManager = LocalBroadcastManager.getInstance((Context)ctx.getApplicationContext());
        return broadcastManager;
    }

    public BroadcastManager intent(Intent intent) {
        this.intent = intent;
        return this;
    }

    public BroadcastManager action(String action) {
        this.action = action;
        return this;
    }

    public BroadcastManager extras(Bundle bundle) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtras(bundle);
        return this;
    }

    public BroadcastManager put(String key, ArrayList<? extends Parcelable> value) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, value);
        return this;
    }

    public BroadcastManager put(String key, Parcelable[] value) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, value);
        return this;
    }

    public BroadcastManager put(String key, Parcelable value) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, value);
        return this;
    }

    public BroadcastManager put(String key, float value) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, value);
        return this;
    }

    public BroadcastManager put(String key, double value) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, value);
        return this;
    }

    public BroadcastManager put(String key, long value) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, value);
        return this;
    }

    public BroadcastManager put(String key, boolean value) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, value);
        return this;
    }

    public BroadcastManager put(String key, int value) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, value);
        return this;
    }

    public BroadcastManager put(String key, String str) {
        this.createIntent();
        if (this.intent == null) {
            Log.e((String)TAG, (String)"intent create failed");
            return this;
        }
        this.intent.putExtra(key, str);
        return this;
    }

    private void createIntent() {
        if (this.intent == null) {
            Log.d((String)TAG, (String)"intent is not created");
        }
        if (this.intent == null) {
            if (!TextUtils.isEmpty((CharSequence)this.action)) {
                this.intent = new Intent(this.action);
            }
            Log.d((String)TAG, (String)"intent created with action");
        }
    }

    public void broadcast() {
        this.createIntent();
        if (this.intent == null) {
            return;
        }
        if (this.action == null) {
            return;
        }
        this.intent.setAction(this.action);
        if (null != this.localBroadcastManager) {
            this.localBroadcastManager.sendBroadcast(this.intent);
        }
    }

    public void registerReceiver(BroadcastReceiver br, List<String> actions) {
        if (null == br || null == actions) {
            return;
        }
        IntentFilter iFilter = new IntentFilter();
        if (actions != null) {
            for (String action : actions) {
                iFilter.addAction(action);
            }
        }
        if (null != this.localBroadcastManager) {
            this.localBroadcastManager.registerReceiver(br, iFilter);
        }
    }

    public void registerReceiver(BroadcastReceiver br, String ... actions) {
        if (actions == null || actions.length <= 0) {
            return;
        }
        this.registerReceiver(br, Arrays.asList(actions));
    }

    public void unregisterReceiver(BroadcastReceiver br) {
        if (null == br) {
            return;
        }
        try {
            this.localBroadcastManager.unregisterReceiver(br);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterReceiver(BroadcastReceiver br, String ... actions) {
        this.unregisterReceiver(br);
    }
}

