/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.entity.MediaData;
import com.luck.picture.lib.listener.OnQueryDataResultListener;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ValueOf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public final class LocalMediaPageLoader {
    private static final String TAG = LocalMediaPageLoader.class.getSimpleName();
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String ORDER_BY = "_id DESC";
    private static final String NOT_GIF_UNKNOWN = "!='image/*'";
    private static final String NOT_GIF = "!='image/gif' AND mime_type!='image/*'";
    private static final String GROUP_BY_BUCKET_Id = " GROUP BY (bucket_id";
    private static final String COLUMN_COUNT = "count";
    private static final String COLUMN_BUCKET_ID = "bucket_id";
    private static final String COLUMN_BUCKET_DISPLAY_NAME = "bucket_display_name";
    private static final int AUDIO_DURATION = 500;
    private Context mContext;
    private PictureSelectionConfig config;
    private static final long FILE_SIZE_UNIT = 0x100000L;
    private static final String SELECTION = "(media_type=? ) AND _size>0) GROUP BY (bucket_id";
    private static final String SELECTION_29 = "media_type=?  AND _size>0";
    private static final String SELECTION_NOT_GIF = "(media_type=? AND mime_type!='image/gif' AND mime_type!='image/*') AND _size>0) GROUP BY (bucket_id";
    private static final String SELECTION_NOT_GIF_29 = "media_type=? AND mime_type!='image/gif' AND mime_type!='image/*' AND _size>0";
    private static final String SELECTION_SPECIFIED_FORMAT = "(media_type=? AND mime_type";
    private static final String SELECTION_SPECIFIED_FORMAT_29 = "media_type=? AND mime_type";
    private static final String[] SELECTION_ALL_ARGS = new String[]{String.valueOf(1), String.valueOf(3)};
    private static final String[] PROJECTION_29 = new String[]{"_id", "bucket_id", "bucket_display_name", "mime_type"};
    private static final String[] PROJECTION = new String[]{"_id", "_data", "bucket_id", "bucket_display_name", "mime_type", "COUNT(*) AS count"};
    private static final String[] PROJECTION_PAGE = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name", "_display_name", "bucket_id"};
    private static LocalMediaPageLoader instance;

    private static String getSelectionArgsForSingleMediaCondition(String timeCondition) {
        if (SdkVersionUtils.checkedAndroid_Q()) {
            return "media_type=? AND _size>0 AND " + timeCondition;
        }
        return "(media_type=?) AND _size>0 AND " + timeCondition + ")" + GROUP_BY_BUCKET_Id;
    }

    private static String getSelectionArgsForAllMediaCondition(String timeCondition, boolean isGif) {
        if (SdkVersionUtils.checkedAndroid_Q()) {
            return "(media_type=?" + (isGif ? "" : " AND mime_type!='image/gif' AND mime_type!='image/*'") + " OR " + "media_type" + "=? AND " + timeCondition + ") AND " + "_size" + ">0";
        }
        return "(media_type=?" + (isGif ? "" : " AND mime_type!='image/gif' AND mime_type!='image/*'") + " OR " + "media_type=? AND " + timeCondition + ") AND " + "_size" + ">0)" + GROUP_BY_BUCKET_Id;
    }

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    private static String[] getSelectionArgsForPageSingleMediaType(int mediaType, long bucketId) {
        String[] stringArray;
        if (bucketId == -1L) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(mediaType);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = String.valueOf(mediaType);
            stringArray = stringArray3;
            stringArray3[1] = ValueOf.toString(bucketId);
        }
        return stringArray;
    }

    public LocalMediaPageLoader(Context context) {
        this.mContext = context;
        this.config = PictureSelectionConfig.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstCover(long bucketId) {
        Cursor data = null;
        try {
            if (SdkVersionUtils.checkedAndroid_R()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(this.getPageSelection(bucketId), this.getPageSelectionArgs(bucketId), 1, 0);
                data = this.mContext.getContentResolver().query(QUERY_URI, new String[]{"_id", "_data"}, queryArgs, null);
            } else {
                String orderBy = "_id DESC limit 1 offset 0";
                data = this.mContext.getContentResolver().query(QUERY_URI, new String[]{"_id", "_data"}, this.getPageSelection(bucketId), this.getPageSelectionArgs(bucketId), orderBy);
            }
            if (data != null && data.getCount() > 0) {
                if (data.moveToFirst()) {
                    long id2 = data.getLong(data.getColumnIndexOrThrow("_id"));
                    String string2 = SdkVersionUtils.checkedAndroid_Q() ? LocalMediaPageLoader.getRealPathAndroid_Q(id2) : data.getString(data.getColumnIndexOrThrow("_data"));
                    return string2;
                }
                String id2 = null;
                return id2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (data != null && !data.isClosed()) {
                data.close();
            }
        }
        return null;
    }

    public void loadPageMediaData(long bucketId, int page, int limit, OnQueryDataResultListener listener) {
        this.loadPageMediaData(bucketId, page, limit, this.config.pageSize, listener);
    }

    public void loadPageMediaData(long bucketId, int page, OnQueryDataResultListener<LocalMedia> listener) {
        this.loadPageMediaData(bucketId, page, this.config.pageSize, this.config.pageSize, listener);
    }

    public void loadPageMediaData(final long bucketId, final int page, final int limit, final int pageSize, final OnQueryDataResultListener<LocalMedia> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<MediaData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaData doInBackground() {
                Cursor data = null;
                try {
                    if (SdkVersionUtils.checkedAndroid_R()) {
                        Bundle queryArgs = MediaUtils.createQueryArgsBundle(LocalMediaPageLoader.this.getPageSelection(bucketId), LocalMediaPageLoader.this.getPageSelectionArgs(bucketId), limit, (page - 1) * pageSize);
                        data = LocalMediaPageLoader.this.mContext.getContentResolver().query(QUERY_URI, PROJECTION_PAGE, queryArgs, null);
                    } else {
                        String orderBy = page == -1 ? LocalMediaPageLoader.ORDER_BY : "_id DESC limit " + limit + " offset " + (page - 1) * pageSize;
                        data = LocalMediaPageLoader.this.mContext.getContentResolver().query(QUERY_URI, PROJECTION_PAGE, LocalMediaPageLoader.this.getPageSelection(bucketId), LocalMediaPageLoader.this.getPageSelectionArgs(bucketId), orderBy);
                    }
                    if (data != null) {
                        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
                        if (data.getCount() > 0) {
                            int idColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[0]);
                            int dataColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[1]);
                            int mimeTypeColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[2]);
                            int widthColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[3]);
                            int heightColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[4]);
                            int durationColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[5]);
                            int sizeColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[6]);
                            int folderNameColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[7]);
                            int fileNameColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[8]);
                            int bucketIdColumn = data.getColumnIndexOrThrow(PROJECTION_PAGE[9]);
                            data.moveToFirst();
                            do {
                                String url;
                                long id2 = data.getLong(idColumn);
                                String absolutePath = data.getString(dataColumn);
                                String string2 = url = SdkVersionUtils.checkedAndroid_Q() ? LocalMediaPageLoader.getRealPathAndroid_Q(id2) : absolutePath;
                                if (((LocalMediaPageLoader)LocalMediaPageLoader.this).config.isFilterInvalidFile && !PictureFileUtils.isFileExists(absolutePath)) continue;
                                String mimeType = data.getString(mimeTypeColumn);
                                String string3 = mimeType = TextUtils.isEmpty((CharSequence)mimeType) ? PictureMimeType.ofJPEG() : mimeType;
                                if (mimeType.endsWith("image/*")) {
                                    mimeType = PictureMimeType.isContent(url) ? PictureMimeType.getImageMimeType(absolutePath) : PictureMimeType.getImageMimeType(url);
                                    if (!((LocalMediaPageLoader)LocalMediaPageLoader.this).config.isGif && PictureMimeType.isGif(mimeType)) continue;
                                }
                                if (!((LocalMediaPageLoader)LocalMediaPageLoader.this).config.isWebp && mimeType.startsWith(PictureMimeType.ofWEBP()) || !((LocalMediaPageLoader)LocalMediaPageLoader.this).config.isBmp && mimeType.startsWith(PictureMimeType.ofBMP())) continue;
                                int width = data.getInt(widthColumn);
                                int height = data.getInt(heightColumn);
                                long duration = data.getLong(durationColumn);
                                long size = data.getLong(sizeColumn);
                                String folderName = data.getString(folderNameColumn);
                                String fileName = data.getString(fileNameColumn);
                                long bucket_id = data.getLong(bucketIdColumn);
                                if (((LocalMediaPageLoader)LocalMediaPageLoader.this).config.filterFileSize > 0.0f && (float)size > ((LocalMediaPageLoader)LocalMediaPageLoader.this).config.filterFileSize * 1048576.0f || PictureMimeType.isHasVideo(mimeType) && (((LocalMediaPageLoader)LocalMediaPageLoader.this).config.videoMinSecond > 0 && duration < (long)((LocalMediaPageLoader)LocalMediaPageLoader.this).config.videoMinSecond || ((LocalMediaPageLoader)LocalMediaPageLoader.this).config.videoMaxSecond > 0 && duration > (long)((LocalMediaPageLoader)LocalMediaPageLoader.this).config.videoMaxSecond || duration == 0L || size <= 0L)) continue;
                                LocalMedia image = new LocalMedia(id2, url, absolutePath, fileName, folderName, duration, ((LocalMediaPageLoader)LocalMediaPageLoader.this).config.chooseMode, mimeType, width, height, size, bucket_id);
                                result.add(image);
                            } while (data.moveToNext());
                        }
                        MediaData mediaData = new MediaData(data.getCount() > 0, result);
                        return mediaData;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)TAG, (String)("loadMedia Page Data Error: " + e.getMessage()));
                    MediaData mediaData = null;
                    return mediaData;
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return null;
            }

            @Override
            public void onSuccess(MediaData result) {
                if (listener != null && result != null) {
                    listener.onComplete(result.data, page, result.isHasNextMore);
                }
            }
        });
    }

    public void loadAllMedia(final OnQueryDataResultListener<LocalMediaFolder> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<LocalMediaFolder>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LocalMediaFolder> doInBackground() {
                Cursor data = LocalMediaPageLoader.this.mContext.getContentResolver().query(QUERY_URI, SdkVersionUtils.checkedAndroid_Q() ? PROJECTION_29 : PROJECTION, LocalMediaPageLoader.this.getSelection(), LocalMediaPageLoader.this.getSelectionArgs(), LocalMediaPageLoader.ORDER_BY);
                try {
                    if (data != null) {
                        int count = data.getCount();
                        int totalCount = 0;
                        ArrayList<LocalMediaFolder> mediaFolders = new ArrayList<LocalMediaFolder>();
                        if (count > 0) {
                            if (SdkVersionUtils.checkedAndroid_Q()) {
                                HashMap<Long, Long> countMap = new HashMap<Long, Long>();
                                while (data.moveToNext()) {
                                    long bucketId = data.getLong(data.getColumnIndex(LocalMediaPageLoader.COLUMN_BUCKET_ID));
                                    Long newCount = (Long)countMap.get(bucketId);
                                    if (newCount == null) {
                                        newCount = 1L;
                                    } else {
                                        Long l = newCount;
                                        Long l2 = newCount = Long.valueOf(newCount + 1L);
                                    }
                                    countMap.put(bucketId, newCount);
                                }
                                if (data.moveToFirst()) {
                                    HashSet<Long> hashSet = new HashSet<Long>();
                                    do {
                                        long bucketId;
                                        if (hashSet.contains(bucketId = data.getLong(data.getColumnIndex(LocalMediaPageLoader.COLUMN_BUCKET_ID)))) continue;
                                        LocalMediaFolder mediaFolder = new LocalMediaFolder();
                                        mediaFolder.setBucketId(bucketId);
                                        String bucketDisplayName = data.getString(data.getColumnIndex(LocalMediaPageLoader.COLUMN_BUCKET_DISPLAY_NAME));
                                        long size = (Long)countMap.get(bucketId);
                                        long id2 = data.getLong(data.getColumnIndex("_id"));
                                        mediaFolder.setName(bucketDisplayName);
                                        mediaFolder.setImageNum(ValueOf.toInt(size));
                                        mediaFolder.setFirstImagePath(LocalMediaPageLoader.getRealPathAndroid_Q(id2));
                                        mediaFolders.add(mediaFolder);
                                        hashSet.add(bucketId);
                                        totalCount = (int)((long)totalCount + size);
                                    } while (data.moveToNext());
                                }
                            } else {
                                data.moveToFirst();
                                do {
                                    LocalMediaFolder mediaFolder = new LocalMediaFolder();
                                    long bucketId = data.getLong(data.getColumnIndex(LocalMediaPageLoader.COLUMN_BUCKET_ID));
                                    String bucketDisplayName = data.getString(data.getColumnIndex(LocalMediaPageLoader.COLUMN_BUCKET_DISPLAY_NAME));
                                    int size = data.getInt(data.getColumnIndex(LocalMediaPageLoader.COLUMN_COUNT));
                                    mediaFolder.setBucketId(bucketId);
                                    String url = data.getString(data.getColumnIndex("_data"));
                                    mediaFolder.setFirstImagePath(url);
                                    mediaFolder.setName(bucketDisplayName);
                                    mediaFolder.setImageNum(size);
                                    mediaFolders.add(mediaFolder);
                                    totalCount += size;
                                } while (data.moveToNext());
                            }
                            LocalMediaPageLoader.this.sortFolder(mediaFolders);
                            LocalMediaFolder allMediaFolder = new LocalMediaFolder();
                            allMediaFolder.setImageNum(totalCount);
                            allMediaFolder.setChecked(true);
                            allMediaFolder.setBucketId(-1L);
                            if (data.moveToFirst()) {
                                String firstUrl = SdkVersionUtils.checkedAndroid_Q() ? LocalMediaPageLoader.getFirstUri(data) : LocalMediaPageLoader.getFirstUrl(data);
                                allMediaFolder.setFirstImagePath(firstUrl);
                            }
                            String bucketDisplayName = ((LocalMediaPageLoader)LocalMediaPageLoader.this).config.chooseMode == PictureMimeType.ofAudio() ? LocalMediaPageLoader.this.mContext.getString(R.string.picture_all_audio) : LocalMediaPageLoader.this.mContext.getString(R.string.picture_camera_roll);
                            allMediaFolder.setName(bucketDisplayName);
                            allMediaFolder.setOfAllType(((LocalMediaPageLoader)LocalMediaPageLoader.this).config.chooseMode);
                            allMediaFolder.setCameraFolder(true);
                            mediaFolders.add(0, allMediaFolder);
                            ArrayList<LocalMediaFolder> arrayList = mediaFolders;
                            return arrayList;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)TAG, (String)("loadAllMedia Data Error: " + e.getMessage()));
                    List<LocalMediaFolder> list = null;
                    return list;
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return new ArrayList<LocalMediaFolder>();
            }

            @Override
            public void onSuccess(List<LocalMediaFolder> result) {
                if (listener != null && result != null) {
                    listener.onComplete(result, 1, false);
                }
            }
        });
    }

    private static String getFirstUri(Cursor cursor) {
        long id2 = cursor.getLong(cursor.getColumnIndex("_id"));
        return LocalMediaPageLoader.getRealPathAndroid_Q(id2);
    }

    private static String getFirstUrl(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndex("_data"));
    }

    private String getPageSelection(long bucketId) {
        String durationCondition = this.getDurationCondition(0L, 0L);
        boolean isQueryFormat = !TextUtils.isEmpty((CharSequence)this.config.specifiedFormat);
        switch (this.config.chooseMode) {
            case 0: {
                if (bucketId == -1L) {
                    return "(media_type=?" + (this.config.isGif ? "" : " AND mime_type!='image/gif' AND mime_type!='image/*'") + " OR " + "media_type" + "=? AND " + durationCondition + ") AND " + "_size" + ">0";
                }
                return "(media_type=?" + (this.config.isGif ? "" : " AND mime_type!='image/gif' AND mime_type!='image/*'") + " OR " + "media_type" + "=? AND " + durationCondition + ") AND " + COLUMN_BUCKET_ID + "=? AND " + "_size" + ">0";
            }
            case 1: {
                if (bucketId == -1L) {
                    if (isQueryFormat) {
                        return "(media_type=?" + " AND mime_type='" + this.config.specifiedFormat + "'" + ") AND " + "_size" + ">0";
                    }
                    return "(media_type=?" + (this.config.isGif ? "" : " AND mime_type!='image/gif' AND mime_type!='image/*'") + ") AND " + "_size" + ">0";
                }
                if (isQueryFormat) {
                    return "(media_type=?" + (this.config.isGif ? "" : " AND mime_type!='image/gif' AND mime_type!='image/*' AND mime_type='" + this.config.specifiedFormat + "'") + ") AND " + COLUMN_BUCKET_ID + "=? AND " + "_size" + ">0";
                }
                return "(media_type=?" + (this.config.isGif ? "" : " AND mime_type!='image/gif' AND mime_type!='image/*'") + ") AND " + COLUMN_BUCKET_ID + "=? AND " + "_size" + ">0";
            }
            case 2: 
            case 3: {
                if (bucketId == -1L) {
                    if (isQueryFormat) {
                        return "(media_type=? AND mime_type='" + this.config.specifiedFormat + "' AND " + durationCondition + ") AND " + "_size" + ">0";
                    }
                    return "(media_type=? AND " + durationCondition + ") AND " + "_size" + ">0";
                }
                if (isQueryFormat) {
                    return "(media_type=? AND mime_type='" + this.config.specifiedFormat + "' AND " + durationCondition + ") AND " + COLUMN_BUCKET_ID + "=? AND " + "_size" + ">0";
                }
                return "(media_type=? AND " + durationCondition + ") AND " + COLUMN_BUCKET_ID + "=? AND " + "_size" + ">0";
            }
        }
        return null;
    }

    private String[] getPageSelectionArgs(long bucketId) {
        switch (this.config.chooseMode) {
            case 0: {
                if (bucketId == -1L) {
                    return new String[]{String.valueOf(1), String.valueOf(3)};
                }
                return new String[]{String.valueOf(1), String.valueOf(3), ValueOf.toString(bucketId)};
            }
            case 1: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(1, bucketId);
            }
            case 2: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(3, bucketId);
            }
            case 3: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(2, bucketId);
            }
        }
        return null;
    }

    private String getSelection() {
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaPageLoader.getSelectionArgsForAllMediaCondition(this.getDurationCondition(0L, 0L), this.config.isGif);
            }
            case 1: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    if (SdkVersionUtils.checkedAndroid_Q()) {
                        return "media_type=? AND mime_type='" + this.config.specifiedFormat + "' AND " + "_size" + ">0";
                    }
                    return "(media_type=? AND mime_type='" + this.config.specifiedFormat + "') AND " + "_size" + ">0)" + GROUP_BY_BUCKET_Id;
                }
                if (SdkVersionUtils.checkedAndroid_Q()) {
                    return this.config.isGif ? SELECTION_29 : SELECTION_NOT_GIF_29;
                }
                return this.config.isGif ? SELECTION : SELECTION_NOT_GIF;
            }
            case 2: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    if (SdkVersionUtils.checkedAndroid_Q()) {
                        return "media_type=? AND mime_type='" + this.config.specifiedFormat + "' AND " + "_size" + ">0";
                    }
                    return "(media_type=? AND mime_type='" + this.config.specifiedFormat + "') AND " + "_size" + ">0)" + GROUP_BY_BUCKET_Id;
                }
                return LocalMediaPageLoader.getSelectionArgsForSingleMediaCondition(this.getDurationCondition(0L, 0L));
            }
            case 3: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    if (SdkVersionUtils.checkedAndroid_Q()) {
                        return "media_type=? AND mime_type='" + this.config.specifiedFormat + "' AND " + "_size" + ">0";
                    }
                    return "(media_type=? AND mime_type='" + this.config.specifiedFormat + "') AND " + "_size" + ">0)" + GROUP_BY_BUCKET_Id;
                }
                return LocalMediaPageLoader.getSelectionArgsForSingleMediaCondition(this.getDurationCondition(0L, 500L));
            }
        }
        return null;
    }

    private String[] getSelectionArgs() {
        switch (this.config.chooseMode) {
            case 0: {
                return SELECTION_ALL_ARGS;
            }
            case 1: {
                return LocalMediaPageLoader.getSelectionArgsForSingleMediaType(1);
            }
            case 2: {
                return LocalMediaPageLoader.getSelectionArgsForSingleMediaType(3);
            }
            case 3: {
                return LocalMediaPageLoader.getSelectionArgsForSingleMediaType(2);
            }
        }
        return null;
    }

    private void sortFolder(List<LocalMediaFolder> imageFolders) {
        Collections.sort(imageFolders, (lhs, rhs) -> {
            if (lhs.getData() == null || rhs.getData() == null) {
                return 0;
            }
            int lSize = lhs.getImageNum();
            int rSize = rhs.getImageNum();
            return Integer.compare(rSize, lSize);
        });
    }

    private static String getRealPathAndroid_Q(long id2) {
        return QUERY_URI.buildUpon().appendPath(ValueOf.toString(id2)).build().toString();
    }

    private String getDurationCondition(long exMaxLimit, long exMinLimit) {
        long maxS;
        long l = maxS = this.config.videoMaxSecond == 0 ? Long.MAX_VALUE : (long)this.config.videoMaxSecond;
        if (exMaxLimit != 0L) {
            maxS = Math.min(maxS, exMaxLimit);
        }
        return String.format(Locale.CHINA, "%d <%s duration and duration <= %d", Math.max(exMinLimit, (long)this.config.videoMinSecond), Math.max(exMinLimit, (long)this.config.videoMinSecond) == 0L ? "" : "=", maxS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalMediaPageLoader getInstance(Context context) {
        if (instance != null) return instance;
        Class<LocalMediaPageLoader> clazz = LocalMediaPageLoader.class;
        synchronized (LocalMediaPageLoader.class) {
            if (instance != null) return instance;
            instance = new LocalMediaPageLoader(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static void setInstanceNull() {
        instance = null;
    }
}

