/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.camera;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.view.CameraView;
import androidx.camera.view.video.OnVideoSavedCallback;
import androidx.camera.view.video.OutputFileResults;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.R;
import com.luck.picture.lib.camera.listener.CameraListener;
import com.luck.picture.lib.camera.listener.CaptureListener;
import com.luck.picture.lib.camera.listener.ClickListener;
import com.luck.picture.lib.camera.listener.ImageCallbackListener;
import com.luck.picture.lib.camera.listener.TypeListener;
import com.luck.picture.lib.camera.view.CaptureLayout;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.AndroidQTransformUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class CustomCameraView
extends RelativeLayout {
    public static final int BUTTON_STATE_ONLY_CAPTURE = 257;
    public static final int BUTTON_STATE_ONLY_RECORDER = 258;
    public static final int BUTTON_STATE_BOTH = 259;
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private int type_flash = 35;
    private PictureSelectionConfig mConfig;
    private CameraListener mCameraListener;
    private ClickListener mOnClickListener;
    private ImageCallbackListener mImageCallbackListener;
    private CameraView mCameraView;
    private ImageView mImagePreview;
    private ImageView mSwitchCamera;
    private ImageView mFlashLamp;
    private CaptureLayout mCaptureLayout;
    private MediaPlayer mMediaPlayer;
    private TextureView mTextureView;
    private long recordTime = 0L;
    private File mVideoFile;
    private File mPhotoFile;
    private TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            CustomCameraView.this.startVideoPlay(CustomCameraView.this.mVideoFile);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };

    public CustomCameraView(Context context) {
        this(context, null);
    }

    public CustomCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void initView() {
        this.setWillNotDraw(false);
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_black));
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.picture_camera_view, (ViewGroup)this);
        this.mCameraView = (CameraView)view.findViewById(R.id.cameraView);
        this.mCameraView.enableTorch(true);
        this.mTextureView = (TextureView)view.findViewById(R.id.video_play_preview);
        this.mImagePreview = (ImageView)view.findViewById(R.id.image_preview);
        this.mSwitchCamera = (ImageView)view.findViewById(R.id.image_switch);
        this.mSwitchCamera.setImageResource(R.drawable.picture_ic_camera);
        this.mFlashLamp = (ImageView)view.findViewById(R.id.image_flash);
        this.setFlashRes();
        this.mFlashLamp.setOnClickListener(v -> {
            ++this.type_flash;
            if (this.type_flash > 35) {
                this.type_flash = 33;
            }
            this.setFlashRes();
        });
        this.mCaptureLayout = (CaptureLayout)view.findViewById(R.id.capture_layout);
        this.mCaptureLayout.setDuration(15000);
        this.mSwitchCamera.setOnClickListener(v -> this.mCameraView.toggleCamera());
        this.mCaptureLayout.setCaptureListener(new CaptureListener(){

            @Override
            public void takePictures() {
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                CustomCameraView.this.mCameraView.setCaptureMode(CameraView.CaptureMode.IMAGE);
                File imageOutFile = CustomCameraView.this.createImageFile();
                if (imageOutFile == null) {
                    return;
                }
                CustomCameraView.this.mPhotoFile = imageOutFile;
                ImageCapture.OutputFileOptions fileOptions = new ImageCapture.OutputFileOptions.Builder(CustomCameraView.this.mPhotoFile).build();
                CustomCameraView.this.mCameraView.takePicture(fileOptions, ContextCompat.getMainExecutor((Context)CustomCameraView.this.getContext()), (ImageCapture.OnImageSavedCallback)new MyImageResultCallback(CustomCameraView.this.getContext(), CustomCameraView.this.mConfig, imageOutFile, CustomCameraView.this.mImagePreview, CustomCameraView.this.mCaptureLayout, CustomCameraView.this.mImageCallbackListener, CustomCameraView.this.mCameraListener));
            }

            @Override
            public void recordStart() {
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                CustomCameraView.this.mCameraView.setCaptureMode(CameraView.CaptureMode.VIDEO);
                CustomCameraView.this.mVideoFile = CustomCameraView.this.createVideoFile();
                CustomCameraView.this.mCameraView.startRecording(CustomCameraView.this.mVideoFile, ContextCompat.getMainExecutor((Context)CustomCameraView.this.getContext()), new OnVideoSavedCallback(){

                    public void onVideoSaved(@NonNull OutputFileResults outputFileResults) {
                        if (CustomCameraView.this.recordTime < 1500L && CustomCameraView.this.mVideoFile.exists() && CustomCameraView.this.mVideoFile.delete()) {
                            return;
                        }
                        if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(((CustomCameraView)CustomCameraView.this).mConfig.cameraPath)) {
                            PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<Boolean>(){

                                @Override
                                public Boolean doInBackground() {
                                    return AndroidQTransformUtils.copyPathToDCIM(CustomCameraView.this.getContext(), CustomCameraView.this.mVideoFile, Uri.parse((String)((CustomCameraView)CustomCameraView.this).mConfig.cameraPath));
                                }

                                @Override
                                public void onSuccess(Boolean result) {
                                    PictureThreadUtils.cancel(PictureThreadUtils.getIoPool());
                                }
                            });
                        }
                        CustomCameraView.this.mTextureView.setVisibility(0);
                        CustomCameraView.this.mCameraView.setVisibility(4);
                        if (CustomCameraView.this.mTextureView.isAvailable()) {
                            CustomCameraView.this.startVideoPlay(CustomCameraView.this.mVideoFile);
                        } else {
                            CustomCameraView.this.mTextureView.setSurfaceTextureListener(CustomCameraView.this.surfaceTextureListener);
                        }
                    }

                    public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                        if (CustomCameraView.this.mCameraListener != null) {
                            CustomCameraView.this.mCameraListener.onError(videoCaptureError, message, cause);
                        }
                    }
                });
            }

            @Override
            public void recordShort(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mSwitchCamera.setVisibility(0);
                CustomCameraView.this.mFlashLamp.setVisibility(0);
                CustomCameraView.this.mCaptureLayout.resetCaptureLayout();
                CustomCameraView.this.mCaptureLayout.setTextWithAnimation(CustomCameraView.this.getContext().getString(R.string.picture_recording_time_is_short));
                CustomCameraView.this.mCameraView.stopRecording();
            }

            @Override
            public void recordEnd(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mCameraView.stopRecording();
            }

            @Override
            public void recordZoom(float zoom) {
            }

            @Override
            public void recordError() {
                if (CustomCameraView.this.mCameraListener != null) {
                    CustomCameraView.this.mCameraListener.onError(0, "An unknown error", null);
                }
            }
        });
        this.mCaptureLayout.setTypeListener(new TypeListener(){

            @Override
            public void cancel() {
                CustomCameraView.this.stopVideoPlay();
                CustomCameraView.this.resetState();
            }

            @Override
            public void confirm() {
                if (CustomCameraView.this.mCameraView.getCaptureMode() == CameraView.CaptureMode.VIDEO) {
                    if (CustomCameraView.this.mVideoFile == null) {
                        return;
                    }
                    CustomCameraView.this.stopVideoPlay();
                    if (CustomCameraView.this.mCameraListener != null || !CustomCameraView.this.mVideoFile.exists()) {
                        CustomCameraView.this.mCameraListener.onRecordSuccess(CustomCameraView.this.mVideoFile);
                    }
                } else {
                    if (CustomCameraView.this.mPhotoFile == null || !CustomCameraView.this.mPhotoFile.exists()) {
                        return;
                    }
                    CustomCameraView.this.mImagePreview.setVisibility(4);
                    if (CustomCameraView.this.mCameraListener != null) {
                        CustomCameraView.this.mCameraListener.onPictureSuccess(CustomCameraView.this.mPhotoFile);
                    }
                }
            }
        });
        this.mCaptureLayout.setLeftClickListener(() -> {
            if (this.mOnClickListener != null) {
                this.mOnClickListener.onClick();
            }
        });
    }

    public File createImageFile() {
        if (SdkVersionUtils.checkedAndroid_Q()) {
            String diskCacheDir = PictureFileUtils.getDiskCacheDir(this.getContext());
            File rootDir = new File(diskCacheDir);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
            boolean isOutFileNameEmpty = TextUtils.isEmpty((CharSequence)this.mConfig.cameraFileName);
            String suffix = this.mConfig.suffixType.startsWith("image/") ? this.mConfig.suffixType.replaceAll("image/", ".") : ".jpeg";
            String newFileImageName = isOutFileNameEmpty ? DateUtils.getCreateFileName("IMG_") + suffix : this.mConfig.cameraFileName;
            File cameraFile = new File(rootDir, newFileImageName);
            Uri outUri = this.getOutUri(PictureMimeType.ofImage());
            if (outUri != null) {
                this.mConfig.cameraPath = outUri.toString();
            }
            return cameraFile;
        }
        String cameraFileName = "";
        if (!TextUtils.isEmpty((CharSequence)this.mConfig.cameraFileName)) {
            boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(this.mConfig.cameraFileName);
            this.mConfig.cameraFileName = !isSuffixOfImage ? StringUtils.renameSuffix(this.mConfig.cameraFileName, ".jpeg") : this.mConfig.cameraFileName;
            cameraFileName = this.mConfig.camera ? this.mConfig.cameraFileName : StringUtils.rename(this.mConfig.cameraFileName);
        }
        File cameraFile = PictureFileUtils.createCameraFile(this.getContext(), PictureMimeType.ofImage(), cameraFileName, this.mConfig.suffixType, this.mConfig.outPutCameraPath);
        this.mConfig.cameraPath = cameraFile.getAbsolutePath();
        return cameraFile;
    }

    public File createVideoFile() {
        if (SdkVersionUtils.checkedAndroid_Q()) {
            String diskCacheDir = PictureFileUtils.getVideoDiskCacheDir(this.getContext());
            File rootDir = new File(diskCacheDir);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
            boolean isOutFileNameEmpty = TextUtils.isEmpty((CharSequence)this.mConfig.cameraFileName);
            String suffix = this.mConfig.suffixType.startsWith("video/") ? this.mConfig.suffixType.replaceAll("video/", ".") : ".mp4";
            String newFileImageName = isOutFileNameEmpty ? DateUtils.getCreateFileName("VID_") + suffix : this.mConfig.cameraFileName;
            File cameraFile = new File(rootDir, newFileImageName);
            Uri outUri = this.getOutUri(PictureMimeType.ofVideo());
            if (outUri != null) {
                this.mConfig.cameraPath = outUri.toString();
            }
            return cameraFile;
        }
        String cameraFileName = "";
        if (!TextUtils.isEmpty((CharSequence)this.mConfig.cameraFileName)) {
            boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(this.mConfig.cameraFileName);
            this.mConfig.cameraFileName = !isSuffixOfImage ? StringUtils.renameSuffix(this.mConfig.cameraFileName, ".mp4") : this.mConfig.cameraFileName;
            cameraFileName = this.mConfig.camera ? this.mConfig.cameraFileName : StringUtils.rename(this.mConfig.cameraFileName);
        }
        File cameraFile = PictureFileUtils.createCameraFile(this.getContext(), PictureMimeType.ofVideo(), cameraFileName, this.mConfig.suffixType, this.mConfig.outPutCameraPath);
        this.mConfig.cameraPath = cameraFile.getAbsolutePath();
        return cameraFile;
    }

    private Uri getOutUri(int type) {
        return type == PictureMimeType.ofVideo() ? MediaUtils.createVideoUri(this.getContext(), this.mConfig.suffixType) : MediaUtils.createImageUri(this.getContext(), this.mConfig.suffixType);
    }

    public void setCameraListener(CameraListener cameraListener) {
        this.mCameraListener = cameraListener;
    }

    public void setPictureSelectionConfig(PictureSelectionConfig config) {
        this.mConfig = config;
    }

    public void setBindToLifecycle(LifecycleOwner lifecycleOwner) {
        if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA") == 0) {
            this.mCameraView.bindToLifecycle(lifecycleOwner);
            lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)((LifecycleEventObserver)(source, event) -> {}));
        }
    }

    public void setRecordVideoMaxTime(int maxDurationTime) {
        this.mCaptureLayout.setDuration(maxDurationTime * 1000);
    }

    public void setRecordVideoMinTime(int minDurationTime) {
        this.mCaptureLayout.setMinDuration(minDurationTime * 1000);
    }

    public void setOnClickListener(ClickListener clickListener) {
        this.mOnClickListener = clickListener;
    }

    public void setImageCallbackListener(ImageCallbackListener mImageCallbackListener) {
        this.mImageCallbackListener = mImageCallbackListener;
    }

    private void setFlashRes() {
        switch (this.type_flash) {
            case 33: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_auto);
                this.mCameraView.setFlash(0);
                break;
            }
            case 34: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_on);
                this.mCameraView.setFlash(1);
                break;
            }
            case 35: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_off);
                this.mCameraView.setFlash(2);
            }
        }
    }

    public CameraView getCameraView() {
        return this.mCameraView;
    }

    public CaptureLayout getCaptureLayout() {
        return this.mCaptureLayout;
    }

    private void resetState() {
        if (this.mCameraView.getCaptureMode() == CameraView.CaptureMode.VIDEO) {
            if (this.mCameraView.isRecording()) {
                this.mCameraView.stopRecording();
            }
            if (this.mVideoFile != null && this.mVideoFile.exists()) {
                this.mVideoFile.delete();
                if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(this.mConfig.cameraPath)) {
                    this.getContext().getContentResolver().delete(Uri.parse((String)this.mConfig.cameraPath), null, null);
                } else {
                    new PictureMediaScannerConnection(this.getContext(), this.mVideoFile.getAbsolutePath());
                }
            }
        } else {
            this.mImagePreview.setVisibility(4);
            if (this.mPhotoFile != null && this.mPhotoFile.exists()) {
                this.mPhotoFile.delete();
                if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(this.mConfig.cameraPath)) {
                    this.getContext().getContentResolver().delete(Uri.parse((String)this.mConfig.cameraPath), null, null);
                } else {
                    new PictureMediaScannerConnection(this.getContext(), this.mPhotoFile.getAbsolutePath());
                }
            }
        }
        this.mSwitchCamera.setVisibility(0);
        this.mFlashLamp.setVisibility(0);
        this.mCameraView.setVisibility(0);
        this.mCaptureLayout.resetCaptureLayout();
    }

    private void startVideoPlay(File videoFile) {
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
            }
            this.mMediaPlayer.setDataSource(videoFile.getAbsolutePath());
            this.mMediaPlayer.setSurface(new Surface(this.mTextureView.getSurfaceTexture()));
            this.mMediaPlayer.setLooping(true);
            this.mMediaPlayer.setOnPreparedListener(mp -> {
                mp.start();
                float ratio = (float)mp.getVideoWidth() * 1.0f / (float)mp.getVideoHeight();
                int width1 = this.mTextureView.getWidth();
                ViewGroup.LayoutParams layoutParams = this.mTextureView.getLayoutParams();
                layoutParams.height = (int)((float)width1 / ratio);
                this.mTextureView.setLayoutParams(layoutParams);
            });
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopVideoPlay() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mTextureView.setVisibility(8);
    }

    private static class MyImageResultCallback
    implements ImageCapture.OnImageSavedCallback {
        private WeakReference<Context> mContextReference;
        private WeakReference<PictureSelectionConfig> mConfigReference;
        private WeakReference<File> mFileReference;
        private WeakReference<ImageView> mImagePreviewReference;
        private WeakReference<CaptureLayout> mCaptureLayoutReference;
        private WeakReference<ImageCallbackListener> mImageCallbackListenerReference;
        private WeakReference<CameraListener> mCameraListenerReference;

        public MyImageResultCallback(Context context, PictureSelectionConfig config, File imageOutFile, ImageView imagePreview, CaptureLayout captureLayout, ImageCallbackListener imageCallbackListener, CameraListener cameraListener) {
            this.mContextReference = new WeakReference<Context>(context);
            this.mConfigReference = new WeakReference<PictureSelectionConfig>(config);
            this.mFileReference = new WeakReference<File>(imageOutFile);
            this.mImagePreviewReference = new WeakReference<ImageView>(imagePreview);
            this.mCaptureLayoutReference = new WeakReference<CaptureLayout>(captureLayout);
            this.mImageCallbackListenerReference = new WeakReference<ImageCallbackListener>(imageCallbackListener);
            this.mCameraListenerReference = new WeakReference<CameraListener>(cameraListener);
        }

        public void onImageSaved(@NonNull ImageCapture.OutputFileResults outputFileResults) {
            if (this.mConfigReference.get() != null && SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(((PictureSelectionConfig)this.mConfigReference.get()).cameraPath)) {
                PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<Boolean>(){

                    @Override
                    public Boolean doInBackground() {
                        return AndroidQTransformUtils.copyPathToDCIM((Context)mContextReference.get(), (File)mFileReference.get(), Uri.parse((String)((PictureSelectionConfig)((MyImageResultCallback)this).mConfigReference.get()).cameraPath));
                    }

                    @Override
                    public void onSuccess(Boolean result) {
                        PictureThreadUtils.cancel(PictureThreadUtils.getIoPool());
                    }
                });
            }
            if (this.mImageCallbackListenerReference.get() != null && this.mFileReference.get() != null && this.mImagePreviewReference.get() != null) {
                ((ImageCallbackListener)this.mImageCallbackListenerReference.get()).onLoadImage((File)this.mFileReference.get(), (ImageView)this.mImagePreviewReference.get());
            }
            if (this.mImagePreviewReference.get() != null) {
                ((ImageView)this.mImagePreviewReference.get()).setVisibility(0);
            }
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).startTypeBtnAnimator();
            }
        }

        public void onError(@NonNull ImageCaptureException exception) {
            if (this.mCameraListenerReference.get() != null) {
                ((CameraListener)this.mCameraListenerReference.get()).onError(exception.getImageCaptureError(), exception.getMessage(), exception.getCause());
            }
        }
    }
}

