/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.StyleRes;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.PictureCustomCameraActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.PictureSelectorActivity;
import com.luck.picture.lib.PictureSelectorCameraEmptyActivity;
import com.luck.picture.lib.PictureSelectorWeChatStyleActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.UCropOptions;
import com.luck.picture.lib.engine.CacheResourcesEngine;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnCustomCameraInterfaceListener;
import com.luck.picture.lib.listener.OnCustomImagePreviewCallback;
import com.luck.picture.lib.listener.OnResultCallbackListener;
import com.luck.picture.lib.listener.OnVideoSelectedPlayCallback;
import com.luck.picture.lib.style.PictureCropParameterStyle;
import com.luck.picture.lib.style.PictureParameterStyle;
import com.luck.picture.lib.style.PictureSelectorUIStyle;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.tools.DoubleUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import java.lang.ref.WeakReference;
import java.util.List;

public class PictureSelectionModel {
    private PictureSelectionConfig selectionConfig;
    private PictureSelector selector;

    public PictureSelectionModel(PictureSelector selector, int chooseMode) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
        this.selectionConfig.chooseMode = chooseMode;
    }

    public PictureSelectionModel(PictureSelector selector, int chooseMode, boolean camera) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
        this.selectionConfig.camera = camera;
        this.selectionConfig.chooseMode = chooseMode;
    }

    public PictureSelectionModel theme(@StyleRes int themeStyleId) {
        this.selectionConfig.themeStyleId = themeStyleId;
        return this;
    }

    public PictureSelectionModel setPictureUIStyle(PictureSelectorUIStyle uiStyle) {
        if (uiStyle != null) {
            PictureSelectionConfig.uiStyle = uiStyle;
            if (!this.selectionConfig.isWeChatStyle) {
                this.selectionConfig.isWeChatStyle = PictureSelectionConfig.uiStyle.isNewSelectStyle;
            }
        }
        return this;
    }

    public PictureSelectionModel setLanguage(int language) {
        this.selectionConfig.language = language;
        return this;
    }

    public PictureSelectionModel setRequestedOrientation(int requestedOrientation) {
        this.selectionConfig.requestedOrientation = requestedOrientation;
        return this;
    }

    @Deprecated
    public PictureSelectionModel loadImageEngine(ImageEngine engine) {
        if (PictureSelectionConfig.imageEngine != engine) {
            PictureSelectionConfig.imageEngine = engine;
        }
        return this;
    }

    public PictureSelectionModel imageEngine(ImageEngine engine) {
        if (PictureSelectionConfig.imageEngine != engine) {
            PictureSelectionConfig.imageEngine = engine;
        }
        return this;
    }

    @Deprecated
    public PictureSelectionModel loadCacheResourcesCallback(CacheResourcesEngine cacheResourcesEngine) {
        if (SdkVersionUtils.checkedAndroid_Q() && PictureSelectionConfig.cacheResourcesEngine != cacheResourcesEngine) {
            PictureSelectionConfig.cacheResourcesEngine = (CacheResourcesEngine)new WeakReference<CacheResourcesEngine>(cacheResourcesEngine).get();
        }
        return this;
    }

    public PictureSelectionModel selectionMode(int selectionMode) {
        this.selectionConfig.selectionMode = selectionMode;
        return this;
    }

    public PictureSelectionModel isWeChatStyle(boolean isWeChatStyle) {
        this.selectionConfig.isWeChatStyle = isWeChatStyle;
        return this;
    }

    public PictureSelectionModel isUseCustomCamera(boolean isUseCustomCamera) {
        this.selectionConfig.isUseCustomCamera = Build.VERSION.SDK_INT > 19 && isUseCustomCamera;
        return this;
    }

    public PictureSelectionModel bindCustomPlayVideoCallback(OnVideoSelectedPlayCallback callback) {
        PictureSelectionConfig.customVideoPlayCallback = (OnVideoSelectedPlayCallback)new WeakReference<OnVideoSelectedPlayCallback>(callback).get();
        return this;
    }

    public PictureSelectionModel bindCustomPreviewCallback(OnCustomImagePreviewCallback callback) {
        PictureSelectionConfig.onCustomImagePreviewCallback = (OnCustomImagePreviewCallback)new WeakReference<OnCustomImagePreviewCallback>(callback).get();
        return this;
    }

    @Deprecated
    public PictureSelectionModel bindPictureSelectorInterfaceListener(OnCustomCameraInterfaceListener listener) {
        PictureSelectionConfig.onCustomCameraInterfaceListener = (OnCustomCameraInterfaceListener)new WeakReference<OnCustomCameraInterfaceListener>(listener).get();
        return this;
    }

    public PictureSelectionModel bindCustomCameraInterfaceListener(OnCustomCameraInterfaceListener listener) {
        PictureSelectionConfig.onCustomCameraInterfaceListener = (OnCustomCameraInterfaceListener)new WeakReference<OnCustomCameraInterfaceListener>(listener).get();
        return this;
    }

    public PictureSelectionModel setButtonFeatures(int buttonFeatures) {
        this.selectionConfig.buttonFeatures = buttonFeatures;
        return this;
    }

    @Deprecated
    public PictureSelectionModel enableCrop(boolean enableCrop) {
        this.selectionConfig.enableCrop = enableCrop;
        return this;
    }

    public PictureSelectionModel isEnableCrop(boolean enableCrop) {
        this.selectionConfig.enableCrop = enableCrop;
        return this;
    }

    public PictureSelectionModel basicUCropConfig(UCropOptions uCropOptions) {
        this.selectionConfig.uCropOptions = uCropOptions;
        return this;
    }

    public PictureSelectionModel isMultipleSkipCrop(boolean isMultipleSkipCrop) {
        this.selectionConfig.isMultipleSkipCrop = isMultipleSkipCrop;
        return this;
    }

    @Deprecated
    public PictureSelectionModel enablePreviewAudio(boolean enablePreviewAudio) {
        this.selectionConfig.enablePreviewAudio = enablePreviewAudio;
        return this;
    }

    public PictureSelectionModel isEnablePreviewAudio(boolean enablePreviewAudio) {
        this.selectionConfig.enablePreviewAudio = enablePreviewAudio;
        return this;
    }

    public PictureSelectionModel freeStyleCropEnabled(boolean freeStyleCropEnabled) {
        this.selectionConfig.freeStyleCropEnabled = freeStyleCropEnabled;
        return this;
    }

    public PictureSelectionModel scaleEnabled(boolean scaleEnabled) {
        this.selectionConfig.scaleEnabled = scaleEnabled;
        return this;
    }

    public PictureSelectionModel rotateEnabled(boolean rotateEnabled) {
        this.selectionConfig.rotateEnabled = rotateEnabled;
        return this;
    }

    public PictureSelectionModel circleDimmedLayer(boolean circleDimmedLayer) {
        this.selectionConfig.circleDimmedLayer = circleDimmedLayer;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setCircleDimmedColor(int circleDimmedColor) {
        this.selectionConfig.circleDimmedColor = circleDimmedColor;
        return this;
    }

    public PictureSelectionModel setCropDimmedColor(int dimmedColor) {
        this.selectionConfig.circleDimmedColor = dimmedColor;
        return this;
    }

    public PictureSelectionModel setCircleDimmedBorderColor(int circleDimmedBorderColor) {
        this.selectionConfig.circleDimmedBorderColor = circleDimmedBorderColor;
        return this;
    }

    public PictureSelectionModel setCircleStrokeWidth(int circleStrokeWidth) {
        this.selectionConfig.circleStrokeWidth = circleStrokeWidth;
        return this;
    }

    public PictureSelectionModel showCropFrame(boolean showCropFrame) {
        this.selectionConfig.showCropFrame = showCropFrame;
        return this;
    }

    public PictureSelectionModel showCropGrid(boolean showCropGrid) {
        this.selectionConfig.showCropGrid = showCropGrid;
        return this;
    }

    public PictureSelectionModel hideBottomControls(boolean hideBottomControls) {
        this.selectionConfig.hideBottomControls = hideBottomControls;
        return this;
    }

    public PictureSelectionModel withAspectRatio(int aspect_ratio_x, int aspect_ratio_y) {
        this.selectionConfig.aspect_ratio_x = aspect_ratio_x;
        this.selectionConfig.aspect_ratio_y = aspect_ratio_y;
        return this;
    }

    public PictureSelectionModel isWithVideoImage(boolean isWithVideoImage) {
        this.selectionConfig.isWithVideoImage = this.selectionConfig.selectionMode != 1 && this.selectionConfig.chooseMode == PictureMimeType.ofAll() && isWithVideoImage;
        return this;
    }

    public PictureSelectionModel isMaxSelectEnabledMask(boolean isMaxSelectEnabledMask) {
        this.selectionConfig.isMaxSelectEnabledMask = isMaxSelectEnabledMask;
        return this;
    }

    public PictureSelectionModel maxSelectNum(int maxSelectNum) {
        this.selectionConfig.maxSelectNum = maxSelectNum;
        return this;
    }

    public PictureSelectionModel minSelectNum(int minSelectNum) {
        this.selectionConfig.minSelectNum = minSelectNum;
        return this;
    }

    public PictureSelectionModel maxVideoSelectNum(int maxVideoSelectNum) {
        this.selectionConfig.maxVideoSelectNum = this.selectionConfig.chooseMode == PictureMimeType.ofVideo() ? 0 : maxVideoSelectNum;
        return this;
    }

    public PictureSelectionModel minVideoSelectNum(int minVideoSelectNum) {
        this.selectionConfig.minVideoSelectNum = minVideoSelectNum;
        return this;
    }

    public PictureSelectionModel closeAndroidQChangeWH(boolean isChangeWH) {
        this.selectionConfig.isAndroidQChangeWH = isChangeWH;
        return this;
    }

    public PictureSelectionModel closeAndroidQChangeVideoWH(boolean isChangeVideoWH) {
        this.selectionConfig.isAndroidQChangeVideoWH = isChangeVideoWH;
        return this;
    }

    public PictureSelectionModel isAutomaticTitleRecyclerTop(boolean isAutomaticTitleRecyclerTop) {
        this.selectionConfig.isAutomaticTitleRecyclerTop = isAutomaticTitleRecyclerTop;
        return this;
    }

    public PictureSelectionModel isSingleDirectReturn(boolean isSingleDirectReturn) {
        this.selectionConfig.isSingleDirectReturn = this.selectionConfig.selectionMode == 1 && isSingleDirectReturn;
        this.selectionConfig.isOriginalControl = (this.selectionConfig.selectionMode != 1 || !isSingleDirectReturn) && this.selectionConfig.isOriginalControl;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, int pageSize) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.pageSize = pageSize < 10 ? 60 : pageSize;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, int pageSize, boolean isFilterInvalidFile) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.pageSize = pageSize < 10 ? 60 : pageSize;
        this.selectionConfig.isFilterInvalidFile = isFilterInvalidFile;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        return this;
    }

    public PictureSelectionModel isPageStrategy(boolean isPageStrategy, boolean isFilterInvalidFile) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.isFilterInvalidFile = isFilterInvalidFile;
        return this;
    }

    public PictureSelectionModel videoQuality(int videoQuality) {
        this.selectionConfig.videoQuality = videoQuality;
        return this;
    }

    public PictureSelectionModel imageFormat(String suffixType) {
        if (SdkVersionUtils.checkedAndroid_Q() || SdkVersionUtils.checkedAndroid_R()) {
            if (TextUtils.equals((CharSequence)suffixType, (CharSequence)".png")) {
                suffixType = "image/png";
            }
            if (TextUtils.equals((CharSequence)suffixType, (CharSequence)".jpeg")) {
                suffixType = "image/jpeg";
            }
            if (TextUtils.equals((CharSequence)suffixType, (CharSequence)".mp4")) {
                suffixType = "video/mp4";
            }
        }
        this.selectionConfig.suffixType = suffixType;
        return this;
    }

    @Deprecated
    public PictureSelectionModel cropWH(int cropWidth, int cropHeight) {
        this.selectionConfig.cropWidth = cropWidth;
        this.selectionConfig.cropHeight = cropHeight;
        return this;
    }

    public PictureSelectionModel cropImageWideHigh(int cropWidth, int cropHeight) {
        this.selectionConfig.cropWidth = cropWidth;
        this.selectionConfig.cropHeight = cropHeight;
        return this;
    }

    public PictureSelectionModel videoMaxSecond(int videoMaxSecond) {
        this.selectionConfig.videoMaxSecond = videoMaxSecond * 1000;
        return this;
    }

    public PictureSelectionModel videoMinSecond(int videoMinSecond) {
        this.selectionConfig.videoMinSecond = videoMinSecond * 1000;
        return this;
    }

    public PictureSelectionModel recordVideoSecond(int recordVideoSecond) {
        this.selectionConfig.recordVideoSecond = recordVideoSecond;
        return this;
    }

    public PictureSelectionModel recordVideoMinSecond(int recordVideoMinSecond) {
        this.selectionConfig.recordVideoMinSecond = recordVideoMinSecond;
        return this;
    }

    @Deprecated
    public PictureSelectionModel glideOverride(@IntRange(from=100L) int width, @IntRange(from=100L) int height) {
        this.selectionConfig.overrideWidth = width;
        this.selectionConfig.overrideHeight = height;
        return this;
    }

    @Deprecated
    public PictureSelectionModel sizeMultiplier(@FloatRange(from=0.10000000149011612) float sizeMultiplier) {
        this.selectionConfig.sizeMultiplier = sizeMultiplier;
        return this;
    }

    public PictureSelectionModel imageSpanCount(int imageSpanCount) {
        this.selectionConfig.imageSpanCount = imageSpanCount;
        return this;
    }

    public PictureSelectionModel minimumCompressSize(int size) {
        this.selectionConfig.minimumCompressSize = size;
        return this;
    }

    @Deprecated
    public PictureSelectionModel cropCompressQuality(int compressQuality) {
        this.selectionConfig.cropCompressQuality = compressQuality;
        return this;
    }

    public PictureSelectionModel cutOutQuality(int cutQuality) {
        this.selectionConfig.cropCompressQuality = cutQuality;
        return this;
    }

    @Deprecated
    public PictureSelectionModel compress(boolean isCompress) {
        this.selectionConfig.isCompress = isCompress;
        return this;
    }

    public PictureSelectionModel isCompress(boolean isCompress) {
        this.selectionConfig.isCompress = isCompress;
        return this;
    }

    public PictureSelectionModel compressQuality(int compressQuality) {
        this.selectionConfig.compressQuality = compressQuality;
        return this;
    }

    public PictureSelectionModel isReturnEmpty(boolean returnEmpty) {
        this.selectionConfig.returnEmpty = returnEmpty;
        return this;
    }

    public PictureSelectionModel synOrAsy(boolean synOrAsy) {
        this.selectionConfig.synOrAsy = synOrAsy;
        return this;
    }

    public PictureSelectionModel compressFocusAlpha(boolean focusAlpha) {
        this.selectionConfig.focusAlpha = focusAlpha;
        return this;
    }

    public PictureSelectionModel isQuickCapture(boolean isQuickCapture) {
        this.selectionConfig.isQuickCapture = isQuickCapture;
        return this;
    }

    public PictureSelectionModel isOriginalImageControl(boolean isOriginalControl) {
        this.selectionConfig.isOriginalControl = !this.selectionConfig.camera && this.selectionConfig.chooseMode != PictureMimeType.ofVideo() && this.selectionConfig.chooseMode != PictureMimeType.ofAudio() && isOriginalControl;
        return this;
    }

    public PictureSelectionModel compressSavePath(String path) {
        this.selectionConfig.compressSavePath = path;
        return this;
    }

    public PictureSelectionModel cameraFileName(String fileName) {
        this.selectionConfig.cameraFileName = fileName;
        return this;
    }

    public PictureSelectionModel renameCropFileName(String renameCropFileName) {
        this.selectionConfig.renameCropFileName = renameCropFileName;
        return this;
    }

    public PictureSelectionModel renameCompressFile(String renameFile) {
        this.selectionConfig.renameCompressFileName = renameFile;
        return this;
    }

    public PictureSelectionModel isZoomAnim(boolean zoomAnim) {
        this.selectionConfig.zoomAnim = zoomAnim;
        return this;
    }

    @Deprecated
    public PictureSelectionModel previewEggs(boolean previewEggs) {
        this.selectionConfig.previewEggs = previewEggs;
        return this;
    }

    public PictureSelectionModel isPreviewEggs(boolean previewEggs) {
        this.selectionConfig.previewEggs = previewEggs;
        return this;
    }

    public PictureSelectionModel isCamera(boolean isCamera) {
        this.selectionConfig.isCamera = isCamera;
        return this;
    }

    public PictureSelectionModel setOutputCameraPath(String outPutCameraPath) {
        this.selectionConfig.outPutCameraPath = outPutCameraPath;
        return this;
    }

    public PictureSelectionModel queryMaxFileSize(float fileSize) {
        this.selectionConfig.filterFileSize = fileSize;
        return this;
    }

    public PictureSelectionModel isGif(boolean isGif) {
        this.selectionConfig.isGif = isGif;
        return this;
    }

    public PictureSelectionModel isWebp(boolean isWebp) {
        this.selectionConfig.isWebp = isWebp;
        return this;
    }

    public PictureSelectionModel isBmp(boolean isBmp) {
        this.selectionConfig.isWebp = isBmp;
        return this;
    }

    @Deprecated
    public PictureSelectionModel previewImage(boolean enablePreview) {
        this.selectionConfig.enablePreview = enablePreview;
        return this;
    }

    public PictureSelectionModel isPreviewImage(boolean enablePreview) {
        this.selectionConfig.enablePreview = enablePreview;
        return this;
    }

    @Deprecated
    public PictureSelectionModel previewVideo(boolean enPreviewVideo) {
        this.selectionConfig.enPreviewVideo = enPreviewVideo;
        return this;
    }

    public PictureSelectionModel isPreviewVideo(boolean enPreviewVideo) {
        this.selectionConfig.enPreviewVideo = enPreviewVideo;
        return this;
    }

    public PictureSelectionModel isNotPreviewDownload(boolean isNotPreviewDownload) {
        this.selectionConfig.isNotPreviewDownload = isNotPreviewDownload;
        return this;
    }

    public PictureSelectionModel querySpecifiedFormatSuffix(String specifiedFormat) {
        this.selectionConfig.specifiedFormat = specifiedFormat;
        return this;
    }

    @Deprecated
    public PictureSelectionModel openClickSound(boolean openClickSound) {
        this.selectionConfig.openClickSound = !this.selectionConfig.camera && openClickSound;
        return this;
    }

    public PictureSelectionModel isOpenClickSound(boolean openClickSound) {
        this.selectionConfig.openClickSound = !this.selectionConfig.camera && openClickSound;
        return this;
    }

    public PictureSelectionModel isDragFrame(boolean isDragFrame) {
        this.selectionConfig.isDragFrame = isDragFrame;
        return this;
    }

    public PictureSelectionModel isMultipleRecyclerAnimation(boolean isAnimation) {
        this.selectionConfig.isMultipleRecyclerAnimation = isAnimation;
        return this;
    }

    public PictureSelectionModel isCameraAroundState(boolean isCameraAroundState) {
        this.selectionConfig.isCameraAroundState = isCameraAroundState;
        return this;
    }

    @Deprecated
    public PictureSelectionModel selectionMedia(List<LocalMedia> selectionMedia) {
        this.selectionConfig.selectionMedias = this.selectionConfig.selectionMode == 1 && this.selectionConfig.isSingleDirectReturn ? null : selectionMedia;
        return this;
    }

    public PictureSelectionModel selectionData(List<LocalMedia> selectionData) {
        this.selectionConfig.selectionMedias = this.selectionConfig.selectionMode == 1 && this.selectionConfig.isSingleDirectReturn ? null : selectionData;
        return this;
    }

    @Deprecated
    public PictureSelectionModel isChangeStatusBarFontColor(boolean isChangeStatusBarFontColor) {
        this.selectionConfig.isChangeStatusBarFontColor = isChangeStatusBarFontColor;
        return this;
    }

    @Deprecated
    public PictureSelectionModel isOpenStyleNumComplete(boolean isOpenStyleNumComplete) {
        this.selectionConfig.isOpenStyleNumComplete = isOpenStyleNumComplete;
        return this;
    }

    @Deprecated
    public PictureSelectionModel isOpenStyleCheckNumMode(boolean isOpenStyleCheckNumMode) {
        this.selectionConfig.isOpenStyleCheckNumMode = isOpenStyleCheckNumMode;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setTitleBarBackgroundColor(@ColorInt int color) {
        this.selectionConfig.titleBarBackgroundColor = color;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setStatusBarColorPrimaryDark(@ColorInt int color) {
        this.selectionConfig.pictureStatusBarColor = color;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setCropTitleBarBackgroundColor(@ColorInt int color) {
        this.selectionConfig.cropTitleBarBackgroundColor = color;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setCropStatusBarColorPrimaryDark(@ColorInt int color) {
        this.selectionConfig.cropStatusBarColorPrimaryDark = color;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setCropTitleColor(@ColorInt int color) {
        this.selectionConfig.cropTitleColor = color;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setUpArrowDrawable(int resId) {
        this.selectionConfig.upResId = resId;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setDownArrowDrawable(int resId) {
        this.selectionConfig.downResId = resId;
        return this;
    }

    @Deprecated
    public PictureSelectionModel setPictureCropStyle(PictureCropParameterStyle style2) {
        PictureSelectionConfig.cropStyle = style2 != null ? style2 : PictureCropParameterStyle.ofDefaultCropStyle();
        return this;
    }

    @Deprecated
    public PictureSelectionModel setPictureStyle(PictureParameterStyle style2) {
        if (style2 != null) {
            PictureSelectionConfig.style = style2;
            if (!this.selectionConfig.isWeChatStyle) {
                this.selectionConfig.isWeChatStyle = style2.isNewSelectStyle;
            }
        } else {
            PictureSelectionConfig.style = PictureParameterStyle.ofDefaultStyle();
        }
        return this;
    }

    public PictureSelectionModel setPictureWindowAnimationStyle(PictureWindowAnimationStyle windowAnimationStyle) {
        PictureSelectionConfig.windowAnimationStyle = windowAnimationStyle != null ? windowAnimationStyle : PictureWindowAnimationStyle.ofDefaultWindowAnimationStyle();
        return this;
    }

    public PictureSelectionModel setRecyclerAnimationMode(int animationMode) {
        this.selectionConfig.animationMode = animationMode;
        return this;
    }

    public PictureSelectionModel isAndroidQTransform(boolean isAndroidQTransform) {
        this.selectionConfig.isAndroidQTransform = isAndroidQTransform;
        return this;
    }

    public PictureSelectionModel isFallbackVersion(boolean isFallbackVersion) {
        this.selectionConfig.isFallbackVersion = isFallbackVersion;
        return this;
    }

    public PictureSelectionModel isFallbackVersion2(boolean isFallbackVersion) {
        this.selectionConfig.isFallbackVersion2 = isFallbackVersion;
        return this;
    }

    public PictureSelectionModel isFallbackVersion3(boolean isFallbackVersion) {
        this.selectionConfig.isFallbackVersion3 = isFallbackVersion;
        return this;
    }

    public void forResult(int requestCode) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null || this.selectionConfig == null) {
                return;
            }
            Intent intent = this.selectionConfig.camera && this.selectionConfig.isUseCustomCamera ? new Intent((Context)activity, PictureCustomCameraActivity.class) : new Intent((Context)activity, this.selectionConfig.camera ? PictureSelectorCameraEmptyActivity.class : (this.selectionConfig.isWeChatStyle ? PictureSelectorWeChatStyleActivity.class : PictureSelectorActivity.class));
            this.selectionConfig.isCallbackMode = false;
            Fragment fragment = this.selector.getFragment();
            if (fragment != null) {
                fragment.startActivityForResult(intent, requestCode);
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
            PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.windowAnimationStyle;
            activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.picture_anim_fade_in);
        }
    }

    @Deprecated
    public void forResult(int requestCode, int enterAnim, int exitAnim) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                return;
            }
            Intent intent = new Intent((Context)activity, this.selectionConfig != null && this.selectionConfig.camera ? PictureSelectorCameraEmptyActivity.class : (this.selectionConfig.isWeChatStyle ? PictureSelectorWeChatStyleActivity.class : PictureSelectorActivity.class));
            this.selectionConfig.isCallbackMode = false;
            Fragment fragment = this.selector.getFragment();
            if (fragment != null) {
                fragment.startActivityForResult(intent, requestCode);
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
            activity.overridePendingTransition(enterAnim, exitAnim);
        }
    }

    public void forResult(OnResultCallbackListener listener) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null || this.selectionConfig == null) {
                return;
            }
            PictureSelectionConfig.listener = (OnResultCallbackListener)new WeakReference<OnResultCallbackListener>(listener).get();
            this.selectionConfig.isCallbackMode = true;
            Intent intent = this.selectionConfig.camera && this.selectionConfig.isUseCustomCamera ? new Intent((Context)activity, PictureCustomCameraActivity.class) : new Intent((Context)activity, this.selectionConfig.camera ? PictureSelectorCameraEmptyActivity.class : (this.selectionConfig.isWeChatStyle ? PictureSelectorWeChatStyleActivity.class : PictureSelectorActivity.class));
            Fragment fragment = this.selector.getFragment();
            if (fragment != null) {
                fragment.startActivity(intent);
            } else {
                activity.startActivity(intent);
            }
            PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.windowAnimationStyle;
            activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.picture_anim_fade_in);
        }
    }

    public void forResult(int requestCode, OnResultCallbackListener listener) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null || this.selectionConfig == null) {
                return;
            }
            PictureSelectionConfig.listener = (OnResultCallbackListener)new WeakReference<OnResultCallbackListener>(listener).get();
            this.selectionConfig.isCallbackMode = true;
            Intent intent = this.selectionConfig.camera && this.selectionConfig.isUseCustomCamera ? new Intent((Context)activity, PictureCustomCameraActivity.class) : new Intent((Context)activity, this.selectionConfig.camera ? PictureSelectorCameraEmptyActivity.class : (this.selectionConfig.isWeChatStyle ? PictureSelectorWeChatStyleActivity.class : PictureSelectorActivity.class));
            Fragment fragment = this.selector.getFragment();
            if (fragment != null) {
                fragment.startActivityForResult(intent, requestCode);
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
            PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.windowAnimationStyle;
            activity.overridePendingTransition(windowAnimationStyle.activityEnterAnimation, R.anim.picture_anim_fade_in);
        }
    }

    public void openExternalPreview(int position, List<LocalMedia> medias) {
        if (this.selector == null) {
            throw new NullPointerException("This PictureSelector is Null");
        }
        this.selector.externalPicturePreview(position, medias, PictureSelectionConfig.windowAnimationStyle.activityPreviewEnterAnimation);
    }

    @Deprecated
    public void openExternalPreview(int position, String directory_path, List<LocalMedia> medias) {
        if (this.selector == null) {
            throw new NullPointerException("This PictureSelector is Null");
        }
        this.selector.externalPicturePreview(position, directory_path, medias, PictureSelectionConfig.windowAnimationStyle.activityPreviewEnterAnimation);
    }

    public void externalPictureVideo(String path) {
        if (this.selector == null) {
            throw new NullPointerException("This PictureSelector is Null");
        }
        this.selector.externalPictureVideo(path);
    }
}

