/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Bundle;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.tools.JumpUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.widget.longimage.ImageSource;
import com.luck.picture.lib.widget.longimage.ImageViewState;
import com.luck.picture.lib.widget.longimage.SubsamplingScaleImageView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PictureSimpleFragmentAdapter
extends PagerAdapter {
    private List<LocalMedia> data;
    private OnCallBackActivity onBackPressed;
    private PictureSelectionConfig config;
    private static final int MAX_CACHE_SIZE = 20;
    private SparseArray<View> mCacheView;

    public void clear() {
        if (null != this.mCacheView) {
            this.mCacheView.clear();
            this.mCacheView = null;
        }
    }

    public void removeCacheView(int position) {
        if (this.mCacheView != null && position < this.mCacheView.size()) {
            this.mCacheView.removeAt(position);
        }
    }

    public PictureSimpleFragmentAdapter(PictureSelectionConfig config, OnCallBackActivity onBackPressed) {
        this.config = config;
        this.onBackPressed = onBackPressed;
        this.mCacheView = new SparseArray();
    }

    public void bindData(List<LocalMedia> data) {
        this.data = data;
    }

    public List<LocalMedia> getData() {
        return this.data == null ? new ArrayList() : this.data;
    }

    public int getSize() {
        return this.data == null ? 0 : this.data.size();
    }

    public void remove(int currentItem) {
        if (this.getSize() > currentItem) {
            this.data.remove(currentItem);
        }
    }

    public LocalMedia getItem(int position) {
        return this.getSize() > 0 && position < this.getSize() ? this.data.get(position) : null;
    }

    public int getCount() {
        return this.data != null ? this.data.size() : 0;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        if (this.mCacheView.size() > 20) {
            this.mCacheView.remove(position);
        }
    }

    public int getItemPosition(@NonNull Object object) {
        return -2;
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object object) {
        return view == object;
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup container, int position) {
        View contentView = (View)this.mCacheView.get(position);
        if (contentView == null) {
            contentView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.picture_image_preview, container, false);
            this.mCacheView.put(position, (Object)contentView);
        }
        PhotoView imageView = (PhotoView)contentView.findViewById(R.id.preview_image);
        SubsamplingScaleImageView longImg = (SubsamplingScaleImageView)contentView.findViewById(R.id.longImg);
        ImageView ivPlay = (ImageView)contentView.findViewById(R.id.iv_play);
        LocalMedia media = this.getItem(position);
        if (media != null) {
            String mimeType = media.getMimeType();
            String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : media.getPath());
            boolean isGif = PictureMimeType.isGif(mimeType);
            boolean isHasVideo = PictureMimeType.isHasVideo(mimeType);
            ivPlay.setVisibility(isHasVideo ? 0 : 8);
            ivPlay.setOnClickListener(v -> {
                if (PictureSelectionConfig.customVideoPlayCallback != null) {
                    PictureSelectionConfig.customVideoPlayCallback.startPlayVideo(media);
                } else {
                    Intent intent = new Intent();
                    Bundle bundle = new Bundle();
                    bundle.putBoolean("isExternalPreviewVideo", true);
                    bundle.putString("videoPath", path);
                    intent.putExtras(bundle);
                    JumpUtils.startPictureVideoPlayActivity(container.getContext(), bundle, 166);
                }
            });
            boolean eqLongImg = MediaUtils.isLongImg(media);
            imageView.setVisibility(eqLongImg && !isGif ? 8 : 0);
            imageView.setOnViewTapListener((view, x, y) -> {
                if (this.onBackPressed != null) {
                    this.onBackPressed.onActivityBackPressed();
                }
            });
            longImg.setVisibility(eqLongImg && !isGif ? 0 : 8);
            longImg.setOnClickListener(v -> {
                if (this.onBackPressed != null) {
                    this.onBackPressed.onActivityBackPressed();
                }
            });
            if (isGif && !media.isCompressed()) {
                if (this.config != null && PictureSelectionConfig.imageEngine != null) {
                    PictureSelectionConfig.imageEngine.loadAsGifImage(contentView.getContext(), path, (ImageView)imageView);
                }
            } else if (this.config != null && PictureSelectionConfig.imageEngine != null) {
                if (eqLongImg) {
                    this.displayLongPic(SdkVersionUtils.checkedAndroid_Q() ? Uri.parse((String)path) : Uri.fromFile((File)new File(path)), longImg);
                } else {
                    PictureSelectionConfig.imageEngine.loadImage(contentView.getContext(), path, (ImageView)imageView);
                }
            }
        }
        container.addView(contentView, 0);
        return contentView;
    }

    private void displayLongPic(Uri uri, SubsamplingScaleImageView longImg) {
        longImg.setQuickScaleEnabled(true);
        longImg.setZoomEnabled(true);
        longImg.setPanEnabled(true);
        longImg.setDoubleTapZoomDuration(100);
        longImg.setMinimumScaleType(2);
        longImg.setDoubleTapZoomDpi(2);
        longImg.setImage(ImageSource.uri(uri), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
    }

    public static interface OnCallBackActivity {
        public void onActivityBackPressed();
    }
}

