/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ValueOf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class LocalMediaLoader {
    private static final String TAG = LocalMediaLoader.class.getSimpleName();
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String ORDER_BY = "_id DESC";
    private static final String NOT_GIF = "!='image/gif'";
    private static final int AUDIO_DURATION = 500;
    private Context mContext;
    private boolean isAndroidQ;
    private PictureSelectionConfig config;
    private static final long FILE_SIZE_UNIT = 0x100000L;
    private static final String[] PROJECTION = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name", "_display_name"};
    private static final String SELECTION = "media_type=? AND _size>0";
    private static final String SELECTION_NOT_GIF = "media_type=? AND _size>0 AND mime_type!='image/gif'";
    private static final String SELECTION_SPECIFIED_FORMAT = "media_type=? AND _size>0 AND mime_type";
    private static final String[] SELECTION_ALL_ARGS = new String[]{String.valueOf(1), String.valueOf(3)};

    private static String getSelectionArgsForSingleMediaCondition(String time_condition) {
        return "media_type=? AND _size>0 AND " + time_condition;
    }

    private static String getSelectionArgsForSingleMediaCondition() {
        return SELECTION;
    }

    private static String getSelectionArgsForAllMediaCondition(String time_condition, boolean isGif) {
        String condition = "(media_type=?" + (isGif ? "" : " AND mime_type!='image/gif'") + " OR " + "media_type=? AND " + time_condition + ") AND " + "_size" + ">0";
        return condition;
    }

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    public LocalMediaLoader(Context context, PictureSelectionConfig config) {
        this.mContext = context.getApplicationContext();
        this.isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalMediaFolder> loadAllMedia() {
        Cursor data = this.mContext.getContentResolver().query(QUERY_URI, PROJECTION, this.getSelection(), this.getSelectionArgs(), ORDER_BY);
        try {
            if (data != null) {
                ArrayList<LocalMediaFolder> imageFolders = new ArrayList<LocalMediaFolder>();
                LocalMediaFolder allImageFolder = new LocalMediaFolder();
                ArrayList<LocalMedia> latelyImages = new ArrayList<LocalMedia>();
                int count = data.getCount();
                if (count > 0) {
                    data.moveToFirst();
                    do {
                        long id2 = data.getLong(data.getColumnIndexOrThrow(PROJECTION[0]));
                        String url = this.isAndroidQ ? this.getRealPathAndroid_Q(id2) : data.getString(data.getColumnIndexOrThrow(PROJECTION[1]));
                        String mimeType = data.getString(data.getColumnIndexOrThrow(PROJECTION[2]));
                        if (mimeType.endsWith("image/*")) {
                            boolean isGif;
                            if (PictureMimeType.isContent(url)) {
                                String absolutePath = PictureFileUtils.getPath(this.mContext, Uri.parse((String)url));
                                mimeType = PictureMimeType.getImageMimeType(absolutePath);
                            } else {
                                mimeType = PictureMimeType.getImageMimeType(url);
                            }
                            if (!this.config.isGif && (isGif = PictureMimeType.isGif(mimeType))) continue;
                        }
                        int width = data.getInt(data.getColumnIndexOrThrow(PROJECTION[3]));
                        int height = data.getInt(data.getColumnIndexOrThrow(PROJECTION[4]));
                        long duration = data.getLong(data.getColumnIndexOrThrow(PROJECTION[5]));
                        long size = data.getLong(data.getColumnIndexOrThrow(PROJECTION[6]));
                        String folderName = data.getString(data.getColumnIndexOrThrow(PROJECTION[7]));
                        String fileName = data.getString(data.getColumnIndexOrThrow(PROJECTION[8]));
                        if (this.config.filterFileSize > 0 && size > (long)this.config.filterFileSize * 0x100000L || PictureMimeType.eqVideo(mimeType) && (this.config.videoMinSecond > 0 && duration < (long)this.config.videoMinSecond || this.config.videoMaxSecond > 0 && duration > (long)this.config.videoMaxSecond || duration == 0L || size <= 0L)) continue;
                        LocalMedia image = new LocalMedia(id2, url, fileName, folderName, duration, this.config.chooseMode, mimeType, width, height, size);
                        LocalMediaFolder folder = this.getImageFolder(url, folderName, imageFolders);
                        List<LocalMedia> images = folder.getImages();
                        images.add(image);
                        folder.setImageNum(folder.getImageNum() + 1);
                        latelyImages.add(image);
                        int imageNum = allImageFolder.getImageNum();
                        allImageFolder.setImageNum(imageNum + 1);
                    } while (data.moveToNext());
                    if (latelyImages.size() > 0) {
                        this.sortFolder(imageFolders);
                        imageFolders.add(0, allImageFolder);
                        allImageFolder.setFirstImagePath(((LocalMedia)latelyImages.get(0)).getPath());
                        String title = this.config.chooseMode == PictureMimeType.ofAudio() ? this.mContext.getString(R.string.picture_all_audio) : this.mContext.getString(R.string.picture_camera_roll);
                        allImageFolder.setName(title);
                        allImageFolder.setOfAllType(this.config.chooseMode);
                        allImageFolder.setCameraFolder(true);
                        allImageFolder.setImages(latelyImages);
                    }
                }
                ArrayList<LocalMediaFolder> arrayList = imageFolders;
                return arrayList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)("loadAllMedia Data Error: " + e.getMessage()));
            List<LocalMediaFolder> list = null;
            return list;
        }
        finally {
            if (data != null && !data.isClosed()) {
                data.close();
            }
        }
        return null;
    }

    private String getSelection() {
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaCondition(this.getDurationCondition(0L, 0L), this.config.isGif);
            }
            case 1: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    return "media_type=? AND _size>0 AND mime_type='" + this.config.specifiedFormat + "'";
                }
                return this.config.isGif ? SELECTION : SELECTION_NOT_GIF;
            }
            case 2: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    return "media_type=? AND _size>0 AND mime_type='" + this.config.specifiedFormat + "'";
                }
                return LocalMediaLoader.getSelectionArgsForSingleMediaCondition();
            }
            case 3: {
                if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
                    return "media_type=? AND _size>0 AND mime_type='" + this.config.specifiedFormat + "'";
                }
                return LocalMediaLoader.getSelectionArgsForSingleMediaCondition(this.getDurationCondition(0L, 500L));
            }
        }
        return null;
    }

    private String[] getSelectionArgs() {
        switch (this.config.chooseMode) {
            case 0: {
                return SELECTION_ALL_ARGS;
            }
            case 1: {
                String[] MEDIA_TYPE_IMAGE = LocalMediaLoader.getSelectionArgsForSingleMediaType(1);
                return MEDIA_TYPE_IMAGE;
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(3);
            }
            case 3: {
                String[] MEDIA_TYPE_AUDIO = LocalMediaLoader.getSelectionArgsForSingleMediaType(2);
                return MEDIA_TYPE_AUDIO;
            }
        }
        return null;
    }

    private void sortFolder(List<LocalMediaFolder> imageFolders) {
        Collections.sort(imageFolders, (lhs, rhs) -> {
            if (lhs.getImages() == null || rhs.getImages() == null) {
                return 0;
            }
            int lSize = lhs.getImageNum();
            int rSize = rhs.getImageNum();
            return Integer.compare(rSize, lSize);
        });
    }

    private String getRealPathAndroid_Q(long id2) {
        return QUERY_URI.buildUpon().appendPath(ValueOf.toString(id2)).build().toString();
    }

    private LocalMediaFolder getImageFolder(String path, String folderName, List<LocalMediaFolder> imageFolders) {
        if (!this.config.isFallbackVersion) {
            for (LocalMediaFolder folder : imageFolders) {
                String name = folder.getName();
                if (TextUtils.isEmpty((CharSequence)name) || !name.equals(folderName)) continue;
                return folder;
            }
            LocalMediaFolder newFolder = new LocalMediaFolder();
            newFolder.setName(folderName);
            newFolder.setFirstImagePath(path);
            imageFolders.add(newFolder);
            return newFolder;
        }
        File imageFile = new File(path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            String name = folder.getName();
            if (TextUtils.isEmpty((CharSequence)name) || !name.equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile.getName());
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    private String getDurationCondition(long exMaxLimit, long exMinLimit) {
        long maxS;
        long l = maxS = this.config.videoMaxSecond == 0 ? Long.MAX_VALUE : (long)this.config.videoMaxSecond;
        if (exMaxLimit != 0L) {
            maxS = Math.min(maxS, exMaxLimit);
        }
        return String.format(Locale.CHINA, "%d <%s duration and duration <= %d", Math.max(exMinLimit, (long)this.config.videoMinSecond), Math.max(exMinLimit, (long)this.config.videoMinSecond) == 0L ? "" : "=", maxS);
    }
}

