/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.immersive.ImmersiveManage;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.BitmapUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.util.ArrayList;

public class PictureSelectorCameraEmptyActivity
extends PictureBaseActivity {
    @Override
    public void immersive() {
        ImmersiveManage.immersiveAboveAPI23(this, ContextCompat.getColor((Context)this, (int)R.color.picture_color_transparent), ContextCompat.getColor((Context)this, (int)R.color.picture_color_transparent), this.openWhiteStatusBar);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (!this.config.isUseCustomCamera && PictureSelectionConfig.onPictureSelectorInterfaceListener == null) {
            if (savedInstanceState == null) {
                if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                    this.onTakePhoto();
                } else {
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                }
            }
            this.setTheme(R.style.Picture_Theme_Translucent);
        }
        super.onCreate(savedInstanceState);
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_empty;
    }

    private void onTakePhoto() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            boolean isPermissionChecker = true;
            if (this.config.isUseCustomCamera) {
                isPermissionChecker = PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO");
            }
            if (isPermissionChecker) {
                this.startCamera();
            } else {
                PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    private void startCamera() {
        switch (this.config.chooseMode) {
            case 0: 
            case 1: {
                this.startOpenCamera();
                break;
            }
            case 2: {
                this.startOpenCameraVideo();
                break;
            }
            case 3: {
                this.startOpenCameraAudio();
                break;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                case 69: {
                    this.singleCropHandleResult(data);
                    break;
                }
                case 909: {
                    this.requestCamera(data);
                    break;
                }
            }
        } else if (resultCode == 0) {
            this.closeActivity();
        } else if (resultCode == 96) {
            if (data == null) {
                return;
            }
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.getContext(), throwable.getMessage());
        }
    }

    protected void singleCropHandleResult(Intent data) {
        if (data == null) {
            return;
        }
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        Uri resultUri = UCrop.getOutput((Intent)data);
        if (resultUri == null) {
            return;
        }
        String cutPath = resultUri.getPath();
        LocalMedia media = new LocalMedia(this.config.cameraPath, 0L, false, this.config.isCamera ? 1 : 0, 0, this.config.chooseMode);
        if (SdkVersionUtils.checkedAndroid_Q()) {
            int lastIndexOf = this.config.cameraPath.lastIndexOf("/") + 1;
            media.setId(lastIndexOf > 0 ? ValueOf.toLong(this.config.cameraPath.substring(lastIndexOf)) : -1L);
            media.setAndroidQToPath(cutPath);
            if (TextUtils.isEmpty((CharSequence)cutPath)) {
                media.setCut(false);
                if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(this.config.cameraPath)) {
                    String path = PictureFileUtils.getPath((Context)this, Uri.parse((String)this.config.cameraPath));
                    media.setSize(!TextUtils.isEmpty((CharSequence)path) ? new File(path).length() : 0L);
                } else {
                    media.setSize(new File(this.config.cameraPath).length());
                }
            } else {
                media.setSize(new File(cutPath).length());
                media.setCut(true);
            }
        } else {
            media.setId(System.currentTimeMillis());
            media.setSize(new File(TextUtils.isEmpty((CharSequence)cutPath) ? media.getPath() : cutPath).length());
        }
        media.setCutPath(cutPath);
        String mimeType = PictureMimeType.getImageMimeType(cutPath);
        media.setMimeType(mimeType);
        medias.add(media);
        this.handlerResult(medias);
    }

    protected void requestCamera(Intent data) {
        int lastImageId;
        String mimeType = null;
        long duration = 0L;
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.config.cameraPath = this.getAudioPath(data);
            if (TextUtils.isEmpty((CharSequence)this.config.cameraPath)) {
                return;
            }
            mimeType = "audio/mpeg";
            duration = MediaUtils.extractDuration(this.getContext(), isAndroidQ, this.config.cameraPath);
        }
        if (TextUtils.isEmpty((CharSequence)this.config.cameraPath) || new File(this.config.cameraPath) == null) {
            return;
        }
        long size = 0L;
        int[] newSize = new int[2];
        if (!isAndroidQ) {
            if (this.config.isFallbackVersion3) {
                new PictureMediaScannerConnection(this.getContext(), this.config.cameraPath);
            } else {
                this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)new File(this.config.cameraPath))));
            }
        }
        LocalMedia media = new LocalMedia();
        if (this.config.chooseMode != PictureMimeType.ofAudio()) {
            if (PictureMimeType.isContent(this.config.cameraPath)) {
                String path = PictureFileUtils.getPath(this.getApplicationContext(), Uri.parse((String)this.config.cameraPath));
                File file = new File(path);
                size = file.length();
                mimeType = PictureMimeType.getMimeType(this.config.cameraMimeType);
                if (PictureMimeType.eqImage(mimeType)) {
                    newSize = MediaUtils.getLocalImageSizeToAndroidQ((Context)this, this.config.cameraPath);
                } else {
                    newSize = MediaUtils.getLocalVideoSize((Context)this, Uri.parse((String)this.config.cameraPath));
                    duration = MediaUtils.extractDuration(this.getContext(), true, this.config.cameraPath);
                }
                int lastIndexOf = this.config.cameraPath.lastIndexOf("/") + 1;
                media.setId(lastIndexOf > 0 ? ValueOf.toLong(this.config.cameraPath.substring(lastIndexOf)) : -1L);
                media.setRealPath(path);
                if (this.config.isUseCustomCamera && data != null) {
                    String mediaPath = data.getStringExtra("mediaPath");
                    media.setAndroidQToPath(mediaPath);
                }
            } else {
                File file = new File(this.config.cameraPath);
                mimeType = PictureMimeType.getMimeType(this.config.cameraMimeType);
                size = file.length();
                if (PictureMimeType.eqImage(mimeType)) {
                    int degree = PictureFileUtils.readPictureDegree((Context)this, this.config.cameraPath);
                    BitmapUtils.rotateImage(degree, this.config.cameraPath);
                    newSize = MediaUtils.getLocalImageWidthOrHeight(this.config.cameraPath);
                } else {
                    newSize = MediaUtils.getLocalVideoSize(this.config.cameraPath);
                    duration = MediaUtils.extractDuration(this.getContext(), false, this.config.cameraPath);
                }
                media.setId(System.currentTimeMillis());
            }
        }
        media.setDuration(duration);
        media.setWidth(newSize[0]);
        media.setHeight(newSize[1]);
        media.setPath(this.config.cameraPath);
        media.setMimeType(mimeType);
        media.setSize(size);
        media.setChooseModel(this.config.chooseMode);
        this.cameraHandleResult(media, mimeType);
        if (!isAndroidQ && PictureMimeType.eqImage(media.getMimeType()) && (lastImageId = MediaUtils.getLastImageId(this.getContext(), media.getMimeType())) != -1) {
            MediaUtils.removeMedia(this.getContext(), lastImageId);
        }
    }

    private void cameraHandleResult(LocalMedia media, String mimeType) {
        boolean eqImg = PictureMimeType.eqImage(mimeType);
        if (this.config.enableCrop && eqImg) {
            this.config.originalPath = this.config.cameraPath;
            this.startCrop(this.config.cameraPath, mimeType);
        } else if (this.config.isCompress && eqImg && !this.config.isCheckOriginalImage) {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.compressImage(result);
        } else {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.onResult(result);
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeActivity();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
                    break;
                }
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_jurisdiction));
                this.closeActivity();
                break;
            }
            case 2: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                this.closeActivity();
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_camera));
                break;
            }
            case 4: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                this.closeActivity();
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_audio));
            }
        }
    }
}

