/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureCustomCameraActivity;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.dialog.PhotoItemSelectedDialog;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.listener.OnAlbumItemClickListener;
import com.luck.picture.lib.listener.OnItemClickListener;
import com.luck.picture.lib.listener.OnPhotoSelectChangedListener;
import com.luck.picture.lib.model.LocalMediaLoader;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.BitmapUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.DoubleUtils;
import com.luck.picture.lib.tools.JumpUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.luck.picture.lib.widget.FolderPopWindow;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.model.CutInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PictureSelectorActivity
extends PictureBaseActivity
implements View.OnClickListener,
OnAlbumItemClickListener,
OnPhotoSelectChangedListener<LocalMedia>,
OnItemClickListener {
    protected ImageView mIvPictureLeftBack;
    protected ImageView mIvArrow;
    protected View titleViewBg;
    protected TextView mTvPictureTitle;
    protected TextView mTvPictureRight;
    protected TextView mTvPictureOk;
    protected TextView mTvEmpty;
    protected TextView mTvPictureImgNum;
    protected TextView mTvPicturePreview;
    protected TextView mTvPlayPause;
    protected TextView mTvStop;
    protected TextView mTvQuit;
    protected TextView mTvMusicStatus;
    protected TextView mTvMusicTotal;
    protected TextView mTvMusicTime;
    protected RecyclerView mPictureRecycler;
    protected RelativeLayout mBottomLayout;
    protected PictureImageGridAdapter mAdapter;
    protected List<LocalMedia> images = new ArrayList<LocalMedia>();
    protected List<LocalMediaFolder> foldersList = new ArrayList<LocalMediaFolder>();
    protected FolderPopWindow folderWindow;
    protected Animation animation = null;
    protected boolean isStartAnimation = false;
    protected MediaPlayer mediaPlayer;
    protected SeekBar musicSeekBar;
    protected boolean isPlayAudio = false;
    protected PictureCustomDialog audioDialog;
    protected CheckBox mCbOriginal;
    protected int oldCurrentListSize;
    protected boolean isFirstEnterActivity = false;
    protected boolean isEnterSetting;
    public Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                if (PictureSelectorActivity.this.mediaPlayer != null) {
                    PictureSelectorActivity.this.mTvMusicTime.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition()));
                    PictureSelectorActivity.this.musicSeekBar.setProgress(PictureSelectorActivity.this.mediaPlayer.getCurrentPosition());
                    PictureSelectorActivity.this.musicSeekBar.setMax(PictureSelectorActivity.this.mediaPlayer.getDuration());
                    PictureSelectorActivity.this.mTvMusicTotal.setText((CharSequence)DateUtils.formatDurationTime(PictureSelectorActivity.this.mediaPlayer.getDuration()));
                    if (PictureSelectorActivity.this.mHandler != null) {
                        PictureSelectorActivity.this.mHandler.postDelayed(PictureSelectorActivity.this.mRunnable, 200L);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.oldCurrentListSize = savedInstanceState.getInt("oldCurrentListSize", 0);
            this.selectionMedias = PictureSelector.obtainSelectorList(savedInstanceState);
            if (this.mAdapter != null) {
                this.isStartAnimation = true;
                this.mAdapter.bindSelectImages(this.selectionMedias);
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isEnterSetting) {
            if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                if (this.mAdapter.isDataEmpty()) {
                    this.readLocalMedia();
                }
            } else {
                this.showPermissionsDialog(false, this.getString(R.string.picture_jurisdiction));
            }
            this.isEnterSetting = false;
        }
        if (this.config.isOriginalControl && this.mCbOriginal != null) {
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
        }
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_selector;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.container = this.findViewById(R.id.container);
        this.titleViewBg = this.findViewById(R.id.titleViewBg);
        this.mIvPictureLeftBack = (ImageView)this.findViewById(R.id.picture_left_back);
        this.mTvPictureTitle = (TextView)this.findViewById(R.id.picture_title);
        this.mTvPictureRight = (TextView)this.findViewById(R.id.picture_right);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.picture_tv_ok);
        this.mCbOriginal = (CheckBox)this.findViewById(R.id.cb_original);
        this.mIvArrow = (ImageView)this.findViewById(R.id.ivArrow);
        this.mTvPicturePreview = (TextView)this.findViewById(R.id.picture_id_preview);
        this.mTvPictureImgNum = (TextView)this.findViewById(R.id.picture_tv_img_num);
        this.mPictureRecycler = (RecyclerView)this.findViewById(R.id.picture_recycler);
        this.mBottomLayout = (RelativeLayout)this.findViewById(R.id.rl_bottom);
        this.mTvEmpty = (TextView)this.findViewById(R.id.tv_empty);
        this.isNumComplete(this.numComplete);
        if (!this.numComplete) {
            this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.picture_anim_modal_in);
        }
        this.mTvPicturePreview.setOnClickListener((View.OnClickListener)this);
        this.mTvPicturePreview.setVisibility(this.config.chooseMode != PictureMimeType.ofAudio() && this.config.enablePreview ? 0 : 8);
        this.mBottomLayout.setVisibility(this.config.selectionMode == 1 && this.config.isSingleDirectReturn ? 8 : 0);
        this.mIvPictureLeftBack.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureRight.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureOk.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureImgNum.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureTitle.setOnClickListener((View.OnClickListener)this);
        this.mIvArrow.setOnClickListener((View.OnClickListener)this);
        String title = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
        this.mTvPictureTitle.setText((CharSequence)title);
        this.folderWindow = new FolderPopWindow((Context)this, this.config);
        this.folderWindow.setArrowImageView(this.mIvArrow);
        this.folderWindow.setOnAlbumItemClickListener(this);
        this.mPictureRecycler.setHasFixedSize(true);
        this.mPictureRecycler.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(this.config.imageSpanCount, ScreenUtils.dip2px((Context)this, 2.0f), false));
        this.mPictureRecycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), this.config.imageSpanCount));
        RecyclerView.ItemAnimator itemAnimator = this.mPictureRecycler.getItemAnimator();
        if (itemAnimator != null) {
            ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
        }
        if (this.config.isFallbackVersion2 || Build.VERSION.SDK_INT <= 19) {
            this.loadAllMediaData();
        }
        this.mTvEmpty.setText((CharSequence)(this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_audio_empty) : this.getString(R.string.picture_empty)));
        StringUtils.tempTextFont(this.mTvEmpty, this.config.chooseMode);
        this.mAdapter = new PictureImageGridAdapter(this.getContext(), this.config);
        this.mAdapter.setOnPhotoSelectChangedListener(this);
        this.mPictureRecycler.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (this.config.isOriginalControl) {
            this.mCbOriginal.setVisibility(0);
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
            this.mCbOriginal.setOnCheckedChangeListener((buttonView, isChecked) -> {
                this.config.isCheckOriginalImage = isChecked;
            });
        }
    }

    public void onEnterAnimationComplete() {
        super.onEnterAnimationComplete();
        if (Build.VERSION.SDK_INT > 19 && !this.config.isFallbackVersion2 && !this.isFirstEnterActivity) {
            this.loadAllMediaData();
            this.isFirstEnterActivity = true;
        }
    }

    private void loadAllMediaData() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            this.readLocalMedia();
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    @Override
    public void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureTitleDownResId != 0) {
                Drawable drawable2 = ContextCompat.getDrawable((Context)this, (int)this.config.style.pictureTitleDownResId);
                this.mIvArrow.setImageDrawable(drawable2);
            }
            if (this.config.style.pictureTitleTextColor != 0) {
                this.mTvPictureTitle.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureTitleTextSize != 0) {
                this.mTvPictureTitle.setTextSize((float)this.config.style.pictureTitleTextSize);
            }
            if (this.config.style.pictureRightDefaultTextColor != 0) {
                this.mTvPictureRight.setTextColor(this.config.style.pictureRightDefaultTextColor);
            } else if (this.config.style.pictureCancelTextColor != 0) {
                this.mTvPictureRight.setTextColor(this.config.style.pictureCancelTextColor);
            }
            if (this.config.style.pictureRightTextSize != 0) {
                this.mTvPictureRight.setTextSize((float)this.config.style.pictureRightTextSize);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.mIvPictureLeftBack.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.pictureUnPreviewTextColor != 0) {
                this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
            }
            if (this.config.style.picturePreviewTextSize != 0) {
                this.mTvPicturePreview.setTextSize((float)this.config.style.picturePreviewTextSize);
            }
            if (this.config.style.pictureCheckNumBgStyle != 0) {
                this.mTvPictureImgNum.setBackgroundResource(this.config.style.pictureCheckNumBgStyle);
            }
            if (this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            if (this.config.style.pictureCompleteTextSize != 0) {
                this.mTvPictureOk.setTextSize((float)this.config.style.pictureCompleteTextSize);
            }
            if (this.config.style.pictureBottomBgColor != 0) {
                this.mBottomLayout.setBackgroundColor(this.config.style.pictureBottomBgColor);
            }
            if (this.config.style.pictureContainerBackgroundColor != 0) {
                this.container.setBackgroundColor(this.config.style.pictureContainerBackgroundColor);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureRightDefaultText)) {
                this.mTvPictureRight.setText((CharSequence)this.config.style.pictureRightDefaultText);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText)) {
                this.mTvPictureOk.setText((CharSequence)this.config.style.pictureUnCompleteText);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureUnPreviewText)) {
                this.mTvPicturePreview.setText((CharSequence)this.config.style.pictureUnPreviewText);
            }
        } else {
            int pictureBottomBgColor;
            if (this.config.downResId != 0) {
                Drawable drawable3 = ContextCompat.getDrawable((Context)this, (int)this.config.downResId);
                this.mIvArrow.setImageDrawable(drawable3);
            }
            if ((pictureBottomBgColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_bottom_bg)) != 0) {
                this.mBottomLayout.setBackgroundColor(pictureBottomBgColor);
            }
        }
        this.titleViewBg.setBackgroundColor(this.colorPrimary);
        if (this.config.isOriginalControl) {
            if (this.config.style != null) {
                if (this.config.style.pictureOriginalControlStyle != 0) {
                    this.mCbOriginal.setButtonDrawable(this.config.style.pictureOriginalControlStyle);
                } else {
                    this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                }
                if (this.config.style.pictureOriginalFontColor != 0) {
                    this.mCbOriginal.setTextColor(this.config.style.pictureOriginalFontColor);
                } else {
                    this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
                }
                if (this.config.style.pictureOriginalTextSize != 0) {
                    this.mCbOriginal.setTextSize((float)this.config.style.pictureOriginalTextSize);
                }
            } else {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
            }
        }
        this.mAdapter.bindSelectImages(this.selectionMedias);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.images != null) {
            outState.putInt("oldCurrentListSize", this.images.size());
        }
        if (this.mAdapter != null && this.mAdapter.getSelectedImages() != null) {
            List<LocalMedia> selectedImages = this.mAdapter.getSelectedImages();
            PictureSelector.saveSelectorList(outState, selectedImages);
        }
    }

    private void isNumComplete(boolean numComplete) {
        if (numComplete) {
            this.initCompleteText(0);
        }
    }

    @Override
    protected void initCompleteText(int startCount) {
        boolean isNotEmptyStyle;
        boolean bl = isNotEmptyStyle = this.config.style != null;
        if (this.config.selectionMode == 1) {
            if (startCount <= 0) {
                this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_please_select)));
            } else {
                boolean isCompleteReplaceNum;
                boolean bl2 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)String.format(this.config.style.pictureCompleteText, startCount, 1));
                } else {
                    this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText) ? this.config.style.pictureCompleteText : this.getString(R.string.picture_done)));
                }
            }
        } else {
            boolean isCompleteReplaceNum;
            boolean bl3 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
            if (startCount <= 0) {
                this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxVideoSelectNum + this.config.maxSelectNum})));
            } else if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                this.mTvPictureOk.setText((CharSequence)String.format(this.config.style.pictureCompleteText, startCount, this.config.maxVideoSelectNum + this.config.maxSelectNum));
            } else {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxVideoSelectNum + this.config.maxSelectNum}));
            }
        }
    }

    protected void readLocalMedia() {
        this.showPleaseDialog();
        PictureThreadUtils.executeByCached(new PictureThreadUtils.SimpleTask<List<LocalMediaFolder>>(){

            @Override
            public List<LocalMediaFolder> doInBackground() {
                return new LocalMediaLoader(PictureSelectorActivity.this.getContext(), PictureSelectorActivity.this.config).loadAllMedia();
            }

            @Override
            public void onSuccess(List<LocalMediaFolder> folders) {
                PictureSelectorActivity.this.dismissDialog();
                PictureThreadUtils.cancel(PictureThreadUtils.getCachedPool());
                if (folders != null) {
                    if (folders.size() > 0) {
                        PictureSelectorActivity.this.foldersList = folders;
                        LocalMediaFolder folder = folders.get(0);
                        folder.setChecked(true);
                        List<LocalMedia> result = folder.getImages();
                        if (PictureSelectorActivity.this.images == null) {
                            PictureSelectorActivity.this.images = new ArrayList<LocalMedia>();
                        }
                        int currentSize = PictureSelectorActivity.this.images.size();
                        int resultSize = result.size();
                        PictureSelectorActivity.this.oldCurrentListSize += currentSize;
                        if (resultSize >= currentSize) {
                            if (currentSize > 0 && currentSize < resultSize && PictureSelectorActivity.this.oldCurrentListSize != resultSize) {
                                PictureSelectorActivity.this.images.addAll(result);
                                LocalMedia media = PictureSelectorActivity.this.images.get(0);
                                folder.setFirstImagePath(media.getPath());
                                folder.getImages().add(0, media);
                                folder.setCheckedNum(1);
                                folder.setImageNum(folder.getImageNum() + 1);
                                PictureSelectorActivity.this.updateMediaFolder(PictureSelectorActivity.this.foldersList, media);
                            } else {
                                PictureSelectorActivity.this.images = result;
                            }
                            PictureSelectorActivity.this.folderWindow.bindFolder(folders);
                        }
                    }
                    if (PictureSelectorActivity.this.mAdapter != null) {
                        boolean isEmpty;
                        PictureSelectorActivity.this.mAdapter.bindImagesData(PictureSelectorActivity.this.images);
                        boolean bl = isEmpty = PictureSelectorActivity.this.images.size() > 0;
                        if (!isEmpty) {
                            PictureSelectorActivity.this.mTvEmpty.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_empty));
                            PictureSelectorActivity.this.mTvEmpty.setCompoundDrawablesRelativeWithIntrinsicBounds(0, R.drawable.picture_icon_no_data, 0, 0);
                        }
                        PictureSelectorActivity.this.mTvEmpty.setVisibility(isEmpty ? 4 : 0);
                    }
                } else {
                    PictureSelectorActivity.this.mTvEmpty.setCompoundDrawablesRelativeWithIntrinsicBounds(0, R.drawable.picture_icon_data_error, 0, 0);
                    PictureSelectorActivity.this.mTvEmpty.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_data_exception));
                    PictureSelectorActivity.this.mTvEmpty.setVisibility(PictureSelectorActivity.this.images.size() > 0 ? 4 : 0);
                }
            }
        });
    }

    public void startCamera() {
        if (!DoubleUtils.isFastDoubleClick()) {
            if (PictureSelectionConfig.onPictureSelectorInterfaceListener != null) {
                if (this.config.chooseMode == 0) {
                    PhotoItemSelectedDialog selectedDialog = PhotoItemSelectedDialog.newInstance();
                    selectedDialog.setOnItemClickListener(this);
                    selectedDialog.show(this.getSupportFragmentManager(), "PhotoItemSelectedDialog");
                } else {
                    PictureSelectionConfig.onPictureSelectorInterfaceListener.onCameraClick(this.getContext(), this.config, this.config.chooseMode);
                    this.config.cameraMimeType = this.config.chooseMode;
                }
                return;
            }
            if (this.config.isUseCustomCamera) {
                this.startCustomCamera();
                return;
            }
            switch (this.config.chooseMode) {
                case 0: {
                    PhotoItemSelectedDialog selectedDialog = PhotoItemSelectedDialog.newInstance();
                    selectedDialog.setOnItemClickListener(this);
                    selectedDialog.show(this.getSupportFragmentManager(), "PhotoItemSelectedDialog");
                    break;
                }
                case 1: {
                    this.startOpenCamera();
                    break;
                }
                case 2: {
                    this.startOpenCameraVideo();
                    break;
                }
                case 3: {
                    this.startOpenCameraAudio();
                    break;
                }
            }
        }
    }

    private void startCustomCamera() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO")) {
            Intent intent = new Intent((Context)this, PictureCustomCameraActivity.class);
            this.startActivityForResult(intent, 909);
            PictureWindowAnimationStyle windowAnimationStyle = this.config.windowAnimationStyle;
            this.overridePendingTransition(windowAnimationStyle != null && windowAnimationStyle.activityEnterAnimation != 0 ? windowAnimationStyle.activityEnterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.picture_left_back || id2 == R.id.picture_right) {
            if (this.folderWindow != null && this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else {
                this.onBackPressed();
            }
        }
        if (id2 == R.id.picture_title || id2 == R.id.ivArrow) {
            if (this.folderWindow.isShowing()) {
                this.folderWindow.dismiss();
            } else if (this.images != null && this.images.size() > 0) {
                this.folderWindow.showAsDropDown(this.titleViewBg);
                if (!this.config.isSingleDirectReturn) {
                    List<LocalMedia> selectedImages = this.mAdapter.getSelectedImages();
                    this.folderWindow.updateFolderCheckStatus(selectedImages);
                }
            }
        }
        if (id2 == R.id.picture_id_preview) {
            this.onPreview();
        }
        if (id2 == R.id.picture_tv_ok || id2 == R.id.picture_tv_img_num) {
            this.onComplete();
        }
    }

    private void onPreview() {
        List<LocalMedia> selectedImages = this.mAdapter.getSelectedImages();
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        int size = selectedImages.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = selectedImages.get(i);
            medias.add(media);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("previewSelectList", medias);
        bundle.putParcelableArrayList("selectList", (ArrayList)selectedImages);
        bundle.putBoolean("bottom_preview", true);
        bundle.putBoolean("isOriginal", this.config.isCheckOriginalImage);
        bundle.putBoolean("isShowCamera", this.mAdapter.isShowCamera());
        bundle.putString("currentDirectory", this.mTvPictureTitle.getText().toString());
        JumpUtils.startPicturePreviewActivity(this.getContext(), this.config.isWeChatStyle, bundle, this.config.selectionMode == 1 ? 69 : 609);
        this.overridePendingTransition(this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewEnterAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewEnterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
    }

    private void onComplete() {
        List<LocalMedia> result = this.mAdapter.getSelectedImages();
        int size = result.size();
        LocalMedia image = result.size() > 0 ? result.get(0) : null;
        String mimeType = image != null ? image.getMimeType() : "";
        boolean eqImg = PictureMimeType.eqImage(mimeType);
        if (this.config.isWithVideoImage) {
            int videoSize = 0;
            int imageSize = 0;
            for (int i = 0; i < size; ++i) {
                LocalMedia media = result.get(i);
                if (PictureMimeType.eqVideo(media.getMimeType())) {
                    ++videoSize;
                    continue;
                }
                ++imageSize;
            }
            if (this.config.selectionMode == 2) {
                if (this.config.minSelectNum > 0 && imageSize < this.config.minSelectNum) {
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}));
                    return;
                }
                if (this.config.minVideoSelectNum > 0 && videoSize < this.config.minVideoSelectNum) {
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum}));
                    return;
                }
            }
        } else if (this.config.selectionMode == 2) {
            if (PictureMimeType.eqImage(mimeType) && this.config.minSelectNum > 0 && size < this.config.minSelectNum) {
                String str = this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum});
                ToastUtils.s(this.getContext(), str);
                return;
            }
            if (PictureMimeType.eqVideo(mimeType) && this.config.minVideoSelectNum > 0 && size < this.config.minVideoSelectNum) {
                String str = this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum});
                ToastUtils.s(this.getContext(), str);
                return;
            }
        }
        if (this.config.returnEmpty && size == 0) {
            if (this.config.selectionMode == 2) {
                if (this.config.minSelectNum > 0 && size < this.config.minSelectNum) {
                    String str = this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum});
                    ToastUtils.s(this.getContext(), str);
                    return;
                }
                if (this.config.minVideoSelectNum > 0 && size < this.config.minVideoSelectNum) {
                    String str = this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum});
                    ToastUtils.s(this.getContext(), str);
                    return;
                }
            }
            if (PictureSelectionConfig.listener != null) {
                PictureSelectionConfig.listener.onResult(result);
            } else {
                Intent intent = PictureSelector.putIntentResult(result);
                this.setResult(-1, intent);
            }
            this.closeActivity();
            return;
        }
        if (this.config.isCheckOriginalImage) {
            this.onResult(result);
            return;
        }
        if (this.config.chooseMode == PictureMimeType.ofAll() && this.config.isWithVideoImage) {
            this.bothMimeTypeWith(eqImg, result);
        } else {
            this.separateMimeTypeWith(eqImg, result);
        }
    }

    private void bothMimeTypeWith(boolean eqImg, List<LocalMedia> images) {
        LocalMedia image;
        LocalMedia localMedia = image = images.size() > 0 ? images.get(0) : null;
        if (image == null) {
            return;
        }
        if (this.config.enableCrop) {
            if (this.config.selectionMode == 1 && eqImg) {
                this.config.originalPath = image.getPath();
                this.startCrop(this.config.originalPath, image.getMimeType());
            } else {
                ArrayList<CutInfo> cuts = new ArrayList<CutInfo>();
                int count = images.size();
                int imageNum = 0;
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = images.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    boolean eqImage = PictureMimeType.eqImage(media.getMimeType());
                    if (eqImage) {
                        ++imageNum;
                    }
                    CutInfo cutInfo = new CutInfo();
                    cutInfo.setId(media.getId());
                    cutInfo.setPath(media.getPath());
                    cutInfo.setImageWidth(media.getWidth());
                    cutInfo.setImageHeight(media.getHeight());
                    cutInfo.setMimeType(media.getMimeType());
                    cutInfo.setDuration(media.getDuration());
                    cutInfo.setRealPath(media.getRealPath());
                    cuts.add(cutInfo);
                }
                if (imageNum <= 0) {
                    this.onResult(images);
                } else {
                    this.startCrop(cuts);
                }
            }
        } else if (this.config.isCompress) {
            int size = images.size();
            int imageNum = 0;
            for (int i = 0; i < size; ++i) {
                LocalMedia media = images.get(i);
                boolean eqImage = PictureMimeType.eqImage(media.getMimeType());
                if (!eqImage) continue;
                ++imageNum;
                break;
            }
            if (imageNum <= 0) {
                this.onResult(images);
            } else {
                this.compressImage(images);
            }
        } else {
            this.onResult(images);
        }
    }

    private void separateMimeTypeWith(boolean eqImg, List<LocalMedia> images) {
        LocalMedia image;
        LocalMedia localMedia = image = images.size() > 0 ? images.get(0) : null;
        if (image == null) {
            return;
        }
        if (this.config.enableCrop && eqImg) {
            if (this.config.selectionMode == 1) {
                this.config.originalPath = image.getPath();
                this.startCrop(this.config.originalPath, image.getMimeType());
            } else {
                ArrayList<CutInfo> cuts = new ArrayList<CutInfo>();
                int count = images.size();
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = images.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    CutInfo cutInfo = new CutInfo();
                    cutInfo.setId(media.getId());
                    cutInfo.setPath(media.getPath());
                    cutInfo.setImageWidth(media.getWidth());
                    cutInfo.setImageHeight(media.getHeight());
                    cutInfo.setMimeType(media.getMimeType());
                    cutInfo.setDuration(media.getDuration());
                    cutInfo.setRealPath(media.getRealPath());
                    cuts.add(cutInfo);
                }
                this.startCrop(cuts);
            }
        } else if (this.config.isCompress && eqImg) {
            this.compressImage(images);
        } else {
            this.onResult(images);
        }
    }

    private void audioDialog(String path) {
        if (!this.isFinishing()) {
            this.audioDialog = new PictureCustomDialog(this.getContext(), R.layout.picture_audio_dialog);
            if (this.audioDialog.getWindow() != null) {
                this.audioDialog.getWindow().setWindowAnimations(R.style.Picture_Theme_Dialog_AudioStyle);
            }
            this.mTvMusicStatus = (TextView)this.audioDialog.findViewById(R.id.tv_musicStatus);
            this.mTvMusicTime = (TextView)this.audioDialog.findViewById(R.id.tv_musicTime);
            this.musicSeekBar = (SeekBar)this.audioDialog.findViewById(R.id.musicSeekBar);
            this.mTvMusicTotal = (TextView)this.audioDialog.findViewById(R.id.tv_musicTotal);
            this.mTvPlayPause = (TextView)this.audioDialog.findViewById(R.id.tv_PlayPause);
            this.mTvStop = (TextView)this.audioDialog.findViewById(R.id.tv_Stop);
            this.mTvQuit = (TextView)this.audioDialog.findViewById(R.id.tv_Quit);
            if (this.mHandler != null) {
                this.mHandler.postDelayed(() -> this.initPlayer(path), 30L);
            }
            this.mTvPlayPause.setOnClickListener((View.OnClickListener)new audioOnClick(path));
            this.mTvStop.setOnClickListener((View.OnClickListener)new audioOnClick(path));
            this.mTvQuit.setOnClickListener((View.OnClickListener)new audioOnClick(path));
            this.musicSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    if (fromUser) {
                        PictureSelectorActivity.this.mediaPlayer.seekTo(progress);
                    }
                }

                public void onStartTrackingTouch(SeekBar seekBar) {
                }

                public void onStopTrackingTouch(SeekBar seekBar) {
                }
            });
            this.audioDialog.setOnDismissListener(dialog -> {
                if (this.mHandler != null) {
                    this.mHandler.removeCallbacks(this.mRunnable);
                }
                new Handler().postDelayed(() -> this.stop(path), 30L);
                try {
                    if (this.audioDialog != null && this.audioDialog.isShowing()) {
                        this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            if (this.mHandler != null) {
                this.mHandler.post(this.mRunnable);
            }
            this.audioDialog.show();
        }
    }

    private void initPlayer(String path) {
        this.mediaPlayer = new MediaPlayer();
        try {
            this.mediaPlayer.setDataSource(path);
            this.mediaPlayer.prepare();
            this.mediaPlayer.setLooping(true);
            this.playAudio();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playAudio() {
        String ppStr;
        if (this.mediaPlayer != null) {
            this.musicSeekBar.setProgress(this.mediaPlayer.getCurrentPosition());
            this.musicSeekBar.setMax(this.mediaPlayer.getDuration());
        }
        if ((ppStr = this.mTvPlayPause.getText().toString()).equals(this.getString(R.string.picture_play_audio))) {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.playOrPause();
        } else {
            this.mTvPlayPause.setText((CharSequence)this.getString(R.string.picture_play_audio));
            this.mTvMusicStatus.setText((CharSequence)this.getString(R.string.picture_pause_audio));
            this.playOrPause();
        }
        if (!this.isPlayAudio) {
            if (this.mHandler != null) {
                this.mHandler.post(this.mRunnable);
            }
            this.isPlayAudio = true;
        }
    }

    public void stop(String path) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.stop();
                this.mediaPlayer.reset();
                this.mediaPlayer.setDataSource(path);
                this.mediaPlayer.prepare();
                this.mediaPlayer.seekTo(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void playOrPause() {
        try {
            if (this.mediaPlayer != null) {
                if (this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                } else {
                    this.mediaPlayer.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemClick(boolean isCameraFolder, String folderName, List<LocalMedia> images) {
        boolean camera = this.config.isCamera && isCameraFolder;
        this.mAdapter.setShowCamera(camera);
        this.mTvPictureTitle.setText((CharSequence)folderName);
        this.folderWindow.dismiss();
        this.mAdapter.bindImagesData(images);
        this.mPictureRecycler.smoothScrollToPosition(0);
    }

    @Override
    public void onTakePhoto() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                this.startCamera();
            } else {
                PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 5);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    @Override
    public void onChange(List<LocalMedia> selectImages) {
        this.changeImageNumber(selectImages);
    }

    @Override
    public void onPictureClick(LocalMedia media, int position) {
        if (this.config.selectionMode == 1 && this.config.isSingleDirectReturn) {
            ArrayList<LocalMedia> list = new ArrayList<LocalMedia>();
            list.add(media);
            if (this.config.enableCrop && PictureMimeType.eqImage(media.getMimeType()) && !this.config.isCheckOriginalImage) {
                this.mAdapter.bindSelectImages(list);
                this.startCrop(media.getPath(), media.getMimeType());
            } else {
                this.handlerResult(list);
            }
        } else {
            List<LocalMedia> images = this.mAdapter.getImages();
            this.startPreview(images, position);
        }
    }

    public void startPreview(List<LocalMedia> previewImages, int position) {
        LocalMedia media = previewImages.get(position);
        String mimeType = media.getMimeType();
        Bundle bundle = new Bundle();
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        if (PictureMimeType.eqVideo(mimeType)) {
            if (this.config.selectionMode == 1 && !this.config.enPreviewVideo) {
                result.add(media);
                this.onResult(result);
            } else if (PictureSelectionConfig.customVideoPlayCallback != null) {
                PictureSelectionConfig.customVideoPlayCallback.startPlayVideo(media);
            } else {
                bundle.putParcelable("mediaKey", (Parcelable)media);
                JumpUtils.startPictureVideoPlayActivity(this.getContext(), bundle, 166);
            }
        } else if (PictureMimeType.eqAudio(mimeType)) {
            if (this.config.selectionMode == 1) {
                result.add(media);
                this.onResult(result);
            } else {
                this.audioDialog(media.getPath());
            }
        } else {
            List<LocalMedia> selectedImages = this.mAdapter.getSelectedImages();
            ImagesObservable.getInstance().savePreviewMediaData(new ArrayList<LocalMedia>(previewImages));
            bundle.putParcelableArrayList("selectList", (ArrayList)selectedImages);
            bundle.putInt("position", position);
            bundle.putBoolean("isOriginal", this.config.isCheckOriginalImage);
            bundle.putBoolean("isShowCamera", this.mAdapter.isShowCamera());
            bundle.putString("currentDirectory", this.mTvPictureTitle.getText().toString());
            JumpUtils.startPicturePreviewActivity(this.getContext(), this.config.isWeChatStyle, bundle, this.config.selectionMode == 1 ? 69 : 609);
            this.overridePendingTransition(this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewEnterAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewEnterAnimation : R.anim.picture_anim_enter, R.anim.picture_anim_fade_in);
        }
    }

    protected void changeImageNumber(List<LocalMedia> selectImages) {
        boolean enable;
        boolean bl = enable = selectImages.size() != 0;
        if (enable) {
            this.mTvPictureOk.setEnabled(true);
            this.mTvPictureOk.setSelected(true);
            this.mTvPicturePreview.setEnabled(true);
            this.mTvPicturePreview.setSelected(true);
            if (this.config.style != null) {
                if (this.config.style.pictureCompleteTextColor != 0) {
                    this.mTvPictureOk.setTextColor(this.config.style.pictureCompleteTextColor);
                }
                if (this.config.style.picturePreviewTextColor != 0) {
                    this.mTvPicturePreview.setTextColor(this.config.style.picturePreviewTextColor);
                }
            }
            if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.picturePreviewText)) {
                this.mTvPicturePreview.setText((CharSequence)this.config.style.picturePreviewText);
            } else {
                this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview_num, new Object[]{selectImages.size()}));
            }
            if (this.numComplete) {
                this.initCompleteText(selectImages.size());
            } else {
                if (!this.isStartAnimation) {
                    this.mTvPictureImgNum.startAnimation(this.animation);
                }
                this.mTvPictureImgNum.setVisibility(0);
                this.mTvPictureImgNum.setText((CharSequence)String.valueOf(selectImages.size()));
                if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)this.config.style.pictureCompleteText);
                } else {
                    this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
                }
                this.isStartAnimation = false;
            }
        } else {
            this.mTvPictureOk.setEnabled(this.config.returnEmpty);
            this.mTvPictureOk.setSelected(false);
            this.mTvPicturePreview.setEnabled(false);
            this.mTvPicturePreview.setSelected(false);
            if (this.config.style != null) {
                if (this.config.style.pictureUnCompleteTextColor != 0) {
                    this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
                }
                if (this.config.style.pictureUnPreviewTextColor != 0) {
                    this.mTvPicturePreview.setTextColor(this.config.style.pictureUnPreviewTextColor);
                }
            }
            if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnPreviewText)) {
                this.mTvPicturePreview.setText((CharSequence)this.config.style.pictureUnPreviewText);
            } else {
                this.mTvPicturePreview.setText((CharSequence)this.getString(R.string.picture_preview));
            }
            if (this.numComplete) {
                this.initCompleteText(selectImages.size());
            } else {
                this.mTvPictureImgNum.setVisibility(4);
                if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)this.config.style.pictureUnCompleteText);
                } else {
                    this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
                }
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block11: {
            Throwable throwable;
            block10: {
                super.onActivityResult(requestCode, resultCode, data);
                if (resultCode != -1) break block10;
                switch (requestCode) {
                    case 166: {
                        ArrayList list;
                        if (data != null && (list = data.getParcelableArrayListExtra("selectList")) != null && list.size() > 0) {
                            this.onResult(list);
                            break;
                        }
                        break block11;
                    }
                    case 69: {
                        this.singleCropHandleResult(data);
                        break;
                    }
                    case 609: {
                        this.multiCropHandleResult(data);
                        break;
                    }
                    case 909: {
                        this.requestCamera(data);
                        break;
                    }
                }
                break block11;
            }
            if (resultCode == 0) {
                this.previewCallback(data);
            } else if (resultCode == 96 && data != null && (throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error")) != null) {
                ToastUtils.s(this.getContext(), throwable.getMessage());
            }
        }
    }

    private void previewCallback(Intent data) {
        if (data == null) {
            return;
        }
        if (this.config.isOriginalControl) {
            this.config.isCheckOriginalImage = data.getBooleanExtra("isOriginal", this.config.isCheckOriginalImage);
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
        }
        ArrayList list = data.getParcelableArrayListExtra("selectList");
        if (this.mAdapter != null && list != null) {
            boolean isCompleteOrSelected = data.getBooleanExtra("isCompleteOrSelected", false);
            if (isCompleteOrSelected) {
                this.onChangeData(list);
                if (this.config.isWithVideoImage) {
                    int size = list.size();
                    int imageSize = 0;
                    for (int i = 0; i < size; ++i) {
                        LocalMedia media = (LocalMedia)list.get(i);
                        if (!PictureMimeType.eqImage(media.getMimeType())) continue;
                        ++imageSize;
                        break;
                    }
                    if (imageSize <= 0 || !this.config.isCompress || this.config.isCheckOriginalImage) {
                        this.onResult(list);
                    } else {
                        this.compressImage(list);
                    }
                } else {
                    String mimeType;
                    String string2 = mimeType = list.size() > 0 ? ((LocalMedia)list.get(0)).getMimeType() : "";
                    if (this.config.isCompress && PictureMimeType.eqImage(mimeType) && !this.config.isCheckOriginalImage) {
                        this.compressImage(list);
                    } else {
                        this.onResult(list);
                    }
                }
            } else {
                this.isStartAnimation = true;
            }
            this.mAdapter.bindSelectImages(list);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    protected void onChangeData(List<LocalMedia> list) {
    }

    private void singleDirectReturnCameraHandleResult(String mimeType) {
        boolean eqImg = PictureMimeType.eqImage(mimeType);
        if (this.config.enableCrop && eqImg) {
            this.config.originalPath = this.config.cameraPath;
            this.startCrop(this.config.cameraPath, mimeType);
        } else if (this.config.isCompress && eqImg) {
            List<LocalMedia> selectedImages = this.mAdapter.getSelectedImages();
            this.compressImage(selectedImages);
        } else {
            this.onResult(this.mAdapter.getSelectedImages());
        }
    }

    private void requestCamera(Intent data) {
        String mimeType = null;
        long duration = 0L;
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (this.config.chooseMode == PictureMimeType.ofAudio()) {
            this.config.cameraPath = this.getAudioPath(data);
            if (TextUtils.isEmpty((CharSequence)this.config.cameraPath)) {
                return;
            }
            mimeType = "audio/mpeg";
            duration = MediaUtils.extractDuration(this.getContext(), isAndroidQ, this.config.cameraPath);
        }
        if (TextUtils.isEmpty((CharSequence)this.config.cameraPath)) {
            return;
        }
        long size = 0L;
        int[] newSize = new int[2];
        if (!isAndroidQ) {
            if (this.config.isFallbackVersion3) {
                new PictureMediaScannerConnection(this.getContext(), this.config.cameraPath);
            } else {
                this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)new File(this.config.cameraPath))));
            }
        }
        LocalMedia media = new LocalMedia();
        if (this.config.chooseMode != PictureMimeType.ofAudio()) {
            if (PictureMimeType.isContent(this.config.cameraPath)) {
                String path = PictureFileUtils.getPath(this.getApplicationContext(), Uri.parse((String)this.config.cameraPath));
                if (!TextUtils.isEmpty((CharSequence)path)) {
                    File file = new File(path);
                    size = file.length();
                    mimeType = PictureMimeType.getMimeType(this.config.cameraMimeType);
                }
                if (PictureMimeType.eqImage(mimeType)) {
                    newSize = MediaUtils.getLocalImageSizeToAndroidQ((Context)this, this.config.cameraPath);
                } else {
                    newSize = MediaUtils.getLocalVideoSize((Context)this, Uri.parse((String)this.config.cameraPath));
                    duration = MediaUtils.extractDuration(this.getContext(), true, this.config.cameraPath);
                }
                int lastIndexOf = this.config.cameraPath.lastIndexOf("/") + 1;
                media.setId(lastIndexOf > 0 ? ValueOf.toLong(this.config.cameraPath.substring(lastIndexOf)) : -1L);
                media.setRealPath(path);
                if (this.config.isUseCustomCamera && data != null) {
                    String mediaPath = data.getStringExtra("mediaPath");
                    media.setAndroidQToPath(mediaPath);
                }
            } else {
                File file = new File(this.config.cameraPath);
                mimeType = PictureMimeType.getMimeType(this.config.cameraMimeType);
                size = file.length();
                if (PictureMimeType.eqImage(mimeType)) {
                    int degree = PictureFileUtils.readPictureDegree((Context)this, this.config.cameraPath);
                    BitmapUtils.rotateImage(degree, this.config.cameraPath);
                    newSize = MediaUtils.getLocalImageWidthOrHeight(this.config.cameraPath);
                } else {
                    newSize = MediaUtils.getLocalVideoSize(this.config.cameraPath);
                    duration = MediaUtils.extractDuration(this.getContext(), false, this.config.cameraPath);
                }
                media.setId(System.currentTimeMillis());
            }
        }
        media.setDuration(duration);
        media.setWidth(newSize[0]);
        media.setHeight(newSize[1]);
        media.setPath(this.config.cameraPath);
        media.setMimeType(mimeType);
        media.setSize(size);
        media.setChooseModel(this.config.chooseMode);
        if (this.mAdapter != null) {
            int lastImageId;
            this.images.add(0, media);
            if (this.checkVideoLegitimacy(media)) {
                List<LocalMedia> selectedImages;
                if (this.config.selectionMode == 1) {
                    if (this.config.isSingleDirectReturn) {
                        selectedImages = this.mAdapter.getSelectedImages();
                        selectedImages.add(media);
                        this.mAdapter.bindSelectImages(selectedImages);
                        this.singleDirectReturnCameraHandleResult(mimeType);
                    } else {
                        selectedImages = this.mAdapter.getSelectedImages();
                        mimeType = selectedImages.size() > 0 ? selectedImages.get(0).getMimeType() : "";
                        boolean mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, media.getMimeType());
                        if (mimeTypeSame || selectedImages.size() == 0) {
                            this.singleRadioMediaImage();
                            selectedImages.add(media);
                            this.mAdapter.bindSelectImages(selectedImages);
                        }
                    }
                } else {
                    selectedImages = this.mAdapter.getSelectedImages();
                    int count = selectedImages.size();
                    mimeType = count > 0 ? selectedImages.get(0).getMimeType() : "";
                    boolean mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, media.getMimeType());
                    if (this.config.isWithVideoImage) {
                        int videoSize = 0;
                        int imageSize = 0;
                        for (int i = 0; i < count; ++i) {
                            LocalMedia m = selectedImages.get(i);
                            if (PictureMimeType.eqVideo(m.getMimeType())) {
                                ++videoSize;
                                continue;
                            }
                            ++imageSize;
                        }
                        if (PictureMimeType.eqVideo(media.getMimeType())) {
                            if (this.config.maxVideoSelectNum <= 0) {
                                ToastUtils.s(this.getContext(), this.getString(R.string.picture_rule));
                            } else if (videoSize < this.config.maxVideoSelectNum) {
                                selectedImages.add(0, media);
                                this.mAdapter.bindSelectImages(selectedImages);
                            } else {
                                ToastUtils.s(this.getContext(), StringUtils.getMsg(this.getContext(), media.getMimeType(), this.config.maxVideoSelectNum));
                            }
                        } else if (imageSize < this.config.maxSelectNum) {
                            selectedImages.add(0, media);
                            this.mAdapter.bindSelectImages(selectedImages);
                        } else {
                            ToastUtils.s(this.getContext(), StringUtils.getMsg(this.getContext(), media.getMimeType(), this.config.maxSelectNum));
                        }
                    } else if (PictureMimeType.eqVideo(mimeType) && this.config.maxVideoSelectNum > 0) {
                        if (count < this.config.maxVideoSelectNum) {
                            if ((mimeTypeSame || count == 0) && selectedImages.size() < this.config.maxVideoSelectNum) {
                                selectedImages.add(0, media);
                                this.mAdapter.bindSelectImages(selectedImages);
                            }
                        } else {
                            ToastUtils.s(this.getContext(), StringUtils.getMsg(this.getContext(), mimeType, this.config.maxVideoSelectNum));
                        }
                    } else if (count < this.config.maxSelectNum) {
                        if (mimeTypeSame || count == 0) {
                            selectedImages.add(0, media);
                            this.mAdapter.bindSelectImages(selectedImages);
                        }
                    } else {
                        ToastUtils.s(this.getContext(), StringUtils.getMsg(this.getContext(), mimeType, this.config.maxSelectNum));
                    }
                }
            }
            this.mAdapter.notifyItemInserted(this.config.isCamera ? 1 : 0);
            this.mAdapter.notifyItemRangeChanged(this.config.isCamera ? 1 : 0, this.images.size());
            this.manualSaveFolder(media);
            if (!isAndroidQ && PictureMimeType.eqImage(media.getMimeType()) && (lastImageId = MediaUtils.getLastImageId(this.getContext(), media.getMimeType())) != -1) {
                MediaUtils.removeMedia(this.getContext(), lastImageId);
            }
            this.mTvEmpty.setVisibility(this.images.size() > 0 || this.config.isSingleDirectReturn ? 4 : 0);
        }
    }

    private boolean checkVideoLegitimacy(LocalMedia media) {
        boolean isEnterNext = true;
        if (PictureMimeType.eqVideo(media.getMimeType())) {
            if (this.config.videoMinSecond > 0 && this.config.videoMaxSecond > 0) {
                if (media.getDuration() < (long)this.config.videoMinSecond || media.getDuration() > (long)this.config.videoMaxSecond) {
                    isEnterNext = false;
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_choose_limit_seconds, new Object[]{this.config.videoMinSecond / 1000, this.config.videoMaxSecond / 1000}));
                }
            } else if (this.config.videoMinSecond > 0) {
                if (media.getDuration() < (long)this.config.videoMinSecond) {
                    isEnterNext = false;
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                }
            } else if (this.config.videoMaxSecond > 0 && media.getDuration() > (long)this.config.videoMaxSecond) {
                isEnterNext = false;
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
            }
        }
        return isEnterNext;
    }

    private void singleCropHandleResult(Intent data) {
        if (data == null) {
            return;
        }
        Uri resultUri = UCrop.getOutput((Intent)data);
        if (resultUri == null) {
            return;
        }
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
        String cutPath = resultUri.getPath();
        if (this.mAdapter != null) {
            List<LocalMedia> mediaList;
            LocalMedia media;
            ArrayList list = data.getParcelableArrayListExtra("selectList");
            if (list != null) {
                this.mAdapter.bindSelectImages(list);
                this.mAdapter.notifyDataSetChanged();
            }
            LocalMedia localMedia = media = (mediaList = this.mAdapter.getSelectedImages()) != null && mediaList.size() > 0 ? mediaList.get(0) : null;
            if (media != null) {
                this.config.originalPath = media.getPath();
                media.setCutPath(cutPath);
                media.setChooseModel(this.config.chooseMode);
                if (TextUtils.isEmpty((CharSequence)cutPath)) {
                    if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(media.getPath())) {
                        String path = PictureFileUtils.getPath((Context)this, Uri.parse((String)media.getPath()));
                        media.setSize(!TextUtils.isEmpty((CharSequence)path) ? new File(path).length() : 0L);
                    } else {
                        media.setSize(new File(media.getPath()).length());
                    }
                    media.setCut(false);
                } else {
                    media.setSize(new File(cutPath).length());
                    media.setAndroidQToPath(cutPath);
                    media.setCut(true);
                }
                result.add(media);
                this.handlerResult(result);
            } else {
                LocalMedia localMedia2 = media = list != null && list.size() > 0 ? (LocalMedia)list.get(0) : null;
                if (media != null) {
                    this.config.originalPath = media.getPath();
                    media.setCutPath(cutPath);
                    media.setChooseModel(this.config.chooseMode);
                    media.setSize(new File(TextUtils.isEmpty((CharSequence)cutPath) ? media.getPath() : cutPath).length());
                    if (TextUtils.isEmpty((CharSequence)cutPath)) {
                        if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(media.getPath())) {
                            String path = PictureFileUtils.getPath((Context)this, Uri.parse((String)media.getPath()));
                            media.setSize(!TextUtils.isEmpty((CharSequence)path) ? new File(path).length() : 0L);
                        } else {
                            media.setSize(new File(media.getPath()).length());
                        }
                        media.setCut(false);
                    } else {
                        media.setSize(new File(cutPath).length());
                        media.setAndroidQToPath(cutPath);
                        media.setCut(true);
                    }
                    result.add(media);
                    this.handlerResult(result);
                }
            }
        }
    }

    protected void multiCropHandleResult(Intent data) {
        int oldSize;
        if (data == null) {
            return;
        }
        List mCuts = UCrop.getMultipleOutput((Intent)data);
        if (mCuts == null || mCuts.size() == 0) {
            return;
        }
        int size = mCuts.size();
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        ArrayList list = data.getParcelableArrayListExtra("selectList");
        if (list != null) {
            this.mAdapter.bindSelectImages(list);
            this.mAdapter.notifyDataSetChanged();
        }
        int n = oldSize = this.mAdapter != null ? this.mAdapter.getSelectedImages().size() : 0;
        if (oldSize == size) {
            List<LocalMedia> result = this.mAdapter.getSelectedImages();
            for (int i = 0; i < size; ++i) {
                CutInfo c = (CutInfo)mCuts.get(i);
                LocalMedia media = result.get(i);
                media.setCut(!TextUtils.isEmpty((CharSequence)c.getCutPath()));
                media.setPath(c.getPath());
                media.setMimeType(c.getMimeType());
                media.setCutPath(c.getCutPath());
                media.setWidth(c.getImageWidth());
                media.setHeight(c.getImageHeight());
                media.setAndroidQToPath(isAndroidQ ? c.getCutPath() : media.getAndroidQToPath());
                media.setSize(!TextUtils.isEmpty((CharSequence)c.getCutPath()) ? new File(c.getCutPath()).length() : media.getSize());
            }
            this.handlerResult(result);
        } else {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            for (int i = 0; i < size; ++i) {
                CutInfo c = (CutInfo)mCuts.get(i);
                LocalMedia media = new LocalMedia();
                media.setId(c.getId());
                media.setCut(!TextUtils.isEmpty((CharSequence)c.getCutPath()));
                media.setPath(c.getPath());
                media.setCutPath(c.getCutPath());
                media.setMimeType(c.getMimeType());
                media.setWidth(c.getImageWidth());
                media.setHeight(c.getImageHeight());
                media.setDuration(c.getDuration());
                media.setChooseModel(this.config.chooseMode);
                media.setAndroidQToPath(isAndroidQ ? c.getCutPath() : c.getAndroidQToPath());
                if (!TextUtils.isEmpty((CharSequence)c.getCutPath())) {
                    media.setSize(new File(c.getCutPath()).length());
                } else if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isContent(c.getPath())) {
                    String path = PictureFileUtils.getPath((Context)this, Uri.parse((String)c.getPath()));
                    media.setSize(!TextUtils.isEmpty((CharSequence)path) ? new File(path).length() : 0L);
                } else {
                    media.setSize(new File(c.getPath()).length());
                }
                result.add(media);
            }
            this.handlerResult(result);
        }
    }

    private void singleRadioMediaImage() {
        List<LocalMedia> selectImages = this.mAdapter.getSelectedImages();
        if (selectImages != null && selectImages.size() > 0) {
            LocalMedia media = selectImages.get(0);
            int position = media.getPosition();
            selectImages.clear();
            this.mAdapter.notifyItemChanged(position);
        }
    }

    private void manualSaveFolder(LocalMedia media) {
        try {
            LocalMediaFolder cameraFolder;
            this.createNewFolder(this.foldersList);
            LocalMediaFolder folder = this.getImageFolder(media.getPath(), this.foldersList);
            LocalMediaFolder localMediaFolder = cameraFolder = this.foldersList.size() > 0 ? this.foldersList.get(0) : null;
            if (cameraFolder != null && folder != null) {
                media.setParentFolderName(folder.getName());
                cameraFolder.setFirstImagePath(media.getPath());
                cameraFolder.setImages(this.images);
                cameraFolder.setImageNum(cameraFolder.getImageNum() + 1);
                int num = folder.getImageNum() + 1;
                folder.setImageNum(num);
                folder.getImages().add(0, media);
                folder.setFirstImagePath(this.config.cameraPath);
                this.folderWindow.bindFolder(this.foldersList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateMediaFolder(List<LocalMediaFolder> imageFolders, LocalMedia media) {
        File imageFile = new File(PictureMimeType.isContent(media.getPath()) ? Objects.requireNonNull(PictureFileUtils.getPath(this.getContext(), Uri.parse((String)media.getPath()))) : media.getPath());
        File folderFile = imageFile.getParentFile();
        if (folderFile == null) {
            return;
        }
        int size = imageFolders.size();
        for (int i = 0; i < size; ++i) {
            LocalMediaFolder folder = imageFolders.get(i);
            String name = folder.getName();
            if (TextUtils.isEmpty((CharSequence)name) || !name.equals(folderFile.getName())) continue;
            folder.setFirstImagePath(this.config.cameraPath);
            folder.setImageNum(folder.getImageNum() + 1);
            folder.setCheckedNum(1);
            folder.getImages().add(0, media);
            break;
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.config != null && PictureSelectionConfig.listener != null) {
            PictureSelectionConfig.listener.onCancel();
        }
        this.closeActivity();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        if (this.mediaPlayer != null && this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    @Override
    public void onItemClick(View view, int position) {
        switch (position) {
            case 0: {
                if (PictureSelectionConfig.onPictureSelectorInterfaceListener != null) {
                    PictureSelectionConfig.onPictureSelectorInterfaceListener.onCameraClick(this.getContext(), this.config, 1);
                    this.config.cameraMimeType = PictureMimeType.ofImage();
                    break;
                }
                this.startOpenCamera();
                break;
            }
            case 1: {
                if (PictureSelectionConfig.onPictureSelectorInterfaceListener != null) {
                    PictureSelectionConfig.onPictureSelectorInterfaceListener.onCameraClick(this.getContext(), this.config, 2);
                    this.config.cameraMimeType = PictureMimeType.ofVideo();
                    break;
                }
                this.startOpenCameraVideo();
                break;
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.readLocalMedia();
                    break;
                }
                this.showPermissionsDialog(false, this.getString(R.string.picture_jurisdiction));
                break;
            }
            case 2: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                this.showPermissionsDialog(true, this.getString(R.string.picture_camera));
                break;
            }
            case 5: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.startCamera();
                    break;
                }
                this.showPermissionsDialog(false, this.getString(R.string.picture_jurisdiction));
                break;
            }
            case 4: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.startCustomCamera();
                    break;
                }
                this.showPermissionsDialog(false, this.getString(R.string.picture_audio));
            }
        }
    }

    @Override
    protected void showPermissionsDialog(boolean isCamera, String errorMsg) {
        if (this.isFinishing()) {
            return;
        }
        PictureCustomDialog dialog = new PictureCustomDialog(this.getContext(), R.layout.picture_wind_base_dialog);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
        Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
        btn_commit.setText((CharSequence)this.getString(R.string.picture_go_setting));
        TextView tv_title = (TextView)dialog.findViewById(R.id.tv_title);
        TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
        tv_title.setText((CharSequence)this.getString(R.string.picture_prompt));
        tv_content.setText((CharSequence)errorMsg);
        btn_cancel.setOnClickListener(v -> {
            if (!this.isFinishing()) {
                dialog.dismiss();
            }
            if (!isCamera) {
                this.closeActivity();
            }
        });
        btn_commit.setOnClickListener(v -> {
            if (!this.isFinishing()) {
                dialog.dismiss();
            }
            PermissionChecker.launchAppDetailsSettings(this.getContext());
            this.isEnterSetting = true;
        });
        dialog.show();
    }

    public class audioOnClick
    implements View.OnClickListener {
        private String path;

        public audioOnClick(String path) {
            this.path = path;
        }

        public void onClick(View v) {
            int id2 = v.getId();
            if (id2 == R.id.tv_PlayPause) {
                PictureSelectorActivity.this.playAudio();
            }
            if (id2 == R.id.tv_Stop) {
                PictureSelectorActivity.this.mTvMusicStatus.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_stop_audio));
                PictureSelectorActivity.this.mTvPlayPause.setText((CharSequence)PictureSelectorActivity.this.getString(R.string.picture_play_audio));
                PictureSelectorActivity.this.stop(this.path);
            }
            if (id2 == R.id.tv_Quit && PictureSelectorActivity.this.mHandler != null) {
                PictureSelectorActivity.this.mHandler.postDelayed(() -> PictureSelectorActivity.this.stop(this.path), 30L);
                try {
                    if (PictureSelectorActivity.this.audioDialog != null && PictureSelectorActivity.this.audioDialog.isShowing()) {
                        PictureSelectorActivity.this.audioDialog.dismiss();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PictureSelectorActivity.this.mHandler.removeCallbacks(PictureSelectorActivity.this.mRunnable);
            }
        }
    }
}

