/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.ViewPager;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.PictureSelectorPreviewWeChatStyleActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureSimpleFragmentAdapter;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.observable.ImagesObservable;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.luck.picture.lib.tools.VoiceUtils;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.model.CutInfo;
import java.util.ArrayList;
import java.util.List;

public class PicturePreviewActivity
extends PictureBaseActivity
implements View.OnClickListener,
PictureSimpleFragmentAdapter.OnCallBackActivity {
    protected ImageView picture_left_back;
    protected TextView tv_img_num;
    protected TextView tv_title;
    protected TextView mTvPictureOk;
    protected PreviewViewPager viewPager;
    protected int position;
    protected boolean is_bottom_preview;
    protected List<LocalMedia> images = new ArrayList<LocalMedia>();
    protected List<LocalMedia> selectImages = new ArrayList<LocalMedia>();
    protected PictureSimpleFragmentAdapter adapter;
    protected Animation animation;
    protected TextView check;
    protected View btnCheck;
    protected boolean refresh;
    protected int index;
    protected int screenWidth;
    protected Handler mHandler;
    protected RelativeLayout selectBarLayout;
    protected CheckBox mCbOriginal;
    protected View titleViewBg;
    protected boolean isShowCamera;
    protected String currentDirectory;
    protected boolean isCompleteOrSelected;
    protected boolean isChangeSelectedData;

    @Override
    public int getResourceId() {
        return R.layout.picture_preview;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.selectImages = PictureSelector.obtainSelectorList(savedInstanceState);
            this.isCompleteOrSelected = savedInstanceState.getBoolean("isCompleteOrSelected", false);
            this.isChangeSelectedData = savedInstanceState.getBoolean("isChangeSelectedData", false);
            this.onImageChecked(this.position);
            this.onSelectNumChange(false);
        }
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.mHandler = new Handler();
        this.titleViewBg = this.findViewById(R.id.titleViewBg);
        this.screenWidth = ScreenUtils.getScreenWidth((Context)this);
        this.animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.picture_anim_modal_in);
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.btnCheck = this.findViewById(R.id.btnCheck);
        this.check = (TextView)this.findViewById(R.id.check);
        this.picture_left_back.setOnClickListener((View.OnClickListener)this);
        this.mTvPictureOk = (TextView)this.findViewById(R.id.tv_ok);
        this.mCbOriginal = (CheckBox)this.findViewById(R.id.cb_original);
        this.tv_img_num = (TextView)this.findViewById(R.id.tv_img_num);
        this.selectBarLayout = (RelativeLayout)this.findViewById(R.id.select_bar_layout);
        this.mTvPictureOk.setOnClickListener((View.OnClickListener)this);
        this.tv_img_num.setOnClickListener((View.OnClickListener)this);
        this.tv_title = (TextView)this.findViewById(R.id.picture_title);
        this.position = this.getIntent().getIntExtra("position", 0);
        if (this.numComplete) {
            this.initCompleteText(0);
        }
        this.tv_img_num.setSelected(this.config.checkNumMode);
        this.btnCheck.setOnClickListener((View.OnClickListener)this);
        this.selectImages = this.getIntent().getParcelableArrayListExtra("selectList");
        this.is_bottom_preview = this.getIntent().getBooleanExtra("bottom_preview", false);
        this.isShowCamera = this.getIntent().getBooleanExtra("isShowCamera", this.config.isCamera);
        this.currentDirectory = this.getIntent().getStringExtra("currentDirectory");
        this.images = this.is_bottom_preview ? this.getIntent().getParcelableArrayListExtra("previewSelectList") : ImagesObservable.getInstance().readPreviewMediaData();
        this.initViewPageAdapterData();
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (!(PicturePreviewActivity.this.getContext() instanceof PictureSelectorPreviewWeChatStyleActivity)) {
                    PicturePreviewActivity.this.isPreviewEggs(PicturePreviewActivity.this.config.previewEggs, position, positionOffsetPixels);
                }
            }

            public void onPageSelected(int i) {
                PicturePreviewActivity.this.position = i;
                PicturePreviewActivity.this.tv_title.setText((CharSequence)PicturePreviewActivity.this.getString(R.string.picture_preview_image_num, new Object[]{PicturePreviewActivity.this.position + 1, PicturePreviewActivity.this.images.size()}));
                LocalMedia media = PicturePreviewActivity.this.images.get(PicturePreviewActivity.this.position);
                PicturePreviewActivity.this.index = media.getPosition();
                if (!PicturePreviewActivity.this.config.previewEggs) {
                    if (PicturePreviewActivity.this.config.checkNumMode) {
                        PicturePreviewActivity.this.check.setText((CharSequence)ValueOf.toString(media.getNum()));
                        PicturePreviewActivity.this.notifyCheckChanged(media);
                    }
                    PicturePreviewActivity.this.onImageChecked(PicturePreviewActivity.this.position);
                }
                if (PicturePreviewActivity.this.config.isOriginalControl) {
                    boolean eqVideo = PictureMimeType.eqVideo(media.getMimeType());
                    PicturePreviewActivity.this.mCbOriginal.setVisibility(eqVideo ? 8 : 0);
                    PicturePreviewActivity.this.mCbOriginal.setChecked(PicturePreviewActivity.this.config.isCheckOriginalImage);
                }
                PicturePreviewActivity.this.onPageSelectedChange(media);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        if (this.config.isOriginalControl) {
            boolean isCheckOriginal = this.getIntent().getBooleanExtra("isOriginal", this.config.isCheckOriginalImage);
            this.mCbOriginal.setVisibility(0);
            this.config.isCheckOriginalImage = isCheckOriginal;
            this.mCbOriginal.setChecked(this.config.isCheckOriginalImage);
            this.mCbOriginal.setOnCheckedChangeListener((buttonView, isChecked) -> {
                this.config.isCheckOriginalImage = isChecked;
            });
        }
    }

    @Override
    protected void initCompleteText(int startCount) {
        boolean isNotEmptyStyle;
        boolean bl = isNotEmptyStyle = this.config.style != null;
        if (this.config.selectionMode == 1) {
            if (startCount <= 0) {
                this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_please_select)));
            } else {
                boolean isCompleteReplaceNum;
                boolean bl2 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
                if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)String.format(this.config.style.pictureCompleteText, startCount, 1));
                } else {
                    this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText) ? this.config.style.pictureCompleteText : this.getString(R.string.picture_done)));
                }
            }
        } else {
            boolean isCompleteReplaceNum;
            boolean bl3 = isCompleteReplaceNum = isNotEmptyStyle && this.config.style.isCompleteReplaceNum;
            if (startCount <= 0) {
                this.mTvPictureOk.setText((CharSequence)(isNotEmptyStyle && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText) ? this.config.style.pictureUnCompleteText : this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxVideoSelectNum + this.config.maxSelectNum})));
            } else if (isCompleteReplaceNum && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                this.mTvPictureOk.setText((CharSequence)String.format(this.config.style.pictureCompleteText, startCount, this.config.maxVideoSelectNum + this.config.maxSelectNum));
            } else {
                this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_done_front_num, new Object[]{startCount, this.config.maxVideoSelectNum + this.config.maxSelectNum}));
            }
        }
    }

    protected void onPageSelectedChange(LocalMedia media) {
    }

    @Override
    public void initPictureSelectorStyle() {
        if (this.config.style != null) {
            if (this.config.style.pictureTitleTextColor != 0) {
                this.tv_title.setTextColor(this.config.style.pictureTitleTextColor);
            }
            if (this.config.style.pictureTitleTextSize != 0) {
                this.tv_title.setTextSize((float)this.config.style.pictureTitleTextSize);
            }
            if (this.config.style.pictureLeftBackIcon != 0) {
                this.picture_left_back.setImageResource(this.config.style.pictureLeftBackIcon);
            }
            if (this.config.style.picturePreviewBottomBgColor != 0) {
                this.selectBarLayout.setBackgroundColor(this.config.style.picturePreviewBottomBgColor);
            }
            if (this.config.style.pictureCheckNumBgStyle != 0) {
                this.tv_img_num.setBackgroundResource(this.config.style.pictureCheckNumBgStyle);
            }
            if (this.config.style.pictureCheckedStyle != 0) {
                this.check.setBackgroundResource(this.config.style.pictureCheckedStyle);
            }
            if (this.config.style.pictureUnCompleteTextColor != 0) {
                this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
            }
            if (!TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText)) {
                this.mTvPictureOk.setText((CharSequence)this.config.style.pictureUnCompleteText);
            }
        }
        this.titleViewBg.setBackgroundColor(this.colorPrimary);
        if (this.config.isOriginalControl) {
            if (this.config.style != null) {
                if (this.config.style.pictureOriginalControlStyle != 0) {
                    this.mCbOriginal.setButtonDrawable(this.config.style.pictureOriginalControlStyle);
                } else {
                    this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                }
                if (this.config.style.pictureOriginalFontColor != 0) {
                    this.mCbOriginal.setTextColor(this.config.style.pictureOriginalFontColor);
                } else {
                    this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
                }
                if (this.config.style.pictureOriginalTextSize != 0) {
                    this.mCbOriginal.setTextSize((float)this.config.style.pictureOriginalTextSize);
                }
            } else {
                this.mCbOriginal.setButtonDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.picture_original_checkbox));
                this.mCbOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.picture_color_53575e));
            }
        }
        this.onSelectNumChange(false);
    }

    private void isPreviewEggs(boolean previewEggs, int position, int positionOffsetPixels) {
        if (previewEggs && this.images.size() > 0) {
            if (positionOffsetPixels < this.screenWidth / 2) {
                LocalMedia media = this.images.get(position);
                this.check.setSelected(this.isSelected(media));
                if (this.config.checkNumMode) {
                    int num = media.getNum();
                    this.check.setText((CharSequence)ValueOf.toString(num));
                    this.notifyCheckChanged(media);
                    this.onImageChecked(position);
                }
            } else {
                LocalMedia media = this.images.get(position + 1);
                this.check.setSelected(this.isSelected(media));
                if (this.config.checkNumMode) {
                    int num = media.getNum();
                    this.check.setText((CharSequence)ValueOf.toString(num));
                    this.notifyCheckChanged(media);
                    this.onImageChecked(position + 1);
                }
            }
        }
    }

    private void initViewPageAdapterData() {
        this.tv_title.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.images.size()}));
        this.adapter = new PictureSimpleFragmentAdapter(this.config, this.images, this);
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.onImageChecked(this.position);
        if (this.images.size() > 0) {
            LocalMedia media = this.images.get(this.position);
            this.index = media.getPosition();
            if (this.config.checkNumMode) {
                this.tv_img_num.setSelected(true);
                this.check.setText((CharSequence)ValueOf.toString(media.getNum()));
                this.notifyCheckChanged(media);
            }
        }
    }

    private void notifyCheckChanged(LocalMedia imageBean) {
        if (this.config.checkNumMode) {
            this.check.setText((CharSequence)"");
            int size = this.selectImages.size();
            for (int i = 0; i < size; ++i) {
                LocalMedia media = this.selectImages.get(i);
                if (!media.getPath().equals(imageBean.getPath()) && media.getId() != imageBean.getId()) continue;
                imageBean.setNum(media.getNum());
                this.check.setText((CharSequence)String.valueOf(imageBean.getNum()));
            }
        }
    }

    private void subSelectPosition() {
        int len = this.selectImages.size();
        for (int index = 0; index < len; ++index) {
            LocalMedia media = this.selectImages.get(index);
            media.setNum(index + 1);
        }
    }

    public void onImageChecked(int position) {
        if (this.images != null && this.images.size() > 0) {
            LocalMedia media = this.images.get(position);
            this.check.setSelected(this.isSelected(media));
        } else {
            this.check.setSelected(false);
        }
    }

    protected boolean isSelected(LocalMedia image) {
        int size = this.selectImages.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = this.selectImages.get(i);
            if (!media.getPath().equals(image.getPath()) && media.getId() != image.getId()) continue;
            return true;
        }
        return false;
    }

    protected void onSelectNumChange(boolean isRefresh) {
        boolean enable;
        this.refresh = isRefresh;
        boolean bl = enable = this.selectImages.size() != 0;
        if (enable) {
            this.mTvPictureOk.setEnabled(true);
            this.mTvPictureOk.setSelected(true);
            if (this.config.style != null) {
                if (this.config.style.pictureCompleteTextColor != 0) {
                    this.mTvPictureOk.setTextColor(this.config.style.pictureCompleteTextColor);
                } else {
                    this.mTvPictureOk.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_fa632d));
                }
            }
            if (this.numComplete) {
                this.initCompleteText(this.selectImages.size());
            } else {
                if (this.refresh) {
                    this.tv_img_num.startAnimation(this.animation);
                }
                this.tv_img_num.setVisibility(0);
                this.tv_img_num.setText((CharSequence)String.valueOf(this.selectImages.size()));
                if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)this.config.style.pictureCompleteText);
                } else {
                    this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_completed));
                }
            }
        } else {
            this.mTvPictureOk.setEnabled(false);
            this.mTvPictureOk.setSelected(false);
            if (this.config.style != null) {
                if (this.config.style.pictureUnCompleteTextColor != 0) {
                    this.mTvPictureOk.setTextColor(this.config.style.pictureUnCompleteTextColor);
                } else {
                    this.mTvPictureOk.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_9b));
                }
            }
            if (this.numComplete) {
                this.initCompleteText(0);
            } else {
                this.tv_img_num.setVisibility(4);
                if (this.config.style != null && !TextUtils.isEmpty((CharSequence)this.config.style.pictureUnCompleteText)) {
                    this.mTvPictureOk.setText((CharSequence)this.config.style.pictureUnCompleteText);
                } else {
                    this.mTvPictureOk.setText((CharSequence)this.getString(R.string.picture_please_select));
                }
            }
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.picture_left_back) {
            this.onBackPressed();
        } else if (id2 == R.id.tv_ok || id2 == R.id.tv_img_num) {
            this.onComplete();
        } else if (id2 == R.id.btnCheck) {
            this.onCheckedComplete();
        }
    }

    protected void onCheckedComplete() {
        block25: {
            block27: {
                LocalMedia media;
                int i;
                LocalMedia image;
                block26: {
                    boolean isChecked;
                    if (this.images == null || this.images.size() <= 0) break block25;
                    image = this.images.get(this.viewPager.getCurrentItem());
                    String mimeType = this.selectImages.size() > 0 ? this.selectImages.get(0).getMimeType() : "";
                    int currentSize = this.selectImages.size();
                    if (this.config.isWithVideoImage) {
                        int videoSize = 0;
                        int imageSize = 0;
                        for (i = 0; i < currentSize; ++i) {
                            media = this.selectImages.get(i);
                            if (PictureMimeType.eqVideo(media.getMimeType())) {
                                ++videoSize;
                                continue;
                            }
                            ++imageSize;
                        }
                        if (PictureMimeType.eqVideo(image.getMimeType())) {
                            if (this.config.maxVideoSelectNum <= 0) {
                                ToastUtils.s(this.getContext(), this.getString(R.string.picture_rule));
                                return;
                            }
                            if (videoSize >= this.config.maxVideoSelectNum && !this.check.isSelected()) {
                                ToastUtils.s(this.getContext(), StringUtils.getMsg(this.getContext(), image.getMimeType(), this.config.maxVideoSelectNum));
                                return;
                            }
                            if (!this.check.isSelected() && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                                ToastUtils.s(this.getContext(), this.getContext().getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                                return;
                            }
                            if (!this.check.isSelected() && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                                ToastUtils.s(this.getContext(), this.getContext().getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                                return;
                            }
                        }
                        if (PictureMimeType.eqImage(image.getMimeType()) && imageSize >= this.config.maxSelectNum && !this.check.isSelected()) {
                            ToastUtils.s(this.getContext(), StringUtils.getMsg(this.getContext(), image.getMimeType(), this.config.maxSelectNum));
                            return;
                        }
                    } else {
                        boolean mimeTypeSame;
                        if (!TextUtils.isEmpty((CharSequence)mimeType) && !(mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, image.getMimeType()))) {
                            ToastUtils.s(this.getContext(), this.getString(R.string.picture_rule));
                            return;
                        }
                        if (PictureMimeType.eqVideo(mimeType) && this.config.maxVideoSelectNum > 0) {
                            if (currentSize >= this.config.maxVideoSelectNum && !this.check.isSelected()) {
                                ToastUtils.s(this.getContext(), StringUtils.getMsg(this.getContext(), mimeType, this.config.maxVideoSelectNum));
                                return;
                            }
                            if (!this.check.isSelected() && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                                ToastUtils.s(this.getContext(), this.getContext().getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                                return;
                            }
                            if (!this.check.isSelected() && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                                ToastUtils.s(this.getContext(), this.getContext().getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                                return;
                            }
                        } else {
                            if (currentSize >= this.config.maxSelectNum && !this.check.isSelected()) {
                                ToastUtils.s(this.getContext(), StringUtils.getMsg(this.getContext(), mimeType, this.config.maxSelectNum));
                                return;
                            }
                            if (PictureMimeType.eqVideo(image.getMimeType())) {
                                if (!this.check.isSelected() && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                                    ToastUtils.s(this.getContext(), this.getContext().getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                                    return;
                                }
                                if (!this.check.isSelected() && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                                    ToastUtils.s(this.getContext(), this.getContext().getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                                    return;
                                }
                            }
                        }
                    }
                    if (!this.check.isSelected()) {
                        isChecked = true;
                        this.check.setSelected(true);
                        this.check.startAnimation(this.animation);
                    } else {
                        isChecked = false;
                        this.check.setSelected(false);
                    }
                    this.isChangeSelectedData = true;
                    if (!isChecked) break block26;
                    VoiceUtils.getInstance().play();
                    if (this.config.selectionMode == 1) {
                        this.selectImages.clear();
                    }
                    if (!TextUtils.isEmpty((CharSequence)image.getRealPath()) && PictureMimeType.isContent(image.getPath())) {
                        image.setRealPath(PictureFileUtils.getPath(this.getContext(), Uri.parse((String)image.getPath())));
                    }
                    this.selectImages.add(image);
                    this.onSelectedChange(true, image);
                    image.setNum(this.selectImages.size());
                    if (!this.config.checkNumMode) break block27;
                    this.check.setText((CharSequence)String.valueOf(image.getNum()));
                    break block27;
                }
                int size = this.selectImages.size();
                for (i = 0; i < size; ++i) {
                    media = this.selectImages.get(i);
                    if (!media.getPath().equals(image.getPath()) && media.getId() != image.getId()) continue;
                    this.selectImages.remove(media);
                    this.onSelectedChange(false, image);
                    this.subSelectPosition();
                    this.notifyCheckChanged(media);
                    break;
                }
            }
            this.onSelectNumChange(true);
        }
    }

    protected void onSelectedChange(boolean isAddRemove, LocalMedia media) {
    }

    protected void onComplete() {
        String mimeType;
        int size = this.selectImages.size();
        LocalMedia image = this.selectImages.size() > 0 ? this.selectImages.get(0) : null;
        String string2 = mimeType = image != null ? image.getMimeType() : "";
        if (this.config.isWithVideoImage) {
            int videoSize = 0;
            int imageSize = 0;
            int currentSize = this.selectImages.size();
            for (int i = 0; i < currentSize; ++i) {
                LocalMedia media = this.selectImages.get(i);
                if (PictureMimeType.eqVideo(media.getMimeType())) {
                    ++videoSize;
                    continue;
                }
                ++imageSize;
            }
            if (this.config.selectionMode == 2) {
                if (this.config.minSelectNum > 0 && imageSize < this.config.minSelectNum) {
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum}));
                    return;
                }
                if (this.config.minVideoSelectNum > 0 && videoSize < this.config.minVideoSelectNum) {
                    ToastUtils.s(this.getContext(), this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum}));
                    return;
                }
            }
        } else if (this.config.selectionMode == 2) {
            if (PictureMimeType.eqImage(mimeType) && this.config.minSelectNum > 0 && size < this.config.minSelectNum) {
                String str = this.getString(R.string.picture_min_img_num, new Object[]{this.config.minSelectNum});
                ToastUtils.s(this.getContext(), str);
                return;
            }
            if (PictureMimeType.eqVideo(mimeType) && this.config.minVideoSelectNum > 0 && size < this.config.minVideoSelectNum) {
                String str = this.getString(R.string.picture_min_video_num, new Object[]{this.config.minVideoSelectNum});
                ToastUtils.s(this.getContext(), str);
                return;
            }
        }
        this.isCompleteOrSelected = true;
        this.isChangeSelectedData = true;
        if (this.config.isCheckOriginalImage) {
            this.onBackPressed();
            return;
        }
        if (this.config.chooseMode == PictureMimeType.ofAll() && this.config.isWithVideoImage) {
            this.bothMimeTypeWith(mimeType, image);
        } else {
            this.separateMimeTypeWith(mimeType, image);
        }
    }

    private void bothMimeTypeWith(String mimeType, LocalMedia image) {
        if (this.config.enableCrop) {
            this.isCompleteOrSelected = false;
            boolean eqImage = PictureMimeType.eqImage(mimeType);
            if (this.config.selectionMode == 1 && eqImage) {
                this.config.originalPath = image.getPath();
                this.startCrop(this.config.originalPath, image.getMimeType());
            } else {
                ArrayList<CutInfo> cuts = new ArrayList<CutInfo>();
                int count = this.selectImages.size();
                int imageNum = 0;
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = this.selectImages.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    if (PictureMimeType.eqImage(media.getMimeType())) {
                        ++imageNum;
                    }
                    CutInfo cutInfo = new CutInfo();
                    cutInfo.setId(media.getId());
                    cutInfo.setPath(media.getPath());
                    cutInfo.setImageWidth(media.getWidth());
                    cutInfo.setImageHeight(media.getHeight());
                    cutInfo.setMimeType(media.getMimeType());
                    cutInfo.setAndroidQToPath(media.getAndroidQToPath());
                    cutInfo.setId(media.getId());
                    cutInfo.setDuration(media.getDuration());
                    cutInfo.setRealPath(media.getRealPath());
                    cuts.add(cutInfo);
                }
                if (imageNum <= 0) {
                    this.isCompleteOrSelected = true;
                    this.onBackPressed();
                } else {
                    this.startCrop(cuts);
                }
            }
        } else {
            this.onBackPressed();
        }
    }

    private void separateMimeTypeWith(String mimeType, LocalMedia image) {
        if (this.config.enableCrop && PictureMimeType.eqImage(mimeType)) {
            this.isCompleteOrSelected = false;
            if (this.config.selectionMode == 1) {
                this.config.originalPath = image.getPath();
                this.startCrop(this.config.originalPath, image.getMimeType());
            } else {
                ArrayList<CutInfo> cuts = new ArrayList<CutInfo>();
                int count = this.selectImages.size();
                for (int i = 0; i < count; ++i) {
                    LocalMedia media = this.selectImages.get(i);
                    if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                    CutInfo cutInfo = new CutInfo();
                    cutInfo.setId(media.getId());
                    cutInfo.setPath(media.getPath());
                    cutInfo.setImageWidth(media.getWidth());
                    cutInfo.setImageHeight(media.getHeight());
                    cutInfo.setMimeType(media.getMimeType());
                    cutInfo.setAndroidQToPath(media.getAndroidQToPath());
                    cutInfo.setId(media.getId());
                    cutInfo.setDuration(media.getDuration());
                    cutInfo.setRealPath(media.getRealPath());
                    cuts.add(cutInfo);
                }
                this.startCrop(cuts);
            }
        } else {
            this.onBackPressed();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 609: {
                    List list = UCrop.getMultipleOutput((Intent)data);
                    data.putParcelableArrayListExtra("com.yalantis.ucrop.OutputUriList", (ArrayList)list);
                    data.putParcelableArrayListExtra("selectList", (ArrayList)this.selectImages);
                    this.setResult(-1, data);
                    this.finish();
                    break;
                }
                case 69: {
                    if (data != null) {
                        data.putParcelableArrayListExtra("selectList", (ArrayList)this.selectImages);
                        this.setResult(-1, data);
                    }
                    this.finish();
                }
            }
        } else if (resultCode == 96) {
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            ToastUtils.s(this.getContext(), throwable.getMessage());
        }
    }

    public void onBackPressed() {
        this.updateResult();
        if (this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewExitAnimation != 0) {
            this.finish();
            this.overridePendingTransition(0, this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityPreviewExitAnimation != 0 ? this.config.windowAnimationStyle.activityPreviewExitAnimation : R.anim.picture_anim_exit);
        } else {
            this.closeActivity();
        }
    }

    private void updateResult() {
        Intent intent = new Intent();
        if (this.isChangeSelectedData) {
            intent.putExtra("isCompleteOrSelected", this.isCompleteOrSelected);
            intent.putParcelableArrayListExtra("selectList", (ArrayList)this.selectImages);
        }
        if (this.config.isOriginalControl) {
            intent.putExtra("isOriginal", this.config.isCheckOriginalImage);
        }
        this.setResult(0, intent);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("isCompleteOrSelected", this.isCompleteOrSelected);
        outState.putBoolean("isChangeSelectedData", this.isChangeSelectedData);
        PictureSelector.saveSelectorList(outState, this.selectImages);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (!this.isOnSaveInstanceState) {
            ImagesObservable.getInstance().clearPreviewMediaData();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        if (this.adapter != null) {
            this.adapter.clear();
        }
    }

    @Override
    public void onActivityBackPressed() {
        this.onBackPressed();
    }
}

