/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraX;
import androidx.camera.view.CameraView;
import androidx.lifecycle.LifecycleOwner;
import com.luck.picture.lib.PictureSelectorCameraEmptyActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.camera.CustomCameraView;
import com.luck.picture.lib.camera.listener.CameraListener;
import com.luck.picture.lib.camera.view.CaptureLayout;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.ToastUtils;
import java.io.File;
import java.lang.ref.WeakReference;

public class PictureCustomCameraActivity
extends PictureSelectorCameraEmptyActivity {
    private CustomCameraView mCameraView;
    protected boolean isEnterSetting;

    @Override
    public boolean isImmersive() {
        return false;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        boolean isExternalStorage;
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().setFlags(0x4000000, 0x4000000);
        this.getWindow().setFlags(0x8000000, 0x8000000);
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = this.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            this.getWindow().setAttributes(lp);
        }
        this.getWindow().addFlags(128);
        super.onCreate(savedInstanceState);
        boolean bl = isExternalStorage = PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE");
        if (!isExternalStorage) {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
            return;
        }
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            boolean isRecordAudio = PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO");
            if (isRecordAudio) {
                this.createCameraView();
            } else {
                PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    private void createCameraView() {
        if (this.mCameraView == null) {
            this.mCameraView = new CustomCameraView(this.getContext());
            this.setContentView((View)this.mCameraView);
            this.initView();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isEnterSetting) {
            boolean isExternalStorage;
            boolean bl = isExternalStorage = PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE");
            if (isExternalStorage) {
                boolean isCameraPermissionChecker = PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA");
                if (isCameraPermissionChecker) {
                    boolean isRecordAudio = PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO");
                    if (isRecordAudio) {
                        this.createCameraView();
                    } else {
                        this.showPermissionsDialog(false, this.getString(R.string.picture_audio));
                    }
                } else {
                    this.showPermissionsDialog(false, this.getString(R.string.picture_camera));
                }
            } else {
                this.showPermissionsDialog(false, this.getString(R.string.picture_jurisdiction));
            }
            this.isEnterSetting = false;
        }
    }

    protected void initView() {
        CaptureLayout captureLayout;
        CameraView cameraView;
        this.mCameraView.setPictureSelectionConfig(this.config);
        this.mCameraView.setBindToLifecycle((LifecycleOwner)new WeakReference<PictureCustomCameraActivity>(this).get());
        if (this.config.recordVideoSecond > 0) {
            this.mCameraView.setRecordVideoMaxTime(this.config.recordVideoSecond);
        }
        if (this.config.recordVideoMinSecond > 0) {
            this.mCameraView.setRecordVideoMinTime(this.config.recordVideoMinSecond);
        }
        if ((cameraView = this.mCameraView.getCameraView()) != null && this.config.isCameraAroundState) {
            cameraView.toggleCamera();
        }
        if ((captureLayout = this.mCameraView.getCaptureLayout()) != null) {
            captureLayout.setButtonFeatures(this.config.buttonFeatures);
        }
        this.mCameraView.setImageCallbackListener((file, imageView) -> {
            if (this.config != null && PictureSelectionConfig.imageEngine != null && file != null) {
                PictureSelectionConfig.imageEngine.loadImage(this.getContext(), file.getAbsolutePath(), imageView);
            }
        });
        this.mCameraView.setCameraListener(new CameraListener(){

            @Override
            public void onPictureSuccess(@NonNull File file) {
                PictureCustomCameraActivity.this.config.cameraMimeType = PictureMimeType.ofImage();
                Intent intent = new Intent();
                intent.putExtra("mediaPath", file.getAbsolutePath());
                if (PictureCustomCameraActivity.this.config.camera) {
                    PictureCustomCameraActivity.this.requestCamera(intent);
                } else {
                    PictureCustomCameraActivity.this.setResult(-1, intent);
                    PictureCustomCameraActivity.this.onBackPressed();
                }
            }

            @Override
            public void onRecordSuccess(@NonNull File file) {
                PictureCustomCameraActivity.this.config.cameraMimeType = PictureMimeType.ofVideo();
                Intent intent = new Intent();
                intent.putExtra("mediaPath", file.getAbsolutePath());
                if (PictureCustomCameraActivity.this.config.camera) {
                    PictureCustomCameraActivity.this.requestCamera(intent);
                } else {
                    PictureCustomCameraActivity.this.setResult(-1, intent);
                    PictureCustomCameraActivity.this.onBackPressed();
                }
            }

            @Override
            public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                ToastUtils.s(PictureCustomCameraActivity.this.getContext(), message);
                PictureCustomCameraActivity.this.onBackPressed();
            }
        });
        this.mCameraView.setOnClickListener(() -> this.onBackPressed());
    }

    @Override
    public void onBackPressed() {
        this.closeActivity();
    }

    @Override
    @SuppressLint(value={"RestrictedApi"})
    protected void onDestroy() {
        if (this.mCameraView != null) {
            CameraX.unbindAll();
            this.mCameraView = null;
        }
        super.onDestroy();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
                    break;
                }
                this.showPermissionsDialog(true, this.getString(R.string.picture_jurisdiction));
                break;
            }
            case 2: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    boolean isRecordAudio = PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO");
                    if (isRecordAudio) {
                        this.createCameraView();
                        break;
                    }
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
                    break;
                }
                this.showPermissionsDialog(true, this.getString(R.string.picture_camera));
                break;
            }
            case 4: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.createCameraView();
                    break;
                }
                this.showPermissionsDialog(false, this.getString(R.string.picture_audio));
            }
        }
    }

    @Override
    protected void showPermissionsDialog(boolean isCamera, String errorMsg) {
        if (this.isFinishing()) {
            return;
        }
        PictureCustomDialog dialog = new PictureCustomDialog(this.getContext(), R.layout.picture_wind_base_dialog);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
        Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
        btn_commit.setText((CharSequence)this.getString(R.string.picture_go_setting));
        TextView tv_title = (TextView)dialog.findViewById(R.id.tv_title);
        TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
        tv_title.setText((CharSequence)this.getString(R.string.picture_prompt));
        tv_content.setText((CharSequence)errorMsg);
        btn_cancel.setOnClickListener(v -> {
            if (!this.isFinishing()) {
                dialog.dismiss();
            }
            this.closeActivity();
        });
        btn_commit.setOnClickListener(v -> {
            if (!this.isFinishing()) {
                dialog.dismiss();
            }
            PermissionChecker.launchAppDetailsSettings(this.getContext());
            this.isEnterSetting = true;
        });
        dialog.show();
    }
}

