/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.view.PreviewView;
import androidx.camera.view.TransformableSurfaceView;
import androidx.core.content.ContextCompat;

final class SurfaceViewImplementation
implements PreviewView.Implementation {
    private static final String TAG = "SurfaceViewPreviewView";
    TransformableSurfaceView mSurfaceView;
    final SurfaceRequestCallback mSurfaceRequestCallback = new SurfaceRequestCallback();
    private Preview.SurfaceProvider mSurfaceProvider = new Preview.SurfaceProvider(){

        public void onSurfaceRequested(@NonNull SurfaceRequest surfaceRequest) {
            SurfaceViewImplementation.this.mSurfaceView.post(() -> SurfaceViewImplementation.this.mSurfaceRequestCallback.setSurfaceRequest(surfaceRequest));
        }
    };

    SurfaceViewImplementation() {
    }

    @Override
    public void init(@NonNull FrameLayout parent) {
        this.mSurfaceView = new TransformableSurfaceView(parent.getContext());
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        parent.addView((View)this.mSurfaceView);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this.mSurfaceRequestCallback);
    }

    @Override
    @NonNull
    public Preview.SurfaceProvider getSurfaceProvider() {
        return this.mSurfaceProvider;
    }

    @Override
    public void onDisplayChanged() {
    }

    class SurfaceRequestCallback
    implements SurfaceHolder.Callback {
        @Nullable
        private Size mTargetSize;
        @Nullable
        private SurfaceRequest mSurfaceRequest;
        @Nullable
        private Size mCurrentSurfaceSize;

        SurfaceRequestCallback() {
        }

        @UiThread
        void setSurfaceRequest(@NonNull SurfaceRequest surfaceRequest) {
            Size targetSize;
            this.cancelPreviousRequest();
            this.mSurfaceRequest = surfaceRequest;
            this.mTargetSize = targetSize = surfaceRequest.getResolution();
            if (!this.tryToComplete()) {
                Log.d((String)SurfaceViewImplementation.TAG, (String)"Wait for new Surface creation.");
                if (Build.VERSION.SDK_INT >= 21) {
                    SurfaceViewImplementation.this.mSurfaceView.getHolder().setFixedSize(targetSize.getWidth(), targetSize.getHeight());
                }
            }
        }

        @UiThread
        private boolean tryToComplete() {
            Surface surface = SurfaceViewImplementation.this.mSurfaceView.getHolder().getSurface();
            if (this.mSurfaceRequest != null && this.mTargetSize != null && this.mTargetSize.equals((Object)this.mCurrentSurfaceSize)) {
                Log.d((String)SurfaceViewImplementation.TAG, (String)"Surface set on Preview.");
                this.mSurfaceRequest.provideSurface(surface, ContextCompat.getMainExecutor((Context)SurfaceViewImplementation.this.mSurfaceView.getContext()), result -> Log.d((String)SurfaceViewImplementation.TAG, (String)"Safe to release surface."));
                this.mSurfaceRequest = null;
                this.mTargetSize = null;
                return true;
            }
            return false;
        }

        @UiThread
        private void cancelPreviousRequest() {
            if (this.mSurfaceRequest != null) {
                Log.d((String)SurfaceViewImplementation.TAG, (String)("Request canceled: " + this.mSurfaceRequest));
                this.mSurfaceRequest.willNotProvideSurface();
                this.mSurfaceRequest = null;
            }
            this.mTargetSize = null;
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            Log.d((String)SurfaceViewImplementation.TAG, (String)"Surface created.");
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
            Log.d((String)SurfaceViewImplementation.TAG, (String)("Surface changed. Size: " + width + "x" + height));
            this.mCurrentSurfaceSize = new Size(width, height);
            this.tryToComplete();
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            Log.d((String)SurfaceViewImplementation.TAG, (String)"Surface destroyed.");
            this.mCurrentSurfaceSize = null;
            this.cancelPreviousRequest();
        }
    }
}

