/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraX;
import androidx.camera.view.CameraView;
import androidx.lifecycle.LifecycleOwner;
import com.luck.picture.lib.PictureSelectorCameraEmptyActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.camera.CustomCameraView;
import com.luck.picture.lib.camera.listener.CameraListener;
import com.luck.picture.lib.camera.view.CaptureLayout;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.tools.ToastUtils;
import java.io.File;
import java.lang.ref.WeakReference;

public class PictureCustomCameraActivity
extends PictureSelectorCameraEmptyActivity {
    private CustomCameraView mCameraView;

    @Override
    public boolean isImmersive() {
        return false;
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_custom_camera;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().setFlags(0x4000000, 0x4000000);
        this.getWindow().setFlags(0x8000000, 0x8000000);
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = this.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            this.getWindow().setAttributes(lp);
        }
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initWidgets() {
        CaptureLayout captureLayout;
        CameraView cameraView;
        super.initWidgets();
        this.mCameraView = (CustomCameraView)this.findViewById(R.id.camera_view);
        this.mCameraView.setPictureSelectionConfig(this.config);
        this.mCameraView.setBindToLifecycle((LifecycleOwner)new WeakReference<PictureCustomCameraActivity>(this).get());
        if (this.config.recordVideoSecond > 0) {
            this.mCameraView.setRecordVideoMaxTime(this.config.recordVideoSecond);
        }
        if (this.config.recordVideoMinSecond > 0) {
            this.mCameraView.setRecordVideoMinTime(this.config.recordVideoMinSecond);
        }
        if ((cameraView = this.mCameraView.getCameraView()) != null && this.config.isCameraAroundState) {
            cameraView.toggleCamera();
        }
        if ((captureLayout = this.mCameraView.getCaptureLayout()) != null) {
            captureLayout.setButtonFeatures(this.config.buttonFeatures);
        }
        this.mCameraView.setImageCallbackListener((file, imageView) -> {
            if (this.config != null) {
                if (PictureSelectionConfig.imageEngine != null && file != null) {
                    PictureSelectionConfig.imageEngine.loadImage(this.getContext(), file.getAbsolutePath(), imageView);
                }
            }
        });
        this.mCameraView.setCameraListener(new CameraListener(){

            @Override
            public void onPictureSuccess(@NonNull File file) {
                if (PictureCustomCameraActivity.this.config.camera) {
                    Intent intent = new Intent();
                    intent.putExtra("mediaPath", file.getAbsolutePath());
                    PictureCustomCameraActivity.this.requestCamera(intent);
                } else {
                    PictureCustomCameraActivity.this.setResult(-1);
                    PictureCustomCameraActivity.this.onBackPressed();
                }
            }

            @Override
            public void onRecordSuccess(@NonNull File file) {
                if (PictureCustomCameraActivity.this.config.camera) {
                    Intent intent = new Intent();
                    intent.putExtra("mediaPath", file.getAbsolutePath());
                    PictureCustomCameraActivity.this.requestCamera(intent);
                } else {
                    PictureCustomCameraActivity.this.setResult(-1);
                    PictureCustomCameraActivity.this.onBackPressed();
                }
            }

            @Override
            public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                ToastUtils.s(PictureCustomCameraActivity.this.getContext(), message);
                PictureCustomCameraActivity.this.onBackPressed();
            }
        });
        this.mCameraView.setOnClickListener(() -> this.onBackPressed());
    }

    @Override
    public void onBackPressed() {
        this.closeActivity();
    }

    @Override
    @SuppressLint(value={"RestrictedApi"})
    protected void onDestroy() {
        CameraX.unbindAll();
        super.onDestroy();
    }
}

