/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Matrix;
import android.util.Size;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.camera.view.SurfaceRotation;
import java.math.BigDecimal;

final class ScaleTypeTransform {
    static Matrix transformCenterCrop(@NonNull Size resolution, @NonNull View view, int displayRotation) {
        if (resolution.getWidth() == 0 || resolution.getHeight() == 0) {
            throw new IllegalArgumentException("Input resolution can not be zero sized");
        }
        if (view.getWidth() == 0 || view.getHeight() == 0) {
            throw new IllegalArgumentException("View resolution can not be zero sized");
        }
        Matrix matrix = new Matrix();
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        int displayRotationDegrees = SurfaceRotation.rotationDegreesFromSurfaceRotation(displayRotation);
        Size scaled = ScaleTypeTransform.calculateCenterCropDimension(resolution.getWidth(), resolution.getHeight(), viewWidth, viewHeight, displayRotationDegrees);
        int centerX = viewWidth / 2;
        int centerY = viewHeight / 2;
        matrix.postRotate((float)(-displayRotationDegrees), (float)centerX, (float)centerY);
        float xScale = (float)scaled.getWidth() / (float)viewWidth;
        float yScale = (float)scaled.getHeight() / (float)viewHeight;
        if (displayRotationDegrees == 90 || displayRotationDegrees == 270) {
            xScale = (float)scaled.getWidth() / (float)viewHeight;
            yScale = (float)scaled.getHeight() / (float)viewWidth;
        }
        xScale = new BigDecimal(xScale).setScale(2, 2).floatValue();
        yScale = new BigDecimal(yScale).setScale(2, 2).floatValue();
        matrix.postScale(xScale, yScale, (float)centerX, (float)centerY);
        return matrix;
    }

    private static Size calculateCenterCropDimension(int sourceWidth, int sourceHeight, int parentWidth, int parentHeight, int displayRotation) {
        int outHeight;
        int outWidth;
        float parentRatio;
        float vfRatio;
        int inWidth = sourceWidth;
        int inHeight = sourceHeight;
        if (displayRotation == 0 || displayRotation == 180) {
            inWidth = sourceHeight;
            inHeight = sourceWidth;
        }
        if ((vfRatio = (float)inWidth / (float)inHeight) < (parentRatio = (float)parentWidth / (float)parentHeight)) {
            outWidth = parentWidth;
            outHeight = Math.round((float)parentWidth / vfRatio);
        } else {
            outWidth = Math.round((float)parentHeight * vfRatio);
            outHeight = parentHeight;
        }
        return new Size(outWidth, outHeight);
    }

    private ScaleTypeTransform() {
    }
}

