/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.luck.picture.lib.PictureContextWrapper;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.PictureSelectorActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.compress.Luban;
import com.luck.picture.lib.compress.OnCompressListener;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureLoadingDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.immersive.ImmersiveManage;
import com.luck.picture.lib.immersive.NavBarUtils;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.AndroidQTransformUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.VoiceUtils;
import com.yalantis.ucrop.UCrop;
import com.yalantis.ucrop.model.CutInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class PictureBaseActivity
extends AppCompatActivity
implements Handler.Callback {
    private static final int MSG_CHOOSE_RESULT_SUCCESS = 200;
    private static final int MSG_ASY_COMPRESSION_RESULT_SUCCESS = 300;
    protected PictureSelectionConfig config;
    protected boolean openWhiteStatusBar;
    protected boolean numComplete;
    protected int colorPrimary;
    protected int colorPrimaryDark;
    protected PictureLoadingDialog mLoadingDialog;
    protected List<LocalMedia> selectionMedias;
    protected Handler mHandler;
    protected View container;
    protected boolean isOnSaveInstanceState;

    public boolean isImmersive() {
        return true;
    }

    public boolean isRequestedOrientation() {
        return true;
    }

    public void immersive() {
        ImmersiveManage.immersiveAboveAPI23(this, this.colorPrimaryDark, this.colorPrimary, this.openWhiteStatusBar);
    }

    public abstract int getResourceId();

    protected void initWidgets() {
    }

    protected void initPictureSelectorStyle() {
    }

    protected void onCreate(Bundle savedInstanceState) {
        int layoutResID;
        if (savedInstanceState != null) {
            this.config = (PictureSelectionConfig)savedInstanceState.getParcelable("PictureSelectorConfig");
        }
        this.isCheckConfigNull();
        if (!this.config.camera) {
            this.setTheme(this.config.themeStyleId);
        }
        super.onCreate(savedInstanceState);
        if (this.isRequestedOrientation()) {
            this.setNewRequestedOrientation();
        }
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.initConfig();
        if (this.isImmersive()) {
            this.immersive();
        }
        if (this.config.style != null && this.config.style.pictureNavBarColor != 0) {
            NavBarUtils.setNavBarColor((Activity)this, this.config.style.pictureNavBarColor);
        }
        if ((layoutResID = this.getResourceId()) != 0) {
            this.setContentView(layoutResID);
        }
        this.initWidgets();
        this.initPictureSelectorStyle();
        this.isOnSaveInstanceState = false;
    }

    private void isCheckConfigNull() {
        if (this.config == null) {
            this.config = PictureSelectionConfig.getInstance();
        }
    }

    protected void setNewRequestedOrientation() {
        if (this.config != null) {
            this.setRequestedOrientation(this.config.requestedOrientation);
        }
    }

    protected Context getContext() {
        return this;
    }

    private void initConfig() {
        List<Object> list = this.selectionMedias = this.config.selectionMedias == null ? new ArrayList() : this.config.selectionMedias;
        if (this.config.style != null) {
            this.openWhiteStatusBar = this.config.style.isChangeStatusBarFontColor;
            if (this.config.style.pictureTitleBarBackgroundColor != 0) {
                this.colorPrimary = this.config.style.pictureTitleBarBackgroundColor;
            }
            if (this.config.style.pictureStatusBarColor != 0) {
                this.colorPrimaryDark = this.config.style.pictureStatusBarColor;
            }
            this.numComplete = this.config.style.isOpenCompletedNumStyle;
            this.config.checkNumMode = this.config.style.isOpenCheckNumStyle;
        } else {
            this.openWhiteStatusBar = this.config.isChangeStatusBarFontColor;
            if (!this.openWhiteStatusBar) {
                this.openWhiteStatusBar = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_statusFontColor);
            }
            this.numComplete = this.config.isOpenStyleNumComplete;
            if (!this.numComplete) {
                this.numComplete = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_style_numComplete);
            }
            this.config.checkNumMode = this.config.isOpenStyleCheckNumMode;
            if (!this.config.checkNumMode) {
                this.config.checkNumMode = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_style_checkNumMode);
            }
            this.colorPrimary = this.config.titleBarBackgroundColor != 0 ? this.config.titleBarBackgroundColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.colorPrimary);
            this.colorPrimaryDark = this.config.pictureStatusBarColor != 0 ? this.config.pictureStatusBarColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.colorPrimaryDark);
        }
        if (this.config.openClickSound) {
            VoiceUtils.getInstance().init(this.getContext());
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.isOnSaveInstanceState = true;
        outState.putParcelable("PictureSelectorConfig", (Parcelable)this.config);
    }

    protected void attachBaseContext(Context newBase) {
        this.config = PictureSelectionConfig.getInstance();
        if (this.config != null) {
            super.attachBaseContext((Context)PictureContextWrapper.wrap(newBase, this.config.language));
        }
    }

    protected void showPleaseDialog() {
        if (!this.isFinishing()) {
            if (this.mLoadingDialog == null) {
                this.mLoadingDialog = new PictureLoadingDialog(this.getContext());
            }
            if (this.mLoadingDialog.isShowing()) {
                this.mLoadingDialog.dismiss();
            }
            this.mLoadingDialog.show();
        }
    }

    protected void dismissDialog() {
        if (!this.isFinishing()) {
            try {
                if (this.mLoadingDialog != null && this.mLoadingDialog.isShowing()) {
                    this.mLoadingDialog.dismiss();
                }
            }
            catch (Exception e) {
                this.mLoadingDialog = null;
                e.printStackTrace();
            }
        }
    }

    protected void compressImage(final List<LocalMedia> result) {
        this.showPleaseDialog();
        if (this.config.synOrAsy) {
            AsyncTask.SERIAL_EXECUTOR.execute(() -> {
                try {
                    List<File> files = Luban.with(this.getContext()).loadMediaData(result).isCamera(this.config.camera).setTargetDir(this.config.compressSavePath).setCompressQuality(this.config.compressQuality).setFocusAlpha(this.config.focusAlpha).setNewCompressFileName(this.config.renameCompressFileName).ignoreBy(this.config.minimumCompressSize).get();
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(300, (Object)new Object[]{result, files}));
                }
                catch (Exception e) {
                    this.onResult(result);
                    e.printStackTrace();
                }
            });
        } else {
            Luban.with((Context)this).loadMediaData(result).ignoreBy(this.config.minimumCompressSize).isCamera(this.config.camera).setCompressQuality(this.config.compressQuality).setTargetDir(this.config.compressSavePath).setFocusAlpha(this.config.focusAlpha).setNewCompressFileName(this.config.renameCompressFileName).setCompressListener(new OnCompressListener(){

                @Override
                public void onStart() {
                }

                @Override
                public void onSuccess(List<LocalMedia> list) {
                    PictureBaseActivity.this.onResult(list);
                }

                @Override
                public void onError(Throwable e) {
                    PictureBaseActivity.this.onResult(result);
                }
            }).launch();
        }
    }

    private void handleCompressCallBack(List<LocalMedia> images, List<File> files) {
        if (images == null || files == null) {
            this.closeActivity();
            return;
        }
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        int size = images.size();
        if (files.size() == size) {
            int j = size;
            for (int i = 0; i < j; ++i) {
                File file = files.get(i);
                String path = file.getAbsolutePath();
                LocalMedia image = images.get(i);
                boolean http = PictureMimeType.isHttp(path);
                boolean flag = !TextUtils.isEmpty((CharSequence)path) && http;
                boolean eqVideo = PictureMimeType.eqVideo(image.getMimeType());
                image.setCompressed(!eqVideo && !flag);
                image.setCompressPath(eqVideo || flag ? "" : path);
                if (!isAndroidQ) continue;
                image.setAndroidQToPath(eqVideo ? null : path);
            }
        }
        this.onResult(images);
    }

    protected void startCrop(String originalPath) {
        boolean isChangeStatusBarFontColor;
        if (TextUtils.isEmpty((CharSequence)originalPath)) {
            ToastUtils.s((Context)this, this.getString(R.string.picture_not_crop_data));
            return;
        }
        UCrop.Options options = this.config.uCropOptions == null ? new UCrop.Options() : this.config.uCropOptions;
        int toolbarColor = 0;
        int statusColor = 0;
        int titleColor = 0;
        if (this.config.cropStyle != null) {
            if (this.config.cropStyle.cropTitleBarBackgroundColor != 0) {
                toolbarColor = this.config.cropStyle.cropTitleBarBackgroundColor;
            }
            if (this.config.cropStyle.cropStatusBarColorPrimaryDark != 0) {
                statusColor = this.config.cropStyle.cropStatusBarColorPrimaryDark;
            }
            if (this.config.cropStyle.cropTitleColor != 0) {
                titleColor = this.config.cropStyle.cropTitleColor;
            }
            isChangeStatusBarFontColor = this.config.cropStyle.isChangeStatusBarFontColor;
        } else {
            toolbarColor = this.config.cropTitleBarBackgroundColor != 0 ? this.config.cropTitleBarBackgroundColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_toolbar_bg);
            statusColor = this.config.cropStatusBarColorPrimaryDark != 0 ? this.config.cropStatusBarColorPrimaryDark : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_status_color);
            titleColor = this.config.cropTitleColor != 0 ? this.config.cropTitleColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_title_color);
            isChangeStatusBarFontColor = this.config.isChangeStatusBarFontColor;
            if (!isChangeStatusBarFontColor) {
                isChangeStatusBarFontColor = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_statusFontColor);
            }
        }
        options.isOpenWhiteStatusBar(isChangeStatusBarFontColor);
        options.setToolbarColor(toolbarColor);
        options.setStatusBarColor(statusColor);
        options.setToolbarWidgetColor(titleColor);
        options.setDimmedLayerColor(this.config.circleDimmedColor);
        options.setDimmedLayerBorderColor(this.config.circleDimmedBorderColor);
        options.setCircleStrokeWidth(this.config.circleStrokeWidth);
        options.setCircleDimmedLayer(this.config.circleDimmedLayer);
        options.setShowCropFrame(this.config.showCropFrame);
        options.setShowCropGrid(this.config.showCropGrid);
        options.setDragFrameEnabled(this.config.isDragFrame);
        options.setScaleEnabled(this.config.scaleEnabled);
        options.setRotateEnabled(this.config.rotateEnabled);
        options.setCompressionQuality(this.config.cropCompressQuality);
        options.setHideBottomControls(this.config.hideBottomControls);
        options.setFreeStyleCropEnabled(this.config.freeStyleCropEnabled);
        options.setCropExitAnimation(this.config.windowAnimationStyle != null ? this.config.windowAnimationStyle.activityCropExitAnimation : 0);
        options.setNavBarColor(this.config.cropStyle != null ? this.config.cropStyle.cropNavBarColor : 0);
        options.withAspectRatio((float)this.config.aspect_ratio_x, (float)this.config.aspect_ratio_y);
        if (this.config.cropWidth > 0 && this.config.cropHeight > 0) {
            options.withMaxResultSize(this.config.cropWidth, this.config.cropHeight);
        }
        boolean isHttp = PictureMimeType.isHttp(originalPath);
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        Uri uri = isHttp || isAndroidQ ? Uri.parse((String)originalPath) : Uri.fromFile((File)new File(originalPath));
        String mimeType = PictureMimeType.getMimeTypeFromMediaContentUri((Context)this, uri);
        String suffix = mimeType.replace("image/", ".");
        File file = new File(PictureFileUtils.getDiskCacheDir((Context)this), TextUtils.isEmpty((CharSequence)this.config.renameCropFileName) ? DateUtils.getCreateFileName("IMG_") + suffix : this.config.renameCropFileName);
        UCrop.of((Uri)uri, (Uri)Uri.fromFile((File)file)).withOptions(options).startAnimationActivity((Activity)this, this.config.windowAnimationStyle != null ? this.config.windowAnimationStyle.activityCropEnterAnimation : R.anim.picture_anim_enter);
    }

    protected void startCrop(ArrayList<CutInfo> list) {
        String mimeType;
        boolean eqVideo;
        boolean isChangeStatusBarFontColor;
        if (list == null || list.size() == 0) {
            ToastUtils.s((Context)this, this.getString(R.string.picture_not_crop_data));
            return;
        }
        int toolbarColor = 0;
        int statusColor = 0;
        int titleColor = 0;
        if (this.config.cropStyle != null) {
            if (this.config.cropStyle.cropTitleBarBackgroundColor != 0) {
                toolbarColor = this.config.cropStyle.cropTitleBarBackgroundColor;
            }
            if (this.config.cropStyle.cropStatusBarColorPrimaryDark != 0) {
                statusColor = this.config.cropStyle.cropStatusBarColorPrimaryDark;
            }
            if (this.config.cropStyle.cropTitleColor != 0) {
                titleColor = this.config.cropStyle.cropTitleColor;
            }
            isChangeStatusBarFontColor = this.config.cropStyle.isChangeStatusBarFontColor;
        } else {
            toolbarColor = this.config.cropTitleBarBackgroundColor != 0 ? this.config.cropTitleBarBackgroundColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_toolbar_bg);
            statusColor = this.config.cropStatusBarColorPrimaryDark != 0 ? this.config.cropStatusBarColorPrimaryDark : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_status_color);
            titleColor = this.config.cropTitleColor != 0 ? this.config.cropTitleColor : AttrsUtils.getTypeValueColor((Context)this, R.attr.picture_crop_title_color);
            isChangeStatusBarFontColor = this.config.isChangeStatusBarFontColor;
            if (!isChangeStatusBarFontColor) {
                isChangeStatusBarFontColor = AttrsUtils.getTypeValueBoolean((Context)this, R.attr.picture_statusFontColor);
            }
        }
        UCrop.Options options = this.config.uCropOptions == null ? new UCrop.Options() : this.config.uCropOptions;
        options.isOpenWhiteStatusBar(isChangeStatusBarFontColor);
        options.setToolbarColor(toolbarColor);
        options.setStatusBarColor(statusColor);
        options.setToolbarWidgetColor(titleColor);
        options.setCircleDimmedLayer(this.config.circleDimmedLayer);
        options.setDimmedLayerColor(this.config.circleDimmedColor);
        options.setDimmedLayerBorderColor(this.config.circleDimmedBorderColor);
        options.setCircleStrokeWidth(this.config.circleStrokeWidth);
        options.setShowCropFrame(this.config.showCropFrame);
        options.setDragFrameEnabled(this.config.isDragFrame);
        options.setShowCropGrid(this.config.showCropGrid);
        options.setScaleEnabled(this.config.scaleEnabled);
        options.setRotateEnabled(this.config.rotateEnabled);
        options.isMultipleSkipCrop(this.config.isMultipleSkipCrop);
        options.setHideBottomControls(this.config.hideBottomControls);
        options.setCompressionQuality(this.config.cropCompressQuality);
        options.setRenameCropFileName(this.config.renameCropFileName);
        options.isCamera(this.config.camera);
        options.setCutListData(list);
        options.isWithVideoImage(this.config.isWithVideoImage);
        options.setFreeStyleCropEnabled(this.config.freeStyleCropEnabled);
        options.setCropExitAnimation(this.config.windowAnimationStyle != null ? this.config.windowAnimationStyle.activityCropExitAnimation : 0);
        options.setNavBarColor(this.config.cropStyle != null ? this.config.cropStyle.cropNavBarColor : 0);
        options.withAspectRatio((float)this.config.aspect_ratio_x, (float)this.config.aspect_ratio_y);
        options.isMultipleRecyclerAnimation(this.config.isMultipleRecyclerAnimation);
        if (this.config.cropWidth > 0 && this.config.cropHeight > 0) {
            options.withMaxResultSize(this.config.cropWidth, this.config.cropHeight);
        }
        int index = 0;
        int size = list.size();
        if (this.config.chooseMode == PictureMimeType.ofAll() && this.config.isWithVideoImage && (eqVideo = PictureMimeType.eqVideo(mimeType = size > 0 ? list.get(index).getMimeType() : ""))) {
            for (int i = 0; i < size; ++i) {
                CutInfo cutInfo = list.get(i);
                if (cutInfo == null || !PictureMimeType.eqImage(cutInfo.getMimeType())) continue;
                index = i;
                break;
            }
        }
        String path = size > 0 && size > index ? list.get(index).getPath() : "";
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        boolean isHttp = PictureMimeType.isHttp(path);
        Uri uri = isHttp || isAndroidQ ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
        String mimeType2 = PictureMimeType.getMimeTypeFromMediaContentUri((Context)this, uri);
        String suffix = mimeType2.replace("image/", ".");
        File file = new File(PictureFileUtils.getDiskCacheDir((Context)this), TextUtils.isEmpty((CharSequence)this.config.renameCropFileName) ? DateUtils.getCreateFileName("IMG_") + suffix : (this.config.camera ? this.config.renameCropFileName : StringUtils.rename(this.config.renameCropFileName)));
        UCrop.of((Uri)uri, (Uri)Uri.fromFile((File)file)).withOptions(options).startAnimationMultipleCropActivity((Activity)this, this.config.windowAnimationStyle != null ? this.config.windowAnimationStyle.activityCropEnterAnimation : R.anim.picture_anim_enter);
    }

    protected void handlerResult(List<LocalMedia> result) {
        if (this.config.isCompress && !this.config.isCheckOriginalImage) {
            this.compressImage(result);
        } else {
            this.onResult(result);
        }
    }

    protected void createNewFolder(List<LocalMediaFolder> folders) {
        if (folders.size() == 0) {
            LocalMediaFolder newFolder = new LocalMediaFolder();
            String folderName = this.config.chooseMode == PictureMimeType.ofAudio() ? this.getString(R.string.picture_all_audio) : this.getString(R.string.picture_camera_roll);
            newFolder.setName(folderName);
            newFolder.setFirstImagePath("");
            folders.add(newFolder);
        }
    }

    @Nullable
    protected LocalMediaFolder getImageFolder(String path, List<LocalMediaFolder> imageFolders) {
        File imageFile = new File(path.startsWith("content://") ? PictureFileUtils.getPath(this.getContext(), Uri.parse((String)path)) : path);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            if (!folder.getName().equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile.getName());
        newFolder.setFirstImagePath(path);
        imageFolders.add(newFolder);
        return newFolder;
    }

    protected void onResult(List<LocalMedia> images) {
        boolean isAndroidQ = SdkVersionUtils.checkedAndroid_Q();
        if (isAndroidQ && this.config.isAndroidQTransform) {
            this.showPleaseDialog();
            this.onResultToAndroidAsy(images);
        } else {
            this.dismissDialog();
            if (this.config.camera && this.config.selectionMode == 2 && this.selectionMedias != null) {
                images.addAll(images.size() > 0 ? images.size() - 1 : 0, this.selectionMedias);
            }
            if (this.config.isCheckOriginalImage) {
                int size = images.size();
                for (int i = 0; i < size; ++i) {
                    LocalMedia media = images.get(i);
                    media.setOriginal(true);
                    media.setOriginalPath(media.getPath());
                }
            }
            if (PictureSelectionConfig.listener != null) {
                PictureSelectionConfig.listener.onResult(images);
            } else {
                Intent intent = PictureSelector.putIntentResult(images);
                this.setResult(-1, intent);
            }
            this.closeActivity();
        }
    }

    private void onResultToAndroidAsy(List<LocalMedia> images) {
        AsyncTask.SERIAL_EXECUTOR.execute(() -> {
            int size = images.size();
            for (int i = 0; i < size; ++i) {
                boolean isCopyAndroidQToPath;
                LocalMedia media = (LocalMedia)images.get(i);
                if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) continue;
                boolean bl = isCopyAndroidQToPath = !media.isCut() && !media.isCompressed() && TextUtils.isEmpty((CharSequence)media.getAndroidQToPath());
                if (isCopyAndroidQToPath) {
                    String pathToAndroidQ = AndroidQTransformUtils.getPathToAndroidQ(this.getContext(), this.config.cameraFileName, media);
                    media.setAndroidQToPath(pathToAndroidQ);
                    if (!this.config.isCheckOriginalImage) continue;
                    media.setOriginal(true);
                    media.setOriginalPath(media.getAndroidQToPath());
                    continue;
                }
                if (media.isCut() && media.isCompressed()) {
                    media.setAndroidQToPath(media.getCompressPath());
                    continue;
                }
                if (!this.config.isCheckOriginalImage) continue;
                media.setOriginal(true);
                media.setOriginalPath(media.getAndroidQToPath());
            }
            this.mHandler.sendMessage(this.mHandler.obtainMessage(200, (Object)images));
        });
    }

    protected void closeActivity() {
        this.finish();
        if (this.config.camera) {
            this.overridePendingTransition(0, R.anim.picture_anim_fade_out);
        } else {
            this.overridePendingTransition(0, this.config.windowAnimationStyle != null && this.config.windowAnimationStyle.activityExitAnimation != 0 ? this.config.windowAnimationStyle.activityExitAnimation : R.anim.picture_anim_exit);
        }
        if (this.getContext() instanceof PictureSelectorActivity) {
            this.releaseResultListener();
            if (this.config.openClickSound) {
                VoiceUtils.getInstance().releaseSoundPool();
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.dismissDialog();
        this.mLoadingDialog = null;
    }

    protected void removeMedia(int id) {
        try {
            ContentResolver cr = this.getContentResolver();
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = "_id=?";
            cr.delete(uri, selection, new String[]{Long.toString(id)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getLastImageId(String mimeType) {
        try {
            String absolutePath = PictureFileUtils.getDCIMCameraPath((Context)this, mimeType);
            String ORDER_BY = "_id DESC";
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            Cursor data = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, selection, selectionArgs, ORDER_BY);
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                int id = data.getInt(data.getColumnIndex("_id"));
                long date = data.getLong(data.getColumnIndex("date_added"));
                int duration = DateUtils.dateDiffer(date);
                data.close();
                return duration <= 1 ? id : -1;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Nullable
    protected String getAudioPath(Intent data) {
        boolean compare_SDK_19;
        boolean bl = compare_SDK_19 = Build.VERSION.SDK_INT <= 19;
        if (data != null && this.config.chooseMode == PictureMimeType.ofAudio()) {
            try {
                Uri uri = data.getData();
                String audioPath = compare_SDK_19 ? uri.getPath() : this.getAudioFilePathFromUri(uri);
                return audioPath;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    @Nullable
    protected String getAudioFilePathFromUri(Uri uri) {
        String path = "";
        try {
            Cursor cursor = this.getContentResolver().query(uri, null, null, null, null);
            cursor.moveToFirst();
            int index = cursor.getColumnIndex("_data");
            path = cursor.getString(index);
            cursor.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void startOpenCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            block7: {
                if (SdkVersionUtils.checkedAndroid_Q()) {
                    imageUri = MediaUtils.createImageUri(this.getApplicationContext());
                    if (imageUri != null) {
                        this.config.cameraPath = imageUri.toString();
                        break block7;
                    } else {
                        ToastUtils.s(this.getContext(), "open is camera error\uff0cthe uri is empty ");
                        if (this.config.camera) {
                            this.closeActivity();
                        }
                        return;
                    }
                }
                int chooseMode = this.config.chooseMode == 0 ? 1 : this.config.chooseMode;
                String cameraFileName = "";
                if (!TextUtils.isEmpty((CharSequence)this.config.cameraFileName)) {
                    boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(this.config.cameraFileName);
                    this.config.cameraFileName = !isSuffixOfImage ? StringUtils.renameSuffix(this.config.cameraFileName, ".jpg") : this.config.cameraFileName;
                    cameraFileName = this.config.camera ? this.config.cameraFileName : StringUtils.rename(this.config.cameraFileName);
                }
                File cameraFile = PictureFileUtils.createCameraFile(this.getApplicationContext(), chooseMode, cameraFileName, this.config.suffixType);
                this.config.cameraPath = cameraFile.getAbsolutePath();
                imageUri = PictureFileUtils.parUri((Context)this, cameraFile);
            }
            if (this.config.isCameraAroundState) {
                cameraIntent.putExtra("android.intent.extras.CAMERA_FACING", 1);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void startOpenCameraVideo() {
        Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
            Uri imageUri;
            block7: {
                if (SdkVersionUtils.checkedAndroid_Q()) {
                    imageUri = MediaUtils.createVideoUri(this.getApplicationContext());
                    if (imageUri != null) {
                        this.config.cameraPath = imageUri.toString();
                        break block7;
                    } else {
                        ToastUtils.s(this.getContext(), "open is camera error\uff0cthe uri is empty ");
                        if (this.config.camera) {
                            this.closeActivity();
                        }
                        return;
                    }
                }
                int chooseMode = this.config.chooseMode == 0 ? 2 : this.config.chooseMode;
                String cameraFileName = "";
                if (!TextUtils.isEmpty((CharSequence)this.config.cameraFileName)) {
                    boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(this.config.cameraFileName);
                    this.config.cameraFileName = isSuffixOfImage ? StringUtils.renameSuffix(this.config.cameraFileName, ".mp4") : this.config.cameraFileName;
                    cameraFileName = this.config.camera ? this.config.cameraFileName : StringUtils.rename(this.config.cameraFileName);
                }
                File cameraFile = PictureFileUtils.createCameraFile(this.getApplicationContext(), chooseMode, cameraFileName, this.config.suffixType);
                this.config.cameraPath = cameraFile.getAbsolutePath();
                imageUri = PictureFileUtils.parUri((Context)this, cameraFile);
            }
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            if (this.config.isCameraAroundState) {
                cameraIntent.putExtra("android.intent.extras.CAMERA_FACING", 1);
            }
            cameraIntent.putExtra("android.intent.extra.durationLimit", this.config.recordVideoSecond);
            cameraIntent.putExtra("android.intent.extra.videoQuality", this.config.videoQuality);
            this.startActivityForResult(cameraIntent, 909);
        }
    }

    public void startOpenCameraAudio() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO")) {
            Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
            if (cameraIntent.resolveActivity(this.getPackageManager()) != null) {
                this.startActivityForResult(cameraIntent, 909);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 3);
        }
    }

    public boolean handleMessage(@NonNull Message msg) {
        switch (msg.what) {
            case 200: {
                List images = (List)msg.obj;
                this.dismissDialog();
                if (images == null) break;
                if (this.config.camera && this.config.selectionMode == 2 && this.selectionMedias != null) {
                    images.addAll(images.size() > 0 ? images.size() - 1 : 0, this.selectionMedias);
                }
                if (PictureSelectionConfig.listener != null) {
                    PictureSelectionConfig.listener.onResult(images);
                } else {
                    Intent intent = PictureSelector.putIntentResult(images);
                    this.setResult(-1, intent);
                }
                this.closeActivity();
                break;
            }
            case 300: {
                Object[] objects;
                if (msg.obj == null || !(msg.obj instanceof Object[]) || (objects = (Object[])msg.obj).length <= 0) break;
                List result = (List)objects[0];
                List files = (List)objects[1];
                this.handleCompressCallBack(result, files);
            }
        }
        return false;
    }

    private void releaseResultListener() {
        if (this.config != null) {
            PictureSelectionConfig.listener = null;
            PictureSelectionConfig.customVideoPlayCallback = null;
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 3: {
                if (grantResults[0] == 0) {
                    Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
                    if (cameraIntent.resolveActivity(this.getPackageManager()) == null) break;
                    this.startActivityForResult(cameraIntent, 909);
                    break;
                }
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_audio));
            }
        }
    }
}

